unit jp5_mailer;

interface

uses
    windows, messages, tn_classes, jp5_kern, tn_stdctl, tn_utils;

//procedures
    procedure ShowMailerDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);

const
    MAILER_DLG      =   2012;

var
    Info : PAccItemInfo;

implementation

procedure ShowMailerDlg(Handle : THandle ; var TargetInfo : TAccItemInfo);

    function DialogCallBack(hDlg : THandle ; uMsg : Cardinal ; wParam : Integer ; lParam : integer) : BOOL; stdcall;
    var
        dummy : Integer;
    begin
        Result := True;

        case uMsg of
            WM_COMMAND:
                begin
                    case WParam of
                        IDOK:
                            begin
                                EndDialog(hDlg, 0);
                            end;

                        IDCANCEL:
                            begin
                                EndDialog(hDlg, 0);
                            end;
                    end;

                    Result := False;
                end;

            WM_INITDIALOG:
                begin
                    Result := False;

                    //POPAhXݒ
                    SendMessage(GetDlgItem(hDlg, 1001), WM_SETTEXT, 0
                                    , Integer(PChar('localhost')));

                    //SMTPAhXݒ
                    SendMessage(GetDlgItem(hDlg, 1002), WM_SETTEXT, 0
                                    , Integer(PChar('localhost')));

                    //[UIDݒ
                    SendMessage(GetDlgItem(hDlg, 1003), WM_SETTEXT, 0
                                    , Integer(PChar(Info.Address)));

                    //GCAXݒ
                    SendMessage(GetDlgItem(hDlg, 1004), WM_SETTEXT, 0
                                    , Integer(PChar(Info.Alias)));

                    //POP|[gݒ
                    SendMessage(GetDlgItem(hDlg, 1005), WM_SETTEXT, 0
                                    , Integer(PChar(IntToStr(Settings.Pop_Port))));

                    //SMTP|[gݒ
                    SendMessage(GetDlgItem(hDlg, 1006), WM_SETTEXT, 0
                                    , Integer(PChar(IntToStr(Settings.Smtp_Port))));

                    //tH[JXZbg
                    SetActiveWindow(hDlg);
                    SendMessage(GetDlgItem(hDlg, 1000), WM_SETFOCUS, 0, 0);
                end;

            WM_DRAWITEM:
                begin
                end;

            WM_CLOSE:
                begin
                    dummy := 0;
                    EndDialog(hDlg, dummy);
                    Result := False;
                end;

            else
                Result := False;
        end;
    end;

begin
    Info := @TargetInfo;
    //SetCapture(Handle);
    DialogBox(hInstance, MAKEINTRESOURCE(MAILER_DLG), Handle, @DialogCallBack);
    //ReleaseCapture;
end;

end.
