unit jp5_kern;

interface

uses
    windows, tn_utils, tn_classes, tn_internet, jp5_crypt;

type
    TScriptStatus   =   (ITEM_EXEC, ITEM_IDLE, ITEM_ERR, ITEM_WAIT, ITEM_DISABLE);
    TItemType       =   (EXE_NONE, EXE_HOUR, EXE_INT);

    TAccItemInfo    =   record
        ScriptTitle : String;
        Title : String;
        FileName : String;
        User : String;
        Pass : String;
        Option : String;
        Address : String;
        Alias : String;
        PopAddr : String;
        PopPort : Integer;
        SmtpAddr : String;
        SmtpPort : Integer;
        SaveCache : Boolean;
        SaveCookie : Boolean;
        Disable : Boolean;
        IntCheck : TItemType;
        Time : Integer;
        Delete : Boolean;
        APOP : Boolean;
    end;

    PAccItemInfo    =   ^TAccItemInfo;

    TSettings       =   record
        Proxy_Addr : String;
        Proxy_Port : Integer;
        Proxy_User : String;
        Proxy_Pass : String;
        UseProxy : Boolean;
        Exec_Max : Integer;
        UsePop : Boolean;
        UseSmtp : Boolean;
        DenyNoLocalHost : Boolean;
        ExecImmediately : Boolean;
        //PassInputEternally : Boolean;
        NotifySound : Boolean;
        ShowItemList : Boolean;
        StartOnBoot : Boolean;
        AutoUpdate : Boolean;
        Priority : Boolean;
        Pop_Port : Integer;
        Smtp_Port : Integer;
        ProductUser : String;
        LastUpdate : Integer;
        Dns : String;
        MonoIcon : Boolean;
        UseSpeedMail : Boolean;
        WebBrowser : String;
    end;

    TJpMsgType      =   (mtMessage, mtUpdate);

    TJpMessage      =   record
        Handle : THandle;
        Index : Integer;
        MessageStr : PChar;
        Types : TJpMsgType;
    end;

    PJpMessage      =   ^TJpMessage;

    TJpCounter      =   record
        Stop : Integer;
        Run : Integer;
        Wait : Integer;
        Err : Integer;
        Dis : Integer;
    end;

    PJpCounter      =   ^TJpCounter;

    TScripts        =   class
        private
            ScriptPath : String;
            Files : TNStringList;
            Titles : TNStringList;
            function GetCount : Integer;
            function GetTitle(Index : Integer) : String;
        public
            constructor Create;
            destructor Destroy; override;
            property Count : Integer read GetCount;
            property Strings[Index : Integer] : String read GetTitle;
            function GetFileNameFromTitle(Title : String) : String;
    end;

    TItems          =   class
        private
            DataPath : String;
            SortList : TNIntList;
            PathIndexs : TNIntList;
            function GetCount : Integer;
            function GetPath(Index : Integer) : String;
        public
            Handles : TNIntList;
            Titles : TNStringList;
            Scripts : TNStringList;
            Messages : TNStringList;
            Statuses : TNIntList;
            Urls : TNStringList;
            Mails : TNStringList;
            ExecType : TNIntList;
            Times : TNIntList;
            Lasts : TNDoubleList;
            Aliases : TNStringList;
            LastPops : TNIntList;
            constructor Create;
            destructor Destroy; override;
            procedure LoadItems;
            procedure Add(FolderIndex : Integer);
            procedure Delete(Index : Integer);
            function ConvertIndex(Index : Integer) : Integer;
            function UnConvertIndex(Index : Integer) : Integer;
            procedure SwapSortList(NewList : TNIntList);
            function MakePath(FolderIndex : Integer) : String;
            procedure AddSortIndex(FolderIndex : Integer);
            property Count : Integer read GetCount;
            property Paths[Index : Integer] : String read GetPath;
    end;

var
    MainMenu : THandle;
    TrayHandle : THandle;
	TrayIconHandle : THandle;
    JobHandle : THandle;
    Scripts : TScripts;
    Items : TItems;
    Settings : TSettings;
    TempPath : String;
    Wait : Boolean;
    AdwinWait : Integer;
    RunAllItems : Boolean;
    RunAddress : String;

const
    TITLE           =   'Grape Software Jupiter 5';
    APPNAME         =   'jp5dx';

    //JP_HIDEDEBUG    =   4000;
    //JP_HIDEJOB      =   4001;
    //JP_HIDEABOUT    =   4002;
    //JP_HIDESETTINGS =   4003;
    //JP_HIDEUPDATE   =   4004;
    //JP_HIDESCINFO   =   4005;
    JP_MENUUPDATE   =   9001;

    WM_JPSTART      =   8200;
    WM_JPMSG        =   8201;
    WM_JPSETCOUNTER =   8202;
    WM_JPSTOP       =   8203;

    WM_JPCONNECT    =   8300;
    WM_JPDOWNLOAD   =   8301;
    WM_JPFINISH     =   8302;
    
//procedures
    function LoadItem(FileName : String) : TAccItemInfo;
    procedure SaveItem(Item : TAccItemInfo);
    function CreateNewItemFolder(Path : String) : Integer;
    procedure Load_Settings;
    procedure Save_Settings;
	function PrepareTemporary : Boolean;
    procedure ClearTemporary;

implementation

uses
    jp5_regist;

//******************************************************************************
// TScripts XNvgǗNX

constructor TScripts.Create;
var
    n : Integer;
    FileName : String;
    temp : String;
    Lists : TNStringList;
begin
    ScriptPath := ExtractFilePath(ParamStr(0)) + 'scripts\';
    Lists := SearchFile(ScriptPath + '*.js');
    Files := TNStringList.Create;
    Titles := TNStringList.Create;

    for n := 0 to Lists.Count - 1 do
    begin
        FileName := ScriptPath + Lists.Strings[n];
        temp := Trim(GetSettings(FileName, '//ScriptTitle'));

        if temp <> '' then
        begin
            Files.Add(Lists.Strings[n]);
            Titles.Add(temp);
        end;
    end;

    Lists.Free;
end;

destructor TScripts.Destroy;
begin
    Files.Free;
    Titles.Free;
    inherited Destroy;
end;

function TScripts.GetCount : Integer;
begin
    Result := Files.Count;
end;

function TScripts.GetTitle(Index : Integer) : String;
begin
    Result := Titles.Strings[Index];
end;

function TScripts.GetFileNameFromTitle(Title : String) : String;
var
    Index : Integer;
begin
    Index := Titles.IndexOf(Title);
    Result := ExtractFilePath(ParamStr(0)) + 'scripts\' + Files.Strings[Index];
    //Result := '';
end;

//******************************************************************************
// TItems ACeǗNX

constructor TItems.Create;
begin
    PathIndexs := TNIntList.Create;
    Handles := TNIntList.Create;
    Titles := TNStringList.Create;
    Scripts := TNStringList.Create;
    Messages := TNStringList.Create;
    Statuses := TNIntList.Create;
    Urls := TNStringList.Create;
    Mails := TNStringList.Create;
    ExecType := TNIntList.Create;;
    Times := TNIntList.Create;
    Lasts := TNDoubleList.Create;
    Aliases := TNStringList.Create;
    LastPops := TNIntList.Create;
    SortList := TNIntList.Create;

    LoadItems;
end;

destructor TItems.Destroy;
begin
    PathIndexs.Free;
    Handles.Free;
    Titles.Free;
    Scripts.Free;
    Messages.Free;
    Statuses.Free;
    Urls.Free;
    Mails.Free;
    ExecType.Free;
    Times.Free;
    Lasts.Free;
    Aliases.Free;
    LastPops.Free;
    SortList.Free;

    inherited Destroy;
end;

procedure TItems.LoadItems;
var
    temp , stemp , ttemp : String;
    n : Integer;
    Folders : TNStringList;
    List : TNIntList;
    FileName : String;
    Value : Integer;
begin
    DataPath := ExtractFilePath(ParamStr(0)) + 'datas\items\';
    Folders := SearchFolder(DataPath);
    List := TNIntList.Create;
    PathIndexs.Clear;

    for n := 0 to Folders.Count - 1 do
    begin
        if Pos('ITEM', UpperCase(Folders.Strings[n])) = 1 then
        begin
            temp := Folders.Strings[n];
            Value := StrToInt(Copy(temp, 5, Length(temp) - 4));

            if Value > 0 then
                PathIndexs.Add(Value);
        end;
    end;

    List.Sort;
    List.Free;

    for n := 0 to PathIndexs.Count - 1 do
    begin
        FileName := DataPath + 'item' + IntToStr(PathIndexs.GetValue(n)) + '\item.ini';
        temp := GetSettings(FileName, 'Title');
        stemp := GetSettings(FileName, 'ScriptTitle');
        ttemp := UpperCase(GetSettings(FileName, 'Disable'));
        Add(PathIndexs.GetValue(n));
    end;

    Folders.Free;

    //\[gXgǂݍ
    FileName := ExtractFilePath(ParamStr(0)) + 'datas\sort.dat';
    if FileExists(FileName) then SortList.LoadFromFile(FileName);

    //vȂƂ\[gXgč\z
    if SortList.Count = Count + 1 then Exit;
    if SortList.GetValue(0) = -1 then Exit;

    SortList.Clear;
    SortList.Add(-1);

    for n := 0 to Count - 1 do
        SortList.Add(PathIndexs.GetValue(n));

    SortList.SaveToFile(FileName);
end;

procedure TItems.Add(FolderIndex : Integer);
var
    FileName : String;
    Types : Integer;
begin
    FileName := DataPath + 'item' + IntToStr(FolderIndex) + '\item.ini';
    //PathIndexs.Add(FolderIndex);
    Titles.Add(GetSettings(FileName, 'Title'));
    Scripts.Add(GetSettings(FileName, 'ScriptTitle'));
    Handles.Add(0);

    if UpperCase(GetSettings(FileName, 'Disable')) = 'TRUE' then
        Statuses.Add(Integer(ITEM_DISABLE))
    else
        Statuses.Add(Integer(ITEM_IDLE));

    Messages.Add('');
    Urls.Add('');
    Mails.Add(GetSettings(FileName, 'Address'));
    Types := StrToInt(GetSettings(FileName, 'CheckType'));
    ExecType.Add(Types);
    Times.Add(StrToInt(GetSettings(FileName, 'CheckTime')));
    Aliases.Add(GetSettings(FileName, 'Alias'));
    LastPops.Add(0);

    if Types <> Integer(EXE_HOUR) then
        Lasts.Add(NowDateTime)
    else
        Lasts.Add(0);
end;

function TItems.GetCount : Integer;
begin
    Result := Titles.Count;
end;

procedure TItems.Delete(Index : Integer);
var
    SortIndex : Integer;
begin
    if Index < 0 then Exit;
    if Index >= Titles.Count then Exit;

    SortIndex := UnConvertIndex(Index);
    Titles.Delete(Index);
    PathIndexs.Delete(Index);
    Scripts.Delete(Index);
    Handles.Delete(Index);
    Statuses.Delete(Index);
    Messages.Delete(Index);
    Urls.Delete(Index);
    Mails.Delete(Index);
    Aliases.Delete(Index);
    LastPops.Delete(Index);

    //ԃXgXV
    SortList.Delete(SortIndex + 1);
    SortList.SaveToFile(ExtractFilePath(ParamStr(0)) + 'datas\sort.dat');
end;

function TItems.ConvertIndex(Index : Integer) : Integer;
var
    FolderIndex : Integer;
begin
    //XgIndex -> f[^Index
    Result := -1;

    if (Index < 0) or (Index >= GetCount) then Exit;
    FolderIndex := SortList.GetValue(Index + 1);
    Result := PathIndexs.IndexOf(FolderIndex);
end;

function TItems.UnConvertIndex(Index : Integer) : Integer;
var
    FolderIndex : Integer;
begin
    //f[^Index -> XgIndex
    Result := -1;

    if (Index < 0) or (Index >= GetCount) then Exit;
    FolderIndex := PathIndexs.GetValue(Index);
    Result := SortList.IndexOf(FolderIndex) - 1;
end;

function TItems.GetPath(Index : Integer) : String;
begin
    Result := '';
    if (Index < 0) or (Index >= GetCount) then Exit;
    Result := DataPath + 'item' + IntToStr(PathIndexs.GetValue(Index)) + '\';
end;

procedure TItems.SwapSortList(NewList : TNIntList);
var
    n : Integer;
    Index : Integer;
begin
    SortList.Clear;
    SortList.Add(-1);

    for n := 0 to NewList.Count - 1 do
    begin
        Index := NewList.GetValue(n);
        SortList.Add(PathIndexs.GetValue(Index));
    end;

    SortList.SaveToFile(ExtractFilePath(ParamStr(0)) + 'datas\sort.dat');
end;

function TItems.MakePath(FolderIndex : Integer) : String;
begin
    Result := DataPath + 'item' + IntToStr(FolderIndex) + '\';
end;

procedure TItems.AddSortIndex(FolderIndex : Integer);
begin
    if FolderIndex < 0 then Exit;
    if SortList.IndexOf(FolderIndex) <> -1 then Exit;

    PathIndexs.Add(FolderIndex);
    SortList.Add(FolderIndex);
    SortList.SaveToFile(ExtractFilePath(ParamStr(0)) + 'datas\sort.dat');
end;

//******************************************************************************
// Procedures

function LoadItem(FileName : String) : TAccItemInfo;
begin
    Result.FileName := FileName;
    Result.Title := GetSettings(FileName, 'Title');
    Result.ScriptTitle := GetSettings(FileName, 'ScriptTitle');
    Result.User := GetSettings(FileName, 'User');
    Result.Pass := PasswordDecode(GetSettings(FileName, 'Pass'));
    Result.Address := GetSettings(FileName, 'Address');
    Result.Option := Base64Decode(GetSettings(FileName, 'Option'));
    Result.SaveCache := UpperCase(GetSettings(FileName, 'SaveCache')) = 'TRUE';
    Result.SaveCookie := UpperCase(GetSettings(FileName, 'SaveCookie')) = 'TRUE';
    Result.Disable := UpperCase(GetSettings(FileName, 'Disable')) = 'TRUE';
    Result.IntCheck := TItemType(StrToInt(GetSettings(FileName, 'CheckType')));
    Result.Time := StrToInt(GetSettings(FileName, 'CheckTime'));
    Result.Alias := GetSettings(FileName, 'Alias');
    Result.PopAddr := GetSettings(FileName, 'PopAddress');
    Result.PopPort := StrToInt(GetSettings(FileName, 'PopPort'));
    Result.SmtpAddr := GetSettings(FileName, 'SmtpAddress');
    Result.SmtpPort := StrToInt(GetSettings(FileName, 'SmtpPort'));

    if Result.PopPort = 0 then Result.PopPort := 110;
    if Result.SmtpPort = 0 then Result.SmtpPort := 25;

    Result.Delete := UpperCase(GetSettings(FileName, 'Delete')) <> 'FALSE';
    Result.APOP := UpperCase(GetSettings(FileName, 'APOP')) = 'TRUE';
end;

procedure SaveItem(Item : TAccItemInfo);
begin
    SaveSettings(Item.FileName, 'Title', Item.Title);
    SaveSettings(Item.FileName, 'ScriptTitle', Item.ScriptTitle);
    SaveSettings(Item.FileName, 'User', Item.User);
    SaveSettings(Item.FileName, 'Pass', PasswordEncode(Item.Pass));
    SaveSettings(Item.FileName, 'Address', Item.Address);
    SaveSettings(Item.FileName, 'Option', Base64Encode(Item.Option));

    if Item.SaveCache then
        SaveSettings(Item.FileName, 'SaveCache', 'True')
    else
        SaveSettings(Item.FileName, 'SaveCache', 'False');

    if Item.SaveCookie then
        SaveSettings(Item.FileName, 'SaveCookie', 'True')
    else
        SaveSettings(Item.FileName, 'SaveCookie', 'False');

    if Item.Disable then
        SaveSettings(Item.FileName, 'Disable', 'True')
    else
        SaveSettings(Item.FileName, 'Disable', 'False');

    SaveSettings(Item.FileName, 'CheckType', IntToStr(Integer(Item.IntCheck)));
    SaveSettings(Item.FileName, 'CheckTime', IntToStr(Item.Time));
    SaveSettings(Item.FileName, 'Alias', Item.Alias);
    SaveSettings(Item.FileName, 'PopAddress', Item.PopAddr);
    SaveSettings(Item.FileName, 'PopPort', IntToStr(Item.PopPort));
    SaveSettings(Item.FileName, 'SmtpAddress', Item.SmtpAddr);
    SaveSettings(Item.FileName, 'SmtpPort', IntToStr(Item.SmtpPort));

    if Item.Delete then
        SaveSettings(Item.FileName, 'Delete', 'True')
    else
        SaveSettings(Item.FileName, 'Delete', 'False');

    if Item.APOP then
        SaveSettings(Item.FileName, 'APOP', 'True')
    else
        SaveSettings(Item.FileName, 'APOP', 'False');
end;

function CreateNewItemFolder(Path : String) : Integer;
var
    NewRoot : String;
    n : Integer;
begin
    Result := -1;
    n := 1;

    while True do
    begin
        NewRoot := Path + 'items\item' + IntToStr(n) + '\';
        if not DirectoryExists(NewRoot) then Break;
        n := n + 1;
    end;

    try
        MkDir(NewRoot);
        MkDir(NewRoot + 'cache\');
        MkDir(NewRoot + 'loadbox\');
        MkDir(NewRoot + 'savebox\');
        Result := n;
    except
    end;
end;

procedure Load_Settings;
var
    FileName : String;
    temp : String;
begin
    FileName := ExtractFilePath(ParamStr(0)) + 'jp5dx.ini';
    Settings.Proxy_Addr := GetSettings(FileName, 'ProxyAddress');
    Settings.Proxy_Port := StrToInt(GetSettings(FileName, 'ProxyPort'));
    Settings.Proxy_User := GetSettings(FileName, 'ProxyUser');
    Settings.Proxy_Pass := PasswordDecode(GetSettings(FileName, 'ProxyPass'));
    if Settings.Proxy_Port = 0 then Settings.Proxy_Port := 8080;
    Settings.Exec_Max := StrToInt(GetSettings(FileName, 'ExecMax'));
    if Settings.Exec_Max = 0 then Settings.Exec_Max := 1;

    temp := Trim(GetSettings(FileName, 'UsePop'));

    if temp = '' then
        Settings.UsePop := True
    else
        Settings.UsePop := UpperCase(temp) = 'TRUE';

    temp := Trim(GetSettings(FileName, 'UseSmtp'));

    if temp = '' then
        Settings.UseSmtp := True
    else
        Settings.UseSmtp := UpperCase(temp) = 'TRUE';

    temp := Trim(GetSettings(FileName, 'DenyNoLocalHost'));

    if temp = '' then
        Settings.DenyNoLocalHost := True
    else
        Settings.DenyNoLocalHost := UpperCase(temp) = 'TRUE';

    //Ɏs
    temp := Trim(GetSettings(FileName, 'ExecImmediately'));

    if temp = '' then
        Settings.ExecImmediately := True
    else
        Settings.ExecImmediately := UpperCase(temp) = 'TRUE';

	(*
    //pX͊
    temp := Trim(GetSettings(FileName, 'PassInputEternally'));

    if temp = '' then
        Settings.PassInputEternally := False
    else
        Settings.PassInputEternally := UpperCase(temp) = 'TRUE';
	*)

    //TEh
    temp := Trim(GetSettings(FileName, 'NotifySound'));

    if temp = '' then
        Settings.NotifySound := True
    else
        Settings.NotifySound := UpperCase(temp) = 'TRUE';

    //ÑACeXg\
    temp := Trim(GetSettings(FileName, 'ShowItemList'));
    Settings.ShowItemList := UpperCase(temp) <> 'FALSE';

    //N̎s
    temp := Trim(GetSettings(FileName, 'StartOnBoot'));

    if temp = '' then
        Settings.StartOnBoot := False
    else
        Settings.StartOnBoot := UpperCase(temp) = 'TRUE';

    //XV
    temp := Trim(GetSettings(FileName, 'AutoUpdate'));

    if temp = '' then
        Settings.AutoUpdate := True
    else
        Settings.AutoUpdate := UpperCase(temp) = 'TRUE';

    //Dx
    temp := Trim(GetSettings(FileName, 'PriorityUp'));
    Settings.Priority := UpperCase(temp) = 'TRUE';

    //mNACR̎gp
    temp := Trim(GetSettings(FileName, 'Monocrome'));
    Settings.MonoIcon := UpperCase(temp) = 'TRUE';

    //SpeedMail̎gp
    temp := Trim(GetSettings(FileName, 'SpeedMail'));
    Settings.UseSpeedMail := UpperCase(temp) = 'TRUE';

    //vLV̎gp
    temp := Trim(GetSettings(FileName, 'UseProxy'));

    if temp = '' then
        Settings.UseProxy := Settings.Proxy_Addr <> ''
    else
        Settings.UseProxy := UpperCase(temp) = 'TRUE';

    //POPESMTP|[g
    Settings.Pop_Port := StrToInt(GetSettings(FileName, 'PopPort'));
    Settings.Smtp_Port := StrToInt(GetSettings(FileName, 'SmtpPort'));

    //[U[h
    Settings.ProductUser := KeyCheck;

    //ŏIXV[h
    Settings.LastUpdate := StrToInt(GetSettings(FileName, 'LastUpdate'));

    //DNSAhX[h
    Settings.Dns := GetSettings(FileName, 'DNS');

    //WebuEŨt@C[h
    Settings.WebBrowser := GetSettings(FileName, 'WebBrowser');

    if Settings.Pop_Port = 0 then Settings.Pop_Port := 110;
    if Settings.Smtp_Port = 0 then Settings.Smtp_Port := 25;
end;

procedure Save_Settings;
var
    FileName : String;
begin
    FileName := ExtractFilePath(ParamStr(0)) + 'jp5dx.ini';
    SaveSettings(FileName, 'ProxyAddress', Settings.Proxy_Addr);
    SaveSettings(FileName, 'ProxyPort', IntToStr(Settings.Proxy_Port));
    SaveSettings(FileName, 'ProxyUser', Settings.Proxy_User);
    SaveSettings(FileName, 'ProxyPass', PasswordEncode(Settings.Proxy_Pass));
    SaveSettings(FileName, 'ExecMax', IntToStr(Settings.Exec_Max));

    if Settings.UsePop then
        SaveSettings(FileName, 'UsePop', 'True')
    else
        SaveSettings(FileName, 'UsePop', 'False');

    if Settings.UseSmtp then
        SaveSettings(FileName, 'UseSmtp', 'True')
    else
        SaveSettings(FileName, 'UseSmtp', 'False');

    if Settings.DenyNoLocalHost then
        SaveSettings(FileName, 'DenyNoLocalHost', 'True')
    else
        SaveSettings(FileName, 'DenyNoLocalHost', 'False');

    if Settings.ExecImmediately then
        SaveSettings(FileName, 'ExecImmediately', 'True')
    else
        SaveSettings(FileName, 'ExecImmediately', 'False');

    (*
    if Settings.PassInputEternally then
        SaveSettings(FileName, 'PassInputEternally', 'True')
    else
        SaveSettings(FileName, 'PassInputEternally', 'False');
	*)

    if Settings.NotifySound then
        SaveSettings(FileName, 'NotifySound', 'True')
    else
        SaveSettings(FileName, 'NotifySound', 'False');

    if Settings.ShowItemList then
        SaveSettings(FileName, 'ShowItemList', 'True')
    else
        SaveSettings(FileName, 'ShowItemList', 'False');

    if Settings.StartOnBoot then
        SaveSettings(FileName, 'StartOnBoot', 'True')
    else
        SaveSettings(FileName, 'StartOnBoot', 'False');

    if Settings.AutoUpdate then
        SaveSettings(FileName, 'AutoUpdate', 'True')
    else
        SaveSettings(FileName, 'AutoUpdate', 'False');

    if Settings.Priority then
        SaveSettings(FileName, 'PriorityUp', 'True')
    else
        SaveSettings(FileName, 'PriorityUp', 'False');

    if Settings.UseProxy then
        SaveSettings(FileName, 'UseProxy', 'True')
    else
        SaveSettings(FileName, 'UseProxy', 'False');

    if Settings.MonoIcon then
        SaveSettings(FileName, 'Monocrome', 'True')
    else
        SaveSettings(FileName, 'Monocrome', 'False');

    if Settings.UseSpeedMail then
        SaveSettings(FileName, 'SpeedMail', 'True')
    else
        SaveSettings(FileName, 'SpeedMail', 'False');

    SaveSettings(FileName, 'PopPort', IntToStr(Settings.Pop_Port));
    SaveSettings(FileName, 'SmtpPort', IntToStr(Settings.Smtp_Port));
    SaveSettings(FileName, 'LastUpdate', IntToStr(Settings.LastUpdate));
    SaveSettings(FileName, 'DNS', Settings.Dns);
    SaveSettings(FileName, 'WebBrowser', Settings.WebBrowser);
end;

function PrepareTemporary : Boolean;
begin
    TempPath := GetTempPath(AppName);
	MkDir(TempPath);
    Result := DirectoryExists(TempPath);
end;

procedure ClearTemporary;
var
    n : Integer;
    List : TNStringList;
begin
    List := SearchFile(TempPath + '*.*');

    for n := 0 to List.Count - 1 do
        DeleteFile(PChar(TempPath + List.Strings[n]));

    if DirectoryExists(TempPath) then
        RmDir(TempPath);
    List.Free;
end;

initialization
    Load_Settings;
    Scripts := TScripts.Create;
    Items := TItems.Create;
    RunAllItems := False;
    RunAddress := '';

finalization
    Scripts.Free;
    Items.Free;

end.
