unit jp5_jobdlg;

interface

uses
    windows, messages, commctrl, shellapi, tn_utils, tn_classes, jp5_dll
    , jp5_kern, jp5_item, tn_stdctl, tn_fw, jp5_sort, tn_crc
    , jp5_crypt, jp5_help;

const
    JOB_DLG         =   2002;

var
    ImgHandle : HIMAGELIST;
    PopupMenu : HMENU;
    Buf : array [0..255] of Char;
    LastSelected : Integer;

//\[X
const
    JOB_TITLE       =   3001;
    JOB_STATUS      =   3002;
    JOB_SCRIPT      =   3003;
    JOB_POPBOX      =   3004;
    JOB_TEMPDATA    =   3005;

    JOB_WORKED      =   3011;
    JOB_STOPPED     =   3012;

    ITEM_NEW        =   3201;

    ITEM_DELETE     =   3401;
    ITEM_CANTDEL    =   3402;

    NOW_CONNECTING  =   3601;
    NOW_DOWNLOAD    =   3602;
    NOW_FINISH      =   3603;
    
//ACR
    IMG_WORKING     =   0;
    IMG_SLEEP       =   1;
    IMG_ERROR       =   2;

//bZ[W
const
    JOB_RUNITEM     =   5001;
    JOB_STOPITEM    =   5002;
    JOB_WEB_LOGIN   =   5003;

    JOB_EXECALL     =   5101;
    JOB_STOPALL     =   5102;

    JOB_ADDITEM     =   5201;
    JOB_DELETE      =   5202;
    JOB_ITEMSET     =   5203;
    JOB_SORT        =   5204;

    JOB_ITEMDIS     =   5301;
    JOB_ITEMENA     =   5302;
    JOB_UPDATE      =   5401;

    JOB_SHORTCUT    =   5501;

    JOB_COPYLOG     =   6001;
    
type
    TItemListDlg    =   class(WModalDialog)
        private
            ImgHandle : THandle;
            ListView : THandle;
            LogMenu : THandle;
            Menu : THandle;
            Progress : THandle;
            procedure SetListView;
            procedure UpdateItem(Handle : THandle ; Index : Integer);
            procedure SetMessages;
            procedure DeleteItem(Path : String);
            procedure CopyToClipboard;
    		procedure SetMenu;
    		procedure ReSize;
        public
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
            procedure OnDestroy(Sender : WObject ; var Return : LRESULT); override;
            procedure OnJupiterMessage(var Message: TMessage); message WM_JPMSG;
            procedure OnJupiterSetCounter(var Message: TMessage); message WM_JPSETCOUNTER;
            procedure OnJupiterConnect(var Message: TMessage); message WM_JPCONNECT;
            procedure OnJupiterDownload(var Message: TMessage); message WM_JPDOWNLOAD;
            procedure OnJupiterFinish(var Message: TMessage); message WM_JPFINISH;
            procedure OnContextMenu(var Message: TMessage); message WM_CONTEXTMENU;
            procedure OnNotify(var Message: TMessage); message WM_NOTIFY;
            procedure OnTimer(var Message: TMessage); message WM_TIMER;
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
            procedure OnSize(var Message: TMessage); message WM_SIZE;
    end;

//procedure
    procedure ShowJobDlg;

implementation


//******************************************************************************
// TItemListDlg

procedure TItemListDlg.OnShow(Sender : WObject ; var Return : LRESULT);
var
	Style : Cardinal;
	rect : TRect;
	widths: array[0..5] of Integer;
begin
    ListView := GetHandle(1000);
    LastSelected := -1;

    //ACRZbg
	SendMessage(Handle, WM_SETICON, ICON_SMALL, TrayIconHandle);

    //WuEBhẼnh擾
    JobHandle := Handle;

    //j[[h
    //MainMenu := LoadMenu(hInstance, MAKEINTRESOURCE(3002));
    PopupMenu := GetSubMenu(MainMenu, 2);
    LogMenu := GetSubMenu(MainMenu, 3);

    //j[Zbg
    Menu := GetMenu(Handle);

    //X^Cݒ
    //Style := GetWindowLong(Handle, GWL_EXSTYLE)
    //            or WS_EX_APPWINDOW or WS_EX_CONTEXTHELP;
    Style := GetWindowLong(Handle, GWL_EXSTYLE) or WS_EX_APPWINDOW;
    SetWindowLong(Handle, GWL_EXSTYLE, Style);

    //^C}[Jn
	SetTimer(Handle, 0, 10, nil);

	//Xe[^Xo[
	widths[0] := 60;
    widths[1] := 120;
    widths[2] := 180;
    widths[3] := 240;
    widths[4] := 290;
    widths[5] := -1;
	CreateStatusWindow(WS_VISIBLE or WS_CHILD, nil, Handle, 1081);
    SendMessage(GetHandle(1081), SB_GETRECT, 0, Integer(@rect));
	SendMessage(GetHandle(1081), SB_SETPARTS, 6, Integer(@widths[0]));

    //vOXo[ݒu
	Progress := CreateWindow('msctls_progress32', 'dl_progress'
    				, WS_CHILD or WS_VISIBLE or PBS_SMOOTH
    				, 0, 0, 1, 1, GetHandle(1081), 0, hInstance, nil);

	SetWindowPos(Progress, 0
    				, 240 + rect.Top
    				, rect.Top
                    , 50 - rect.Top
                    , rect.Bottom - rect.Top
                    , SWP_SHOWWINDOW);

    SendMessage(Progress, PBM_SETRANGE, 0, MAKELPARAM(0, 100));
    //SendMessage(Progress, PBM_SETPOS, 10, 0);
end;

procedure TItemListDlg.OnDestroy(Sender : WObject ; var Return : LRESULT);
var
	FileName : String;
begin
    DestroyMenu(Menu);
    ImageList_Destroy(ImgHandle);
    //SendMessage(TrayHandle, WM_COMMAND, JP_HIDEJOB, 0);

    //ʒuL
	FileName := ExtractFilePath(ParamStr(0)) + 'jp5dx.ini';

	if (GetWindowLong(Handle, GWL_STYLE) and WS_MAXIMIZE = 0)
    	and (GetWindowLong(Handle, GWL_STYLE) and WS_MINIMIZE = 0 ) then
    begin
		SaveSettings(FileName, 'List.x', IntToStr(Left));
		SaveSettings(FileName, 'List.y', IntToStr(Top));
		SaveSettings(FileName, 'List.width', IntToStr(Width));
		SaveSettings(FileName, 'List.height', IntToStr(Height));
    end;

    JobHandle := 0;
end;

procedure TItemListDlg.OnJupiterMessage(var Message: TMessage);
var
    JpMsg : PJpMessage;
    Hand : THandle;
    ItemIndex : Integer;
    NowIndex : Integer;
    n : Integer;
begin
    //bZ[WĂ
    JpMsg := Pointer(Message.WParam);

    if JpMsg.Handle <> 0 then
    begin
        //nhŎw -> CfbNX֕ϊ
        ItemIndex := Items.Handles.IndexOf(JpMsg.Handle);
        if ItemIndex = -1 then Exit;
    end
    else
    begin
        //CfbNXŎw
        if (JpMsg.Index < 0) or (JpMsg.Index >= Items.Count) then Exit;
        ItemIndex := JpMsg.Index;
    end;

    //Xgr[̃nh
    //Hand := GetHandle(1000);

    if JpMsg.Types = mtMessage then
    begin
        //݂̃CfbNX擾
        NowIndex := LV_GetIndex(ListView);

        //Xg{bNXɈsǉ
        if Items.UnConvertIndex(ItemIndex) = NowIndex then
        begin
            Hand := GetHandle(1001);
            SendMessage(Hand, LB_ADDSTRING, 0, Integer(JpMsg.MessageStr));
            n := List_Count(Hand);
            List_SetIndex(Hand,  n - 1);
        end;
    end
    else if JpMsg.Types = mtUpdate then
    begin
        UpdateItem(ListView, ItemIndex);
        SetMenu;
    end;
end;

procedure TItemListDlg.OnJupiterSetCounter(var Message: TMessage);
var
    JpCount : PJpCounter;
begin
    JpCount := Pointer(Message.WParam);

    //SendMessage(GetHandle(1002), WM_SETTEXT
    //                , 0, Integer(PChar(IntToStr(JpCount.Stop))));

    //SendMessage(GetHandle(1003), WM_SETTEXT
    //                , 0, Integer(PChar(IntToStr(JpCount.Run))));

    //SendMessage(GetHandle(1004), WM_SETTEXT
    //                , 0, Integer(PChar(IntToStr(JpCount.Wait))));

    //SendMessage(GetHandle(1005), WM_SETTEXT
    //                , 0, Integer(PChar(IntToStr(JpCount.Err))));

	SendMessage(GetHandle(1081), SB_SETTEXT, 0
    			, Integer(PChar(Format(LoadResourceString(4701)
                , [JpCount.Stop]))));

	SendMessage(GetHandle(1081), SB_SETTEXT, 1
    			, Integer(PChar(Format(LoadResourceString(4702)
                , [JpCount.Run]))));

	SendMessage(GetHandle(1081), SB_SETTEXT, 2
    			, Integer(PChar(Format(LoadResourceString(4703)
                , [JpCount.Wait]))));

	SendMessage(GetHandle(1081), SB_SETTEXT, 3
    			, Integer(PChar(Format(LoadResourceString(4704)
                , [JpCount.Err]))));
end;

procedure TItemListDlg.OnJupiterConnect(var Message: TMessage);
var
    NowIndex : Integer;
    ItemIndex : Integer;
begin
    NowIndex := Items.ConvertIndex(LV_GetIndex(GetHandle(1000)));
    ItemIndex := Items.Handles.IndexOf(Message.WParam);

    //URLۑ
    if ItemIndex <> -1 then
        Items.Urls.Strings[ItemIndex] := String(PChar(Pointer(Message.LParam)));

    //\̍XV
    if NowIndex = ItemIndex then
    begin
        //SendMessage(GetHandle(1007), WM_SETTEXT, 0, Message.LParam);
        //SendMessage(GetHandle(1008), PBM_SETPOS, 0, 0);
		SendMessage(GetHandle(1081), SB_SETTEXT, 5, Message.LParam);
        SendMessage(Progress, PBM_SETPOS, 0, 0);
    end;
end;

procedure TItemListDlg.OnJupiterDownload(var Message: TMessage);
var
    NowIndex : Integer;
    ProgPos : Integer;
    DLInfo : PDownLoadInfo;
begin
    NowIndex := Items.ConvertIndex(LV_GetIndex(GetHandle(1000)));
    DLInfo := Pointer(Message.WParam);

    if Items.Handles.GetValue(NowIndex) = Integer(DLInfo.Handle) then
    begin
        if DLInfo.Length <> 0 then
        begin
	        ProgPos := Trunc(DLInfo.Pos * 100 / DLInfo.Length);
        end
        else
        begin
	        //ProgPos := SendMessage(GetHandle(1008), PBM_GETPOS, 0, 0);
	        ProgPos := SendMessage(Progress, PBM_GETPOS, 0, 0);
            if ProgPos < 100 then Inc(ProgPos, 5);
        end;

        //vOXo[̐ݒ
        //SendMessage(GetHandle(1008), PBM_SETPOS, ProgPos, 0);
        SendMessage(Progress, PBM_SETPOS, ProgPos, 0);
    end;
end;

procedure TItemListDlg.OnJupiterFinish(var Message: TMessage);
var
    NowIndex : Integer;
begin
    NowIndex := Items.ConvertIndex(LV_GetIndex(GetHandle(1000)));

    if Items.Handles.GetValue(NowIndex) = Message.WParam then
    begin
        //vOXo[̐ݒ
        //SendMessage(GetHandle(1008), PBM_SETPOS, 0, 0);
        SendMessage(Progress, PBM_SETPOS, 0, 0);
    end;
end;

procedure TItemListDlg.OnContextMenu(var Message: TMessage);
var
    Count : Integer;
    ItemIndex : Integer;
    tp : TPoint;
begin
    GetCursorPos(tp);

    if THandle(Message.WParam) = ListView then
    begin
        //Xgr[Cxg
        Count := LV_GetSelectedCount(ListView);

        if Count = 0 then
        begin
            EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
            EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_GRAYED);
            EnableMenuItem(PopupMenu, 5003, MF_BYCOMMAND or MF_GRAYED);

            EnableMenuItem(PopupMenu, 5202, MF_BYCOMMAND or MF_GRAYED);
            EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_GRAYED);

            EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
            EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);

            EnableMenuItem(PopupMenu, 5501, MF_BYCOMMAND or MF_GRAYED);
        end
        else
        begin
            ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

            EnableMenuItem(PopupMenu, 5202, MF_BYCOMMAND or MF_ENABLED);
            EnableMenuItem(PopupMenu, 5501, MF_BYCOMMAND or MF_ENABLED);

            if (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_EXEC))
                or (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_WAIT)) then
            begin
                //s
                EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
                EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_ENABLED);
                EnableMenuItem(PopupMenu, 5003, MF_BYCOMMAND or MF_GRAYED);

                EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_GRAYED);

                EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
                EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);
            end
            else
            begin
                //~
                EnableMenuItem(PopupMenu, 5002, MF_BYCOMMAND or MF_GRAYED);
                EnableMenuItem(PopupMenu, 5203, MF_BYCOMMAND or MF_ENABLED);

                if Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_DISABLE) then
                begin
                    EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_GRAYED);
                    EnableMenuItem(PopupMenu, 5003, MF_BYCOMMAND or MF_GRAYED);
                    EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_GRAYED);
                    EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_ENABLED);
                end
                else
                begin
                    EnableMenuItem(PopupMenu, 5001, MF_BYCOMMAND or MF_ENABLED);
                    EnableMenuItem(PopupMenu, 5003, MF_BYCOMMAND or MF_ENABLED);
                    EnableMenuItem(PopupMenu, 5301, MF_BYCOMMAND or MF_ENABLED);
                    EnableMenuItem(PopupMenu, 5302, MF_BYCOMMAND or MF_GRAYED);
                end;
            end;
        end;

        TrackPopupMenu(PopupMenu, TPM_LEFTALIGN or TPM_RIGHTBUTTON
                                                , tp.X, tp.Y, 0, Handle, nil);
    end
    else if THandle(Message.WParam) = GetHandle(1001) then
    begin
        TrackPopupMenu(LogMenu, TPM_LEFTALIGN or TPM_RIGHTBUTTON
                                                , tp.X, tp.Y, 0, Handle, nil);
    end;
end;

procedure TItemListDlg.OnNotify(var Message: TMessage);
var
    Action : PNMLISTVIEW;
    ItemIndex : Integer;
begin
    Action := Pointer(Message.LParam);

    case Message.WParam of
        1000:
            begin
                if (Action.hdr.code = NM_CLICK)
                    or (Action.hdr.code = NM_RCLICK) then
                begin
                    if (LastSelected <> -1) and (LV_GetIndex(ListView) = -1) then
                    begin
                        LastSelected := -1;
                        SendMessage(GetHandle(1001), LB_RESETCONTENT, 0, 0);
                        SetMenu;
                        Exit;
                    end;

                    ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

                    //ڂ͕ύXĂȂ
                    if LastSelected = ItemIndex then Exit;

                    //vOXo[Zbg
                    //SendMessage(GetHandle(1008), PBM_SETPOS, 0, 0);
                    SendMessage(Progress, PBM_SETPOS, 0, 0);

                    //j[̐ݒ
					SetMenu;
                    
                    //bZ[W\
                    LastSelected := ItemIndex;
                    SetMessages;
                end
                else if Action.hdr.code = NM_DBLCLK then
                begin
                    //IACes
                    ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

                    if TScriptStatus(Items.Statuses.GetValue(ItemIndex)) = ITEM_IDLE then
                    begin
                        SendMessage(GetHandle(1001), LB_RESETCONTENT, 0, 0);
                        SendMessage(TrayHandle, WM_JPSTART, ItemIndex, 0);
                    end;
                end;
            end;

        1001:
            begin
            end;
    end;
end;

procedure TItemListDlg.OnTimer(var Message: TMessage);
var
	Style : Cardinal;
    FileName : String;
    x, y : Integer;
begin
	//^C}[~
    KillTimer(Handle, 0);

    //5.0x X^C
    LV_SetStyle(ListView, LVS_EX_FULLROWSELECT or LVS_EX_GRIDLINES);

    //C[WXgݒ
    ImgHandle := ImageList_LoadImage(hInstance, 'JOB_IMG', 16, 0
                        , RGB(255, 0, 255), IMAGE_BITMAP, LR_CREATEDIBSECTION);
    LV_SetImageList(ListView, ImgHandle);

    //Jݒ
    repeat
        ProcessMessage;
        LV_AddColumn(ListView, PChar(LoadResourceString(JOB_TITLE)), 0, 200);
        LV_AddColumn(ListView, PChar(LoadResourceString(JOB_STATUS)), 1, 70);
        LV_AddColumn(ListView, PChar(LoadResourceString(JOB_SCRIPT)), 2, 100);
        LV_AddColumn(ListView, PChar(LoadResourceString(JOB_POPBOX)), 3, 50);
        LV_AddColumn(ListView, PChar(LoadResourceString(JOB_TEMPDATA)), 4, 50);
        ProcessMessage;
    until SendMessage(ListView, LVM_GETCOLUMNWIDTH, 0, 0) <> 0;

    //Xgr[̃X^C
    Style := GetWindowLong(ListView, GWL_STYLE) or ES_NOHIDESEL;
    SetWindowLong(ListView, GWL_STYLE, Style);

    //Xgr[̐ݒ
    SetListView;

    //vOXo[̐ݒ
    //SendMessage(GetHandle(1008), PBM_SETRANGE, 0, MAKELPARAM(0, 100));
    SendMessage(Progress, PBM_SETRANGE, 0, MAKELPARAM(0, 100));

    //EBhEʒu𕜊
	FileName := ExtractFilePath(ParamStr(0)) + 'jp5dx.ini';
	x := StrToInt(GetSettings(FileName, 'List.x'));
	y := StrToInt(GetSettings(FileName, 'List.y'));

	if (x < GetSystemMetrics(SM_CXSCREEN))
    	and (y < GetSystemMetrics(SM_CYSCREEN))
        and (x > -Width) and (y > -Height) then
    begin
	    if (x <> 0) and (y <> 0) then
    	begin
        	Left := x;
	    	Top := y;
    	end;
    end;

    //EBhETCY𕜊
	x := StrToInt(GetSettings(FileName, 'List.width'));
	y := StrToInt(GetSettings(FileName, 'List.height'));

	if (x > 0) and (y > 0) and (x <= GetSystemMetrics(SM_CXSCREEN))
    	and (y <= GetSystemMetrics(SM_CYSCREEN)) then
    begin
		Width := x;
        Height := y;
    end;

    //j[̐ݒ
    SetMenu;
end;

procedure TItemListDlg.OnCommand(Sender : WObject ; wParam : Integer
                                    ; lParam : Integer ; var Return : LRESULT);
var
    ItemIndex : Integer;
    n : Integer;
    Info : TAccitemInfo;
    FolderIndex : Integer;
    Index : Integer;
    temp : String;
begin
	if wParam >= 10000 then
    begin
    	Index := wParam - 10000;
		Return := SendMessage(TrayHandle, WM_COMMAND, Index, 0);
        Exit;
    end;

    case wParam of
        IDCANCEL:
            inherited;
            
        JOB_RUNITEM:
            begin
                //IACes
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));
                SendMessage(GetDlgItem(Handle, 1001), LB_RESETCONTENT, 0, 0);
                SendMessage(TrayHandle, WM_JPSTART, ItemIndex, 0);
            end;

        JOB_STOPITEM:
            begin
                //IACe~
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));
                SendMessage(TrayHandle, WM_JPSTOP, ItemIndex, 0);
            end;

        JOB_WEB_LOGIN:
            begin
                //IACes
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));
                //BrowserLogin(ItemIndex);
                SendMessage(TrayHandle, WM_JPSTART, ItemIndex, 1);
            end;

        JOB_EXECALL:
            begin
                //ׂĎs
                for n := 0 to Items.Count - 1 do
                begin
                    if Items.Statuses.GetValue(n) = Integer(ITEM_IDLE) then
                        Items.Statuses.SetValue(n, Integer(ITEM_WAIT));
                end;
            end;

        JOB_STOPALL:
            begin
                //s̃ACeׂĒ~
                for n := 0 to Items.Count - 1 do
                begin
                    case TScriptStatus(Items.Statuses.GetValue(n)) of
                        ITEM_EXEC, ITEM_WAIT:
                            SendMessage(TrayHandle, WM_JPSTOP, n, 0);
                    end;
                end;
            end;

        JOB_ADDITEM:
            begin
                //ACeǉ
                Info.Title := LoadResourceString(ITEM_NEW);
                Info.ScriptTitle := '';
                Info.User := '';
                Info.Pass := '';
                Info.Address := '';
                Info.Option := '';
                Info.SaveCache := False;
                Info.SaveCookie := True;
                Info.Disable := False;
                Info.PopAddr := '';
                Info.PopPort := 110;
                Info.SmtpAddr := '';
                Info.SmtpPort := 25;
                Info.Delete := True;

                if ShowItemDlg(Handle, Info) then
                begin
                    FolderIndex := CreateNewItemFolder(ExtractFilePath(ParamStr(0))
                                                                    + 'datas\');
                    if FolderIndex <> -1 then
                    begin
                        Info.FileName := Items.MakePath(FolderIndex) + 'item.ini';
                        SaveItem(Info);
                        Items.Add(FolderIndex);
                        Items.AddSortIndex(FolderIndex);
                        SetListView;
                        SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                    end;
                end;
            end;

        JOB_ITEMSET:
            begin
                //ACe̐ݒύX
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));
                temp := Items.Paths[ItemIndex] + 'item.ini';
                Info := LoadItem(temp);

                if ShowItemDlg(Handle, Info) then
                begin
                    Items.Aliases.Strings[ItemIndex] := Info.Alias;
                    Items.Titles.Strings[ItemIndex] := Info.Title;
                    Items.Scripts.Strings[ItemIndex] := Info.ScriptTitle;
                    Items.Mails.Strings[ItemIndex] := Info.Address;

                    if Info.Disable then
                        Items.Statuses.Values[ItemIndex] := Integer(ITEM_DISABLE)
                    else
                        Items.Statuses.Values[ItemIndex] := Integer(ITEM_IDLE);

                    Items.Times.Values[ItemIndex] := Info.Time;
                    Items.ExecType.Values[ItemIndex] := Integer(Info.IntCheck);

                    SaveItem(Info);
                    UpdateItem(ListView, ItemIndex);

                    //j[̍XV
                    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                    SetMenu;

                    //ԂZbg
                    if Items.ExecType.GetValue(ItemIndex) = Integer(EXE_HOUR) then
                        Items.Lasts.SetValue(ItemIndex, 0)
                    else
                        Items.Lasts.SetValue(ItemIndex, NowDateTime);
                end;
            end;

        JOB_SORT:
            begin
                if ShowSortDlg then
                begin
                    //Xgr[\
                    SetListView;

                    //j[̍XV
                    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                    SetMenu;
                end;
            end;

        JOB_DELETE:
            begin
                //IACe̍폜
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

                //sǂ
                if Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_EXEC) then
                begin
                    MessageBox(Handle, PChar(LoadResourceString(ITEM_CANTDEL))
                                , PChar(TITLE), MB_TOPMOST or MB_SETFOREGROUND
                                                            or MB_ICONWARNING);
                    Exit;
                end;

                temp := Format(LoadResourceString(ITEM_DELETE)
                                , [Items.Titles.Strings[ItemIndex]]);

                if MessageBox(Handle, PChar(temp), PChar(TITLE)
                                , MB_YESNO or MB_TOPMOST or MB_SETFOREGROUND
                                    or MB_ICONWARNING) = IDYES then
                begin
                    DeleteItem(Items.Paths[ItemIndex]);
                    Items.Delete(ItemIndex);

                    //Xgr[̕\
                    SetListView;

                    //j[̍XV
                    SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                    SetMenu;
                end;
            end;

        JOB_ITEMDIS:
            begin
                //IꂽACe𖳌ɂ
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

                Items.Statuses.SetValue(ItemIndex, Integer(ITEM_DISABLE));
                SaveSettings(Items.Paths[ItemIndex] + 'item.ini', 'Disable', 'True');
                UpdateItem(ListView, ItemIndex);

                //j[̍XV
                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                SetMenu;
            end;

        JOB_ITEMENA:
            begin
                //IꂽACeLɂ
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

                Items.Statuses.SetValue(ItemIndex, Integer(ITEM_IDLE));
                SaveSettings(Items.Paths[ItemIndex] + 'item.ini', 'Disable', 'False');
                UpdateItem(ListView, ItemIndex);

                //j[̍XV
                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                SetMenu;
            end;

        JOB_UPDATE:
            begin
                //Xgr[\
                SetListView;

                //j[̍XV
                SendMessage(TrayHandle, WM_COMMAND, JP_MENUUPDATE, 0);
                SetMenu;
            end;

        JOB_SHORTCUT:
            begin
                //fXNgbvփV[gJbg쐬
                ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));
                CreateLink(ParamStr(0)
                            , '/r:' + Items.Mails.Strings[ItemIndex]
                            , GetDesktopPath
                                + Items.Titles.Strings[ItemIndex] + '.lnk'
                            , 5, '');
            end;

        JOB_COPYLOG:
            begin
                //ONbv{[hɃRs[
                CopyToClipboard;
            end;

        7101:
        	begin
            end;
    end;
end;

procedure TItemListDlg.OnSize(var Message: TMessage);
begin
	ReSize;
end;

procedure TItemListDlg.SetListView;
var
    n : Integer;
    List : TNStringList;
    ImgIndex : Integer;
    Index : Integer;
    //Files : TNStringList;
begin
    List := TNStringList.Create;

    //ACeׂč폜
    ListView_DeleteAllItems(ListView);

    //ACe\
    for n := 0 to Items.Count - 1 do
    begin
        List.Clear;
        Index := Items.ConvertIndex(n);
        List.Add(Items.Titles.Strings[Index]);

        ImgIndex := Items.Statuses.GetValue(Index);
        List.Add(LoadResourceString(3011 + ImgIndex));
        List.Add(Items.Scripts.Strings[Index]);

        //POPT[oɃXv[ꂽf[^
        List.Add(IntToStr(SearchFileCount(Items.Paths[Index] + 'savebox\*.eml')));

        //SMTPT[oɃXv[ꂽf[^
        List.Add(IntToStr(SearchFileCount(Items.Paths[Index] + 'loadbox\*.eml')));

        //Xgr[ɒǉ
        LV_AddItem(ListView, List, ImgIndex);
    end;

    List.Free;
end;

procedure TItemListDlg.UpdateItem(Handle : THandle ; Index : Integer);
var
    List : TNStringList;
    ImgIndex : Integer;
    Files : TNStringList;
begin
    //ACeݒ̂߂StringList
    List := TNStringList.Create;
    List.Clear;
    List.Add(Items.Titles.Strings[Index]);

    ImgIndex := Items.Statuses.GetValue(Index);
    List.Add(LoadResourceString(3011 + ImgIndex));
    List.Add(Items.Scripts.Strings[Index]);

    //POPT[oɃXv[ꂽf[^
    Files := SearchFile(Items.Paths[Index] + 'savebox\*.eml');
    List.Add(IntToStr(Files.Count));
    Files.Free;

    //SMTPT[oɃXv[ꂽf[^
    Files := SearchFile(Items.Paths[Index] + 'loadbox\*.eml');
    List.Add(IntToStr(Files.Count));
    Files.Free;

    //Xgr[ɒǉ
    LV_SetItem(Handle, List, ImgIndex, Items.UnConvertIndex(Index));

    List.Free;
end;

procedure TItemListDlg.SetMessages;
var
    Index : Integer;
    MsgHandle : THandle;
    Lines : TNStringList;
    n : Integer;
begin
    //
    MsgHandle := GetHandle(1001);
    Index := Items.ConvertIndex(LV_GetIndex(ListView));

    //ׂĂ̍ڂ폜
    SendMessage(MsgHandle, LB_RESETCONTENT, 0, 0);

    Lines := TNStringList.Create;
    Lines.Text := Items.Messages.Strings[Index];

    for n := 0 to Lines.Count - 1 do
    begin
        SendMessage(MsgHandle, LB_ADDSTRING, 0, Integer(PChar(Lines.Strings[n])));
    end;

    //URLZbg
    //SendMessage(GetHandle(1007)
    //                , WM_SETTEXT, 0
    //                , Integer(PChar(Items.Urls.Strings[Index])));

	SendMessage(GetHandle(1081), SB_SETTEXT, 5, Integer(PChar(Items.Urls.Strings[Index])));
    Lines.Free;
end;

procedure TItemListDlg.DeleteItem(Path : String);
var
    Folders : TNStringList;
    Files : TNStringList;
    n : Integer;
begin
    Folders := SearchFolder(Path);
    Files := SearchFile(Path + '*.*');

    //t@C폜
    for n := 0 to Files.Count - 1 do
        DeleteFile(PChar(Path + Files.Strings[n]));

    //tH_폜
    for n := 0 to Folders.Count - 1 do
        DeleteItem(PChar(Path + Folders.Strings[n] + '\'));

    //IuWFNgj
    Folders.Free;
    Files.Free;

    //̃tH_폜
    RemoveDirectory(PChar(Path));
end;

procedure TItemListDlg.CopyToClipboard;
var
    Index : Integer;
    Data : String;
    Mem : THandle;
    p : PChar;
begin
    //ACẽCfbNX擾
    Index := LV_GetIndex(ListView);
    if Index = -1 then Exit;
    Index := Items.ConvertIndex(Index);

    //bZ[W擾
    Data := Items.Messages.Strings[Index];
    if Data = '' then Exit;

    //Global𑀍
    Mem := GlobalAlloc(GMEM_MOVEABLE or GMEM_DDESHARE, Length(Data) + 1);
    p := GlobalLock(Mem);
    lstrcpy(p, PChar(Data));
	GlobalUnlock(Mem);

    //Nbv{[hɃf[^Zbg
    while not OpenClipboard(Handle) do
        Sleep(10);

    EmptyClipboard;
    SetClipboardData(CF_TEXT, Mem);
    ProcessMessage;
    GlobalUnlock(Mem);
    CloseClipboard;

    //GlobalJ
    GlobalFree(Mem);
end;

procedure TItemListDlg.SetMenu;
var
	ItemIndex : Integer;
begin
	ItemIndex := Items.ConvertIndex(LV_GetIndex(ListView));

    if ItemIndex <> -1 then
    begin
	    EnableMenuItem(Menu, 5501, MF_BYCOMMAND or MF_ENABLED);

		if (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_EXEC))
    		or (Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_WAIT)) then
	    begin
			//s
			EnableMenuItem(Menu, 5001, MF_BYCOMMAND or MF_GRAYED);
			EnableMenuItem(Menu, 5002, MF_BYCOMMAND or MF_ENABLED);
        	EnableMenuItem(Menu, 5003, MF_BYCOMMAND or MF_GRAYED);

	        EnableMenuItem(Menu, 5202, MF_BYCOMMAND or MF_GRAYED);
    	    EnableMenuItem(Menu, 5203, MF_BYCOMMAND or MF_GRAYED);

			EnableMenuItem(Menu, 5301, MF_BYCOMMAND or MF_GRAYED);
    	    EnableMenuItem(Menu, 5302, MF_BYCOMMAND or MF_GRAYED);
		end
		else
		begin
			//~
			EnableMenuItem(Menu, 5002, MF_BYCOMMAND or MF_GRAYED);

	        EnableMenuItem(Menu, 5202, MF_BYCOMMAND or MF_ENABLED);
			EnableMenuItem(Menu, 5203, MF_BYCOMMAND or MF_ENABLED);

			if Items.Statuses.GetValue(ItemIndex) = Integer(ITEM_DISABLE) then
			begin
				EnableMenuItem(Menu, 5001, MF_BYCOMMAND or MF_GRAYED);
		        EnableMenuItem(Menu, 5003, MF_BYCOMMAND or MF_GRAYED);

    			EnableMenuItem(Menu, 5301, MF_BYCOMMAND or MF_GRAYED);
			    EnableMenuItem(Menu, 5302, MF_BYCOMMAND or MF_ENABLED);
			end
			else
			begin
				EnableMenuItem(Menu, 5001, MF_BYCOMMAND or MF_ENABLED);
		        EnableMenuItem(Menu, 5003, MF_BYCOMMAND or MF_ENABLED);

			    EnableMenuItem(Menu, 5301, MF_BYCOMMAND or MF_ENABLED);
		    	EnableMenuItem(Menu, 5302, MF_BYCOMMAND or MF_GRAYED);
			end;
        end;
	end
    else
    begin
        EnableMenuItem(Menu, 5001, MF_BYCOMMAND or MF_GRAYED);
        EnableMenuItem(Menu, 5002, MF_BYCOMMAND or MF_GRAYED);
        EnableMenuItem(Menu, 5003, MF_BYCOMMAND or MF_GRAYED);

        EnableMenuItem(Menu, 5202, MF_BYCOMMAND or MF_GRAYED);
        EnableMenuItem(Menu, 5203, MF_BYCOMMAND or MF_GRAYED);

        EnableMenuItem(Menu, 5301, MF_BYCOMMAND or MF_GRAYED);
        EnableMenuItem(Menu, 5302, MF_BYCOMMAND or MF_GRAYED);

	    EnableMenuItem(Menu, 5501, MF_BYCOMMAND or MF_GRAYED);
    end;
end;

procedure TItemListDlg.ReSize;
var
	rect : TRect;
    winrect : TRect;
    wid : Integer;
    hei : Integer;
    status_hei : Integer;
begin
	GetClientRect(Handle, rect);

    wid := rect.Right - rect.Left;
    hei := rect.Bottom - rect.Top;

	//Xe[^Xo[
    GetWindowRect(GetHandle(1081), winrect);
    status_hei := winrect.Bottom - winrect.Top;
	SetWindowPos(GetHandle(1081), 0, 0
    				, hei - status_hei
    				, wid, hei, 0);

    //ACeXg
    hei := hei - status_hei;
	SetWindowPos(GetHandle(1000), 0, 0, 0, wid, (hei * 3) div 5, 0);

    //O
	SetWindowPos(GetHandle(1001), 0, 0, (hei * 3) div 5 + 1, wid
    				, hei - (hei * 3) div 5 + 1, 0);
end;

//******************************************************************************

procedure ShowJobDlg;
var
    Dlg : TItemListDlg;
begin
    Dlg := TItemListDlg.Create(TrayHandle, '2002');
    Dlg.Show;
    //Dlg.Free;
end;

end.
