unit jp5_item;

interface

uses
    windows, messages, tn_classes, jp5_kern, tn_stdctl, tn_utils, jp5_mailer
        , jp5_itemchk, tn_fw, jp5_adv, jp5_help;

//procedures
    function ShowItemDlg(Handle : THandle ; var TargetInfo : TAccItemInfo) : Boolean;

const
    ITEM_DLG        =   2004;
    ID_CHKTIME      =   1011;
    ID_MAILER       =   1012;

//\[X
const
    ERR_NOTITLE     =   3211;
    ERR_NOUSER      =   3212;
    ERR_NOPASS      =   3213;
    ERR_NOADDRESS   =   3214;

    STR_EXE_NONE    =   3701;
    STR_EXE_HOUR    =   3702;
    STR_EXE_INT     =   3703;

type
    TItemDlg        =   class(WModalDialog)
        private
            Info : PAccItemInfo;
            Canceled : Boolean;
            procedure Prepare;
        public
            procedure OnCommand(Sender : WObject ; wParam : Integer ; lParam : Integer ; var Return : LRESULT); override;
            procedure OnShow(Sender : WObject ; var Return : LRESULT); override;
    end;

implementation

//******************************************************************************

procedure TItemDlg.Prepare;
var
    n : Integer;
    Index : Integer;
    Handle : THandle;
begin
    //ACeݒ
    Ctl_SetText(GetHandle(1001), Info.Title);

    //XNvgǉ
    Handle := GetHandle(1002);

    for n := 0 to Scripts.Count - 1 do
        Combo_Add(Handle, Scripts.Strings[n]);

    //Ώۂ̃XNvgɂ킹
    Handle := GetHandle(1002);
    Index := Combo_IndexOf(Handle, Info.ScriptTitle);

    if Index = CB_ERR then
        Combo_SetIndex(Handle, 0)
    else
        Combo_SetIndex(Handle, Index);

    Ctl_SetText(GetHandle(1003), Info.User);
    Ctl_SetText(GetHandle(1004), Info.Pass);
    Ctl_SetText(GetHandle(1005), Info.Address);
    //Ctl_SetText(GetHandle(1006), Info.Option);
    Ctl_SetCheck(GetHandle(1007), Info.SaveCache);
    Ctl_SetCheck(GetHandle(1008), Info.SaveCookie);
    Ctl_SetCheck(GetHandle(1009), Info.Disable);

    case Info.IntCheck of
        EXE_NONE:
            Ctl_SetText(GetHandle(1010), LoadResourceString(STR_EXE_NONE));

        EXE_HOUR:
            Ctl_SetText(GetHandle(1010)
                            , Format(LoadResourceString(STR_EXE_HOUR)
                            ,[Info.Time]));
        EXE_INT:
            Ctl_SetText(GetHandle(1010)
                            , Format(LoadResourceString(STR_EXE_INT)
                            , [Info.Time]));
    end;

    Ctl_SetCheck(GetHandle(1013), Info.Delete);
end;

procedure TItemDlg.OnCommand(Sender : WObject ; wParam : Integer
                                ; lParam : Integer ; var Return : LRESULT);
begin
    if wParam = IDOK then
    begin
        Info.Title := Ctl_GetText(GetHandle(1001));
        Info.ScriptTitle := Ctl_GetText(GetHandle(1002));
        Info.User := Ctl_GetText(GetHandle(1003));
        Info.Pass := Ctl_GetText(GetHandle(1004));
        Info.Address := Ctl_GetText(GetHandle(1005));
        //Info.Option := Ctl_GetText(GetHandle(1006));
        Info.SaveCache := Ctl_IsChecked(GetHandle(1007));
        Info.SaveCookie := Ctl_IsChecked(GetHandle(1008));
        Info.Disable := Ctl_IsChecked(GetHandle(1009));

        if Info.Title = '' then
        begin
            MessageBox(Handle, PChar(LoadResourceString(ERR_NOTITLE))
                        , PChar(TITLE), MB_ICONWARNING);
            Exit;
        end;

        if Info.User = '' then
        begin
            MessageBox(Handle, PChar(LoadResourceString(ERR_NOUSER))
                        , PChar(TITLE), MB_ICONWARNING);
            Exit;
        end;

        if Info.Address = '' then
        begin
            MessageBox(Handle, PChar(LoadResourceString(ERR_NOADDRESS))
                        , PChar(TITLE), MB_ICONWARNING);
            Exit;
        end;

        Info.Delete := Ctl_IsChecked(GetHandle(1013));

        Canceled := False;
        Close;
    end
    else if wParam = IDCANCEL then
        Close
    else if wParam = ID_MAILER then
        ShowMailerDlg(Handle, Info^)
    else if wParam = 1014 then
        ShowAdvanceDlg(Handle, Info^)
    else if wParam = ID_CHKTIME then
    begin
        ShowItemChkDlg(Handle, Info^);

        case Info.IntCheck of
            EXE_NONE:
                Ctl_SetText(GetHandle(1010), LoadResourceString(STR_EXE_NONE));

            EXE_HOUR:
                Ctl_SetText(GetHandle(1010)
                                , Format(LoadResourceString(STR_EXE_HOUR)
                                ,[Info.Time]));

            EXE_INT:
                Ctl_SetText(GetHandle(1010)
                                , Format(LoadResourceString(STR_EXE_INT)
                                , [Info.Time]));
        end;
    end;
end;

procedure TItemDlg.OnShow(Sender : WObject ; var Return : LRESULT);
//var
//    Style : Cardinal;
begin
    //Window?ACRǉ
    //Style := GetWindowLong(Handle, GWL_EXSTYLE);
    //Style := Style or WS_EX_CONTEXTHELP;
    //SetWindowLong(Handle, GWL_EXSTYLE, Style);

    Prepare;
end;

//******************************************************************************

function ShowItemDlg(Handle : THandle ; var TargetInfo : TAccItemInfo) : Boolean;
var
    Dlg : TItemDlg;
begin
    Dlg := TItemDlg.Create(Handle, '2004');
    Dlg.Canceled := True;
    Dlg.Info := @TargetInfo;
    Dlg.ShowModal;

    Result := not Dlg.Canceled;

    Dlg.Free;
end;

end.
