unit jp5_inst;

interface

uses
    windows, messages, shellapi, tn_classes, jp5_kern, tn_stdctl, tn_utils;

//procedures
    procedure ShowInstScriptDlg;
    function InstallScript(Handle : THandle ; FileName : String) : Boolean;

const
    INSTSCRIPT_DLG      =   2011;

//\[X
const
    NOT_JSFILE          =   3801;
    NO_JAGA_HEAD        =   3802;
    CANT_INST           =   3803;
    NO_RELEASE_NUM      =   3804;
    NOT_NES_UPD         =   3805;
    CANT_UPD            =   3806;
    SHORT_FILE          =   3807;
    SUCCESS_UPD         =   3808;

implementation

procedure ShowInstScriptDlg;

    function DialogCallBack(hDlg : THandle ; uMsg : Cardinal ; wParam : Integer ; lParam : integer) : BOOL; stdcall;
    var
        dummy : Integer;
        Buf : array [0..511] of Char;
        NewFile : String;
    begin
        Result := True;

        case uMsg of
            WM_COMMAND:
                begin
                    case WParam of
                        IDOK:
                            begin
                                //XNvgCXg[
                                NewFile := Ctl_GetText(GetDlgItem(hDlg, 1001));

                                if NewFile = '' then Exit;
                                if InstallScript(hDlg, NewFile) then
                                    EndDialog(hDlg, 0);
                            end;

                        IDCANCEL:
                            begin
                                EndDialog(hDlg, 0);
                            end;
                    end;

                    Result := False;
                end;

            WM_DROPFILES:
                begin
                    Result := False;
                    FillChar(Buf, SizeOf(Buf), #0);
                    DragQueryFile(wParam, 0, Buf, SizeOf(Buf));
                    NewFile := String(PChar(@Buf));

                    //t@C̃`FbN
                    if UpperCase(ExtractFileExt(NewFile)) <> 'JS' then
                    begin
                        MessageBox(TrayHandle
                                    , PChar(Format(LoadResourceString(NOT_JSFILE)
                                                , [NewFile]))
                                    , TITLE
                                    , MB_TOPMOST or MB_SETFOREGROUND
                                                        or MB_ICONWARNING);
                        //hbȌI
                        DragFinish(wParam);
                        Exit;
                    end;

                    //pX̃`FbN
                    if Pos(ExtractFilePath(ParamStr(0))
                            , ExtractFilePath(NewFile)) <> 0 then
                    begin
                        MessageBox(hDlg
                                    , PChar(Format(LoadResourceString(CANT_INST)
                                                , [NewFile]))
                                    , TITLE
                                    , MB_TOPMOST or MB_SETFOREGROUND
                                        or MB_ICONWARNING);

                        //hbȌI
                        DragFinish(wParam);
                        Exit;
                    end;

                    //^Cg̃`FbN
                    if GetSettings(NewFile, '//ScriptTitle') = '' then
                    begin
                        MessageBox(hDlg
                                    , PChar(Format(LoadResourceString(NO_JAGA_HEAD)
                                                , [NewFile]))
                                    , TITLE
                                    , MB_TOPMOST or MB_SETFOREGROUND
                                        or MB_ICONWARNING);

                        //hbȌI
                        DragFinish(wParam);
                        Exit;
                    end;

                    //o[W̃`FbN
                    if GetSettings(NewFile, '//ScriptVersion') = '' then
                    begin
                        MessageBox(hDlg
                                    , PChar(Format(LoadResourceString(NO_RELEASE_NUM)
                                                , [NewFile]))
                                    , TITLE
                                    , MB_TOPMOST or MB_SETFOREGROUND
                                        or MB_ICONWARNING);

                        //hbȌI
                        DragFinish(wParam);
                        Exit;
                    end;

                    //\
                    Ctl_SetText(GetDlgItem(hDlg, 1001), NewFile);
                    Ctl_SetText(GetDlgItem(hDlg, 1002)
                                    , GetSettings(NewFile, '//ScriptTitle'));

                    //hbȌI
                    DragFinish(wParam);
                end;

            WM_INITDIALOG:
                begin
                    Result := False;
                    DragAcceptFiles(hDlg, True);

                    //tH[JXZbg
                    SetActiveWindow(hDlg);
                    SetForegroundWindow(hDlg);
                    SendMessage(GetDlgItem(hDlg, 1), WM_SETFOCUS, 0, 0);
                end;

            WM_DRAWITEM:
                begin
                end;

            WM_CLOSE:
                begin
                    dummy := 0;
                    EndDialog(hDlg, dummy);
                    Result := False;
                end;

            else
                Result := False;
        end;
    end;

begin
    SetActiveWindow(GetDesktopWindow);
    SetForegroundWindow(GetDesktopWindow);

	if JobHandle = 0 then
	    DialogBox(hInstance, MAKEINTRESOURCE(INSTSCRIPT_DLG), TrayHandle, @DialogCallBack)
    else
	    DialogBox(hInstance, MAKEINTRESOURCE(INSTSCRIPT_DLG), JobHandle, @DialogCallBack);
end;

function InstallScript(Handle : THandle ; FileName : String) : Boolean;
var
    Path : String;
    TargetPath : String;
    NewNum : Integer;
    OldNum : Integer;
    OldFile : String;
    List : TNStringList;
    temp : String;
    n : Integer;
begin
    Result := False;
    Path := ExtractFilePath(FileName);
    TargetPath := ExtractFilePath(ParamStr(0)) + 'scripts\';
    OldFile := TargetPath + ExtractFileName(FileName);

    //Vt@C̃[Xio[擾
    NewNum := StrToInt(GetSettings(FileName, '//ScriptVersion'));

    //Ât@CƂ̓[Xio[̔r
    if FileExists(OldFile) then
    begin
        OldNum := StrToInt(GetSettings(OldFile, '//ScriptVersion'));

        if NewNum = OldNum then
        begin
            MessageBox(Handle, PChar(LoadResourceString(NOT_NES_UPD))
                        , TITLE, MB_TOPMOST or MB_SETFOREGROUND
                            or MB_ICONINFORMATION);
            Exit;
        end;

        if NewNum < OldNum then
        begin
            MessageBox(Handle, PChar(LoadResourceString(CANT_UPD))
                        , TITLE, MB_TOPMOST or MB_SETFOREGROUND or MB_ICONERROR);
            Exit;
        end;
    end;

    //ǉt@C擾
    temp := GetSettings(FileName, '//CopyFiles');

    List := TNStringList.Create;
    List.Text := Replace(temp, ',', #13#10);

    for n := 0 to List.Count - 1 do
    begin
        if not FileExists(Path + List.Strings[n]) then
        begin
            MessageBox(Handle, PChar(LoadResourceString(SHORT_FILE))
                        , TITLE, MB_TOPMOST or MB_SETFOREGROUND or MB_ICONERROR);
            List.Free;
            Exit;
        end;
    end;

    //XNvgXV
    CopyFile(PChar(FileName), PChar(OldFile), False);

    for n := 0 to List.Count - 1 do
    begin
        CopyFile(PChar(Path + List.Strings[n])
                    , PChar(TargetPath + List.Strings[n]), False);
    end;

    MessageBox(Handle, PChar(LoadResourceString(SUCCESS_UPD))
                , TITLE, MB_TOPMOST or MB_SETFOREGROUND or MB_ICONINFORMATION);

    Result := True;
    List.Free;
end;

end.
