unit jp5_dll;

interface

uses
    windows;

type
    TItemInfo       =   record
        FileName    :   PChar;
        CustomInfo  :   PChar;
        Handle      :   THandle;
        Cache       :   PChar;
        Cookie      :   PChar;
        ItemPath    :   PChar;
        Temporary   :   PChar;
        Option      :   PChar;
        Priority    :   Integer;
    end;

    PItemInfo       =   ^TItemInfo;

    TDownLoadInfo   =   record
        Handle      :   THandle;
        Length      :   Integer;
        Pos         :   Integer;
    end;

    PDownLoadInfo   =   ^TDownLoadInfo;

//procedure
    function JupiterOpen(Info : PItemInfo) : THandle; stdcall;
    procedure JupiterClose(Handle : THandle); stdcall;
    function JupiterRun(Handle : THandle ; Sync : BOOL) : BOOL; stdcall
    function JupiterIsRunning(Handle : THandle) : BOOL; stdcall;
    function JupiterGetStructSize(Handle : THandle) : Integer; stdcall;
    procedure JupiterGetStructStr(Handle : THandle ; Buf : PChar); stdcall;
    function JupiterGetCompileSize(Handle : THandle) : Integer; stdcall;
    procedure JupiterGetCompileStr(Handle : THandle ; Buf : PChar); stdcall;
    function JupiterCompile(Handle : THandle) : BOOL; stdcall;

const
    WM_JPTERMINATE      =   8000;
    WM_JPMESSAGE        =   8100;

    WM_JPSTARTDL        =   8110;
    WM_JPENDDL          =   8111;
    WM_JPDOWNLOADING    =   8112;

    JP5                 =   'jp5.dll';

implementation

function JupiterOpen; external JP5 name 'JupiterOpen';
procedure JupiterClose; external JP5 name 'JupiterClose';
function JupiterRun; external JP5 name 'JupiterRun';
function JupiterIsRunning; external JP5 name 'JupiterIsRunning';
function JupiterGetStructSize; external JP5 name 'JupiterGetStructSize';
procedure JupiterGetStructStr; external JP5 name 'JupiterGetStructStr';
function JupiterGetCompileSize; external JP5 name 'JupiterGetCompileSize';
procedure JupiterGetCompileStr; external JP5 name 'JupiterGetCompileStr';
function JupiterCompile; external JP5 name 'JupiterCompile';

end.
