unit jp5_crypt;

interface

const
    STRTABLE    =   'oVzJI8RmkLbtE6y3B+XCgldef0TcNOqHapjwK1hiW9/YZMPrFGQ2USsx4u7AvnD5';
    BASTABLE    =   'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789/+';

type
    TKey    =   array [0..63] of ShortInt;
    PKey    =   ^TKey;

    TCrypt      =   class
        private
        public
            KeyTable : array [0..63] of Char;
            constructor Create;
            destructor Destroy; override;
            procedure KeyGenerator(var Keys : PKey);
            procedure SetKey(Keys : PKey);
            function DecodeText(Source : String) : String;
            function EncodeText(Source : String) : String;
            function DecodeData(Data : Pointer ; Size : Integer ; Buffer : Pointer) : Integer;
            function EncodeData(Data : Pointer ; Size : Integer ; Buffer : Pointer) : Integer;
    end;

function PasswordDecode(Source : String) : String;
function PasswordEncode(Source : String) : String;

implementation

constructor TCrypt.Create;
begin
    inherited Create;
    KeyTable := BASTABLE;
    Randomize;
end;

destructor TCrypt.Destroy;
begin
    inherited Destroy;
end;

procedure TCrypt.KeyGenerator(var Keys : PKey);
var
    n : Integer;
    BasCheck : array [0..63] of Boolean;
    Index : Integer;
    Start : Integer;
begin
    //
    FillChar(BasCheck, SizeOf(BasCheck), #0);

    //e[u̍쐬
    RandSeed := Random(2147483648);
    Index := 0;

    for n := 0 to 63 do
    begin
        while True do
        begin
            Index := Random(64);
            if not BasCheck[Index] then Break;
        end;

        KeyTable[n] := BASTABLE[Index + 1];
        BasCheck[Index] := True;
    end;

    Start := 0;

    for n := 0 to 63 do
    begin
        Index := Pos(KeyTable[n], BASTABLE) - 1;
        Keys[n] := ShortInt(Byte(ShortInt(Index - Start)) xor n);
        Start := Index;
    end;
end;

procedure TCrypt.SetKey(Keys : PKey);
var
    n : Integer;
    Start : Integer;
    Index : Integer;
begin
    Start := 0;
    FillChar(KeyTable, SizeOf(KeyTable), #0);

    for n := 0 to 63 do
    begin
        Index := Start + ShortInt(Byte(Keys[n]) xor n);
        KeyTable[n] := BASTABLE[ Index + 1 ];
        Start := Index;
    end;

end;

{
function TCrypt.DecodeText(Source : String) : String;
var
    a , b , k , l , m : Integer;
begin
    l := 22;
    k := 41;
    Result := '';
    if Length(Source) mod 2 <> 0 then Exit;
    for m := 1 to Length(Source) div 2 do
    begin
        a := Pos(Source[m*2-1], KeyTable) - 1;
        b := Pos(Source[m*2], KeyTable) - 1;
        Result := Result + Chr(((a xor k) xor l ) * 64 + (b xor l));
        Inc(k,23);
        Inc(l,13);
        if k > 63 then k := k - 64;
        if l > 63 then l := l - 64;
    end;
end;

function TCrypt.EncodeText(Source : String) : String;
var
    k , l , m , x : Integer;
begin
    l := 22;
    k := 41;
    Result := '';
    for m := 1 to Length(Source) do
    begin
        x := Byte(Source[m]);
        Result := Result
                    + KeyTable[((x div 64) xor l) xor k]
                        + KeyTable[((x mod 64) xor l)];
        Inc(k,23);
        Inc(l,13);
        if l > 63 then l := l - 64;
        if k > 63 then k := k - 64;
    end;
end;
}

function TCrypt.DecodeText(Source : String) : String;
begin
    SetLength(Result, Length(Source));
    SetLength(Result,DecodeData(PChar(Source), length(Source), PChar(Result)));
end;

function TCrypt.EncodeText(Source : String) : String;
begin
    SetLength(Result, Length(Source) * 2);
    SetLength(Result,EncodeData(PChar(Source), length(Source), PChar(Result)));
end;

function TCrypt.DecodeData(Data : Pointer ; Size : Integer ; Buffer : Pointer) : Integer;
var
    a , b , k , l , m : Integer;
    ch : Integer;
    Src : PChar;
    Buf : PChar;
begin
    l := 22;
    k := 41;
    ch := 0;
    Src := Data;
    Buf := Buffer;
    Result := 0;

    if Size mod 2 <> 0 then Exit;
    for m := 0 to Size div 2 - 1 do
    begin
        a := Pos((Src + m * 2)^, KeyTable) - 1;
        b := Pos((Src + m * 2 + 1)^, KeyTable) - 1;
        (Buf + ch)^ := Chr(((a xor k) xor l ) * 64 + (b xor l));
        k := k + 23;
        l := l + 13;
        ch := ch + 1;
        if k > 63 then k := k - 64;
        if l > 63 then l := l - 64;
    end;

    Result := ch;
end;

function TCrypt.EncodeData(Data : Pointer ; Size : Integer ; Buffer : Pointer) : Integer;
var
    k , l , m , x : Integer;
    Src : PChar;
    Buf : PChar;
    ch : Integer;
begin
    l := 22;
    k := 41;
    Src := Data;
    Buf := Buffer;
    ch := 0;

    for m := 0 to Size - 1 do
    begin
        x := Byte((Src + m)^);
        (Buf + ch)^ :=KeyTable[((x div 64) xor l) xor k];
        (Buf + ch + 1)^ := KeyTable[((x mod 64) xor l)];
        ch := ch + 2;
        k := k + 23;
        l := l + 13;
        if l > 63 then l := l - 64;
        if k > 63 then k := k - 64;
    end;

    Result := ch;
end;

//******************************************************************************

function PasswordDecode(Source : String) : String;
var
    a , b , k , l , m : Integer;
begin
    l := 22;
    k := 41;
    Result := '';
    if Length(Source) mod 2 <> 0 then Exit;
    for m:= 1 to Length(Source) div 2 do
    begin
        a := Pos(Source[m*2-1],STRTABLE) - 1;
        b := Pos(Source[m*2],STRTABLE) - 1;
        Result := Result + Chr(((a xor k) xor l ) * 64 + (b xor l));
        Inc(k,23);
        Inc(l,13);
        if k > 63 then k := k - 64;
        if l > 63 then l := l - 64;
    end;
end;

function PasswordEncode(Source : String) : String;
var
    k , l , m , x : Integer;
begin
    l := 22;
    k := 41;
    Result := '';
    for m:= 1 to Length(Source) do
    begin
        x := Byte(Source[m]);
        Result := Result + strtable[((x div 64) xor l) xor k + 1]
                                + strtable[((x mod 64) xor l) + 1];
        Inc(k,23);
        Inc(l,13);
        if l > 63 then l := l - 64;
        if k > 63 then k := k - 64;
    end;
end;


end.
