unit jupiter;

interface

uses
    //sysutils,
    windows, messages, ja_embed, tn_socket, jp5_http, tn_utils, tn_classes
    , tn_internet, tn_lang, tn_crc, tn_bregexp, tn_md5sup;

type
    TMetaInfo   =   record
        Refresh : String;
        Charset : String;
    end;

    TJupiterRegistry    =   class;

    TJupiter    =   class(TJaObject)
        private
            //RXgN^
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //\bh
            function encodeTo(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function decodeFrom(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getSaveBoxCount(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getLoadBoxCount(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function loadItem(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function saveItem(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function print(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function htmlToText(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function textToHtml(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function deleteTag(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function adjustCrlf(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getVersion(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getBuild(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function regGetSetting(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function regSaveSetting(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function regClear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function regDelete(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function directSmtp(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function md5Encode(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function openHtml(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getCrc(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            Language : TLanguageDriver;
            CookiePath : String;
            CachePath : String;
            ItemPath : String;
            TempPath : String;
            WindowHandle : THandle;
            Handle : THandle;
            History : TNStringList;
            Reg : TJupiterRegistry;
            Auth : TAuthData;
            constructor Create;
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); override;
            procedure Init;
    end;

    TJaWindow   =   class(TJaObject)
        private
            procedure HtmlParser(const Source : String ; This : TVirtualObject ; IsDecoded : Boolean);
            procedure AddLink(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject ; Links : TVirtualObject);
            procedure AddForm(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure AddInput(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure AddSelect(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure AddOption(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure AddTextArea(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure AddTitle(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            procedure SkipScript(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            function GetMetaInfo(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject) : TMetaInfo;
            function Post(Method : String ; Url : String ; OptionHeader : String ; OptionData : String ; var GetHeader : String ; Cache : Boolean ; This : TVirtualObject) : String;
            procedure SubmitData(This : TVirtualObject ; Form : TVirtualObject ; var Src : String ; var Header : String);
            procedure SetCookie(Data : String ; Url : String);
            procedure LoadCache(var Info : THttpInfo ; Cache : String ; This : TVirtualObject);
            procedure ClearAll(This : TVirtualObject);
            procedure SkipComment(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
            //\bh
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function document(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function window(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function navigate(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getSource(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getHeader(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function open(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function close(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function name(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function customPost(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function download(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function title(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function errCode(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function errMessage(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function clear(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function clearCookie(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            Language : TLanguageDriver;
            User : String;
            Pass : String;
            CachePath : String;
            CookiePath : String;
            Cookie : TNCookie;
            StartTime : String;
            History : TNStringList;
            ExitFlag : PBoolean;
            Runtime : TObject;
            JupiterObj : TVirtualObject;
            constructor Create(Cache : String ; Cook : String);
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); override;
            //fXgN^
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaSocket   =   class(TJaObject)
        private
            //RXgN^
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //\bh
            function connect(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function sendCommand(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function readLine(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function isConnected(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function localHost(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getChar(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function read(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function send(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            //fXgN^
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaWebItem  =   class(TJaArray)
        private
            Window : TVirtualObject;
        public
            constructor Create;
            //fXgN^
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
            //\bh
            function onClick(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function onLoad(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function onSubmit(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
    end;

    TJaLink     =   class(TJaWebItem)
        private
            //vpeB
            function href(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function text(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        protected
            //I[o[Ch
            function toString(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject; override;
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
    end;

    TJaForm     =   class(TJaWebItem)
        private
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function submit(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaInput    =   class(TJaWebItem)
        private
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function click(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
    end;

    TJaSelect   =   class(TJaInput)
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
    end;

    TJaOption   =   class(TJaWebItem)
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
    end;

    TJaMime     =   class(TJaObject)
        private
            procedure LoadFile(FileName : String ; This : TVirtualObject);
            procedure ExtractAttachFile(const Source : String ; This : TVirtualObject);
            function FindMailType( Header : String ; Types : String ) : String;
            function FindString( S : String ; A : String ; Start : Integer ) : Integer;
            procedure SaveFile(FileName : String ; This : TVirtualObject);
            //\bh
            function setSource(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function getSource(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function importHeader(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
        public
            TempPath : String;
            Language : TLanguageDriver;
            constructor Create;
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaFile     =   class(TJaObject)
        public
            constructor Create;
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaLinks    =   class(TJaObject)
        private
            procedure Add(This : TVirtualObject ; Url : String ; Text : String);
            function matchTextFirst(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function matchUrlFirst(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function matchText(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function matchUrl(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function getLink(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function length(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function concat(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaMimes    =   class(TJaObject)
        private
            function get(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
            function save(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function find(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function count(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function delete(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function findHistory(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function saveHistory(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            //C^[i\bh
            function setPath(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaStringList   =   class(TJaObject)
        private
            function Construct(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function length(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function count(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function getLine(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setLine(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function add(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function text(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function delete(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
            function setText(args : array of TVirtualObject ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
        public
            constructor Create;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJupiterRegistry    =   class
        private
            Reg : TNStringList;
            procedure LoadFromFile(const FileName : String);
            procedure SaveToFile(const FileName : String);
            function GetSetting(const Name : String) : String;
            procedure SaveSetting(const Name, Data : String);
            procedure Clear;
            procedure Delete(const Name : String);
        public
            constructor Create;
            destructor Destroy; override;
    end;

var
	UAString : String;

implementation

uses
    jp5_main, jascript, jp5_smtp;

//******************************************************************************
//TJupiter -> Jupiter

constructor TJupiter.Create;
begin
    inherited Create;
    ClassName := 'Jupiter';

	(*
    User := '';
    Pass := '';
    Proxy_Addr := '';
    Proxy_Port := 8080;
	*)

    //Q[WhCoǂݍ
    Language := TLanguageDriver.Create(ExtractFilePath(ParamStr(0)) + 'language\');

    //֐ǉ
    AddFunction('Jupiter', Construct, 0);
    AddFunction('adjustCrlf', adjustCrlf, 1);
    AddFunction('decodeFrom', decodeFrom, 2);
    AddFunction('deleteTag', deleteTag, 1);
    AddFunction('directSmtp', directSmtp, 3);
    AddFunction('encodeTo', encodeTo, 2);
    AddFunction('getBuild', getBuild, 0);
    AddFunction('getLoadBoxCount', getLoadBoxCount, 0);
    AddFunction('getSaveBoxCount', getSaveBoxCount, 0);
    AddFunction('getVersion', getVersion, 0);
    AddFunction('htmlToText', htmlToText, 1);
    AddFunction('loadItem', loadItem, 1);
    AddFunction('md5Encode', md5Encode, 1);
    AddFunction('openHtml', openHtml, 1);
    AddFunction('print', print, 1);
    AddFunction('regClear', regClear, 0);
    AddFunction('regDelete', regDelete, 1);
    AddFunction('regGetSetting', regGetSetting, 1);
    AddFunction('regSaveSetting', regSaveSetting, 2);
    AddFunction('saveItem', saveItem, 2);
    AddFunction('textToHtml', textToHtml, 1);
    AddFunction('getCrc', getCrc, 1);

    //vpeB̒ǉ

    //URLHistroy
    History := TNStringList.Create;

    //WXg̒ǉ
    Reg := TJupiterRegistry.Create;

    //F؃f[^
    Auth := TAuthData.Create;
end;

destructor TJupiter.Destroy;
begin
    Language.Free;
    History.SaveToFile(ItemPath + 'cache\history.txt');
    History.Free;

    //WXgۑ
    Reg.SaveToFile(ItemPath + 'cache\registry.txt');
    Reg.Free;

    Auth.Free;
    
    inherited Destroy;
end;

procedure TJupiter.CreateObject(This : TVirtualObject);
var
    Obj : TVirtualObject;
    args : array of TVirtualObject;
begin
    SetLength(args, 1);

    //IuWFNg̏
    Obj := This.Server.PrepareInstance('Mimes');
    //args[0] := MakeString(LoadBox, This.Server);
    args[0] := MakeString(ItemPath + 'loadbox\' , This.Server);
    TJaMimes(Obj.Reference).setPath(args, Obj, nil);
    This.Variants.SetObject('loadBox', Obj);
    args[0].Free;

    Obj := This.Server.PrepareInstance('Mimes');
    //args[0] := MakeString(SaveBox, This.Server);
    args[0] := MakeString(ItemPath + 'savebox\', This.Server);
    TJaMimes(Obj.Reference).setPath(args, Obj, nil);
    This.Variants.SetObject('saveBox', Obj);
    args[0].Free;

    This.Variants.SetString('accept', '*/*', This.Server);
    This.Variants.SetString('authorization', '', This.Server);
    This.Variants.SetString('encoding', '*', This.Server);
    This.Variants.SetString('language', '', This.Server);
    This.Variants.SetString('mailAddress', '', This.Server);
    This.Variants.SetString('pass', '', This.Server);
    This.Variants.SetString('proxyAddr', '', This.Server);
    This.Variants.SetInt('proxyPort', 8080, This.Server);
    This.Variants.SetString('user', '', This.Server);
    This.Variants.SetString('userAgent', UAString, This.Server);
    This.Variants.SetString('version', 'HTTP/1.0', This.Server);
end;

function TJupiter.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

procedure TJupiter.Init;
begin
    if FileExists(ItemPath + 'cache\registry.txt') then
        Reg.LoadFromFile(ItemPath + 'cache\registry.txt');
end;

function TJupiter.toString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('Jupiter Object by T.Nak', This.Server);
end;

function TJupiter.encodeTo(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Source : String;
    Lang : String;
begin
    Source := ForceString(args[0]);
    Lang := ForceString(args[1]);
    Result := MakeString(Language.EncodeString(Lang ,Source), This.Server);
end;

function TJupiter.decodeFrom(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Source : String;
    Lang : String;
begin
    Source := ForceString(args[0]);
    Lang := ForceString(args[1]);
    Result := MakeString(Language.DecodeString(Lang ,Source), This.Server);
end;

function TJupiter.getSaveBoxCount(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    //List := SearchFile(SaveBox + '*.eml');
    List := SearchFile(ItemPath + 'savebox\*.eml');
    Result := MakeInt(List.Count, This.Server);
    List.Free;
end;

function TJupiter.getLoadBoxCount(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    //List := SearchFile(LoadBox + '*.eml');
    List := SearchFile(ItemPath + 'loadbox\*.eml');
    Result := MakeInt(List.Count, This.Server);
    List.Free;
end;

function TJupiter.loadItem(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
    List : TNStringList;
    NaN : Boolean;
begin
    Index := ForceInt(args[0], NaN);
    List := TNStringList.Create;
    //List.LoadFromFile(LoadBox + 'index.ini');
    List.LoadFromFile(ItemPath + 'loadbox\index.ini');

    if (Index < 0) or (Index >= List.Count) then
        Result := MakeUndefined(This.Server)
    else
    begin
        Result := This.Server.PrepareInstance('Mime');
        //TJaMime(Result.Reference).LoadFile(LoadBox + List.Strings[Index], Result);
        TJaMime(Result.Reference).LoadFile(ItemPath + 'loadbox\' + List.Strings[Index], Result);
    end;

    List.Free;
end;

function TJupiter.saveItem(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    ID : String;
    Target : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    ID := ForceString(args[0]);
    Target := args[1];

    if (Target.Reference = nil)
        or (Target.Reference.ClassName <> 'Mime') then Exit;

    //TJaMime(Target.Reference).SaveFile(SaveBox + GetCrc(ID + ID + ID) + '.eml'
    //                                                                , Target);
    TJaMime(Target.Reference).SaveFile(ItemPath + 'savebox\'
                                        + tn_crc.GetCrc(ID + ID + ID) + '.eml', Target);
end;

function TJupiter.print(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    temp : String;
    stemp : String;
    ch : Char;
    n : Integer;
begin
    Result := MakeUndefined(This.Server);
    temp := ForceString(args[0]);
    stemp := '';

    for n := 1 to Length(temp) do
    begin
        ch := temp[n];

        if ch = #13 then
        begin
            SendMessage(WindowHandle, WM_JPMESSAGE, Handle, Integer(PChar(stemp)));
            stemp := '';
        end
        else if ch < #13 then
            Continue
        else
            stemp := stemp + ch;
    end;

    if stemp <> '' then
    begin
        SendMessage(WindowHandle, WM_JPMESSAGE, Handle, Integer(PChar(stemp)));
    end;
end;

function TJupiter.htmlToText(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(tn_internet.HtmlToText(ForceString(args[0]))
                            , This.Server);
end;

function TJupiter.textToHtml(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(tn_internet.TextToHtml(ForceString(args[0]))
                            , This.Server);
end;

function TJupiter.deleteTag(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(tn_internet.DeleteTag(ForceString(args[0]))
                            , This.Server);
end;

function TJupiter.adjustCrlf(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(AdjustLineBreaks(ForceString(args[0]))
                            , This.Server);
end;

function TJupiter.getVersion(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    temp : String;
    Data : String;
begin
    //o[W擾
    temp := tn_utils.GetVersion;
    Data := '';

    for n := Length(temp) downto 1 do
    begin
        if temp[n] = '.' then
        begin
            Data := Copy(temp, 1, n - 1);
            Break;
        end;
    end;

    if Data <> '' then
    begin
        for n := 1 to Length(Data) do
        begin
            if Data[n] = '.' then
            begin
                Data := Copy(Data, 1, n)
                        + Replace(Copy(Data, n + 1, Length(Data) - n), '.', '');
                Break;
            end;
        end;
    end;

    Result := MakeFloat(StrToDouble(Data), This.Server);
end;

function TJupiter.getBuild(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    temp : String;
    Data : String;
begin
    //o[W擾
    temp := tn_utils.GetVersion;
    Data := '';

    for n := Length(temp) downto 1 do
    begin
        if temp[n] = '.' then
        begin
            Data := Trim(Copy(temp, n + 1, Length(temp) - n));
            Break;
        end;
    end;

    Result := MakeInt(StrToInt(Data), This.Server);
end;

function TJupiter.regGetSetting(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Name : String;
begin
    if High(args) = 0 then
    begin
        Name := ForceString(args[0]);
        Result := MakeString(Reg.GetSetting(Name), This.Server);
    end
    else
        Result := MakeString('', This.Server);
end;

function TJupiter.regSaveSetting(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Name : String;
    Data : String;
begin
    Result := MakeUndefined(This.Server);

    if High(args) = 1 then
    begin
        Name := ForceString(args[0]);
        Data := ForceString(args[1]);
        Reg.SaveSetting(Name, Data);
    end;
end;

function TJupiter.regClear(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    Reg.Clear;
end;

function TJupiter.regDelete(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    if High(args) = 0 then Reg.Delete(ForceString(args[0]));
end;

function TJupiter.directSmtp(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
	dns : String;
    from : String;
    rcpt : String;
    src : String;
    smtp : TNSmtpTransfer;
begin
	if High(args) <> 2 then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

    dns := ForceString(This.Variants.GetObject('dnsAddr'));
    from := ForceString(args[0]);
    rcpt := ForceString(args[1]);
    src := ForceString(args[2]);

	if (dns = '') or (from = '') or (rcpt = '') or (src = '') then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

	smtp := TNSmtpTransfer.Create(dns);
    Result := MakeBoolean(smtp.SendMessage(from, rcpt, src), This.Server);
    smtp.Free;
end;

function TJupiter.md5Encode(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
	data : String;
begin
	if High(args) <> 0 then
    begin
	    Result := MakeString('', This.Server);
        Exit;
    end;

    data := ForceString(args[0]);
    Result := MakeString(tn_md5sup.MD5Encode(data), This.Server);
end;

function TJupiter.openHtml(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
	data : String;
    FileName : String;
    Handle : THandle;
begin
    Result := MakeString(tn_md5sup.MD5Encode(data), This.Server);
	if High(args) <> 0 then Exit;
    data := ForceString(args[0]);
    FileName := TempPath + tn_crc.GetCRC(CookiePath) + '.htm';
    SaveToFile(FileName, data);

    Handle := FindWindow('TNGSJP5', nil);
	SendMessage(Handle, WM_COMMAND, 9101, Integer(PChar(FileName)));
    //OpenFile(FileName);
end;

function TJupiter.getCrc(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
	if High(args) = 0 then
		Result := MakeInt(GetCrcInt(ForceString(args[0])), This.Server)
    else
	    Result := MakeInt(0, This.Server);
end;

//******************************************************************************
//TJaWindow -> Window

constructor TJaWindow.Create(Cache : String ; Cook : String);
begin
    inherited Create;
    ClassName := 'Window';
    CachePath := Cache;
    CookiePath := Cook;
    ExitFlag := nil;
    Runtime := nil;

    //֐ǉ
    AddFunction('Window', Construct, 0);
    AddFunction('navigate', navigate, 0);
    AddFunction('getSource', getSource, 0);
    AddFunction('getHeader', getHeader, 0);
    AddFunction('open', open, 2);
    AddFunction('close', close, 0);
    AddFunction('customPost', customPost, 4);
    AddFunction('download', download, 1);
    AddFunction('clear', clear, 0);
    AddFunction('clearCookie', clearCookie, 0);

    //vpeB̒ǉ
    AddProperty('document', document);
    AddProperty('self', window);
    AddProperty('name', name);
    AddProperty('title', title);
    AddProperty('errCode', errCode);
    AddProperty('errMessage', errMessage);

    //NbL[̏
    Cookie := TNCookie.Create;
    Cookie.CookiePath := Cook;
    Cookie.Load;
end;

destructor TJaWindow.Destroy;
begin
    Cookie.Save;
    Cookie.Free;
    inherited Destroy;
end;

procedure TJaWindow.CreateObject(This : TVirtualObject);
var
    Target : TVirtualObject;
    Http : TNhttp;
    List : TNStringList;
begin
    //ϐ̐ݒ
    This.Variants.SetInt('errNum', 100, This.Server);
    This.Variants.SetString('referer', '', This.Server);
    This.Variants.SetString('lastURL', '', This.Server);
    This.Variants.SetString('pageURL', '', This.Server);
    This.Variants.SetBoolean('breakWithCrlf', True, This.Server);

    //HttpIuWFNg̐ݒ
    Http := TNhttp.Create;
    Http.ExitFlag := ExitFlag;
    This.Int_Data := Integer(Pointer(Http));

    //NIuWFNg̐ݒ
    Target := This.Server.PrepareInstance('Links');
    This.Variants.SetObject('links', Target);

    //tH[IuWFNg̐ݒ
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('forms', Target);

    //charsetݒ
    This.Variants.SetString('charset', '', This.Server);

    //refreshUrlݒ
    This.Variants.SetString('refreshUrl', '', This.Server);

    This.Str_Data := '';

    //StringList̐ݒ
    List := TNStringList.Create;
    This.Data := List;
    List.Add('');       //\[X̊i[Xy[X
    List.Add('');       //wb_̊i[Xy[X
    List.Add('');       //^Cg̊i[Xy[X
    List.Add('');       //G[bZ[W̊i[Xy[X
    List.Add('0');      //G[R[h̊i[Xy[X
end;

procedure TJaWindow.FreeObject(This : TVirtualObject);
var
    Http : TNhttp;
    List : TNStringList;
begin
    ClearAll(This);

    //HTTPIuWFNg̊J
    Http := Pointer(This.Int_Data);
    Http.Free;

    //i[XgJ
    List := This.Data;
    List.Free;
end;

procedure TJaWindow.HtmlParser(const Source : String ; This : TVirtualObject ; IsDecoded : Boolean);
var
    n : Integer;
    ch : Char;
    Data : String;
    CharSet : String;
    Refresh : String;
    Src : PChar;
    Ln : Integer;
    Target : TVirtualObject;
    List : TNStringList;
    Links : TVirtualObject;
    Meta : TMetaInfo;

    //eXgp
    temp : String;
begin
    n := 0;
    Data := Source + '       ';
    Src := PChar(Data);
    Ln := Length(Source);
    List := This.Data;
    Refresh := '';
    CharSet := '';

    //links
    Links := This.Server.PrepareInstance('Links');
    This.Variants.SetObject('links', Links);

    //forms
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('forms', Target);

    //refreshUrl
    This.Variants.SetString('refreshUrl', '', This.Server);

    if not IsDecoded then
    begin
        //EtbV()擾
        while n < Ln do
        begin
            ch := (Src + n)^;

            if ch = '<' then
            begin
                n := n + 1;
                ch := (Src + n + 4)^;

                if (UpperCase(Copy(Data, n + 1, 4)) = 'META')
                    and ((ch = ' ') or (ch = #9) or (ch = #13) or (ch = #10)) then
                begin
                    //META^O
                    n := n + 5;
                    Meta := GetMetaInfo(Src, Ln, n, This);

                    if Meta.Charset <> '' then CharSet :=Meta.Charset;
                    if Meta.Refresh <> '' then Refresh :=Meta.Refresh;

                    Continue;
                end
                else if (UpperCase(Copy(Data, n + 1, 4)) = 'BODY')
                    and ((ch = ' ') or (ch = #9) or (ch = #13)
                    or (ch = #10) or (ch = '>')) then
                begin
                    Break;
                end
                else
                begin
                    ch := (Src + n + 5)^;
                    if (UpperCase(Copy(Data, n + 1, 5)) = '/HEAD')
                        and ((ch = ' ') or (ch = #9) or (ch = #13)
                        or (ch = #10) or (ch = '>')) then
                    begin
                        Break;
                    end;
                end;
            end;

            n := n + 1;
        end;

        This.Variants.SetString('charSet', CharSet, This.Server);
        This.Variants.SetString('refreshUrl', Refresh, This.Server);

        //HTML\[XfR[hĊi[
        if CharSet = '' then
            CharSet := ForceString(This.Variants.GetObject('charset'));

        if CharSet <> '' then
        begin
            List.Strings[0] := Language.DecodeString(CharSet, Source);
            Data := List.Strings[0] + '       ';
            Ln := Length(List.Strings[0]);
            Src := PChar(Data);
            This.Variants.SetString('charset', CharSet, This.Server);
        end;
    end;

    n := 0;

    while n < Ln do
    begin
        ch := (Src + n)^;

        if ch = '<' then
        begin
            n := n + 1;
            temp := Copy(Data, n + 1, 10);

            ch := (Src + n + 1)^;
            if (UpperCase(Copy(Data, n + 1, 1)) = 'A')
                and ((ch = ' ') or (ch = #9) or (ch = #13) or (ch = #10)) then
            begin
                //nCp@N
                n := n + 2;
                AddLink(Src, Ln, n, This, Links);
                Continue;
            end;

            if Copy(Data, n + 1, 3) = '!--' then
            begin
                //Rg
                n := n + 3;
                SkipComment(Src, Ln, n, This);
                Continue;
            end;

            ch := (Src + n + 4)^;
            if (UpperCase(Copy(Data, n + 1, 4)) = 'FORM')
                and ((ch = ' ') or (ch = #9) or (ch = #13) or (ch = #10)) then
            begin
                //FORMtB[h
                n := n + 5;
                AddForm(Src, Ln, n, This);
                Continue;
            end;

            ch := (Src + n + 5)^;
            if (UpperCase(Copy(Data, n + 1, 5)) = 'TITLE')
                and ((ch = ' ') or (ch = #9) or (ch = #13)
                or (ch = #10) or (ch = '>')) then
            begin
                //^Cg
                n := n + 5;
                AddTitle(Src, Ln, n, This);
                Continue;
            end;

            ch := (Src + n + 6)^;
            if (UpperCase(Copy(Data, n + 1, 6)) = 'SCRIPT')
                and ((ch = ' ') or (ch = #9) or (ch = #13)
                or (ch = #10) or (ch = '>')) then
            begin
                //XNvgXLbv
                n := n + 6;
                SkipScript(Src, Ln, n, This);
                Continue;
            end;
        end;

        n := n + 1;
    end;
end;

procedure TJaWindow.AddLink(Src : PChar ; Ln : Integer ; var Index : Integer
                    ; This : TVirtualObject ; Links : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    temp : String;
    IsKey : Boolean;
    QuotType : TQuoteType;
    CurrentUrl : String;
    Link_Url : String;
    Link_Text : String;
begin
    Key := '';
    Item := '';
    Link_Url := '';
    IsKey := True;
    QuotType := qtNone;

    //pX𔲂o
    CurrentUrl := ForceString(This.Variants.GetObject('lastURL'));

    //<A `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        if Link_Url = '' then
                        begin
                            if Key = '' then Exit;
                            if Item = '' then Exit;
                        end;

                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'HREF' then
                        begin
                            if Item <> '' then
                                Item := AbsoluteUrl(CurrentUrl, HtmlToText(Item));

                            Link_Url := Item;
                        end;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if (IsKey) and (QuotType = qtNone) then
                    begin
                        IsKey := False;
                        Index := Index + 1;
                        Continue;
                    end
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //<A`></A>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ch = '<' then
        begin
            //if ByteType(Src, Index + 1) <> btSingle then
            //begin
            //    Item := Item + ch;
            //    Index := Index + 1;
            //    Continue;
            //end;

            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                //if (ch = '>') and (ByteType(Src, Index + 1) = btSingle) then
                if ch = '>' then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            if UpperCase(Trim(temp)) = '/A' then
            begin
                Link_Text := HTMLToText(Trim(Item));
                Item := '';
                Break;
            end
            else
                Continue;
        end
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //Linksɒǉ
    if (Links.Reference = nil)
        or (Links.Reference.ClassName <> 'Links') then Exit;

    TJaLinks(Links.Reference).Add(Links, Link_Url, Link_Text);
end;

procedure TJaWindow.AddForm(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    temp : String;
    IsKey : Boolean;
    Forms : TVirtualObject;
    NewForm : TVirtualObject;
    TempObj : TVirtualObject;
    List : TNStringList;
    QuotType : TQuoteType;
    CurrentURL : String;
    Links : TVirtualObject;
begin
    //
    Key := '';
    Item := '';
    IsKey := True;
    QuotType := qtNone;

    //Links̏
    Links := This.Variants.GetObject('links');

    //VtH[쐬
    NewForm := This.Server.PrepareInstance('Form');
    List := Pointer(NewForm.Int_Data);

    //EBhEZbg
    VarCopy(This, TempObj, This.Server);
    NewForm.Variants.SetObject('owner', TempObj);

    //pX𔲂o
    CurrentURL := ForceString(This.Variants.GetObject('lastURL'));

    //Formsɒǉ
    Forms := This.Variants.GetObject('forms');
    Forms.Arrays.AddNext(NewForm);

    //<FORM `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'ACTION' then
                        begin
                            if Item <> '' then
                                Item := AbsoluteURL(CurrentURL, Item);

                            NewForm.Variants.SetString('action', Item, This.Server);
                        end
                        else if Key = 'ENCTYPE' then
                            NewForm.Variants.SetString('encoding', Item, This.Server)
                        else if Key = 'METHOD' then
                            NewForm.Variants.SetString('method', UpperCase(Trim(Item)), This.Server)
                        else if Key = 'NAME' then
                        begin
                            NewForm.Variants.SetString('name', Item, This.Server);

                            if Item <> '' then
                            begin
                                VarCopy(NewForm, TempObj, This.Server);
                                This.Variants.SetObject(Item, TempObj);
                            end;
                        end
                        else if Key = 'TARGET' then
                            NewForm.Variants.SetString('target', Item, This.Server)
                        else if Key = 'ONRESET' then
                            List.Strings[15] := Item
                        else if Key = 'ONSUBMIT' then
                            List.Strings[14] := Item
                        else if Key = 'ONLOAD' then
                            List.Strings[10] := Item
                        else if Key = 'ONUNLOAD' then
                            List.Strings[11] := Item;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;

                        if Item <> '' then
                            Item := Item + '=';

                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //<FORM`></FORM>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

//        if (ch = '<') and (ByteType(Src, Index + 1) = btSingle) then
        if ch = '<' then
        begin
            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if (ch = '>') or (ch = ' ') or (ch = #13) or (ch = #10) then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            temp := UpperCase(Trim(temp));

            if temp = '/FORM' then
            begin
                Item := '';
                temp := '';
                Break;
            end
            else if temp = 'A' then
            begin
                AddLink(Src, Ln, Index, This, Links);
                Continue;
            end
            else if Copy(temp, 1, 3) = '!--' then
            begin
                if Length(temp) > 3 then
                    Index := Index - Length(temp) + 2;

                SkipComment(Src, Ln, Index, This);
                Continue;
            end
            else if temp = 'INPUT' then
            begin
                AddInput(Src, Ln, Index, NewForm);
                Continue;
            end
            else if temp = 'SELECT' then
            begin
                AddSelect(Src, Ln, Index, NewForm);
                Continue;
            end
            else if temp = 'TEXTAREA' then
            begin
                AddTextArea(Src, Ln, Index, NewForm);
                Continue;
            end
            else if temp = 'SCRIPT' then
            begin
                SkipScript(Src, Ln, Index, This);
                Continue;
            end
            else
            begin
                temp := '';
                Continue;
            end;
        end;
        
        Index := Index + 1;
    end;

    //Formsɒǉ
    //Forms := This.Variants.GetObject('forms');
    //Forms.Arrays.AddNext(NewForm);
end;

procedure TJaWindow.AddInput(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    Name : String;
    Types : String;
    IsKey : Boolean;
    Obj : TVirtualObject;
    Elements : TVirtualObject;
    NewInput : TVirtualObject;
    TempObj : TVirtualObject;
    List : TNStringList;
    QuotType : TQuoteType;
    InvalidQuot : Boolean;
    Undefined : Boolean;
begin
    Key := '';
    Item := '';
    Name := '';
    Types := '';
    IsKey := True;
    InvalidQuot := False;
    Undefined := True;
    QuotType := qtNone;
    NewInput := This.Server.PrepareInstance('Input');
    List := Pointer(NewInput.Int_Data);

    //tH[IuWFNgRs[
    VarCopy(This, Obj, This.Server);
    NewInput.Variants.SetObject('owner', Obj);

    //<INPUT `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'NAME' then
                        begin
                            NewInput.Variants.SetString('name', Item, This.Server);
                            Name := Item;
                        end
                        else if Key = 'TYPE' then
                        begin
                            NewInput.Variants.SetString('type', Item, This.Server);
                            Types := UpperCase(Item);
                        end
                        else if Key = 'VALUE' then
                        begin
                            NewInput.Variants.SetString('value', Item, This.Server);
                            Undefined := False;
                        end
                        else if Key = 'CHECKED' then
                        begin
                            NewInput.Variants.SetBoolean('defaultChecked', True, This.Server);
                            NewInput.Variants.SetBoolean('checked', True, This.Server);
                        end
                        else if Key = 'ONCLICK' then
                            List.Strings[0] := Item
                        else if Key = 'ONLOAD' then
                            List.Strings[10] := Item
                        else if Key = 'ONUNLOAD' then
                            List.Strings[11] := Item
                        else if Key = 'ONSUBMIT' then
                            List.Strings[14] := Item
                        else if Key = 'ONRESET' then
                            List.Strings[15] := Item;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                        begin
                            InvalidQuot := False;
                            Continue;
                        end
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;

                        //=̎̕`FbN
                        ch := (Src + Index)^;

                        if (ch = '"') or (ch = '''') then
                            InvalidQuot := False
                        else
                            InvalidQuot := True;

                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                    begin
                        if not InvalidQuot then
                            QuotType := qtDouble;
                    end
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                    begin
                        if not InvalidQuot then
                            QuotType := qtSingle;
                    end
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //^Cv錾ĂȂ
    if Types = '' then
    begin
        Types := 'TEXT';
        NewInput.Variants.SetString('type', Types, This.Server);
    end;

    //l`ĂȂ
    if Undefined then
    begin
        if (Types = 'CHECKBOX') or (Types = 'RADIO') then
            NewInput.Variants.SetString('value', 'on', This.Server)
        else if Types = 'IMAGE' then
            NewInput.Variants.SetString('value', '1', This.Server)
    end;

    //elementsɒǉ
    Elements := This.Variants.GetObject('elements');
    Elements.Arrays.AddNext(NewInput);

    //tH[ɓo^
    if (Name <> '') and (Name <> 'action') and (Name <> 'encoding')
        and (Name <> 'method') then
    begin
        VarCopy(NewInput, TempObj, This.Server);
        This.Variants.SetObject(Name ,TempObj);
    end;
end;

procedure TJaWindow.AddSelect(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    temp : String;
    Name : String;
    IsKey : Boolean;
    Obj : TVirtualObject;
    Elements : TVirtualObject;
    NewSelect : TVirtualObject;
    List : TNStringList;
    QuotType : TQuoteType;
    Links : TVirtualObject;
begin
    //
    Key := '';
    Item := '';
    Name := '';
    IsKey := True;
    QuotType := qtNone;

    //LinksIuWFNgo
    Links := This.Variants.GetObject('owner').Variants.GetObject('links');

    //SelectIuWFNg쐬
    NewSelect := This.Server.PrepareInstance('Select');
    VarCopy(This.Variants.GetObject('owner'), Obj, This.Server);
    NewSelect.Variants.SetObject('owner', Obj);
    List := Pointer(NewSelect.Int_Data);

    //<SELECT `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'NAME' then
                        begin
                            NewSelect.Variants.SetString('name', Item, This.Server);
                            Name := Item;
                        end
                        else if Key = 'SIZE' then
                            NewSelect.Variants.SetString('size', Item, This.Server)
                        else if Key = 'TARGET' then
                            NewSelect.Variants.SetString('target', Item, This.Server)
                        else if Key = 'ONRESET' then
                            List.Strings[15] := Item
                        else if Key = 'ONSUBMIT' then
                            List.Strings[14] := Item
                        else if Key = 'ONLOAD' then
                            List.Strings[10] := Item
                        else if Key = 'ONUNLOAD' then
                            List.Strings[11] := Item;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;
                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //<SELECT`></SELECT>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ByteType(Src, Index + 1) <> btSingle then
        begin
            Item := Item + ch;
        end
        else if ch = '<' then
        begin
            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if ((ch = '>') or (ch = ' ') or (ch = #13) or (ch = #10))
                    and (ByteType(Src, Index + 1) = btSingle) then
                begin
                    if ch <> '>' then Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            temp := UpperCase(Trim(temp));

            if temp = '/SELECT' then
            begin
                Item := '';
                temp := '';
                Break;
            end
            else if temp = 'A' then
            begin
                AddLink(Src, Ln, Index, This, Links);
                Continue;
            end
            else if temp = 'INPUT' then
            begin
                AddInput(Src, Ln, Index, This);
                Continue;
            end
            else if temp = 'OPTION' then
            begin
                AddOption(Src, Ln, Index, NewSelect);
                Continue;
            end
            else if temp = 'SCRIPT' then
            begin
                SkipScript(Src, Ln, Index, This);
                Continue;
            end
            else
            begin
                temp := '';
                Continue;
            end;
        end
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //elementsɒǉ
    Elements := This.Variants.GetObject('elements');
    Elements.Arrays.AddNext(NewSelect);

    //tH[ɓo^
    if (Name <> '') and (Name <> 'action') and (Name <> 'encoding')
        and (Name <> 'method') then
    begin
        VarCopy(NewSelect, Obj, This.Server);
        This.Variants.SetObject(Name ,Obj);
    end;
end;

procedure TJaWindow.AddOption(Src : PChar ; Ln : Integer ; var Index : Integer
                                                        ; This : TVirtualObject);
var
    ch : Char;
    Selected : Boolean;
    Key : String;
    Item : String;
    temp : String;
    Value : String;
    IsKey : Boolean;
    Options : TVirtualObject;
    NewOption : TVirtualObject;
    List : TNStringList;
    QuotType : TQuoteType;
    Links : TVirtualObject;
begin
    Key := '';
    Item := '';
    Value := '';
    IsKey := True;
    QuotType := qtNone;
    Selected := False;
    NewOption := This.Server.PrepareInstance('Option');
    Links := This.Variants.GetObject('owner').Variants.GetObject('links');
    List := Pointer(NewOption.Int_Data);

    //<OPTION `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'VALUE' then
                        begin
                            Value := Item;
                            NewOption.Variants.SetString('value', Item, This.Server);
                        end
                        else if Key = 'SELECTED' then
                            Selected := True
                        else if Key = 'ONCLICK' then
                            List.Strings[0] := Item
                        else if Key = 'ONLOAD' then
                            List.Strings[10] := Item
                        else if Key = 'ONSUBMIT' then
                            List.Strings[14] := Item;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;
                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //<OPTION`></OPTION>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ByteType(Src, Index + 1) <> btSingle then
        begin
            Item := Item + ch;
        end
        else if ch = '<' then
        begin
            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if (ch = '>') or (ch = ' ') or (ch = #13) or (ch = #10) then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            temp := UpperCase(Trim(temp));

            if temp = 'A' then
            begin
                AddLink(Src, Ln, Index, This, Links);
                Continue;
            end
            else if temp = 'OPTION' then
            begin
                Item := Trim(Item);

                if Value = '' then
                    NewOption.Variants.SetString('value', Item, This.Server);

                NewOption.Variants.SetString('text', Item, This.Server);
                Item := '';
                temp := '';
                Index := Index - 8;
                Break;
            end
            else if temp = '/OPTION' then
            begin
                Item := Trim(Item);

                if Value = '' then
                    NewOption.Variants.SetString('value', Item, This.Server);

                NewOption.Variants.SetString('text', Item, This.Server);
                Item := '';
                temp := '';
                Break;
            end
            else if temp = '/SELECT' then
            begin
                if Value = '' then
                    NewOption.Variants.SetString('value', Item, This.Server);

                NewOption.Variants.SetString('text', Item, This.Server);
                Index := Index - 9;
                if Index < 0 then Index := 0;    //قƂǊYȂÔ
                Break;
            end
            else if temp = 'SCRIPT' then
            begin
                SkipScript(Src, Ln, Index, This);
                Continue;
            end
            else
            begin
                temp := '';
                Continue;
            end;
        end
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //optionsɒǉ
    Options := This.Variants.GetObject('options');
    Options.Arrays.AddNext(NewOption);

    if Selected then
        This.Variants.SetInt('selectedIndex'
                                , Options.Arrays.Count - 1, This.Server);
end;

procedure TJaWindow.AddTextArea(Src : PChar ; Ln : Integer ; var Index : Integer ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    temp : String;
    Name : String;
    IsKey : Boolean;
    Elements : TVirtualObject;
    NewArea : TVirtualObject;
    TempObj : TVirtualObject;
    List : TNStringList;
    QuotType : TQuoteType;
begin
    Key := '';
    Item := '';
    Name := '';
    IsKey := True;
    QuotType := qtNone;
    NewArea := This.Server.PrepareInstance('Input');
    List := Pointer(NewArea.Int_Data);

    //<TEXTAREA `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'NAME' then
                        begin
                            Name := Item;
                            NewArea.Variants.SetString('name', Item, This.Server);
                        end
                        else if Key = 'ONCLICK' then
                            List.Strings[0] := Item
                        else if Key = 'ONLOAD' then
                            List.Strings[10] := Item
                        else if Key = 'ONSUBMIT' then
                            List.Strings[14] := Item;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;
                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //<TEXTAREA`></TEXTAREA>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ByteType(Src, Index + 1) <> btSingle then
        begin
            Item := Item + ch;
        end
        else if ch = '<' then
        begin
            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if ch = '>' then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            if UpperCase(Trim(temp)) = '/TEXTAREA' then
            begin
                NewArea.Variants.SetString('value', Item, This.Server);
                Item := '';
                temp := '';
                Break;
            end
            else
            begin
                temp := '';
                Continue;
            end;
        end
        else
            Item := Item + ch;

        Index := Index + 1;
    end;

    //elementsɒǉ
    Elements := This.Variants.GetObject('elements');
    Elements.Arrays.AddNext(NewArea);

    //tH[ɓo^
    if Name <> '' then
    begin
        VarCopy(NewArea, TempObj, This.Server);
        This.Variants.SetObject(Name ,TempObj);
    end;
end;

procedure TJaWindow.AddTitle(Src : PChar ; Ln : Integer ; var Index : Integer
                                                    ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    Item : String;
    temp : String;
    List : TNStringList;
begin
    Key := '';
    Item := '';
    temp := '';
    List := This.Data;

    //pX𔲂o

    //<TITLE>̕XLbv
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ch = '>' then
        begin
            Index := Index + 1;
            Break;
        end;

        temp := temp + ch;
        Index := Index + 1;
    end;

    temp := '';

    //<TITLE></TITLE>̊Ԃ擾
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ch = '<' then
        begin
            if ByteType(Src, Index + 1) <> btSingle then
            begin
                Item := Item + ch;
                Index := Index + 1;
                Continue;
            end;

            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if (ch = '>') and (ByteType(Src, Index + 1) = btSingle) then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            if UpperCase(Trim(temp)) = '/TITLE' then
            begin
                List.Strings[2] := Trim(Item);
                Item := '';
                Break;
            end
            else
                Continue;
        end
        else
            Item := Item + ch;

        Index := Index + 1;
    end;
end;

procedure TJaWindow.SkipScript(Src : PChar ; Ln : Integer ; var Index : Integer
                                                    ; This : TVirtualObject);
var
    ch : Char;
    Key : String;
    temp : String;
begin
    Key := '';
    temp := '';

    //pX𔲂o

    //<SCRIPT`>̕XLbv
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ch = '>' then
        begin
            Index := Index + 1;
            Break;
        end;

        temp := temp + ch;
        Index := Index + 1;
    end;

    temp := '';

    //<SCRIPT></SCRIPT>̊ԂXLbv
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        if ch = '<' then
        begin
            //if ByteType(Src, Index + 1) <> btSingle then
            //begin
            //    Index := Index + 1;
            //    Continue;
            //end;

            Index := Index + 1;
            temp := '';

            while Index < Ln do
            begin
                ch := (Src + Index)^;

                if (ch = ' ') or (ch = #13) or (ch = #10) or (ch = '>') then
                begin
                    Index := Index + 1;
                    Break;
                end
                else
                    temp := temp + ch;

                Index := Index + 1;
            end;

            if UpperCase(Trim(temp)) = '/SCRIPT' then
                Break
            else
            begin
                temp := '';
                Continue;
            end;
        end;

        Index := Index + 1;
    end;
end;

function TJaWindow.GetMetaInfo(Src : PChar ; Ln : Integer ; var Index : Integer
                                            ; This : TVirtualObject) : TMetaInfo;
var
    ch : Char;
    Key : String;
    Item : String;
    ps : Integer;
    IsKey : Boolean;
    IsRefresh : Boolean;
    QuotType : TQuoteType;
begin
    Result.Refresh := '';
    Result.Charset := '';

    Key := '';
    Item := '';
    IsKey := True;
    IsRefresh := False;
    QuotType := qtNone;

    //<META `>̕
    while Index < Ln do
    begin
        ch := (Src + Index)^;

        case ch of
            '>', ' ', #9, #13, #10:
                begin
                    if QuotType = qtNone then
                    begin
                        Key := UpperCase(Trim(Key));
                        Item := Trim(Item);

                        if Length(Item) > 1 then
                        begin
                            if (Item[1] = '"') and (Item[Length(Item)] = '"') then
                                Item := Copy(Item, 2, Length(Item) - 2)
                            else if (Item[1] = '''') and (Item[Length(Item)] = '''') then
                                Item := Copy(Item, 2, Length(Item) - 2);
                        end;

                        if Key = 'CONTENT' then
                        begin
                            ps := Pos('CHARSET=', UpperCase(Item));

                            if ps <> 0 then
                            begin
                                ps := ps + 7;
                                Result.Charset := Trim(Copy(Item, ps + 1, Length(Item) - ps));
                            end;

                            if IsRefresh then
                            begin
                                ps := Pos('URL=', UpperCase(Item));
                                Result.Refresh := Trim(Copy(Item, ps + 4, Length(Item) - ps - 3));
                                IsRefresh := False;
                            end;
                        end
                        else if Key = 'HTTP-EQUIV' then
                        begin
                            if UpperCase(Trim(Item)) = 'REFRESH' then
                                IsRefresh := True
                            else
                                IsRefresh := False;
                        end;

                        //s
                        IsKey := True;
                        Key := '';
                        Item := '';
                        Index := Index + 1;

                        if ch <> '>' then
                            Continue
                        else
                            Break;
                    end
                end;

            '=':
                begin
                    if QuotType = qtNone then
                    begin
                        IsKey := False;
                        Index := Index + 1;
                        Continue;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;
        end;

        if IsKey then
            Key := Key + ch
        else
            Item := Item + ch;

        Index := Index + 1;
    end;
end;

function TJaWindow.Post(Method : String ; Url : String ; OptionHeader : String
                                ; OptionData : String ; var GetHeader : String
                                ; Cache : Boolean ; This : TVirtualObject) : String;
var
    Http : TNhttp;
    Inf : THttpInfo;
    Header : THeader;
    ps : Integer;
    List : TNStringList;
    Path : String;
    Protocol : String;
    User_Agent : String;
    Referer : String;
    Version : String;
    temp : String;
    stemp : String;
    PostHeader : String;
    User : String;
    Pass : String;
    CurrentRoot : String;
    CurrentDir : String;
    CharSet : String;
    OldURL : String;
    Proxy_Addr : String;
    Proxy_User : String;
    Proxy_Pass : String;
    Encoding : String;
    Accept : String;
    Language : String;
    MailAddress : String;
    Proxy_Port : Integer;
    ErrorNum : Integer;
    NaN : Boolean;
    Request : TRequest;
begin
    Result := '';
    Http := Pointer(This.Int_Data);
    FillChar(Inf, SizeOf(THttpInfo), #0);
    User := ForceString(JupiterObj.Variants.GetObject('user'));
    Pass := ForceString(JupiterObj.Variants.GetObject('pass'));
    Proxy_Addr := ForceString(JupiterObj.Variants.GetObject('proxyAddr'));
    Proxy_Port := ForceInt(JupiterObj.Variants.GetObject('proxyPort'), NaN);
    Proxy_User := ForceString(JupiterObj.Variants.GetObject('proxyUser'));
    Proxy_Pass := ForceString(JupiterObj.Variants.GetObject('proxyPass'));
    User_Agent := ForceString(JupiterObj.Variants.GetObject('userAgent'));
    Version := ForceString(JupiterObj.Variants.GetObject('version'));
    Accept := ForceString(JupiterObj.Variants.GetObject('accept'));
    Encoding := ForceString(JupiterObj.Variants.GetObject('encoding'));
    Language := Trim(ForceString(JupiterObj.Variants.GetObject('language')));
    MailAddress := ForceString(JupiterObj.Variants.GetObject('mailAddress'));
    List :=This.Data;

    //vpeB̎擾
    Referer := Trim(ForceString(This.Variants.GetObject('lastURL')));

    //URL
    if Url = '' then Exit;

    //wb_IuWFNg̏
    Header := THeader.Create;

    //URL
    DevideURL(Url, Protocol, Inf.Host, Path, Inf.Port);

    //wb_̏
    if Proxy_Addr = '' then
    begin
        PostHeader  :=      Method + ' ' + Path + ' ' + Version + #13#10
                        +   'Host: ' + Inf.Host + #13#10
                        +   'Accept: ' + Accept + #13#10
                        +   'Accept-Encoding: ' + Encoding + #13#10
                        +   'User-Agent: ' + User_Agent + #13#10;
    end
    else
    begin
        PostHeader  :=      Method + ' ' + Url + ' ' + Version + #13#10
                        +   'Host: ' + Inf.Host + #13#10
                        +   'Accept: ' + Accept + #13#10
                        +   'Accept-Encoding: ' + Encoding + #13#10
                        +   'User-Agent: ' + User_Agent + #13#10
                        +   'Proxy-Connection: Keep-Alive' + #13#10;
    end;

    if Language <> '' then
        PostHeader := PostHeader + 'Accept-Language: ' + Language + #13#10;

	temp := TJupiter(JupiterObj.Reference).Auth.GetAuth(Path);
	if temp <> '' then PostHeader := PostHeader + temp + #13#10;

    if Referer <> '' then
        PostHeader := PostHeader + 'Referer: ' + Referer + #13#10;

    temp := Cookie.GetCookie(Url);

    if temp <> '' then
        PostHeader  :=      PostHeader + temp + #13#10;

    if OptionHeader <> '' then
    begin
        PostHeader  :=      PostHeader
                        +   OptionHeader + #13#10;
    end;

    while True do
    begin
        if (Protocol = 'http') and (Proxy_User <> '') then
        begin
            temp := Base64Encode(Proxy_User + ':' + Proxy_Pass);
        	PostHeader :=	PostHeader
            			+	'Proxy-Authorization: Basic ' + temp + #13#10;
        end;

        //|Xgf[^
        if OptionData <> '' then
        begin
            Inf.PostData := PostHeader
                            + 'Content-Length: ' + IntToStr(Length(OptionData)) + #13#10
                            + #13#10
                            + OptionData
                            + #13#10;
        end
        else
            Inf.PostData := PostHeader + #13#10;

        Inf.Proxy_Addr := Proxy_Addr;
        Inf.Proxy_Port := Proxy_Port;
        Inf.URL := Url;
        Inf.Method := Method;
        Inf.Path := Path;
        Inf.Version := Version;
        Inf.Protocol := protocol;

        //I[i[EBhEɃbZ[W𑗐M
        if Runtime <> nil then
        begin
            SendMessage(TJupiterBoot(Runtime).Handle, WM_JPSTARTDL
                        , Integer(Pointer(Runtime))
                        , Integer(PChar(Url)));
        end;

        //LbVt@Cݒ
        temp := GetCrc(Inf.Method + Url + StartTime + MailAddress);
        Result := CachePath + temp;
        ErrorNum := 0;

        if Cache and (Inf.Method =  'GET')
            and (FileExists(Result + '.htm'))
                and (FileExists(Result + '.hed')) then
        begin
            //wb_ǂݍ
            Inf.Header := LoadFromFile(Result + '.hed');

            //ŏ̍so
            ps := Pos(#13, Inf.Header);
            if ps <> 0 then
                stemp := Copy(Inf.Header, 1, ps - 1)
            else
                stemp := '';

            ps := Pos(' ', stemp);

            if ps <> 0 then
            begin
                //G[ԍ擾
                stemp := Trim(Copy(stemp, ps + 1, Length(stemp) - ps));
                ps := Pos(' ', stemp);

                if ps = 0 then
                    ErrorNum := StrToInt(stemp)
                else
                begin
                    ErrorNum := StrToInt(Copy(stemp, 1, ps - 1));

                    //G[bZ[W擾
                    List.Strings[3] := Trim(Copy(stemp, ps + 1
                                                , Length(stemp) - ps));
                end;
            end
            else
            begin
                List.Strings[3] := '';
            end;

            //LbVǂݍ
            LoadCache(Inf, Result, This);
        end
        else
        begin
            //LbV폜
            if FileExists(Result + '.htm') then
                DeleteFile(PChar(Result + '.htm'));

            if FileExists(Result + '.hed') then
                DeleteFile(PChar(Result + '.hed'));

            //Postf[^LbVɕۑ
            SaveToFile(Result + '.pim', Inf.PostData);

            if Protocol = 'http' then
            begin
                Http.Post(Inf, Result + '.htm', Integer(Pointer(Runtime)));
                Inf.PostData := Trim(Inf.PostData);
//                Http.PostInet(Inf, Result + '.htm');
                ErrorNum := Http.ErrorNum;
            end
            else if Protocol = 'https' then
            begin
                Http.PostInet(Inf, Result + '.htm');
                ErrorNum := Http.ErrorNum;
            end
            else
            begin
                Header.Free;
                Exit;
            end;
        end;

        //G[R[h擾
        List.Strings[4] := IntToStr(ErrorNum);

        //Historyɒǉ
        History.Add(temp + ' ' + Method + ' ' + Url);

        //wb_LbVۑ
        SaveToFile(Result + '.hed', Inf.Header);

        //vpeB̐ݒ
        This.Variants.SetString('lastURL', Url, This.Server);
        This.Variants.SetString('userAgent', User_Agent, This.Server);
        This.Variants.SetString('referer', Referer, This.Server);

        //wb_IuWFNgɃwb_Zbg
        Header.SetHeader(AdjustLineBreaks(Inf.Header));

        //Set-Cookie΁ANbL[i[
        temp := Header.GetHeader('Set-Cookie');
        SetCookie(temp, Url);

        //Content-Typecharseto
        temp := Header.GetHeader('Content-Type');
        ps := Pos('charset=', temp);

        if ps <> 0 then
        begin
            ps := ps + 7;
            CharSet := Trim(Copy(temp, ps + 1, Length(temp) - ps));

            if CharSet[1] = '"' then
                CharSet := Copy(CharSet, 2, Length(CharSet) - 2);
        end
        else
            CharSet := '';

        case ErrorNum of
            301, 302:
                begin
                    Method := 'GET';
                    CurrentRoot := SplitRoot(Url);
                    CurrentDir := SplitCurrentDir(Url);
                    OldURL := Url;
                    Url := Header.GetHeader('Location');

                    if Url <> '' then
                    begin
                        if Url[1] = '/' then
                            Url := CurrentRoot + Url
                        else if Url[1] = '.' then
                            Url := CurrentDir + Url;

                        if Pos('//', Url) = 0 then
                            Url := CurrentDir + Url;
                    end;

                    //URL
                    Url := UrlCheck(Url);
                    DevideURL(Url, Protocol, Inf.Host, Path, Inf.Port);

                    //wb_̏
                    if Proxy_Addr = '' then
                    begin
                        PostHeader  :=      Method + ' ' + Path + ' ' + Version + #13#10
                                        +   'Host: ' + Inf.Host + #13#10
                                        +   'Accept: */*' + #13#10
                                        +   'Accept-Encoding: *' + #13#10
                                        +   'User-Agent: ' + User_Agent + #13#10;
                    end
                    else
                    begin
                        PostHeader  :=      Method + ' ' + Url + ' ' + Version + #13#10
                                        +   'Host: ' + Inf.Host + #13#10
                                        +   'Accept: */*' + #13#10
                                        +   'Accept-Encoding: *' + #13#10
                                        +   'User-Agent: ' + User_Agent + #13#10;
                    end;

                    //F؂̐ݒ
                    temp := TJupiter(JupiterObj.Reference).Auth.GetAuth(Path);
                    if temp <> '' then PostHeader := PostHeader + temp + #13#10;

                    //Referer̐ݒ
                    if Referer <> '' then
                        PostHeader  :=      PostHeader
                                        +   'Referer: ' + Referer + #13#10;

                    //Cookie擾
                    temp := Cookie.GetCookie(Url);

                    if temp <> '' then
                        PostHeader  :=      PostHeader + temp + #13#10;

                    OptionData := '';
                    OptionHeader := '';
                end;

            401:
                begin
                    //F؂Kv
                    temp := Header.GetHeader('WWW-Authenticate');
                    if temp = '' then Break;

                    //F؎s
                    if Pos(#13#10'Authorization: ', PostHeader) <> 0 then Break;

                    //F؃wb_ǉ
					Request := AnalyzeAuthHeader(Method, Path, temp, User, Pass);
                    temp := GenerateAuthHeader(Request);
                    TJupiter(JupiterObj.Reference).Auth.SetAuth(Request.URI, temp);
                    PostHeader := PostHeader + temp + #13#10;
                end;

            else
                begin
                    //f[^text/html̂ƂHTML
                    temp := Trim(Header.GetHeader('Content-Type'));

                    if Copy(temp, 1, 9) = 'text/html' then
                        This.Variants.SetString('charSet', charset, This.Server);

                    GetHeader := Inf.Header;
                    Break;
                end;
        end;

	    //LbVgȂƂ̓t@C폜
    	if ForceBool(JupiterObj.Variants.GetObject('_NO_CACHE')) then
	    begin
    		DeleteFile(PChar(Result + '.htm'));
	    	DeleteFile(PChar(Result + '.hed'));
    		DeleteFile(PChar(Result + '.pim'));
	    end;
    end;

    Header.Free;
end;

procedure TJaWindow.SubmitData(This : TVirtualObject ; Form : TVirtualObject
                                    ; var Src : String ; var Header : String);
var
    n : Integer;
    Obj : TVirtualObject;
    Window : TVirtualObject;
    Target, Target2 : TVirtualObject;
    List : TNStringList;
    temp : String;
    stemp : String;
    Url : String;
    PostData : String;
    PostHeader : String;
    PostFile : String;
    CharSet : String;
    Boundary : String;
    FileName : String;
    Method : String;
    NewUrl : String;
    Name : String;
    Types : String;
    Multipart : Boolean;
    Index : Integer;
    NaN : Boolean;
    x : Integer;
    y : Integer;
begin
    if Form.Reference = nil then Exit;
    if Form.Reference.ClassName <> 'Form' then Exit;

    Obj := Form.Variants.GetObject('elements');
    if Obj.Arrays.Count = 0 then Exit;

    Window := Form.Variants.GetObject('owner');
    if Window.Reference = nil then Exit;
    if Window.Reference.ClassName <> 'Window' then Exit;

    PostData := '';
    PostHeader := '';
    //List := Pointer(Form.Int_Data);
    NewUrl := '';

    //Zbg擾
    CharSet := ForceString(This.Variants.GetObject('charSet'));

    //tH[̃ANV擾
    Url := ForceString(Form.Variants.GetObject('action'));
    if Url = '' then Exit;

    //f[^̎ނ
    temp := Trim(ForceString(Form.Variants.GetObject('encoding')));
    Multipart := UpperCase(temp) = 'MULTIPART/FORM-DATA';

    //\bh擾
    Method := ForceString(Form.Variants.GetObject('method'));

    //oE_擾
    Boundary := GenerateBoundary;

    //wb_ݒ
    if Multipart then
        //PostHeader :=   'Content-Type: multipart/form-data;' + #13#10
        //            +   #9 + 'boundary="' + Boundary + '"'
        PostHeader :=   'Content-Type: multipart/form-data; '
                            + 'boundary=' + Boundary
    else
        PostHeader :=   'Content-Type: application/x-www-form-urlencoded';

    for n := 0 to Obj.Arrays.Count - 1 do
    begin
        Target := Obj.Arrays.Datas[n];
        if Target.Reference = nil then Continue;

        if Target.Reference.ClassName = 'Input' then
        begin
            //List := Pointer(Target.Int_Data);
            Name := ForceString(Target.Variants.GetObject('name'));
            Types := UpperCase(ForceString(Target.Variants.GetObject('type')));

            if Name <> '' then
            begin
                Target2 := Target.Variants.GetObject('value');

                if (Types = 'CHECKBOX') or (Types = 'RADIO')
                    or (Types = 'SUBMIT') or (Types = 'IMAGE') then
                begin
                    if not ForceBool(Target.Variants.GetObject('checked')) then
                        Continue;
                    {
                    else if ForceString(Target.Variants.GetObject('value')) = '' then
                    begin
                        Target.Variants.SetString('value', '1', This.Server);
                        Target2 := Target.Variants.GetObject('value');
                    end;
                    }
                end
                else if (Types = 'BUTTON') or (Types = 'RESET') then
                    Continue;

                x := ForceInt(Target.Variants.GetObject('x'), NaN);
                y := ForceInt(Target.Variants.GetObject('y'), NaN);

                if Method = 'GET' then
                begin
                    if NewUrl <> '' then NewUrl := NewUrl + '&';

                    if Types = 'IMAGE' then
                    begin
                        NewUrl := NewUrl + UrlEncode(Name) + '.x='
                            + IntToStr(x) + '&' + UrlEncode(Name) + '.y='
                            + IntToStr(y);
                    end
                    else
                    begin
                        
                        NewUrl := NewUrl + UrlEncode(Name) + '='
                            + UrlEncode(Language.EncodeString(CharSet
                                , AdjustLineBreaks(ForceString(Target2))));
                    end;
                end
                else if not Multipart then
                begin
                    if PostData <> '' then PostData := PostData + '&';

                    if Types = 'IMAGE' then
                    begin
                        PostData := PostData + UrlEncode(Name) + '.x='
                                    + IntToStr(x) + '&' + UrlEncode(Name)
                                    + '.y=' + IntToStr(y);
                    end
                    else
                    begin
                        PostData := PostData + UrlEncode(Name) + '='
                                    + UrlEncode(Language.EncodeString(CharSet
                                    , AdjustLineBreaks(ForceString(Target2))));
                    end;
                end
                else
                begin
                    stemp :=        '--' + Boundary + #13#10;

                    if Types = 'FILE' then
                    begin
                        if Target2.Reference = nil then Continue;

                        if (Target2.Reference.ClassName = 'File')
                            and (FileExists(Target2.Str_Data)) then
                        begin
                            PostFile := ForceString(Target2.Variants.GetObject('fileName'));

                            stemp :=    stemp
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name)
                                    + '"; filename="' + PostFile + '"' + #13#10
                                +   'Content-Type: application/octet-stream' + #13#10
                                +   #13#10
                                +   LoadFromFile(Target2.Str_Data) + #13#10;
                        end
                        else
                        begin
                            stemp :=    stemp
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name) + '"' + #13#10
                                +   #13#10
                                +   #13#10;
                        end;
                    end
                    else if Types = 'IMAGE' then
                    begin
                        stemp :=    stemp
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name) + '.x"' + #13#10
                                +   #13#10
                                +   IntToStr(x) + #13#10;

                        stemp :=    stemp
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name) + '.y"' + #13#10
                                +   #13#10
                                +   IntToStr(y) + #13#10;
                    end
                    else
                    begin
                        stemp :=    stemp
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name) + '"' + #13#10
                                +   #13#10
                                +   Language.EncodeString(CharSet
                                            , ForceString(Target2)) + #13#10;
                    end;

                    PostData := PostData + stemp;
                end;
            end;
        end
        else if Target.Reference.ClassName = 'Select' then
        begin
            Name := ForceString(Target.Variants.GetObject('name'));
            Index := ForceInt(Target.Variants.GetObject('selectedIndex'), NaN);

            if Name <> '' then
            begin
                //IvVRNVo
                Target2 := Target.Variants.GetObject('options');
                Index := Target2.Arrays.GetIndex(Index);
                if Index < 0 then Continue;

                //Valueo
                Target2 := Target2.Arrays.Datas[Index];
                Target2 := Target2.Variants.GetObject('value');

                if Method = 'GET' then
                begin
                    if NewUrl <> '' then NewUrl := NewUrl + '&';
                    Target2.Variants.GetObject('value');
                    NewUrl := NewUrl + UrlEncode(Name) + '='
                            + UrlEncode(Language.EncodeString(CharSet
                                                , ForceString(Target2)));
                end
                else if not Multipart then
                begin
                    if PostData <> '' then PostData := PostData + '&';

                    PostData := PostData + UrlEncode(Name) + '='
                                    + UrlEncode(Language.EncodeString(CharSet
                                                        , ForceString(Target2)));
                end
                else
                begin
                    stemp :=        '--' + Boundary + #13#10
                                +   'Content-Disposition: form-data; name="'
                                    + UrlEncode(Name) + '"' + #13#10
                                +   #13#10
                                +   Language.EncodeString(CharSet
                                            , ForceString(Target2)) + #13#10;

                    PostData := PostData + stemp;
                end;
            end;
        end;
    end;

    //}`p[gbZ[W̍Ō̃oE_ǉ
    if Multipart then
    begin
        PostData    :=  PostData
                    +   '--' + Boundary + '--' + #13#10;
    end;

    //GET\bĥƂUrl
    if Method = 'GET' then
    begin
        Url := Url + '?' + NewUrl;
        PostData := '';
        PostHeader := '';
    end;

    Url := UrlCheck(Url);
    
    //|Xgs
    FileName := Post(Method, Url, PostHeader, PostData, Header, False, Window);
    Src := LoadFromFile(FileName + '.htm');

    //LbVgȂƂ̓t@C폜
   	if ForceBool(JupiterObj.Variants.GetObject('_NO_CACHE')) then
    begin
    	DeleteFile(PChar(FileName + '.htm'));
    	DeleteFile(PChar(FileName + '.hed'));
    	DeleteFile(PChar(FileName + '.pim'));
    end;

    //Zbg擾
    CharSet := ForceString(This.Variants.GetObject('charSet'));

    //pageURLݒ
    This.Variants.SetString('pageURL'
                				, ForceString(This.Variants.GetObject('lastURL'))
                				, This.Server);

    //\[XEwb_擾
    List := TNStringList(Window.Data);
    List.Strings[0] := Src;
    List.Strings[1] := Header;

    //tH[eNA
    ClearAll(This);

    //HTML
    if CharSet <> '' then
        HtmlParser(Language.DecodeString(charset, Src), This, True)
    else
        HtmlParser(Src, This, False);
end;

procedure TJaWindow.SetCookie(Data : String ; Url : String);
var
    List : TNStringList;
    n : Integer;
    ps : Integer;
    Ln : Integer;
    ch : Char;
    Src : PChar;
    temp : String;
    stemp : String;
    ttemp : String;
    Path : String;
    Expires : String;
    Domain : String;
    Key : String;
    Item : String;
    QuotType : TQuoteType;
begin
    List := TNStringList.Create;
    List.Text := Trim(Data);

    for n := 0 to List.Count - 1 do
    begin
        temp := List.Strings[n];
        stemp := UpperCase(temp);
        Ln := Length(temp);
        Src := PChar(temp);

        //domain
        ps := Pos('DOMAIN=', stemp);

        if ps <> 0 then
        begin
            ps := ps + 6;
            ttemp := '';
            QuotType := qtNone;

            while ps < Ln do
            begin
                ch := (Src + ps)^;

                case ch of
                    ';':
                        begin
                            if QuotType = qtNone then
                                Break;
                        end;

                    '"':
                        begin
                            if QuotType = qtNone then
                                QuotType := qtDouble
                            else if QuotType = qtDouble then
                                QuotType := qtNone;
                        end;

                end;

                ps := ps + 1;
                ttemp := ttemp + ch;
            end;

            ttemp := Trim(ttemp);

            if ttemp <> '' then
            begin
                if ttemp[1] = '"' then
                    ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
            end;

            Domain := Replace(ttemp, '-', ' ');
        end
        else
            Domain := '';

        //path
        Path := '';
        ps := Pos('PATH=', stemp);

        if ps <> 0 then
        begin
            ps := ps + 4;
            ttemp := '';
            QuotType := qtNone;

            while ps < Ln do
            begin
                ch := (Src + ps)^;

                case ch of
                    ';', ' ':
                        begin
                            if QuotType = qtNone then
                                Break;
                        end;

                    '"':
                        begin
                            if QuotType = qtNone then
                                QuotType := qtDouble
                            else if QuotType = qtDouble then
                                QuotType := qtNone;
                        end;

                end;

                ps := ps + 1;
                ttemp := ttemp + ch;
            end;

            ttemp := Trim(ttemp);

            if ttemp <> '' then
            begin
                if ttemp[1] = '"' then
                    ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
            end;

            if Domain = '' then
                Path := AbsoluteURL(Url, ttemp)
            else
                Path := Domain + ttemp;
        end;

        if Path = '' then
            Path := SplitCurrentDir(Url);

        ps := Pos('//', Path);

        if ps <> 0 then
            Path := Copy(Path, ps + 2, Length(Path) - ps - 1);

        //expires
        ps := Pos('EXPIRES=', stemp);

        if ps <> 0 then
        begin
            ps := ps + 7;
            ttemp := '';
            QuotType := qtNone;

            while ps < Ln do
            begin
                ch := (Src + ps)^;

                case ch of
                    ';':
                        begin
                            if QuotType = qtNone then
                                Break;
                        end;

                    '"':
                        begin
                            if QuotType = qtNone then
                                QuotType := qtDouble
                            else if QuotType = qtDouble then
                                QuotType := qtNone;
                        end;

                end;

                ps := ps + 1;
                ttemp := ttemp + ch;
            end;

            ttemp := Trim(ttemp);

            if ttemp <> '' then
            begin
                if ttemp[1] = '"' then
                    ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
            end;

            Expires := Replace(ttemp, '-', ' ');
        end
        else
            Expires := '';

        //f[^擾
        ps := Pos('=', temp);
        if ps = 0 then Continue;
        Key := Trim(Copy(temp, 1, ps - 1));
        ttemp := '';

        while ps < Ln do
        begin
            ch := (Src + ps)^;

            if ch = ';' then
                Break
            else
                ttemp := ttemp + ch;

            ps := ps + 1;
        end;

        Item := Trim(ttemp);
        ttemp := UpperCase(Key);

        if (ttemp = 'PATH') or (ttemp = 'EXPIRES') then Continue;

        Cookie.SetCookie(Key, Item, Path, Expires);
    end;

    List.Free;
end;

procedure TJaWindow.LoadCache(var Info : THttpInfo ; Cache : String
                                                ; This : TVirtualObject);
var
    ps : Integer;
    Http : TNHttp;
    temp : String;
begin
    Info.Header := LoadFromFile(Cache + '.hed');
    Http := Pointer(This.Int_Data);
    ps := Pos(#13#10, Info.Header);

    if ps = 0 then Exit;

    //ŏ̈s擾
    temp := Trim(Copy(temp, 1, ps - 1));

    //G[ԍ擾
    ps := Pos(' ', temp);
    if ps = 0 then Exit;

    temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    ps := Pos(' ', temp);

    if ps = 0 then
        Http.ErrorNum := StrToInt(temp)
    else
    begin
        Http.ErrorNum := StrToInt(Copy(temp, 1, ps - 1));

        //G[bZ[W擾
        Http.ErrorMsg := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    end;
end;

procedure TJaWindow.ClearAll(This : TVirtualObject);
var
    m, n : Integer;
    Forms , Form, Elements, Obj : TVirtualObject;
    Name : String;
begin
    //I[gKx[WRNVȂƂȂ蓾ϐ폜
    Forms := This.Variants.GetObject('forms');

    for m := 0 to Forms.Arrays.Count - 1 do
    begin
        Form := Forms.Arrays.Datas[m];

        //tH[owner̓I[i[EBhE|CgĂ
        Form.Variants.Blank('owner', This.Server);

        for n := 0 to Form.Variants.Count - 1 do
        begin
            //GgFORMQƂ폜
            Obj := Form.Variants.Datas[n];
            if Obj.Reference = nil then Continue;
            Name := Obj.Reference.ClassName;
            if Name = 'Input' then
                Obj.Variants.Blank('owner', This.Server);
        end;

        //elementsRNV擾
        Elements := Form.Variants.GetObject('elements');

        for n := 0 to Elements.Arrays.Count - 1 do
        begin
            //GgFORMQƂ폜
            Obj := Elements.Arrays.Datas[n];
            if Obj.Reference = nil then Continue;
            Name := Obj.Reference.ClassName;
            if Name = 'Input' then
                Obj.Variants.Blank('owner', This.Server);
        end;

        //J
        Forms.Arrays.Datas[m].Free;
        Forms.Arrays.Datas[m] := MakeUndefined(This.Server);
    end;

    This.Variants.SetObject('forms', This.Server.PrepareInstance('Array'));
end;

function TJaWindow.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Count : Integer;
    Obj : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    Count := High(args);

    if (Count = 0) or (Count = 1) then
    begin
        Obj := TJaWindow(This.Reference).navigate(args, This, Error);
        Obj.Free;
    end;
end;

function TJaWindow.toString(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString('JagaScript WindowIuWFNg by T.Nak', This.Server);
end;

function TJaWindow.document(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    VarCopy(This, Result, This.Server);
end;

function TJaWindow.window(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    if High(args) = 0 then
        navigate(args, This, Error);

    Result := MakeUndefined(This.Server);
end;

function TJaWindow.navigate(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Url : String;
    NowUrl : String;
    Source : String;
    Header : String;
    charset : String;
    FileName : String;
    Http : TNHttp;
    List : TNStringList;
    UseCache : Boolean;
    ps : Integer;
begin
    Http := Pointer(This.Int_Data);
    Url := UrlCheck(Trim(ForceString(args[0])));
    List := This.Data;
    NowUrl := ForceString(This.Variants.GetObject('lastURL'));

    if High(args) = 1 then
        UseCache := ForceBool(args[1])
    else
        UseCache := False;

    if Url = '' then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    if Pos('//', Url) = 0 then
    begin
        //ȑOURLȂbɂȂ
        if NowUrl = '' then
        begin
            Result := MakeUndefined(This.Server);
            Exit;
        end;

        if Copy(Url, 1, 3) = '../' then
            Url := SplitCurrentParent(NowUrl) + Copy(Url, 4, Length(Url) - 3)
        else if Copy(Url, 1, 2) = './' then
            Url := SplitCurrentDir(NowUrl) + Copy(Url, 3, Length(Url) - 2)
        else if Url[1] = '/' then
            Url := SplitRoot(NowUrl) + Url
        else
            Url := SplitCurrentDir(NowUrl) + Url;
    end;

    FileName := Post('GET', Url, '', '', Header, UseCache, This);
    Source := LoadFromFile(FileName + '.htm');
    List.Strings[0] := Source;
    List.Strings[1] := Header;

    //LbVgȂƂ̓t@C폜
   	if ForceBool(JupiterObj.Variants.GetObject('_NO_CACHE')) then
    begin
    	DeleteFile(PChar(FileName + '.htm'));
    	DeleteFile(PChar(FileName + '.hed'));
    	DeleteFile(PChar(FileName + '.pim'));
    end;

    //\[X̉sR[h𒲂ׂ
    ps := Pos(#13#10, Source);

    if ps = 0 then
        This.Variants.SetBoolean('breakWithCrlf', False, This.Server)
    else
    begin
        if ps < Pos(#10, Source) then
            This.Variants.SetBoolean('breakWithCrlf', True, This.Server)
        else
            This.Variants.SetBoolean('breakWithCrlf', False, This.Server);
    end;

    //LN^Zbgo
    charset := ForceString(This.Variants.GetObject('charSet'));

    //tH[eNA
    ClearAll(This);

    if charset <> '' then
        HtmlParser(Language.DecodeString(charset, Source), This, True)
    else
        HtmlParser(Source, This, False);

    //ŏIURLZbg
    This.Variants.SetString('pageURL'
                , ForceString(This.Variants.GetObject('lastURL'))
                , This.Server);

    Result := MakeInt(Http.ErrorNum, This.Server);
end;

function TJaWindow.getSource(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeString(List.Strings[0], This.Server);
end;

function TJaWindow.getHeader(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeString(List.Strings[1], This.Server);
end;

function TJaWindow.open(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Target : TVirtualObject;
    Url : String;
    Name : String;
    args2 : array of TVirtualObject;
begin
    Url := ForceString(args[0]);
    Name := ForceString(args[1]);

    //VEBhEJ
    Result := This.Server.PrepareInstance('Window');
    SetLength(args2, 1);
    args2[0] := MakeString(Url, This.Server);
    Target := TJaWindow(Result.Reference).navigate(args2, Result, Error);
    Target.Free;
    args2[0].Free;

    //openerݒ
    VarCopy(This, Target, This.Server);
    Result.Variants.SetObject('opener', Target);

    //Oݒ
    if (Name <> '') and (IDCheck(Name)) then
    begin
        Result.Str_Data := Name;
        VarCopy(Result, Target, This.Server);
        This.Variants.SetObject(Name, Target);
    end;
end;

function TJaWindow.close(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

function TJaWindow.name(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeString(This.Str_Data, This.Server);
end;

function TJaWindow.customPost(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Method : String;
    Url : String;
    OptionHeader : String;
    OptionData : String;
    Source : String;
    Header : String;
    FileName : String;
    charset : String;
    Http : TNHttp;
    List : TNStringList;
begin
    Http := Pointer(This.Int_Data);
    Method := ForceString(args[0]);
    Url := UrlCheck(ForceString(args[1]));
    OptionHeader := ForceString(args[2]);
    OptionData := ForceString(args[3]);
    List := This.Data;

    if (Method <> '') and (Url <> '') then
    begin
        FileName := Post(Method, Url, OptionHeader
                            , OptionData, Header, False, This);

        //\[X[h
        Source := LoadFromFile(FileName + '.htm');
        List.Strings[0] := Source;
        List.Strings[1] := Header;

	    //LbVgȂƂ̓t@C폜
    	if ForceBool(JupiterObj.Variants.GetObject('_NO_CACHE')) then
	    begin
    		DeleteFile(PChar(FileName + '.htm'));
	    	DeleteFile(PChar(FileName + '.hed'));
    		DeleteFile(PChar(FileName + '.pim'));
	    end;

        //LN^Zbgo
        charset := ForceString(This.Variants.GetObject('charSet'));

        //tH[eNA
        ClearAll(This);

        if charset <> '' then
            HtmlParser(Language.DecodeString(charset, Source), This, True)
        else
            HtmlParser(Source, This, False);

        //ŏIURLZbg
        This.Variants.SetString('pageURL'
                    , ForceString(This.Variants.GetObject('lastURL'))
                    , This.Server);

        Result := MakeInt(Http.ErrorNum, This.Server);
    end
    else
        Result := MakeInt(0, This.Server);
end;

function TJaWindow.download(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Url : String;
    Header : String;
    FileName : String;
    UseCache : Boolean;
begin
    Url := UrlCheck(Trim(ForceString(args[0])));

    if High(args) = 1 then
        UseCache := ForceBool(args[1])
    else
        UseCache := False;

    if Url <> '' then
    begin
        FileName := Post('GET', Url, '', '', Header, UseCache, This);
        Result := This.Server.PrepareInstance('File');
        Result.Str_Data := FileName + '.htm';
        Result.Variants.SetString('fileName', GetSingleFile(Url), This.Server);
    end
    else
        Result := MakeUndefined(This.Server);
end;

function TJaWindow.title(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeString(List.Strings[2], This.Server);
end;

function TJaWindow.errCode(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeInt(StrToInt(List.Strings[4]), This.Server);
end;

function TJaWindow.errMessage(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeInt(StrToInt(List.Strings[3]), This.Server);
end;

function TJaWindow.clear(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    //I[gKx[WRNVȂƂȂ蓾ϐ폜
    Result := MakeUndefined(This.Server);
    ClearAll(This);
end;

function TJaWindow.clearCookie(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    //Cookieׂč폜
    Cookie.Clear;
    Result := MakeUndefined(This.Server);
end;

procedure TJaWindow.SkipComment(Src : PChar ; Ln : Integer ; var Index : Integer
                                                    ; This : TVirtualObject);
begin
    while Index < Ln do
    begin
        if ((Src + Index)^ = '-')
            and ((Src + Index + 1)^ = '-')
                and ((Src + Index + 2)^ = '>') then
        begin
            Index := Index + 1;
            Break;
        end;

        Index := Index + 1;
    end;
end;

//******************************************************************************
//TJaSocket -> Socket

constructor TJaSocket.Create;
begin
    inherited Create;

    ClassName := 'Socket';

    //֐ǉ
    AddFunction('Socket', Construct, 0);
    AddFunction('connect', connect, 2);
    AddFunction('sendCommand', sendCommand, 1);
    AddFunction('readLine', readLine, 0);
    AddFunction('getChar', getChar, 0);
    AddFunction('read', read, 1);
    AddFunction('send', send, 1);

    //vpeB̒ǉ
    AddProperty('isConnected', isConnected);
    AddProperty('localHost', localHost);

end;

function TJaSocket.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
begin
    Socket := TNSocket.Create;
    This.Int_Data := Integer(Pointer(Socket));
    Result := MakeUndefined(This.Server);
end;

procedure TJaSocket.FreeObject(This : TVirtualObject);
var
    Socket : TNSocket;
begin
    Socket := Pointer(This.Int_Data);
    Socket.Free;
end;

function TJaSocket.connect(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
    Host : String;
    Port : Integer;
    NaN : Boolean;
begin
    Host := ForceString(args[0]);
    Port := ForceInt(args[1], NaN);

    if NaN then
    begin
        Result := MakeBoolean(False, This.Server);
        Exit;
    end;

    Socket := Pointer(This.Int_Data);
    Socket.Connect(Host, Port);
    Result := MakeBoolean(Socket.SocketCheck, This.Server);
end;

function TJaSocket.sendCommand(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
    temp : String;
begin
    temp := ForceString(args[0]);
    Socket := Pointer(This.Int_Data);
    Socket.SendCommand(temp);
    Result := MakeUndefined(This.Server);
end;

function TJaSocket.readLine(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
begin
    Socket := Pointer(This.Int_Data);
    Result := MakeString(Socket.ReadLine, This.Server);
end;

function TJaSocket.isConnected(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
begin
    Socket := Pointer(This.Int_Data);
    Result := MakeBoolean(Socket.SocketCheck ,This.Server);
end;

function TJaSocket.localHost(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
begin
    Socket := Pointer(This.Int_Data);
    Result := MakeString(Socket.LocalHost ,This.Server);
end;

function TJaSocket.getChar(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
    ch : Char;
begin
    Socket := Pointer(This.Int_Data);
    Socket.Read(@ch, 1);
    Result := MakeString(ch ,This.Server);
end;

function TJaSocket.read(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
	sz : Integer;
    nan : Boolean;
begin
	if High(args) <> 0 then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

    sz := ForceInt(args[0], nan);
    Socket := Pointer(This.Int_Data);
    Result := MakeString(Socket.ReadData(sz) ,This.Server);
end;

function TJaSocket.send(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Socket : TNSocket;
    data : String;
begin
	Result := MakeUndefined(This.Server);
	if High(args) <> 0 then Exit;

    data := ForceString(args[0]);
    Socket := Pointer(This.Int_Data);
	Socket.SendString(data);
end;

//******************************************************************************
//TJaWebItem

constructor TJaWebItem.Create;
begin
    inherited Create;

    //\bhǉ
    AddFunction('toString', toString, 0);

    //vpeBǉ
    AddProperty('onClick', onClick);
    AddProperty('onLoad', onLoad);
    AddProperty('onSubmit', onSubmit);
end;

procedure TJaWebItem.CreateObject(This : TVirtualObject);
var
    Data : TNStringList;
begin
    Data := TNStringList.Create;
    This.Int_Data := Integer(Pointer(Data));

    Data.Add('');       //onClickCxgnh\[X(0)
    Data.Add('');       //onDblClickCxgnh\[X(1)
    Data.Add('');       //onKeyDownCxgnh\[X(2)
    Data.Add('');       //onKeyPressCxgnh\[X(3)
    Data.Add('');       //onKeyUpCxgnh\[X(4)
    Data.Add('');       //onMouseDownCxgnh\[X(5)
    Data.Add('');       //onMouseUpCxgnh\[X(6)
    Data.Add('');       //onMouseOverCxgnh\[X(7)
    Data.Add('');       //onMouseOutCxgnh\[X(8)
    Data.Add('');       //onMouseMoveCxgnh\[X(9)
    Data.Add('');       //onLoadCxgnh\[X(10)
    Data.Add('');       //onUnLoadCxgnh\[X(11)
    Data.Add('');       //onFocusCxgnh\[X(12)
    Data.Add('');       //onBlurCxgnh\[X(13)
    Data.Add('');       //onSubmitCxgnh\[X(14)
    Data.Add('');       //onResetCxgnh\[X(15)
    Data.Add('');       //onChangeCxgnh\[X(16)
    Data.Add('');       //onResizeCxgnh\[X(17)
    Data.Add('');       //onMoveCxgnh\[X(18)
    Data.Add('');       //onDragDropCxgnh\[X(19)
    Data.Add('');       //onAbortCxgnh\[X(20)
    Data.Add('');       //onErrorCxgnh\[X(21)
    Data.Add('');       //onSelectCxgnh\[X(22)
end;

procedure TJaWebItem.FreeObject(This : TVirtualObject);
var
    Data : TNStringList;
begin
    Data := Pointer(This.Int_Data);
    Data.Free
end;

function TJaWebItem.onClick(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Data : TNStringList;
    CallInf : TScriptCall;
    Code : String;
begin
    Data := Pointer(This.Int_Data);

    Code := Data.Strings[0];
    CallInf.BreakLevel := 0;
    CallInf.Code := PChar(Code);
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Index := 0;
    CallInf.Length := Length(Code);
    CallInf.Parent := Window;
    CallInf.Return := nil;

    CallInf.Switch := nil;
    CallInf.Vars := Window.Variants;

    Result := MakeUndefined(This.Server);
end;

function TJaWebItem.onLoad(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

function TJaWebItem.onSubmit(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
end;

//******************************************************************************
//TJaLink -> Link

constructor TJaLink.Create;
begin
    inherited Create;

    ClassName := 'Link';

    //\bhǉ
    AddProperty('href', href);
    AddProperty('text', text);
end;

procedure TJaLink.CreateObject(This : TVirtualObject);
var
    Data : TNStringList;
begin
    //RXgN^
    inherited CreateObject(This);
    Data := Pointer(This.Int_Data);

    //f[^̃Zbg
    Data.Add('');       //N(23)
    Data.Add('');       //eLXg(24)
end;

function TJaLink.toString(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := Pointer(This.Int_Data);
    Result := MakeString(List.Strings[24] + '( ' + List.Strings[23] + ' )', This.Server);
end;

function TJaLink.href(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := Pointer(This.Int_Data);
    Result := MakeString(List.Strings[23], This.Server);
end;

function TJaLink.text(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := Pointer(This.Int_Data);
    Result := MakeString(List.Strings[24], This.Server);
end;

//******************************************************************************
//TJaForm -> Form

constructor TJaForm.Create;
begin
    inherited Create;

    ClassName := 'Form';

    //\bh̒ǉ
    AddFunction('Form', Construct, 0);
    AddFunction('submit', submit, 0);
end;

procedure TJaForm.CreateObject(This : TVirtualObject);
var
    Target : TVirtualObject;
begin
    //RXgN^
    inherited CreateObject(This);

    //GgIuWFNg̐ݒ
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('elements', Target);

    //ϐZbg
    This.Variants.SetString('action', '', This.Server);
    This.Variants.SetString('encoding', '', This.Server);
    This.Variants.SetString('method', 'GET', This.Server);
    This.Variants.SetString('name', '', This.Server);
    This.Variants.SetString('target', '', This.Server);
end;

procedure TJaForm.FreeObject(This : TVirtualObject);
begin
    This.Variants.Clear;
    inherited FreeObject(This);
end;

function TJaForm.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Obj : TVirtualObject;
begin
    if High(args) = 0 then
    begin
        VarCopy(args[0], Obj, This.Server);
        This.Variants.SetObject('owner', Obj);
    end;

    Result := MakeUndefined(This.Server);
end;

function TJaForm.submit(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Window : TVirtualObject;
    Source : String;
    Header : String;
begin
    Result := MakeUndefined(This.Server);
    Window :=This.Variants.GetObject('owner');

    if (Window.Reference = nil)
        or (Window.Reference.ClassName <> 'Window') then
            Exit;

    TJaWindow(Window.Reference).SubmitData(Window, This, Source, Header);
end;

//******************************************************************************
//

constructor TJaInput.Create;
begin
    inherited Create;

    ClassName := 'Input';

    //\bh̒ǉ
    AddFunction('Input', Construct, 0);
    AddFunction('click', click, 0);
end;

procedure TJaInput.CreateObject(This : TVirtualObject);
begin
    //RXgN^
    inherited CreateObject(This);

    //ϐ̐ݒ
    This.Variants.SetBoolean('checked', False, This.Server);
    This.Variants.SetBoolean('defaultChecked', False, This.Server);
    This.Variants.SetString('name', '', This.Server);
    This.Variants.SetString('type', 'hidden', This.Server);
    This.Variants.SetString('value', '', This.Server);
    This.Variants.SetString('owner', '', This.Server);
end;

function TJaInput.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    Obj : TVirtualObject;
begin
    if High(args) = 0 then
    begin
        This.Variants.SetString('name', ForceString(args[0]), This.Server);
        This.Variants.SetString('value', '', This.Server);
    end
    else if High(args) = 1 then
    begin
        This.Variants.SetString('name', ForceString(args[0]), This.Server);
        VarCopy(args[1], Obj, This.Server);
        This.Variants.SetObject('value', Obj);
    end;

    Result := MakeUndefined(This.Server);
end;

function TJaInput.click(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    Obj : TVirtualObject;
    Target : TVirtualObject;
    Types : String;
    NaN : Boolean;
begin
    Result := MakeUndefined(This.Server);
    Obj := This.Variants.GetObject('owner');
    Types := UpperCase(ForceString(This.Variants.GetObject('type')));
    if Obj.Reference = nil then Exit;
    if Obj.Reference.ClassName <> 'Form' then Exit;

    //Type𒲂ׂ
    if Types = 'IMAGE' then
    begin
        //`FbN
        This.Variants.SetBoolean('checked', True, This.Server);

        if High(args) = 1 then
        begin
            This.Variants.SetInt('x', ForceInt(args[0], NaN), This.Server);
            This.Variants.SetInt('y', ForceInt(args[1], NaN), This.Server);
        end
        else
        begin
            This.Variants.SetInt('x', 0, This.Server);
            This.Variants.SetInt('y', 0, This.Server);
        end;

        //Submits
        Target := TJaForm(Obj.Reference).submit(args, Obj, Error);
        Target.Free;
    end
    else if Types = 'SUBMIT' then
    begin
        //`FbN
        This.Variants.SetBoolean('checked', True, This.Server);

        //Submits
        Target := TJaForm(Obj.Reference).submit(args, Obj, Error);
        Target.Free;
    end
end;

//******************************************************************************
//TJaSelect -> Select

constructor TJaSelect.Create;
begin
    inherited Create;

    ClassName := 'Select';
end;

procedure TJaSelect.CreateObject(This : TVirtualObject);
var
    Target : TVirtualObject;
begin
    inherited CreateObject(This);

    //ϐZbg
    This.Variants.SetInt('selectedIndex', 0, This.Server);
    This.Variants.SetString('name', '', This.Server);

    //optionsZbg
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('options', Target);
end;

//******************************************************************************
// TJaOption -> Option

constructor TJaOption.Create;
begin
    inherited Create;

    ClassName := 'Option';
end;

procedure TJaOption.CreateObject(This : TVirtualObject);
begin
    //RXgN^
    inherited CreateObject(This);

    //ϐ̐ݒ
    This.Variants.SetString('value', '', This.Server);
    This.Variants.SetString('text', '', This.Server);
end;

//******************************************************************************
// TJaMime -> Mime

constructor TJaMime.Create;
begin
    inherited Create;

    ClassName := 'Mime';

    //\bh
    AddFunction('setSource', setSource, 1);
    AddFunction('getSource', getSource, 0);
    AddFunction('importHeader', importHeader, 1);
end;

destructor TJaMime.Destroy;
begin
    inherited Destroy;
end;

procedure TJaMime.CreateObject(This : TVirtualObject);
var
    Target : TVirtualObject;
    List : TNStringList;
begin
    //filesݒ
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('files', Target);

    //ϐݒ
    This.Variants.SetString('defCharSet', '', This.Server);
    This.Variants.SetString('to', '', This.Server);
    This.Variants.SetString('cc', '', This.Server);
    This.Variants.SetString('bcc', '', This.Server);
    This.Variants.SetString('subject', '', This.Server);
    This.Variants.SetString('date', '', This.Server);
    This.Variants.SetString('from', '', This.Server);
    This.Variants.SetString('inReplyTo', '', This.Server);
    This.Variants.SetString('messageId', '', This.Server);
    This.Variants.SetString('references', '', This.Server);
    This.Variants.SetString('replyTo', '', This.Server);
    This.Variants.SetString('priority', '', This.Server);
    This.Variants.SetString('mailer', '', This.Server);
    This.Variants.SetString('contentType', '', This.Server);
    This.Variants.SetString('boundary', '', This.Server);
    This.Variants.SetString('encode', '', This.Server);
    This.Variants.SetString('text', '', This.Server);
    This.Variants.SetString('html', '', This.Server);
    This.Variants.SetString('option', '', This.Server);

    List := TNStringList.Create;
    List.Add('');
    This.Data := Pointer(List);
end;

procedure TJaMime.FreeObject(This : TVirtualObject);
var
    List : TNStringList;
begin
    List := Pointer(This.Data);
    List.Free;
end;

procedure TJaMime.LoadFile(FileName : String ; This : TVirtualObject);
var
    Target : TVirtualObject;
    Source : String;
    Src : TNStringList;
    List : TNStringList;
    m, n : Integer;
    ps : Integer;
    PSrc : PChar;
    ch : Char;
    temp : String;
    stemp : String;
    utemp : String;
    Charset : String;
    Encode : String;
    DeliverTo : String;
    Mail_To : String;
    Mail_Cc : String;
    New_To : String;
    New_Cc : String;
    New_Bcc : String;
    IsMultipart : Boolean;
begin
    //
    DeliverTo := '';
    Mail_To := '';
    Mail_Cc := '';

    //filesݒ
    Target := This.Server.PrepareInstance('Array');
    This.Variants.SetObject('files', Target);

    if not FileExists(FileName) then Exit;
    This.Str_Data := FileName;

    //MIME`̃t@Cǂݍ
    Source := LoadFromFile(FileName);
    if Source = '' then Exit;

    Src := TNStringList.Create;
    Src.Text := Source;

    IsMultipart := False;

    for n := 0 to Src.Count - 1 do
    begin
        temp := Src.Strings[n];
        utemp := UpperCase(temp);

        if Copy(utemp, 1, 3) = 'TO:' then
        begin
            //To
            stemp := Language.BDecode(Trim(Copy(temp, 4, Length(temp)-3)));

            for m := n + 1 to Src.Count - 1 do
            begin
                temp := Src.Strings[m];

                if temp = '' then Break;

                if (temp[1] = #9) or (temp[1] = ' ') then
                    stemp := stemp + Language.BDecode(Trim(temp))
                else
                    Break;
            end;

            This.Variants.SetString('to', stemp, This.Server);
            Mail_To := stemp;
        end
        else if Copy(utemp,1,3) = 'CC:' then
        begin
            stemp := Language.BDecode(Trim(Copy(temp, 4, Length(temp) - 3)));

            for m := n + 1 to Src.Count - 1 do
            begin
                temp := Src.Strings[m];

                if temp = '' then Break;

                if (temp[1] = #9) or (temp[1] = ' ') then
                    stemp := stemp + Language.BDecode(Trim(temp))
                else
                    Break;
            end;

            This.Variants.SetString('cc', stemp, This.Server);
            Mail_Cc := stemp;
        end
        //else if Copy(utemp,1,4) = 'BCC:' then
        //begin
        //    stemp := Language.BDecode(Trim(Copy(temp, 5, Length(temp) - 4)));

        //    for m := n + 1 to Src.Count - 1 do
        //    begin
        //        temp := Src.Strings[m];

        //        if temp = '' then Break;

        //        if (temp[1] = #9) or (temp[1] = ' ') then
        //            stemp := stemp + Language.BDecode(Trim(temp))
        //        else
        //            Break;
        //    end;
        //
        //    This.Variants.SetString('bcc', stemp, This.Server);
        //    Mail_Bcc := stemp;
        //end
        else if Copy(utemp,1,8) = 'SUBJECT:' then
        begin
            stemp := Language.BDecode(Trim(Copy(temp, 9, Length(temp)-8)));

            for m := n + 1 to Src.Count - 1 do
            begin
                temp := Src.Strings[m];

                if temp = '' then Break;

                if (temp[1] = #9) or (temp[1] = ' ') then
                    stemp := stemp + Language.BDecode(Trim(temp))
                else
                    Break;
            end;

            This.Variants.SetString('subject', stemp, This.Server);
        end
        else if Copy(utemp,1,5) = 'DATE:' then
        begin
            stemp := Copy(temp, 6, Length(temp) - 5);
            This.Variants.SetString('date', stemp, This.Server);
        end
        else if Copy(utemp,1,5) = 'FROM:' then
        begin
            if Trim(ForceString(This.Variants.GetObject('from'))) = '' then
            begin
                stemp := Language.BDecode(Trim(Copy(temp, 6, Length(temp) - 5)));
                This.Variants.SetString('from', stemp, This.Server);
            end;
        end
        else if Copy(utemp,1,12) = 'IN-REPLY-TO:' then
        begin
            stemp := Trim(Copy(temp, 13, Length(temp) - 12));
            This.Variants.SetString('inReplyTo', stemp, This.Server);
        end
        else if Copy(utemp,1,11) = 'MESSAGE-ID:' then
        begin
            stemp := Trim(Copy(temp, 12, Length(temp) - 11));
            This.Variants.SetString('messageId', stemp, This.Server);
        end
        else if Copy(utemp,1,11) = 'REFFERNCES:' then
        begin
            stemp := Trim(Copy(temp, 12, Length(temp) - 11));
            This.Variants.SetString('references', stemp, This.Server);
        end
        else if Copy(utemp,1,9) = 'REPLY-TO:' then
        begin
            stemp := Language.BDecode(Trim(Copy(temp, 10, Length(temp) - 9)));
            This.Variants.SetString('replyTo', stemp, This.Server);
        end
        else if Copy(utemp,1,11) = 'X-PRIORITY:' then
        begin
            stemp := Trim(Copy(temp, 12, Length(temp) - 11));
            This.Variants.SetString('priority', stemp, This.Server);
        end
        else if Copy(utemp,1,9) = 'X-MAILER:' then
        begin
            stemp := Trim(Copy(temp, 10, Length(temp) - 9));
            This.Variants.SetString('mailer', stemp, This.Server);
        end
        else if Copy(utemp,1,13) = 'X-DELIVER-TO:' then
        begin
            stemp := Trim(Copy(temp, 14, Length(temp) - 13));
            DeliverTo := stemp;
        end
        else if Copy(utemp,1,15) = 'X-DELIVER-FROM:' then
        begin
            stemp := Trim(Copy(temp, 16, Length(temp) - 15));

            if stemp <> '' then
                This.Variants.SetString('from', stemp, This.Server);
        end
        else if Copy(utemp,1,13) = 'CONTENT-TYPE:' then
        begin
            stemp := Trim(Copy(temp, 14, Length(temp) - 13));

            for m := n + 1 to Src.Count - 1 do
            begin
                temp := Src.Strings[m];

                if temp = '' then Break;

                if (temp[1] = #9) or (temp[1] = ' ') then
                    stemp := stemp + Language.BDecode(Trim(temp))
                else
                    Break;
            end;

            This.Variants.SetString('contentType', stemp, This.Server);

            //boundary𔲂o
            utemp := UpperCase(stemp);
            ps := Pos('BOUNDARY=', utemp);

            if ps = 0 then
                This.Variants.SetString('boundary', '', This.Server)
            else
            begin
                m := ps + 8;
                PSrc := PChar(stemp);
                temp := '';

                while m < Length(stemp) do
                begin
                    ch := (PSrc + m)^;

                    case ch of
                        #13, ';':
                            Break;
                        else
                            temp := temp + ch;
                    end;

                    m := m + 1;
                end;

                temp := Trim(temp);

                if temp = '' then Continue;
                if (temp[1] = '"') and (temp[Length(temp)] = '"') then
                    temp := Trim(Copy(temp, 2, Length(temp) - 2));

                IsMultipart := True;
                This.Variants.SetString('boundary', temp, This.Server);
            end;

            //Charset𔲂o
            utemp := UpperCase(stemp);
            ps := Pos('CHARSET=', utemp);

            if ps = 0 then
                This.Variants.SetString('defCharSet', '', This.Server)
            else
            begin
                m := ps + 7;
                PSrc := PChar(stemp);
                temp := '';

                while m < Length(stemp) do
                begin
                    ch := (PSrc + m)^;

                    case ch of
                        #13, ';':
                            Break;
                        else
                            temp := temp + ch;
                    end;

                    m := m + 1;
                end;

                temp := Trim(temp);

                if temp = '' then Continue;
                if (temp[1] = '"') and (temp[Length(temp)] = '"') then
                    temp := Trim(Copy(temp, 2, Length(temp) - 2));

                CharSet := temp;
                This.Variants.SetString('defCharSet', temp, This.Server);
            end;
        end
        else if Copy(utemp,1,26) = 'CONTENT-TRANSFER-ENCODING:' then
        begin
            stemp := Trim(Copy(temp, 27, Length(temp) - 26));
            Encode := stemp;
            This.Variants.SetString('encode', Encode, This.Server);
        end
        else if temp = '' then
            Break;
    end;

    Src.Free;

    //DeliverToTo, Cc, BccɐU蕪
    if DeliverTo <> '' then
    begin
        List := TNStringList.Create;
        List.Text := Trim(Replace(DeliverTo, ';', #13#10));

        //dAhX폜
        for n := 0 to List.Count - 1 do
        begin
            temp := List.Strings[n];

            for m := List.Count - 1 downto n + 1 do
            begin
                if temp = List.Strings[m] then
                    List.Delete(m);
            end;
        end;

        //To, Cc, BccɐU蕪
        New_To := '';
        New_Cc := '';
        New_Bcc := '';

        for n := 0 to List.Count - 1 do
        begin
            temp := List.Strings[n];

            //Toɑ݂邩ǂ
            if Pos(temp, Mail_To) <> 0 then
            begin
                if New_To <> '' then New_To := New_To + ';';
                New_To := New_To + temp;
                Continue;
            end;

            //Ccɑ݂邩ǂ
            if Pos(temp, Mail_Cc) <> 0 then
            begin
                if New_Cc <> '' then New_Cc := New_Cc + ';';
                New_Cc := New_Cc + temp;
                Continue;
            end;

            //Bccɒǉ
            if New_Bcc <> '' then New_Bcc := New_Bcc + ';';
            New_Bcc := New_Bcc + temp;
        end;

        //IuWFNg̃vpeBɐݒ
        This.Variants.SetString('to', New_To, This.Server);
        This.Variants.SetString('cc', New_Cc, This.Server);
        This.Variants.SetString('bcc', New_Bcc, This.Server);

        //J
        List.Free;
    end;

    //Ytt@C
    if IsMultipart then
        ExtractAttachFile(Source, This)
    else
    begin
        ps := Pos(#13#10#13#10, Source);
        temp := Copy(Source, ps + 4, Length(Source) - ps - 3);

        //fR[h
        stemp := UpperCase(Encode);

        if stemp = 'BASE64' then
            temp := Base64Decode(temp)
        else if stemp = 'QUOTED-PRINTABLE' then
            temp := QPDecode(temp)
        else if stemp = 'BINHEX' then
            temp := BinHexDecode(temp);

        temp := Language.DecodeString(CharSet, temp);
        This.Variants.SetString('text', temp, This.Server);
    end;
end;

procedure TJaMime.ExtractAttachFile(const Source : String ; This : TVirtualObject);
var
    Files : TVirtualObject;
    Obj : TVirtualObject;
    Header, temp, stemp, ttemp : String;
    Data : String;
    Encode : String;
    SaveFile : String;
    ContentType : String;
    CharSet : String;
    ContentID : String;
    k, l, m, n : Integer;
begin
    //files擾
    Files := This.Variants.GetObject('files');

    //wb_ƃf[^̋Eʒu
    n := Pos(#13#10#13#10, Source);
    Header := Copy(Source, 1, n - 1);
    temp := FindMailType(Header, 'boundary');
    m := FindString(Source, '--' + temp, 1);

    while m <> 0 do
    begin
        n := FindString(Source, #13#10#13#10, m + 1);

        if n <> 0 then
        begin
            Header := Copy(Source, m, n - m);

            //t@C擾
            stemp := FindMailType(Header, 'filename');

            if stemp = '' then
                stemp := FindMailType(Header, 'name');

            //t@CBDecode
            stemp := Language.BDecode(stemp);

            //̃oE_ʒu擾
            m := FindString(Source, '--' + temp, n + 1);
            if m = 0 then Break;

            //wb_ƃf[^̋Eʒu擾
            //n := FindString(Source, #13#10#13#10, n + 4);
            n := n + 4;

            //Content-Transfer-Encoding擾
            k := FindString(UpperCase(Header), 'CONTENT-TRANSFER-ENCODING:', 1);
            if k <> 0 then
            begin
                l := FindString(Header, #13#10, k);
                if l = 0 then l := Length(Header) + 1;
                Encode := UpperCase(Trim(Copy(Header, k + 26, l - k - 26)));
            end;

            //Content-Type擾
            k := FindString(UpperCase(Header), 'CONTENT-TYPE:', 1);
            if k = 0 then Continue;
            l := FindString(Header, #13#10, k);
            if l = 0 then l := Length(Header) + 1;

            ContentType := UpperCase(Trim(Copy(Header, k + 13, l - k - 13)));

            //Content-ID擾
            k := FindString(UpperCase(Header), 'CONTENT-ID:', 1);
            if k <> 0 then
            begin
                l := FindString(Header, #13#10, k);
                if l = 0 then l := Length(Header) + 1;
                ttemp := Trim(Copy(Header, k + 11, l - k - 11));

                if (Pos('<', ttemp) = 1) and (Pos('>', ttemp) = Length(ttemp)) then
                    ContentID := Copy(ttemp, 2, Length(ttemp) - 2);

                if l <> Length(Header) then
                begin
                    l := l + 2;

                    if (Header[l] = #9) or (Header[l] = ' ') then
                    begin
                        k := FindString(Header, #13#10, l);

                        if k <> 0 then
                        begin
                            ContentType := ContentType
                                + UpperCase(Trim(Copy(Header, l, k - l)));
                        end;
                    end;
                end;
            end;

            CharSet := FindMailType(ContentType, 'charset');

            //fR[hEWJEe|t@C֕ۑ
            //Base64, BinHex, UUEncodeɑΉ
            if n <> 0 then
            begin
                Data := Copy(Source, n, m - n - 1);
                if Data = '' then Continue;

                SaveFile := GenerateTempFile(TempPath);

                if Encode = 'BASE64' then
                begin
                    if stemp = '' then
                    begin
                        if Pos('TEXT/PLAIN', ContentType) <> 0 then
                            This.Variants.SetString('text'
                                , Language.DecodeString(CharSet
                                    , Base64Decode(Trim(Data)))
                                        , This.Server)
                        else if Pos('TEXT/HTML', ContentType) <> 0 then
                            This.Variants.SetString('html'
                                , Language.DecodeString(CharSet
                                    , Base64Decode(Trim(Data)))
                                        , This.Server);

                        Continue;
                    end
                    else
                        SaveToFile(SaveFile, Base64Decode(Data));
                end
                else if Encode = 'BINHEX' then
                begin
                    if stemp = '' then
                    begin
                        if Pos('TEXT/PLAIN', ContentType) <> 0 then
                            This.Variants.SetString('text'
                                , Language.DecodeString(CharSet
                                    , BinHexDecode(Trim(Data)))
                                        , This.Server)
                        else if Pos('TEXT/HTML', ContentType) <> 0 then
                            This.Variants.SetString('html'
                                , Language.DecodeString(CharSet
                                    , BinHexDecode(Trim(Data)))
                                        , This.Server);

                        Continue;
                    end
                    else
                        SaveToFile(SaveFile, BinHexDecode(Data));
                end
                else if Encode = 'QUOTED-PRINTABLE' then
                begin
                    if stemp = '' then
                    begin
                        if Pos('TEXT/PLAIN', ContentType) <> 0 then
                            This.Variants.SetString('text'
                                , Language.DecodeString(CharSet
                                    , QPDecode(Trim(Data)))
                                        , This.Server)
                        else if Pos('TEXT/HTML', ContentType) <> 0 then
                            This.Variants.SetString('html'
                                , Language.DecodeString(CharSet
                                    , QPDecode(Trim(Data)))
                                        , This.Server);

                        Continue;
                    end
                    else
                        SaveToFile(SaveFile, QPDecode(Data));
                end
                else
                begin
                    if stemp = '' then
                    begin
                        if Pos('TEXT/PLAIN', ContentType) <> 0 then
                            This.Variants.SetString('text'
                                        , Language.DecodeString(CharSet, Data)
                                        , This.Server)
                        else if Pos('TEXT/HTML', ContentType) <> 0 then
                            This.Variants.SetString('html'
                                        , Language.DecodeString(CharSet, Data)
                                        , This.Server)
                        else if Pos('MULTIPART/', ContentType) <> 0 then
                            ExtractAttachFile(Header + #13#10#13#10 + Data, This);

                        Continue;
                    end
                    else
                        SaveToFile(SaveFile, Data);
                end;

                //else if Encode = 'UUEncode' then

                //t@CIuWFNgǉ
                Obj := This.Server.PrepareInstance('File');
                Obj.Str_Data := SaveFile;
                Obj.Variants.SetString('fileName', stemp, This.Server);
                Obj.Variants.SetString('contentId', ContentID, This.Server);
                Files.Arrays.AddNext(Obj);

            end;

        end
        else
            Break;
    end;
end;

function TJaMime.FindMailType( Header : String ; Types : String ) : String;
var
    uHeader , uTitle , temp : String;
    ln , m , n : Integer;
begin
    Result := '';
    uHeader := UpperCase(Header) + #13#10;
    uTitle := UpperCase(Types) + '="';
    ln := Length(uTitle);
    n := Pos(uTitle,uHeader);

    if n <> 0 then
    begin
        temp := Copy(Header, n + ln, Length(Header) - n - ln + 1);
        n := Pos('"', temp);
        Result := Copy(temp, 1, n - 1);
    end
    else
    begin
        uTitle := UpperCase(Types) + '=';
        ln := Length(uTitle);
        n := Pos(uTitle,uHeader);

        if n <> 0 then
        begin
            temp := Copy(Header, n + ln, Length(Header) - n - ln + 1);
            m := Pos(';', temp);
            n := Pos(#13#10, temp);

            if (m = 0) or (n = 0) then
            begin
                if m = 0 then
                begin
                    if n <> 0 then
                        Result := Trim(Copy(temp, 1, n - 1))
                    else
                        Result := Trim(temp);
                end
                else
                    Result := Copy(temp, 1, m - 1);
            end
            else
            begin
                if m > n then
                    Result := Copy(temp, 1, n - 1)
                else
                    Result := Copy(temp, 1, m - 1);
            end;
        end;
    end;
end;

function TJaMime.FindString( S : String ; A : String ; Start : Integer ) : Integer;
var
    r , t : PChar;
    ln , m , n : Integer;
    passed : Boolean;
begin
    Result := 0;
    ln := Length(S);
    r := PChar(A);
    t := PChar(S) + Start - 1;

    for m := Start - 1 to ln - Length(A) - 1 do
    begin
        if t^ = r^ then
        begin
            passed := True;

            for n := 1 to Length(A) - 1 do
            begin
                if (t + n)^ <> (r + n)^ then
                begin
                    passed := False;
                    Break;
                end;
            end;

            if passed then
            begin
                Result := m + 1;
                Exit;
            end;
        end;

        t := t + 1;
    end;
end;

procedure TJaMime.SaveFile(FileName : String ; This : TVirtualObject);
var
    Files : TVirtualObject;
    Boundary : String;
    CharSet : String;
    IsMultipart : Boolean;
    temp : String;
    Source : String;
    TextData : String;
    HtmlData : String;
    AttachName : String;
    TrueFile : String;
    List : TNStringList;
    n : Integer;
    cid : String;
begin
    //
    Files := This.Variants.GetObject('files');
    CharSet := ForceString(This.Variants.GetObject('defCharSet'));
    Boundary := GenerateBoundary;
    IsMultipart := Files.Arrays.Count <> 0;
    Source := '';
    List := This.Data;

    if List.Strings[0] = '' then
    begin
        //[{擾
        TextData := ForceString(This.Variants.GetObject('text'));
        HtmlData := ForceString(This.Variants.GetObject('html'));

        //To擾
        temp := Language.HeaderBEncode(ForceString(This.Variants.GetObject('to'))
                                                                    , CharSet);
        Source := 'To: ' + temp + #13#10;

        //Cc擾
        temp := Language.HeaderBEncode(ForceString(This.Variants.GetObject('cc'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'Cc: ' + temp + #13#10;

        //Bcc擾
        temp := Language.HeaderBEncode(ForceString(This.Variants.GetObject('bcc'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'Bcc: ' + temp + #13#10;

        //From擾
        temp := Language.HeaderBEncode(ForceString(This.Variants.GetObject('from'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'From: ' + temp + #13#10;

        //Subject擾
        temp := Language.BEncode(ForceString(This.Variants.GetObject('subject'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'Subject: ' + temp + #13#10;

        //Date擾
        temp := ForceString(This.Variants.GetObject('date'));
        if temp <> '' then
            Source := Source + 'Date: ' + temp + #13#10;

        //In-Reply-To擾
        temp := Language.BEncode(ForceString(This.Variants.GetObject('inReplyTo'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'In-Reply-To: ' + temp + #13#10;

        //References擾
        temp := Language.BEncode(ForceString(This.Variants.GetObject('references'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'References: ' + temp + #13#10;

        //Reply-To擾
        temp := Language.BEncode(ForceString(This.Variants.GetObject('replyTo'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'Reply-To: ' + temp + #13#10;

        //Message-ID擾
        temp := Language.BEncode(ForceString(This.Variants.GetObject('messageId'))
                                                                    , CharSet);
        if temp <> '' then
            Source := Source + 'Message-ID: ' + temp + #13#10;

        //MIMEVersion
        Source := Source + 'MIME-Version: 1.0' + #13#10;

        //Content-Typeݒ
        if IsMultipart then
        begin
            Source := Source + 'Content-Type: multipart/mixed; boundary="'
                        + Boundary + '"' + #13#10;
        end
        else
        begin
            if HtmlData = '' then
                Source := Source + 'Content-Type: text/plain; charset="'
                            + CharSet + '"'+ #13#10
            else if TextData = '' then
                Source := Source + 'Content-Type: text/html; charset="'
                            + CharSet + '"'+ #13#10
            else
            begin
                //̓}`p[g
                IsMultipart := True;
                Source := Source + 'Content-Type: multipart/mixed; boundary="'
                        + Boundary + '"' + #13#10;
            end;
        end;

		//IvVwb_
        temp := Trim(ForceString(This.Variants.GetObject('option')));
        if temp <> '' then
        	Source := Source + temp + #13#10;

        //wb_ƃf[^̋؂
        Source := Source + #13#10;

        //f[^ݒ
        if IsMultipart then
        begin
            //}`p[gbZ[W
            Source := Source + 'This message is multipart message.' + #13#10#13#10;

            //eLXg
            if (TextData = '') and (HtmlData = '') then
                TextData := 'Body is empty.';

            if TextData <> '' then
            begin
                Source := Source
                        + '--' + Boundary + #13#10
                        + 'Content-Type: text/plain; charset="' + CharSet + '"' + #13#10
                        + 'Content-Transfer-Encoding: 7bit' + #13#10
                        + #13#10
                        + Language.EncodeString(CharSet, TextData) + #13#10
                        + #13#10;
            end;

            //HTML
            if HtmlData <> '' then
            begin
                Source := Source
                        + '--' + Boundary + #13#10
                        + 'Content-Type: text/html; charset="' + CharSet + '"' + #13#10
                        + 'Content-Transfer-Encoding: 7bit' + #13#10
                        + #13#10
                        + Language.EncodeString(CharSet, HtmlData) + #13#10
                        + #13#10;
            end;

            //t@C荞
            for n := 0 to Files.Arrays.Count - 1 do
            begin
                TrueFile := Files.Arrays.Datas[n].Str_Data;
                AttachName := ForceString(Files.Arrays.Datas[n].Variants.GetObject('fileName'));

                if (TrueFile = '') or (AttachName = '') then Continue;
                if not FileExists(TrueFile) then Continue;
                cid := ForceString(Files.Arrays.Datas[n].Variants.GetObject('contentId'));

                Source := Source
                        + '--' + Boundary + #13#10
                        + 'Content-Type: application/octet-stream; name="'
                            + Language.BEncode(AttachName, CharSet) + '"' + #13#10
                        + 'Content-Transfer-Encoding: Base64' + #13#10;

                if cid <> '' then
                begin
                    Source := Source
                        + 'Content-ID: <' + cid + '>' + #13#10
                end
                else
                begin
                    Source := Source
                        + 'Content-Disposition: attachment; filename="'
                            + Language.BEncode(AttachName, CharSet) + '"' + #13#10;
                end;

                Source := Source
                        + AutoReturn(Base64Encode(LoadFromFile(TrueFile)), 76) + #13#10;


            end;

            //Ō̃oE_
            Source := Source
                        + '--' + Boundary + '--' + #13#10;
        end
        else
        begin
            //eLXg邢HTML̃[
            if TextData <> '' then
                Source := Source + Language.EncodeString(CharSet, TextData)
            else
                Source := Source + Language.EncodeString(CharSet, HtmlData);
        end;

        //t@Cɕۑ
        SaveToFile(FileName, Source);
    end
    else
        SaveToFile(FileName, List.Strings[0]);
end;

function TJaMime.setSource(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    List.Strings[0] := ForceString(args[0]);
    Result := MakeUndefined(This.Server);
end;

function TJaMime.getSource(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    ReBuild : TNStringList;
    n : Integer;
    Ends : Integer;
    temp : String;
begin
    List := This.Data;

    if List.Strings[0] <> '' then
        Result := MakeString(List.Strings[0], This.Server)
    else
    begin
        ReBuild := TNStringList.Create;
        ReBuild.LoadFromFile(This.Str_Data);
        Ends := Rebuild.Count - 1;

        for n := 0 to ReBuild.Count - 1 do
            if Trim(ReBuild.Strings[n]) = '' then Ends := n;

        for n := Ends downto 0 do
        begin
            temp := UpperCase(ReBuild.Strings[n]);

            if Copy(temp, 1, 15) = 'X-DELIVER-FROM:' then
                ReBuild.Delete(n)
            else if Copy(temp, 1, 13) = 'X-DELIVER-TO:' then
                ReBuild.Delete(n);
        end;

        Result := MakeString(ReBuild.Text, This.Server);
        ReBuild.Free;
    end;
end;

function TJaMime.importHeader(args : array of TVirtualObject ; This : TVirtualObject
                                            ; Error : TErrors) : TVirtualObject;
var
	src : String;
    option : String;
    temp, utemp : String;
    list : TNStringList;
    n : Integer;
    lastobj : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    lastobj := nil;
    option := '';

	if High(args) = 0 then
    begin
		src := AdjustLineBreaks(Trim(ForceString(args[0])));
		list := TNStringList.Create;
        list.Text := src;

        for n := 0 to list.Count - 1 do
        begin
        	temp := list.Strings[n];
            utemp := UpperCase(temp);

            //wb_
            if Copy(utemp, 1, 14) = 'CONTENT-TYPE: ' then
            begin
            	lastobj := nil;
            	Continue;
            end
            else if Copy(utemp, 1, 14) = 'MIME-VERSION: ' then
            begin
            	lastobj := nil;
            	Continue;
            end
            else if Copy(utemp, 1, 27) = 'CONTENT-TRANSFER-ENCODING: ' then
            begin
            	lastobj := nil;
            	Continue;
            end

            //uwb_
            else if Copy(utemp, 1, 4) = 'TO: ' then
            begin
				This.Variants.SetString('to', Copy(temp, 5, Length(temp) - 4), This.Server);
                lastobj := This.Variants.GetObject('to');
            end
            else if Copy(utemp, 1, 4) = 'CC: ' then
            begin
				This.Variants.SetString('cc', Copy(temp, 5, Length(temp) - 4), This.Server);
                lastobj := This.Variants.GetObject('cc');
            end
            else if Copy(utemp, 1, 9) = 'SUBJECT: ' then
            begin
				This.Variants.SetString('subject', Copy(temp, 10, Length(temp) - 9), This.Server);
                lastobj := This.Variants.GetObject('subject');
            end
            else if Copy(utemp, 1, 6) = 'DATE: ' then
            begin
				This.Variants.SetString('date', Copy(temp, 7, Length(temp) - 6), This.Server);
                lastobj := This.Variants.GetObject('date');
            end
            else if Copy(utemp, 1, 6) = 'FROM: ' then
            begin
				This.Variants.SetString('from', Copy(temp, 7, Length(temp) - 6), This.Server);
                lastobj := This.Variants.GetObject('from');
            end
            else if Copy(utemp, 1, 13) = 'IN-REPLY-TO: ' then
            begin
				This.Variants.SetString('inReplyTo', Copy(temp, 14, Length(temp) - 13), This.Server);
                lastobj := This.Variants.GetObject('inReplyTo');
            end
            else if Copy(utemp, 1, 12) = 'REFERENCES: ' then
            begin
				This.Variants.SetString('references', Copy(temp, 13, Length(temp) - 12), This.Server);
                lastobj := This.Variants.GetObject('references');
            end
            else if Copy(utemp, 1, 10) = 'REPLY-TO: ' then
            begin
				This.Variants.SetString('replyTo', Copy(temp, 11, Length(temp) - 10), This.Server);
                lastobj := This.Variants.GetObject('replyTo');
            end

            //wb_̑
            else if (Copy(utemp, 1, 1) = #9) or (Copy(utemp, 1, 1) = ' ') then
            begin
            	if (lastobj <> nil) and (lastobj.Reference <> nil)
                	and (lastobj.Reference.ClassName = 'String') then
                begin
                	lastobj.Str_Data := lastobj.Str_Data + #13#10 + temp;
                end;
            end

            //sȃwb_
            else
            begin
            	if option <> '' then option := option + #13#10;
                option := option + temp;
                lastobj := nil;
            end;
        end;

		//IvVwb_Zbg
        This.Variants.SetString('option', option, This.Server);        
        list.Free;
    end;
end;

//******************************************************************************
// TJaFile -> File

constructor TJaFile.Create;
begin
    inherited Create;

    ClassName := 'File';
end;

destructor TJaFile.Destroy;
begin
    inherited Destroy;
end;

procedure TJaFile.CreateObject(This : TVirtualObject);
begin
    This.Str_Data := '';
    This.Variants.SetString('fileName', '', This.Server);
    This.Variants.SetString('contentId', '', This.Server);
end;

procedure TJaFile.FreeObject(This : TVirtualObject);
begin

end;

//*****************************************************************************
// TJaLinks -> Links

constructor TJaLinks.Create;
begin
    inherited Create;
    ClassName := 'Links';

    //\bhǉ
    AddFunction('matchText', matchText, 1);
    AddFunction('matchTextFirst', matchTextFirst, 1);
    AddFunction('matchUrl', matchUrl, 1);
    AddFunction('matchUrlFirst', matchUrlFirst, 1);
    AddFunction('getLink', getLink, 1);
    AddFunction('concat', concat, 1);

    //vpeB̒ǉ
    AddProperty('length', length);
end;

procedure TJaLinks.CreateObject(This : TVirtualObject);
var
    List : TNStringList;
begin
    List := TNStringList.Create;
    This.Data := List;
    List := TNStringList.Create;
    This.Data2 := List;
end;

procedure TJaLinks.FreeObject(This : TVirtualObject);
var
    Urls : TNStringList;
    Texts : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Urls.Free;
    Texts.Free;
end;

procedure TJaLinks.Add(This : TVirtualObject ; Url : String ; Text : String);
var
    Urls : TNStringList;
    Texts : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Urls.Add(Url);
    Texts.Add(Text);
end;

function TJaLinks.matchText(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    Pattern : String;
    Text : String;
    Link : String;
    Urls : TNStringList;
    Texts : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Pattern := ForceString(args[0]);
    Result := This.Server.PrepareInstance('Links');

    if Pattern = '' then Exit;
    if args[0].Reference = nil then Exit;

    if args[0].Reference.ClassName = 'RegExp' then
    begin
        //K\
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if TJaRegExp(args[0].Reference).RegExp.Exec(Text) then
                TJaLinks(Result.Reference).Add(Result, Link, Text);
        end;
    end
    else
    begin
        //ʂ̕
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if Pos(Pattern, Text) <> 0 then
                TJaLinks(Result.Reference).Add(Result, Link, Text);
        end;
    end;
end;

function TJaLinks.matchTextFirst(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    Pattern : String;
    Text : String;
    Link : String;
    Urls : TNStringList;
    Texts : TNStringList;
    List : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Pattern := ForceString(args[0]);

    if (Pattern = '') or (args[0].Reference = nil) then
    begin
        Result := This.Server.PrepareInstance('Undefined');
        Exit;
    end;

    if args[0].Reference.ClassName = 'RegExp' then
    begin
        //K\
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if TJaRegExp(args[0].Reference).RegExp.Exec(Text) then
            begin
                Result := This.Server.PrepareInstance('Link');
                List := Pointer(Result.Int_Data);
                List.Strings[23] := Link;
                List.Strings[24] := Text;
                Exit;
            end;
        end;
    end
    else
    begin
        //ʂ̕
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if Pos(Pattern, Text) <> 0 then
            begin
                Result := This.Server.PrepareInstance('Link');
                List := Pointer(Result.Int_Data);
                List.Strings[23] := Link;
                List.Strings[24] := Text;
                Exit;
            end;
        end;
    end;

    Result := This.Server.PrepareInstance('Undefined');
end;

function TJaLinks.matchUrl(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    Pattern : String;
    Text : String;
    Link : String;
    Urls : TNStringList;
    Texts : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Pattern := ForceString(args[0]);
    Result := This.Server.PrepareInstance('Links');

    if Pattern = '' then Exit;
    if args[0].Reference = nil then Exit;

    if args[0].Reference.ClassName = 'RegExp' then
    begin
        //K\
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if TJaRegExp(args[0].Reference).RegExp.Exec(Link) then
                TJaLinks(Result.Reference).Add(Result, Link, Text);
        end;
    end
    else
    begin
        //ʂ̕
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if Pos(Pattern, Link) <> 0 then
                TJaLinks(Result.Reference).Add(Result, Link, Text);
        end;
    end;
end;

function TJaLinks.matchUrlFirst(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    Pattern : String;
    Text : String;
    Link : String;
    Urls : TNStringList;
    Texts : TNStringList;
    List : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Pattern := ForceString(args[0]);

    if (Pattern = '') or (args[0].Reference = nil) then
    begin
        Result := This.Server.PrepareInstance('Undefined');
        Exit;
    end;

    if args[0].Reference.ClassName = 'RegExp' then
    begin
        //K\
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if TJaRegExp(args[0].Reference).RegExp.Exec(Link) then
            begin
                Result := This.Server.PrepareInstance('Link');
                List := Pointer(Result.Int_Data);
                List.Strings[23] := Link;
                List.Strings[24] := Text;
                Exit;
            end;
        end;
    end
    else
    begin
        //ʂ̕
        for n := 0 to Urls.Count - 1 do
        begin
            Link := Urls.Strings[n];
            Text := Texts.Strings[n];

            if Pos(Pattern, Link) <> 0 then
            begin
                Result := This.Server.PrepareInstance('Link');
                List := Pointer(Result.Int_Data);
                List.Strings[23] := Link;
                List.Strings[24] := Text;
                Exit;
            end;
        end;
    end;

    Result := This.Server.PrepareInstance('Undefined');
end;

function TJaLinks.getLink(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    Urls : TNStringList;
    Texts : TNStringList;
    Index : Integer;
    NaN : Boolean;
    List : TNStringList;
begin
    Urls := This.Data;
    Texts := This.Data2;
    Index := ForceInt(args[0], NaN);

    if (Index < 0) or (Index >= Texts.Count) then
    begin
        Result := MakeUndefined(This.Server);
        Exit;
    end;

    Result := This.Server.PrepareInstance('Link');
    List := Pointer(Result.Int_Data);
    List.Strings[23] := Urls.Strings[Index];
    List.Strings[24] := Texts.Strings[Index];
end;

function TJaLinks.length(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    Urls : TNStringList;
begin
    Urls := This.Data;
    Result := MakeInt(Urls.Count, This.Server);
end;

function TJaLinks.concat(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    Urls, Urls2 : TNStringList;
    Texts, Texts2 : TNStringList;
    n : Integer;
begin
    Result := MakeUndefined(This.Server);

    if (args[0].Reference = nil)
        or (args[0].Reference.ClassName <> 'Links') then
            Exit;

    Urls := This.Data;
    Texts := This.Data2;

    Urls2 := args[0].Data;
    Texts2 := args[0].Data2;

    for n := 0 to Urls2.Count - 1 do
    begin
        Urls.Add(Urls2.Strings[n]);
        Texts.Add(Texts2.Strings[n]);
    end;
end;

//******************************************************************************
// TJaMimes -> Mimes

constructor TJaMimes.Create;
begin
    inherited Create;
    ClassName := 'Mimes';

    //vpeB̒ǉ
    AddProperty('count', count);

    //\bh̒ǉ
    AddFunction('get', get, 1);
    AddFunction('save', save, 2);
    AddFunction('find', find, 1);
    AddFunction('delete', delete, 1);
    AddFunction('findHistory', findHistory, 1);
    AddFunction('saveHistory', saveHistory, 1);
end;

procedure TJaMimes.FreeObject(This : TVirtualObject);
var
    List : TNStringList;
begin
    List := Pointer(This.Data);
    List.Free;
end;

function TJaMimes.get(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
    Index : Integer;
    List : TNStringList;
    NaN : Boolean;
begin
    Index := ForceInt(args[0], NaN);
    List := Pointer(This.Data);

    if (Index < 0) or (Index >= List.Count) then
        Result := MakeUndefined(This.Server)
    else
    begin
        Result := This.Server.PrepareInstance('Mime');
        TJaMime(Result.Reference).LoadFile(This.Str_Data + List.Strings[Index]
                                            , Result);
    end;
end;

function TJaMimes.save(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    ID : String;
    Target : TVirtualObject;
begin
    Result := MakeUndefined(This.Server);
    ID := ForceString(args[0]);
    Target := args[1];

    if (Target.Reference = nil)
        or (Target.Reference.ClassName <> 'Mime') then Exit;

    TJaMime(Target.Reference).SaveFile(This.Str_Data
                        + GetCrc(ID + ID + ID) + '.eml', Target);
end;

function TJaMimes.find(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    ID : String;
    Index : Integer;
begin
    List := Pointer(This.Data);
    ID := ForceString(args[0]);
    Index := List.IndexOf(GetCrc(ID + ID + ID) + '.eml');
    Result := MakeBoolean(Index <> -1, This.Server);
end;

function TJaMimes.count(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := Pointer(This.Data);
    Result := MakeInt(List.Count, This.Server);
end;

function TJaMimes.delete(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    Index : Integer;
    NaN : Boolean;
begin
    Result := MakeUndefined(This.Server);
    List := Pointer(This.Data);
    Index := ForceInt(args[0], NaN);
    if (Index < 0) or (Index >= List.Count) then Exit;

    DeleteFile(PChar(This.Str_Data + List.Strings[Index]));
    List.Strings[Index] := '';
end;

function TJaMimes.findHistory(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    History : TNIntList;
    IDStr : String;
    Value : Integer;
    FileName : String;
begin
    //
    FileName := This.Str_Data + 'history.dat';
    History := TNIntList.Create;
    History.LoadFromFile(FileName);
    History.Reverse := True;

    //ID񂩂CRC擾
    IDStr := ForceString(args[0]);
    Value := GetCrcInt(IDStr);

    Result := MakeBoolean(History.IndexOf(Value) <> -1, This.Server);

    //ۑďI
    //History.SaveToFile(FileName);
    History.Free;
end;

function TJaMimes.saveHistory(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    History : TNIntList;
    IDStr : String;
    Value : Integer;
    FileName : String;
begin
    //
    FileName := This.Str_Data + 'history.dat';
    History := TNIntList.Create;
    History.LoadFromFile(FileName);
    History.Reverse := True;

    //ID񂩂CRC擾
    IDStr := ForceString(args[0]);
    Value := GetCrcInt(IDStr);

    Result := MakeUndefined(This.Server);

    //ǉ
    if History.IndexOf(Value) <> -1 then Exit;
    History.Add(Value);

    //ő1000ȉɂȂ܂ōڂ폜
    while History.Count > 1000 do
        History.Delete(0);

    //ۑďI
    History.SaveToFile(FileName);
    History.Free;
end;

function TJaMimes.setPath(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    if This.Data <> nil then
        TNStringList(This.Data).Free;

    Result := MakeUndefined(This.Server);
    This.Str_Data := ForceString(args[0]);
    List := SearchFile(This.Str_Data + '*.eml');
    This.Data := Pointer(List);
end;

//******************************************************************************
// TJaStringList -> StringList

constructor TJaStringList.Create;
begin
    inherited Create;
    ClassName := 'StringList';

    //vpeB̒ǉ
    AddProperty('length', length);
    AddProperty('count', count);
    AddProperty('text', text);

    //\bh̒ǉ
    AddFunction('StringList', Construct, 0);
    AddFunction('getLine', getLine, 1);
    AddFunction('setLine', setLine, 2);
    AddFunction('add', add, 1);
    AddFunction('delete', delete, 1);
    AddFunction('setText', setText, 1);
end;

procedure TJaStringList.CreateObject(This : TVirtualObject);
begin
    This.Data := TNStringList.Create;
end;

procedure TJaStringList.FreeObject(This : TVirtualObject);
begin
    TNStringList(This.Data).Free;
end;

function TJaStringList.Construct(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;

    if High(args) = 0 then
        List.Text := ForceString(args[0]);

    Result := MakeUndefined(This.Server);
end;

function TJaStringList.length(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeInt(System.Length(List.Text), This.Server);
end;

function TJaStringList.count(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeInt(List.Count, This.Server);
end;

function TJaStringList.getLine(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    Index : Integer;
    NaN : Boolean;
begin
    Index := ForceInt(args[0], NaN);
    List := This.Data;
    Result := MakeString(List.Strings[Index], This.Server);
end;

function TJaStringList.setLine(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    Index : Integer;
    NaN : Boolean;
begin
    List := This.Data;
    Index := ForceInt(args[0], NaN);
    List.Strings[Index] := ForceString(args[1]);
    Result := MakeUndefined(This.Server);
end;

function TJaStringList.add(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    n : Integer;
    List : TNStringList;
begin
    List := This.Data;

    for n := 0 to High(args) do
        List.Add(ForceString(args[n]));

    Result := MakeUndefined(This.Server);
end;

function TJaStringList.text(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    List := This.Data;
    Result := MakeString(List.Text, This.Server);
end;

function TJaStringList.delete(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
    NaN : Boolean;
    Index : Integer;
begin
    Result := MakeUndefined(This.Server);
    List := This.Data;
    if High(args) <> 0 then Exit;
    Index := ForceInt(args[0], NaN);
    if not NaN then List.Delete(Index);
end;

function TJaStringList.setText(args : array of TVirtualObject
                    ; This : TVirtualObject; Error : TErrors) : TVirtualObject;
var
    List : TNStringList;
begin
    Result := MakeUndefined(This.Server);
    if High(args) <> 0 then Exit;
    List := This.Data;
    List.Text := ForceString(args[0]);
end;

//******************************************************************************
// TJupiterRegistry - JupiterŃf[^ێ\ȃWXg

constructor TJupiterRegistry.Create;
begin
    Reg := TNStringList.Create;
end;

destructor TJupiterRegistry.Destroy;
begin
    Reg.Free;
    inherited;
end;

procedure TJupiterRegistry.LoadFromFile(const FileName : String);
begin
    if FileExists(FileName) then Reg.LoadFromFile(FileName);
end;

procedure TJupiterRegistry.SaveToFile(const FileName : String);
begin
    Reg.SaveToFile(FileName);
end;

function TJupiterRegistry.GetSetting(const Name : String) : String;
var
    n : Integer;
    ln : Integer;
    temp : String;
    Section : String;
begin
    Result := '';
    Section := Trim(Name);
    if Section = '' then Exit;

    Section := Section + '=';
    ln := Length(Section);

    for n := 0 to Reg.Count - 1 do
    begin
        temp := Reg.Strings[n];

        if Copy(temp, 1, ln) = Section then
        begin
            Result := Base64Decode(Copy(temp, ln + 1, Length(temp) - ln));
            Exit;
        end;
    end;
end;

procedure TJupiterRegistry.SaveSetting(const Name, Data : String);
var
    n : Integer;
    ln : Integer;
    temp : String;
    Section : String;
begin
    Section := Trim(Name);
    if Section = '' then Exit;

    Section := Section + '=';
    ln := Length(Section);

    for n := 0 to Reg.Count - 1 do
    begin
        temp := Reg.Strings[n];

        if Copy(temp, 1, ln) = Section then
        begin
            Reg.Strings[n] := Section + Base64Encode(Data);
            Exit;
        end;
    end;

    Reg.Add(Section + Base64Encode(Data));
end;

procedure TJupiterRegistry.Clear;
begin
    Reg.Clear;
end;

procedure TJupiterRegistry.Delete(const Name : String);
var
    n : Integer;
    ln : Integer;
    temp : String;
    Section : String;
begin
    Section := Trim(Name);
    if Section = '' then Exit;

    Section := Section + '=';
    ln := Length(Section);

    for n := 0 to Reg.Count - 1 do
    begin
        temp := Reg.Strings[n];

        if Copy(temp, 1, ln) = Section then
        begin
            Reg.Delete(n);
            Exit;
        end;
    end;
end;

//******************************************************************************

procedure SetUserAgent;
begin
    UAString := 'Jupiter/' + GetShortVersion;
end;

initialization
	SetUserAgent;

end.
