unit jp5_http;

interface

uses
    windows, tn_socket, tn_classes, tn_utils, tn_internet, tn_md5sup, tn_inet;

type
    PBoolean    =   ^Boolean;

    THttpInfo   =   record
        Method : String;    //Method
        URL : String;       //URL
        PostData : String;  //Option Data
        Host : String;      //Host Address
        Port : Integer;     //Host Port
        Proxy_Addr : String;
        Proxy_Port : Integer;
        Proxy_User : String;
        Proxy_Pass : String;
        Version : String;
        Path : String;
        Protocol : String;
        Header : String;
    end;

    TNCookie    =   class
        private
            Names : TNStringList;
            Datas : TNStringList;
            Paths : TNStringList;
            Expires : TNStringList;
            function DeletePort(URL : String) : String;
        public
            CookiePath : String;
            constructor Create;
            destructor Destroy; override;
            procedure Load;
            procedure SetCookie(Name : String ; Data : String ; Path : String ; Expire : String);
            procedure Clear;
            procedure Save;
            function GetCookie(URL : String) : String;
    end;

    TNhttp      =   class
        private
            Inet : TNInet;
            Buf : array [0..4095] of Char;
        public
            ExitFlag : PBoolean;
            ErrorNum : Integer;
            ErrorMsg : String;
            constructor Create;
            destructor Destroy; override;
            procedure Post(var Info : THttpInfo ; Cache : String ; Handle : THandle);
            procedure PostInet(var Info : THttpInfo ; Cache : String);
    end;

//procedure
    procedure DevideURL(URL : String; var Protocol : String ; var Host : String ; var Path : String ; var Port : Integer);
	function AnalyzeAuthHeader(const Method, URI, Data, User, Pass : String) : TRequest;
    //function GenerateAuthHeader(Method : String ; URI : String ; Data : String ; User : String ; Pass : String) : String;
    function GenerateAuthHeader(Data : TRequest) : String;
    function SplitRoot(URL : String) : String;
    function SplitCurrentDir(URL : String) : String;
    function SplitCurrentParent(URL : String) : String;
    function AbsoluteUrl(CurrentURL : String ; Relative : String) : String;
    function GetSingleFile(URL : String) : String;
    function UrlCheck(URL : String) : String;

implementation

uses
    jascript, jp5_main;

//******************************************************************************
//TNCookie

constructor TNCookie.Create;
begin
    Names := TNStringList.Create;
    Datas := TNStringList.Create;
    Paths := TNStringList.Create;
    Expires := TNStringList.Create;
end;

destructor TNCookie.Destroy;
begin
    Names.Free;
    Datas.Free;
    Paths.Free;
    Expires.Free;
end;

procedure TNCookie.Load;
begin
    if CookiePath <> '' then
    begin
        Names.LoadFromFile(CookiePath + 'c_name.txt');
        Datas.LoadFromFile(CookiePath + 'c_data.txt');
        Paths.LoadFromFile(CookiePath + 'c_path.txt');
        Expires.LoadFromFile(CookiePath + 'c_expires.txt');
    end;
end;

procedure TNCookie.SetCookie(Name : String ; Data : String ; Path : String ; Expire : String);
var
    n : Integer;
    CookDate : String;
    DeleteCook : Boolean;
begin
    DeleteCook := False;
    CookDate := Trim(Expire);

    if (CookDate <> '') and (DecodeGMTString(CookDate) < NowDateTime) then
    begin
        DeleteCook := True;
    end;

    for n := 0 to Names.Count - 1 do
    begin
        if (Names.Strings[n] = Name) and (Paths.Strings[n] = Path) then
        begin
            if DeleteCook then
            begin
                //Cookieׂč폜
                Names.Delete(n);
                Datas.Delete(n);
                Paths.Delete(n);
                Expires.Delete(n);
            end
            else
            begin
                //łɑ݂f[^㏑
                Datas.Strings[n] := Data;
                Expires.Strings[n] := Expire;
            end;

            Exit;
        end;
    end;

    //Vǉ
    Names.Add(Name);
    Datas.Add(Data);
    Paths.Add(Path);
    Expires.Add(Expire);
end;

procedure TNCookie.Clear;
begin
    Names.Clear;
    Datas.Clear;
    Paths.Clear;
    Expires.Clear;
end;

procedure TNCookie.Save;
begin
    if CookiePath <> '' then
    begin
        Names.SaveToFile(CookiePath + 'c_name.txt');
        Datas.SaveToFile(CookiePath + 'c_data.txt');
        Paths.SaveToFile(CookiePath + 'c_path.txt');
        Expires.SaveToFile(CookiePath + 'c_expires.txt');
    end;
end;

function TNCookie.GetCookie(URL : String) : String;
var
    n : Integer;
    m : Integer;
    Cook_Names : TNStringList;
    Cook_Datas : TNStringList;
    Cook_Paths : TNStringList;
    NowName : String;
    Dele : Boolean;
    Path : String;
    CookieUrl : String;
begin
    Result := '';
    Cook_Names := TNStringList.Create;
    Cook_Datas := TNStringList.Create;
    Cook_Paths := TNStringList.Create;

    CookieUrl := UrlCheck(URL);

    for n := 0 to Paths.Count - 1 do
    begin
        if Pos(UpperCase(Paths.Strings[n]), UpperCase(DeletePort(CookieUrl))) <> 0 then
        begin
            Cook_Names.Add(Names.Strings[n]);
            Cook_Datas.Add(Datas.Strings[n]);
            Cook_Paths.Add(Paths.Strings[n]);
        end;
    end;

    n := 0;

    while n < Cook_Names.Count do
    begin
        NowName := Cook_Names.Strings[n];
        Path := Cook_Paths.Strings[n];
        Dele := False;

        for m := n + 1 to Cook_Names.Count - 1 do
        begin
            if (NowName = Cook_Names.Strings[m])
                and (Length(Path) < Length(Cook_Paths.Strings[m])) then
            begin
                Dele := True;
                Break;
            end;
        end;

        if Dele then
        begin
            Cook_Names.Delete(n);
            Cook_Datas.Delete(n);
            Cook_Paths.Delete(n);
            Continue;
        end;

        n := n + 1;
    end;

    for n := 0 to Cook_Names.Count - 1 do
    begin
        if Result = '' then
            Result := 'Cookie: '
        else
            Result := Result + '; ';

        Result :=   Result  + Cook_Names.Strings[n] + '='
                        + Cook_Datas.Strings[n];
    end;

    Cook_Names.Free;
    Cook_Datas.Free;
    Cook_Paths.Free;
end;

function TNCookie.DeletePort(URL : String) : String;
var
    ps : Integer;
    temp : String;
begin
    Result := '';
    ps := Pos('//', URL);
    Result := Copy(URL, 1, ps + 1);
    temp := Copy(URL, ps + 2, Length(URL) - ps - 1);
    ps := Pos(':', temp);

    if ps = 0 then
        Result := URL
    else
    begin
        Result := Result + Copy(temp, 1, ps - 1);
        temp := Copy(temp, ps + 1, Length(temp) - ps);
        ps := Pos('/', temp);
        if ps = 0 then
            Result := Result + '/'
        else
            Result := Result + Copy(temp, ps, Length(temp) - ps + 1);
    end;
end;

//******************************************************************************
//TNhttp

constructor TNhttp.Create;
begin
    Inet := TNInet.Create;
    ExitFlag := nil;
end;

destructor TNhttp.Destroy;
begin
    Inet.Free;
    inherited Destroy;
end;

procedure TNhttp.Post(var Info : THttpInfo ; Cache : String ; Handle : THandle);
var
    Socket : TNSocket;
    temp : String;
    ps : Integer;
    RealSize : Integer;
    SizeChk : Integer;
    F : File;
    DLInfo : TDownLoadInfo;
begin
    Info.Header := '';
    ErrorNum := 0;
    Socket := TNSocket.Create;

    if Info.Proxy_Addr = '' then
    begin
        //Pattern1. i}ŃT[oɐڑ
        if not Socket.Connect(Info.Host, Info.Port) then
        begin
            Socket.Free;
            Exit;
        end;
    end
    else
    begin
        //Pattern2. vLVoRŃT[oɐڑ
        if not Socket.Connect(Info.Proxy_Addr, Info.Proxy_Port) then
        begin
            Socket.Free;
            Exit;
        end;
    end;

    //𑗐M
    Socket.SendString(Info.PostData);
    //Socket.BlockWrite(Info.PostData);
    //Socket.SendString(#13#10);

    //ŏ̍so
    temp := Trim(Socket.ReadLine);
    ps := Pos(' ', temp);
    Info.Header := temp + #13#10;

    if ps = 0 then
    begin
        Socket.Free;
        Exit;
    end;

    //G[ԍ擾
    temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    ps := Pos(' ', temp);

    if ps = 0 then
        ErrorNum := StrToInt(temp)
    else
    begin
        ErrorNum := StrToInt(Copy(temp, 1, ps - 1));

        //G[bZ[W擾
        ErrorMsg := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    end;

    //wb_擾
    temp := Socket.ReadLine;

    //DLInfoZbg
    DLInfo.Handle := Handle;
    DLInfo.Length := 0;
    DLInfo.Pos := 0;

    while Trim(temp) <> '' do
    begin
        Info.Header := Info.Header + temp;

        if UpperCase(Copy(temp, 1, 16)) = 'CONTENT-LENGTH: ' then
            DLInfo.Length := StrToInt(Trim(Copy(temp, 17, Length(temp) - 16)));

        temp := Socket.ReadLine;
    end;


    //LbVt@Ĉ݂߂ɊJ
    try
        AssignFile(F, Cache);
        ReWrite(F, 1);

        //ؒf܂Ńf[^擾
        RealSize := Socket.Read(@Buf, SizeOf(Buf));

        // <-eXg
        //if RealSize = -1 then
        //begin
        //    MessageBox(0, PChar(IntToStr(WSAGetLastError)), '', MB_ICONWARNING);
        //end;
        // ->

        while (Socket.SocketCheck) and (RealSize > 0) do
        begin
            if (ExitFlag <> nil) and (ExitFlag^) then Break;
            BlockWrite(F, Buf, RealSize, SizeChk);
            DLInfo.Pos := DLInfo.Pos + RealSize;
            SendMessage(TJupiterBoot(Pointer(Handle)).Handle
                            , WM_JPDOWNLOADING, Integer(@DLInfo), 0);

            if SizeChk <> RealSize then
            begin
                ErrorNum := 0;
                CloseFile(F);
                Socket.Close;
                Socket.Free;
                Exit;
            end;

            //Info.Source := Info.Source + Copy(Buf, 1, RealSize);
            RealSize := Socket.Read(@Buf, SizeOf(Buf));
        end;
    finally
        //LbVt@C
        CloseFile(F);
    end;

    SendMessage(TJupiterBoot(Pointer(Handle)).Handle
                            , WM_JPENDDL, Handle, 0);

    //\Pbg
    Socket.Close;
    Socket.Free;
end;

(*
procedure TNhttp.PostInet(var Info : THttpInfo ; Cache : String);
var
    OpenHandle : HINTERNET;
    ConHandle : HINTERNET;
    ReqHandle : HINTERNET;
    TimeOut : Integer;
    n : Integer;
    Flags : Cardinal;
    HeaderBuf : array [0..65535] of Char;
    Size : Cardinal;
    rs : Cardinal;
    ps : Integer;
    temp : String;
    Proxy : String;
    PostHeader : String;
    PostData : String;
    F : TextFile;
begin
    Info.Header := '';
    ErrorNum := 0;
    ErrorMsg := '';

    Inet.InternetAttemptConnect(0);

    if not InetLoaded then Exit;
    Proxy := Info.Proxy_Addr + ':' + IntToStr(Info.Proxy_Port);

    if Info.Proxy_Addr = '' then
        OpenHandle := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_DIRECT
                                                            , nil, nil, 0)
    else
        OpenHandle := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_PROXY
                                            , PChar(Proxy) , nil, 0);

    if OpenHandle = nil then Exit;

    //^CAEgݒ
    TimeOut := 60000;

    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONNECT_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT
                                                , @TimeOut, sizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_CONTROL_SEND_TIMEOUT
                                                , @TimeOut, sizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_DATA_SEND_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));
    Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_DATA_RECEIVE_TIMEOUT
                                                , @TimeOut, SizeOf(TimeOut));

    if Info.Proxy_User <> '' then
    begin
        Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_PROXY_USERNAME
                            , PChar(Info.Proxy_User)
                            , StrLen(PChar(Info.Proxy_User)));

        Inet.InternetSetOption(OpenHandle, INTERNET_OPTION_PROXY_PASSWORD
                            , PChar(Info.Proxy_Pass)
                            , StrLen(PChar(Info.Proxy_Pass)));
    end;

{
    ReqHandle := Inet.InternetOpenUrl(OpenHandle, PChar(Info.URL)
                                    , nil, 0, INTERNET_FLAG_RELOAD, 0);
}

    //ڑ
    for n := 1 to 5 do
    begin
        ConHandle := Inet.InternetConnect(OpenHandle, PChar(Info.Host)
                        , Info.Port , nil, nil, INTERNET_SERVICE_HTTP
                        , 0, 0);
        if ConHandle <> nil then Break;
    end;

    if ConHandle = nil then
    begin
        Inet.InternetCloseHandle(OpenHandle);
        Exit;
    end;

    Flags := INTERNET_FLAG_RELOAD or INTERNET_FLAG_HYPERLINK or
                INTERNET_FLAG_NO_UI or INTERNET_FLAG_NO_AUTO_REDIRECT;

    if Info.Protocol = 'https' then
    begin
        Flags := Flags or INTERNET_FLAG_SECURE
                    or INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;
    end;

    ReqHandle := Inet.HttpOpenRequest(ConHandle, PChar(Info.Method)
                                    , PChar(Info.Path), PChar(Info.Version)
                                        , nil, nil, Flags, 0);
    //|Xgf[^ēxo
    ps := Pos(#13#10, Info.PostData);
    PostHeader := Copy(Info.PostData, ps + 2, Length(Info.PostData) - ps - 1);
    ps := Pos(#13#10#13#10, PostHeader);
    PostData := Copy(PostHeader, ps + 4, Length(PostHeader) - ps - 3);
    PostHeader := Copy(PostHeader, 1, ps - 1);

    if not Inet.HttpSendRequest(ReqHandle, PChar(PostHeader)
        , Length(PostHeader), PChar(PostData), Length(PostData)) then
    begin
        Inet.InternetCloseHandle(ConHandle);
        Inet.InternetCloseHandle(ReqHandle);
        Inet.InternetCloseHandle(OpenHandle);
        Exit;
    end;

    Size := SizeOf(HeaderBuf);
    rs := 0;

    if not Inet.HttpQueryInfo(ReqHandle,
           HTTP_QUERY_RAW_HEADERS_CRLF,// or HTTP_QUERY_CUSTOM,
           @HeaderBuf, Size, rs) then Exit;

    //wb_o
    Info.Header := AdjustLineBreaks(Copy(HeaderBuf, 1, Size));
    ps := Pos(#13#10, Info.Header);
    temp := Trim(Copy(Info.Header, 1, ps - 1));
    ps := Pos(' ', temp);

    if ps <> 0 then
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));

    ps := Pos(' ', temp);

    if ps <> 0 then
    begin
        ErrorNum := StrToInt(Trim(Copy(temp, 1, ps - 1)));
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
    end;

    ErrorMsg := temp;

    //wb_݂̂ɂ
    ps := Pos(#13#10, Info.Header);
    Info.Header := Copy(Info.Header, ps + 2, Length(Info.Header) - ps - 1);

    //LbVt@Ĉ݂߂ɊJ
    AssignFile(F, Cache);
    ReWrite(F);

    //ؒf܂Ńf[^擾
    Size := 0;

    while (Inet.InternetReadFile(ReqHandle,@Buf,SizeOf(Buf),Size)) and (Size > 0) do
    begin
        //Info.Source := Info.Source + Copy(Buf, 1, Size);
        if (ExitFlag <> nil) and (ExitFlag^) then Break;
        Write(F, Copy(Buf, 1, Size));
    end;

    //LbVt@C
    CloseFile(F);

    //nhJ
    if ReqHandle <> nil then
        Inet.InternetCloseHandle(ReqHandle);

    if ConHandle <> nil then
        Inet.InternetCloseHandle(ConHandle);

    if OpenHandle <> nil then
        Inet.InternetCloseHandle(OpenHandle);
end;
*)

procedure TNhttp.PostInet(var Info : THttpInfo ; Cache : String);
var
    hConnect, hInt, hHttp : HINTERNET;
    flag, rs, size : DWORD;
    ps : Integer;
    PostHeader, PostData, proxy, temp : String;
    HeaderBuf : array [0..65535] of Char;
    F : TextFile;
label
    _EXIT;
begin
	hConnect := nil;
    hHttp := nil;

    proxy := Info.Proxy_Addr + ':' + IntToStr(Info.Proxy_Port);

    if Info.Proxy_Addr = '' then
	begin
		hInt := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_PROXY
                                    , PChar(proxy)
                                    , nil
                                    , 0);
	end
	else
	begin
		hInt := Inet.InternetOpen(nil, INTERNET_OPEN_TYPE_PRECONFIG
                                    , nil
                                    , nil
                                    , 0);
	end;

    if hInt = nil then goto _EXIT;

	hConnect := Inet.InternetConnect(hInt
                                    , PChar(Info.Host)
                                    , Info.Port
                                    , nil
                                    , nil
                                    , INTERNET_SERVICE_HTTP
                                    , 0
                                    , 0);

    if hConnect = nil then goto _EXIT;

    flag := INTERNET_FLAG_RELOAD or INTERNET_FLAG_NO_AUTO_REDIRECT;

    if Info.Protocol = 'https' then
    begin
        flag := flag
                or INTERNET_FLAG_SECURE
                or INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;
    end;

	hHttp := Inet.HttpOpenRequest(hConnect
                                    , PChar(Info.Method)
                                    , PChar(Info.Path)
                                    , PChar(Info.Version)
                                    , nil
                                    , nil
				                    , flag
                                    , 0);

    if hHttp = nil then goto _EXIT;
    if Info.Proxy_User <> '' then
    begin
    	Inet.InternetSetOption(hHttp, INTERNET_OPTION_PROXY_USERNAME
                            , PChar(Info.Proxy_User)
                            , Length(Info.Proxy_User));

	    Inet.InternetSetOption(hHttp, INTERNET_OPTION_PROXY_PASSWORD
                            , PChar(Info.Proxy_Pass)
                            , Length(Info.Proxy_Pass));
    end;

    //|Xgf[^ēxo
    ps := Pos(#13#10, Info.PostData);
    PostHeader := Copy(Info.PostData, ps + 2, Length(Info.PostData) - ps - 1);
    ps := Pos(#13#10#13#10, PostHeader);
    PostData := Copy(PostHeader, ps + 4, Length(PostHeader) - ps - 3);
    PostHeader := Copy(PostHeader, 1, ps - 1);

    if not Inet.HttpSendRequest(hHttp, PChar(PostHeader)
                                , Length(PostHeader)
                                , PChar(PostData)
                                , Length(PostData)) then goto _EXIT;

    size := SizeOf(HeaderBuf);
    rs := 0;

    if not Inet.HttpQueryInfo(hHttp
                    , HTTP_QUERY_RAW_HEADERS_CRLF
                    , @HeaderBuf, size, rs) then goto _EXIT;

    //wb_o
    Info.Header := AdjustLineBreaks(Copy(HeaderBuf, 1, size));
    ps := Pos(#13#10, Info.Header);
    temp := Trim(Copy(Info.Header, 1, ps - 1));
    ps := Pos(' ', temp);

    if ps <> 0 then
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));

    ps := Pos(' ', temp);

    if ps <> 0 then
    begin
        ErrorNum := StrToInt(Trim(Copy(temp, 1, ps - 1)));
        temp := Trim(Copy(temp, ps + 1, Length(temp) - ps));
        ErrorMsg := temp;
    end
    else
    begin
        ErrorNum := StrToInt(temp);
        ErrorMsg := '';
    end;


    //wb_݂̂ɂ
    ps := Pos(#13#10, Info.Header);
    Info.Header := Copy(Info.Header, ps + 2, Length(Info.Header) - ps - 1);

    //LbVt@Ĉ݂߂ɊJ
    AssignFile(f, Cache);
    ReWrite(f);

    //ؒf܂Ńf[^擾
    size := 0;

    while (Inet.InternetReadFile(hHttp,@Buf,SizeOf(Buf),size)) and (size > 0) do
    begin
        if (ExitFlag <> nil) and (ExitFlag^) then Break;
        Write(f, Copy(Buf, 1, size));
    end;

    //LbVt@C
    CloseFile(f);

_EXIT:
	if hConnect <> nil then Inet.InternetCloseHandle(hConnect);
    if hInt <> nil then Inet.InternetCloseHandle(hInt);
    if hHttp <> nil then Inet.InternetCloseHandle(hHttp);
end;

//******************************************************************************
//Procedures

procedure DevideURL(URL : String; var Protocol : String ; var Host : String
                                    ; var Path : String ; var Port : Integer);
var
    ps : Integer;
    temp : String;
begin
    //vgR擾
    ps := Pos('://', URL);
    if ps = 0 then Exit;
    Protocol := Copy(URL, 1, ps - 1);

    //vgRȊO̕擾
    temp := Copy(URL, ps + 3, Length(URL) - ps - 1);

    //zXg擾
    ps := Pos('/', temp);
    Host := Copy(temp, 1, ps - 1);
    Port := 0;

    if ps = 0 then
    begin
        Path := '/';
    end
    else
    begin
        Host := Copy(temp, 1, ps - 1);
        Path := Copy(temp, ps, Length(temp) - ps + 1);
    end;

    //ڑ|[g擾
    ps := Pos(':', Host);

    if ps <> 0 then
    begin
        Port := StrToInt(Copy(Host, ps + 1, Length(Host) - ps));
        Host := Copy(Host, 1, ps - 1);
    end;

    if Port = 0 then
    begin
        if Protocol = 'ftp' then
            Port := INTERNET_DEFAULT_FTP_PORT
        else if Protocol = 'http' then
            Port := INTERNET_DEFAULT_HTTP_PORT
        else if Protocol = 'https' then
            Port := INTERNET_DEFAULT_HTTPS_PORT;
    end;
end;

function AnalyzeAuthHeader(const Method, URI, Data, User, Pass : String) : TRequest;
var
    temp : String;
    stemp : String;
    ttemp : String;
    ps : Integer;
    Ln : Integer;
    n : Integer;
    Src : PChar;
    ch : Char;
    QuotType : TQuoteType;
    List : TNStringList;
begin
    List := TNStringList.Create;
    List.Text := Trim(Data);

    for n := 0 to List.Count - 1 do
    begin
        temp := List.Strings[n];

        if UpperCase(Copy(temp, 1, 5)) = 'BASIC' then
        begin
            //BASICF
            Result.Algorithm := 'Basic';
            Break;
        end
        else if UpperCase(Copy(temp, 1, 6)) = 'DIGEST' then
        begin
            //DIGESTF
            temp := Copy(temp, 7, Length(temp) - 6);

            //
            Ln := Length(temp);
            Src := PChar(temp);
            stemp := UpperCase(temp);
            Result.Algorithm := 'MD5';
            Result.Method := Method;
            Result.Pass := Pass;
            Result.User := User;
            Result.URI := URI;

            //realm
            ps := Pos('REALM=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 5;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;

                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Result.Realm := ttemp;
            end;

            //nonce
            ps := Pos('NONCE=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 5;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;

                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Result.Nonce := ttemp;
            end;

            //qop
            ps := Pos('QOP=', stemp);

            if ps <> 0 then
            begin
                ps := ps + 3;
                ttemp := '';
                QuotType := qtNone;

                while ps < Ln do
                begin
                    ch := (Src + ps)^;

                    case ch of
                        ';', ' ', ',':
                            begin
                                if QuotType = qtNone then
                                    Break;
                            end;

                        '"':
                            begin
                                if QuotType = qtNone then
                                    QuotType := qtDouble
                                else if QuotType = qtDouble then
                                    QuotType := qtNone;
                            end;
                    end;

                    ps := ps + 1;
                    ttemp := ttemp + ch;
                end;

                ttemp := Trim(ttemp);

                if ttemp <> '' then
                begin
                    if ttemp[1] = '"' then
                        ttemp := Copy(ttemp, 2, Length(ttemp) - 2);
                end;

                Result.Qop := ttemp;
            end;

            Break;
        end;
    end;

    List.Free;
end;

function GenerateAuthHeader(Data : TRequest) : String;
begin
	Result := '';

	if Data.Algorithm = 'Basic' then
    	Result := 'Authorization: Basic '
        			+ Base64Encode(Data.User + ':' + Data.Pass)
    else if Data.Algorithm = 'MD5' then
    	Result := Digest_Response(Data)
    else
    	Exit;
end;

function SplitRoot(URL : String) : String;
var
    Src : PChar;
    ch : Char;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    Src := PChar(URL);
    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        Result := Copy(URL, 1, ps + 1);
        Index := ps + 1;

        while Index < Length(URL) do
        begin
            ch := (Src + Index)^;

            if ch = '/' then
                Break
            else
                Result := Result + ch;

            Index := Index + 1;
        end;
    end;
end;

function SplitCurrentDir(URL : String) : String;
var
    Src : PChar;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    Src := PChar(URL);
    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        Index := Length(URL) - 1;

        while Index > ps do
        begin
            if (Src + Index)^ = '/' then
                Break;

            Index := Index - 1;
        end;

        Result := Copy(URL, 1, Index + 1);
    end;
end;

function SplitCurrentParent(URL : String) : String;
var
    NewUrl : String;
    Src : PChar;
    ps : Integer;
    Index : Integer;
begin
    Result := '';
    NewUrl := SplitCurrentDir(URL);

    if NewUrl = '' then Exit;
    if NewUrl[Length(NewUrl)] <> '/' then Exit;

    NewUrl := Copy(NewUrl, 1, Length(NewUrl) - 1);
    Src := PChar(NewUrl);
    ps := Pos('//', NewUrl);
    Index := Length(NewUrl) - 1;

    while Index > ps do
    begin
        if (Src + Index)^ = '/' then
            Break;

        Index := Index - 1;
    end;

    Result := Copy(NewUrl, 1, Index + 1);
end;

function AbsoluteUrl(CurrentURL : String ; Relative : String) : String;
var
    CurrentDir : String;
    ParentDir : String;
    RootDir : String;
begin
    if Pos('//', Relative) <> 0 then
    begin
        Result := Relative;
        Exit;
    end;

    Result := '';
    if Relative = '' then Exit;

    CurrentDir := SplitCurrentDir(CurrentURL);
    ParentDir := SplitCurrentParent(CurrentURL);
    RootDir := SplitRoot(CurrentURL);

    if Copy(Relative, 1, 2) = './' then
        Result := CurrentDir + Copy(Relative, 3, Length(Relative) - 2)
    else if Copy(Relative, 1, 3) = '../' then
        Result := CurrentDir + Copy(Relative, 3, Length(Relative) - 2)
    else if Relative[1] = '/' then
//        Result := RootDir + Copy(Relative, 2, Length(Relative) - 1)
        Result := RootDir + Relative
    else
        Result := CurrentDir + Relative;
end;

function GetSingleFile(URL : String) : String;
var
    Index : Integer;
    temp : String;
    n : Integer;
begin
    Result := '';
    temp := URL;
    Index := Pos('?', temp);

    if Index <> 0 then
        temp := Copy(temp, 1, Index - 1);

    for n := Length(temp) downto 1 do
    begin
        if temp[n] = '/' then
        begin
            Result := Copy(temp, n + 1, Length(temp) - n);
            Break;
        end;
    end;

    if Result = '' then
        Result := 'index.htm';
end;

function UrlCheck(URL : String) : String;
var
    ps : Integer;
    temp : String;
begin
    Result := URL;

    ps := Pos('//', URL);

    if ps <> 0 then
    begin
        temp := Copy(URL, ps + 2, Length(URL) - ps - 1);

        if Pos('/', temp) = 0 then
            Result := Result + '/';
    end;
end;

end.
