unit jascript;

interface

uses
    windows, tn_classes, tn_utils, ja_embed;

type
    //ECMAɏJavaScript[eB
    //G[R[h 10000ȍ~͂̃VXeŗL̃G[

    TQuoteType  =   (qtNone, qtSingle, qtDouble);
    TCalcType   =   (ctNone, ctAnd, ctOr, ctNot, ctBitAnd, ctBitOr, ctBitNot
                        , ctBitXor, ctAdd, ctSub, ctMul, ctDiv, ctMod);

    TJaRuntime  =   class;
    TScriptFile =   class;

    TScriptCall =   record
        Parent : TVirtualObject;    //̃R[hێĂNX
        Code : PChar;               //R[h{
        Index : Integer;            //̈ʒu
        Length : Integer;           //̒
        Vars : TVariantList;        //ϐXg
        Return : TVirtualObject;    //߂l
        BreakLevel : Integer;       //u[Nx(0ł̓u[N͎sȂ)
        Continued : Boolean;        //̃[v֓˓
        Exception : Boolean;        //vIG[
        Switch : TVirtualObject;
        WithState : TVirtualObject; //With̃^[QbgIuWFNg
    end;

    TScriptFile =   class
        private
            Parent : TObject;
            ScriptFile : String;
            Source : String;
            Includes : array of TScriptFile;
            Count : Integer;
            Error : TErrors;
            function DeleteComment(const Source : String) : String;
            function FindDefine(const Source : String) : String;
            function Compile : Boolean;
            procedure CompileError(ErrorNumber : Integer ; LineNum : Integer ; Mes : String);
            function LoadFromFile(FileName : String) : Boolean;
            procedure AddInclude(FileName : String);
            function FindClass(Name : String) : TJaObject;
        public
            ObjectServer : TObjectServer;
            constructor Create(Err : TErrors);
            destructor Destroy; override;
    end;

    TScript     =   class
        private
            Count : Integer;
            LibPath : String;
            CurrentPath : String;
            StartFile : String;
            function AddInclude(FileName : String) : TScriptFile;
            procedure Clear;
        protected
            Plugin : TPluginLoader;
            procedure ExecuteTerm(Sender : TObject);
        public
            Error : TErrors;
            Scripts : array of TScriptFile;
            Handle : THandle;
            Runtime : TJaRuntime;
            StructStr : String;
            ErrorStr : String;
            DustBox : TNIntList;
            Compiled : Boolean;
            constructor Create(ScriptFile : String);
            destructor Destroy; override;
            procedure Compile;
            function GetStruct : String;
            function GetCompileError : String;
            function Run(Sync : Boolean) : Boolean; virtual;
    end;

    TJaRuntime  =   class(TNThread)
        private
            Error : TErrors;
            Globals : array of TVirtualObject;
            MathObj : TJaObject;
            function ValueResolve(var Inf : TScriptCall ; This : TVirtualObject ; Data : String ; EnterValue : TVirtualObject ; AsPointer : Boolean) : TVirtualObject;
            function DivideParam(const Data : String) : TNStringList;
            function ToObject(var Inf : TScriptCall ; const Data : String) : TVirtualObject;
            procedure Inc_Exec(Index : Integer);
            procedure ExecOption;
            procedure Run_IncFile(Name : String);
            function MakeInstance(var Inf : TScriptCall ; Name : String) : TVirtualObject;
            procedure ForStatement(var Inf : TScriptCall);
            procedure WhileStatement(var Inf : TScriptCall);
            procedure IfStatement(var Inf : TScriptCall);
            function GetOneStatement(var Inf : TScriptCall) : String;
            function SkipNonsenseChar(var Inf : TScriptCall) : String;
            function GetSingleWord (var Inf : TScriptCall) : String;
            function GetWide(var Inf : TScriptCall) : String;
            function GetSmall(var Inf : TScriptCall) : String;
            procedure SwitchStatement(var Inf : TScriptCall);
            procedure WithStatement(var Inf : TScriptCall);
            function GetStringUntil(var Inf : TScriptCall ; FindChar : Char) : String;
            procedure Quit;
        protected
            Script : TScript;
            Variants : TVariantList;
        public
            ExitFlag : Boolean;
            OptionCode : String;
            Priority : Integer;
            constructor Create(CompiledScript : TScript);
            destructor Destroy; override;
            procedure Execute; override;
            procedure Run(var Inf : TScriptCall);
    end;

const
    WM_JPTERMINATE  =   8000;
    SYNTAX_ERR      =   10001;
    LINK_ERR        =   10002;

implementation

//******************************************************************************
//TScriptFile

constructor TScriptFile.Create(Err : TErrors);
begin
    Count := 0;
    ObjectServer := TObjectServer.Create;
    Error := Err;
end;

destructor TScriptFile.Destroy;
begin
    ObjectServer.Free;
    inherited Destroy;
end;

function TScriptFile.DeleteComment(const Source : String) : String;
var
    n : Integer;
    LineNum : Integer;
    temp : String;
    PSource : PChar;
    ch : Char;
    QuotType : TQuoteType;
    BackSlash : Boolean;

    procedure SkipComment_Type1(var Index : Integer);
    var
        ps : Integer;
    begin
        ps := Pos(#13#10, String(PChar(PSource + Index)));

        if ps = 0 then
            ps := Length(Source) + Index + 1
        else
            LineNum := LineNum + 1;

        Index := Index + ps;
    end;

    function SkipComment_Type2(var Index : Integer) : Boolean;
    var
        n : Integer;
        ps : Integer;
    begin
        ps := Pos('*/', String(PChar(PSource + Index)));
        Result := True;

        if ps = 0 then
        begin
            ps := Length(Source) + Index + 1;
            Result := False;
        end
        else
        begin
            for n := Index to Index + ps do
            begin
                if PChar(PSource + n)^ = #13 then
                begin
                    temp := temp + #13#10;
                    LineNum := LineNum + 1;
                end;
            end;
        end;

        Index := Index + ps;
    end;

begin
    //Rg폜
    n := 0;
    temp := '';
    Result := '';
    LineNum := 1;
    QuotType := qtNone;
    BackSlash := False;
    PSource := PChar(Source);

    while n < Length(Source) do
    begin
        ch := PChar(PSource + n)^;

        if BackSlash then
        begin
            n := n + 1;
            temp := temp + ch;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '/':
                begin
                    if QuotType <> qtNone then
                    begin
                        n := n + 1;
                        temp := temp + ch;
                        Continue;
                    end;

                    n := n + 1;
                    ch := PChar(PSource + n)^;
                    n := n + 1;

                    if ch = '/' then
                    begin
                        SkipComment_Type1(n);
                        temp := temp + #13#10;
                    end
                    else if ch = '*' then
                    begin
                        if not SkipComment_Type2(n) then
                        begin
                            CompileError(SYNTAX_ERR, LineNum,'RgIĂ܂.');
                        end;
                    end
                    else
                    begin
                        temp := temp + '/' + ch;
                        Continue;
                        //CompileError(SYNTAX_ERR, LineNum,'sȕ : "' + ch +  '"');
                        //SkipComment_Type1(n);
                    end;
                end;

            #13:
                begin
                    if QuotType <> qtNone then
                    begin
                        CompileError(SYNTAX_ERR, LineNum,'񂪕Ă܂.');
                        QuotType := qtNone;
                    end;

                    LineNum := LineNum + 1;
                    temp := temp + #13;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (ByteType(Source, n + 1) = btSingle) and (QuotType <> qtNone) then
                        BackSlash := True;

                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    Result := temp;
end;

function TScriptFile.FindDefine(const Source : String) : String;
var
    n : Integer;
    LineNum : Integer;
    PSource : PChar;
    ch : Char;
    QuotType : Integer;
    BackSlash : Boolean;
    Step : Integer;
    CSource : String;
    NewSource : String;
    temp : String;
    stemp : String;
    GlobalObj : TJaObject;

    function AddVariant(var Index : Integer ; var Lines : Integer; Dest : TBaseObject) : Boolean;
    var
        ID : String;
        Quot : Boolean;
        SQuot : Boolean;
    begin
        Result := False;
		temp := '';
		//Index := Index + 1;

		while Index < Length(CSource) do
		begin
			ch := PChar(PSource + Index)^;

			case ch of
				',', ';':
					begin
						temp := Trim(temp);

						if temp = '' then
						begin
							CompileError(SYNTAX_ERR, Index
								, 'Syntax Error. Identifer was not found.');
							Exit;
						end;

						if Dest.Variants.IndexOf(temp) = -1 then
							Dest.Variants.Add(temp)
						else
						begin
							CompileError(SYNTAX_ERR, Index
								, 'Syntax Error. Identifer was overlapped.');
							Exit;
						end;

						temp := '';
						//Index := Index + 1;

						if ch = ';' then Break;
					end;

				'=':
					begin
						temp := Trim(temp);

						if temp = '' then
						begin
							CompileError(SYNTAX_ERR, Index
								, 'Syntax Error. Invalid identifer.');
							Exit;
						end;

						ID := temp;
						Index := Index + 1;
						Quot := False;
						SQuot := False;
						BackSlash := False;

						if Dest.Variants.IndexOf(temp) = -1 then
							Dest.Variants.Add(temp)
						else
						begin
							CompileError(SYNTAX_ERR, Index
								, 'Syntax Error. Invalid identifer.');
							Exit;
						end;

						temp := '';

						while Index < Length(CSource) do
						begin
							ch := PChar(PSource + Index)^;

							if BackSlash then
							begin
								temp := temp + ch;
								Index := Index + 1;
								BackSlash := False;
								Continue;
							end;

							case ch of
								'"':
									begin
										Quot := not Quot;
										temp := temp + ch;
									end;

								'''':
									begin
										SQuot := not SQuot;
										temp := temp + ch;
									end;

								'\':
									begin
										if (not Quot) and (not SQuot) and
                                            (ByteType(CSource, Index + 1) = btSingle) then
										begin
											CompileError(SYNTAX_ERR, Index
												, 'Syntax Error. Invalid character.');
											Exit;
										end;

										if ByteType(CSource, Index + 1) = btSingle then
										BackSlash := True;

										temp := temp + ch;
									end;

								'*', '/', '-', '%', '$', '#', '!', '|'
									, '=', '<', '>', '?', '@', ':', '~'
										, '[', ']', '}':
									begin
										if (not Quot) and (not SQuot) then
										begin
											CompileError(SYNTAX_ERR, Index
												, 'Syntax Error. Invalid character.');
											Exit;
										end
										else
											temp := temp + ch;
									end;

								';', ',':
									begin
										if (not Quot) and (not SQuot) then
										begin
											temp := Trim(temp);
											//R[hɒǉ
											Dest.PreCode := Dest.PreCode
														+ ID + '=' + temp + ';' + #13#10;
                                            temp := '';
                                            Index := Index + 1;
											Break;
										end
										else
											temp := temp + ch;
									end;

                                #13:
                                    begin
                                        Lines := Lines + 1;
                                        NewSource := NewSource + #13#10;
                                    end;

                                #10:
                                    begin
                                    end;

								else
									temp := temp + ch;
							end;

							Index := Index + 1;
						end;

                        if ch = ';' then Break;
					end;

                '*', '/', '-', '%', '$', '#', '!', '|'
                    , '<', '>', '?', '@', ':', '~', '['
                        , ']', '}', '''' , '"':
                    begin
                        CompileError(SYNTAX_ERR, Index
                                        , 'Syntax Error. Invalid character.');
                        Exit;
                    end;

                #13:
                    begin
                        Lines := Lines + 1;
                        NewSource := NewSource + #13#10;
                        temp := temp + ch;
                    end;

                #10:
                    begin
                        temp := temp + ch;
                    end;

				else
					temp := temp + ch;
			end;

			Index := Index + 1;
		end;
    end;

    function AddFunction(var Index : Integer; var Lines : Integer; Dest : TJaObject) : Boolean;
    var
        m : Integer;
        temp : String;
        Name : String;
        Param : String;
        ch : Char;
        BackSlash : Boolean;
        QuotType : Integer;
        Step : Integer;
        FSource : String;
        NewFunc : TFunction;
    begin
        Result := False;
        temp := '';

        //֐EƂ
        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            case ch of
                '(':
                    begin
                        Name := Trim(temp);
                        temp := '';
                        n := n + 1;

                        while Index < Length(CSource) do
                        begin
                            ch := PChar(PSource + Index)^;

                            case ch of
                                ')':
                                    begin
                                        Param := temp;
                                        break;
                                    end;

                                '(', ';', '{', '}', '*', '/', '-', '+'
                                    , '\', '%', '$', '#', '"', '''', '!'
                                        , '.', '|', '=', '<', '>', '?', '@'
                                            , ':', '~', '[', ']':
                                    begin
                                        CompileError(SYNTAX_ERR, Lines
                                                    , 'Syntax Error. Invalid Character "' + ch +  '".');
                                    end;

                                #13:
                                    begin
                                        NewSource := NewSource + #13#10;
                                        Lines := Lines + 1;
                                    end;

                                #9, ' ':
                                    begin
                                    end;

                                else
                                    begin
                                        temp := temp + ch;
                                    end;
                            end;

                            Index := Index + 1;
                        end;

                        break;
                    end;

                ';', '*', '/', '-', '+', '\', '%', '$'
                    , '#', '"', '''', '!', '.', '|', '='
                        , '<', '>', '?', '@', ':', '['
                            , ']', '{', '}':
                    begin
                        CompileError(SYNTAX_ERR, Lines
                            , 'Syntax Error. Invalid Character "' + ch +  '".');
                    end;

                #13:
                    begin
                        Lines := Lines + 1;
                        NewSource := NewSource + #13#10;
                    end;

                #9, #10, ' ':
                    begin
                    end;
                    
                else
                    temp := temp + ch;
            end;

            Index := Index + 1;
        end;

        n  := n + 1;

        // )...{ ܂łXL
        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            case ch of
                '{':
                    begin
                        break;
                    end;

                #13:
                    begin
                        Lines := Lines + 1;
                        NewSource := NewSource + #13#10;
                    end;

                #9, #10, ' ':
                    begin
                    end;

                else
                    begin
                        CompileError(SYNTAX_ERR, Lines
                            , 'Syntax Error. Invalid Character "' + ch +  '".');
                    end;
            end;

            Index := Index + 1;
        end;

        temp := '';
        BackSlash := False;
        QuotType := 0;
        Step := 1;
        FSource := '';
        NewFunc := TFunction.Create;
        Dest.Functions.Add(NewFunc);
        NewFunc.Name := Name;
        NewFunc.MaxParam := 0;
        NewFunc.Line := Lines;
        Index := Index + 1;

        //̐ݒ
        for m := 1 to Length(Param) do
        begin
            ch := Param[m];

            case ch of
                ',':
                    begin
                        temp := Trim(temp);

                        if temp = '' then
                        begin
                            CompileError(SYNTAX_ERR, Lines
                                            , 'Syntax Error. Identifer was not found.');

                            break;
                        end
                        else
                        begin
                            if NewFunc.Variants.IndexOf(temp) = -1 then
                            begin
                                NewFunc.Variants.Add(temp);
                                NewFunc.MaxParam := NewFunc.MaxParam + 1;
                            end
                            else
                            begin
                                CompileError(SYNTAX_ERR, Lines
                                                , 'Syntax Error. Identifer is duplicated.');

                                Exit;
                            end;
                            temp := '';
                        end;
                    end;

                #13:
                    begin
                        Lines := Lines + 1;
                        NewSource := NewSource + #13#10;
                    end;

                #9, #10, ' ':
                    begin
                    end;
                    
                else
                    temp := temp + ch;
            end;
        end;

        if temp <> '' then
        begin
            temp := Trim(temp);

            if NewFunc.Variants.IndexOf(temp) = -1 then
            begin
                NewFunc.Variants.Add(temp);
                NewFunc.MaxParam := NewFunc.MaxParam + 1;
            end
            else
            begin
                CompileError(SYNTAX_ERR, Lines
                                , 'Syntax Error. Identifer is duplicated.');

                Exit;
            end;
        end;

        temp := '';

        //function̓eo
        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            if BackSlash then
            begin
                Index := Index + 1;
                temp := temp + ch;
                BackSlash := False;
                Continue;
            end;

            case ch of
                '{':
                    begin
                        if QuotType = 0 then
                            Step := Step + 1;

                        temp := temp + ch;
                    end;

                '}':
                    begin
                        if QuotType = 0 then
                            Step := Step - 1;

                        //functioneo
                        if Step = 0 then
                        begin
                            FSource := FSource + temp;
                            temp := '';
                            Index := Index + 1;
                            Result := True;
                            NewFunc.Code := FSource;
                            Exit;
                        end
                        else
                            temp := temp + ch;
                    end;

                #13:
                    begin
                        Lines := Lines + 1;
                        NewSource := NewSource + #13#10;
                        QuotType := 0;

                        if Trim(temp) = 'var' then
                        begin
                            Index := Index + 1;
                            AddVariant(Index, Lines, NewFunc);
                            FSource := FSource + #13#10;
                            temp := '';
                        end
                        else
                            temp := temp + #13#10;
                    end;

                #10:
                    begin
                    end;

                #9, ' ':
                    begin
                        if Trim(temp) = 'var' then
                        begin
                            Index := Index + 1;
                            AddVariant(Index, Lines, NewFunc);
                            temp := '';
                        end
                        else
                            temp := temp + ch;
                    end;

                ';':
                    begin
                        FSource := FSource + temp + ch;
                        temp := '';
                        Index := Index + 1;
                        Continue;
                    end;

                '"':
                    begin
                        if QuotType = 0 then
                            QuotType := 1
                        else if QuotType = 1 then
                            QuotType := 0;

                        temp := temp + ch;
                    end;

                '''':
                    begin
                        if QuotType = 0 then
                            QuotType := 2
                        else if QuotType = 2 then
                            QuotType := 0;

                        temp := temp + ch;
                    end;

                '\':
                    begin
                        if (ByteType(CSource, n + 1) = btSingle)
                                            and (QuotType <> 0) then
                            BackSlash := True;

                        temp := temp + ch;
                    end;

                else
                    temp := temp + ch;
            end;

            Index := Index + 1;
        end;
    end;

    function AddIncludeFile(var Index : Integer; var Lines : Integer) : Boolean;
    var
        ch : Char;
        temp : String;
        AddFile : String;
    begin
        Result := False;
        n := Index;
        temp := '';

        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            if ch = #13 then
            begin
                Lines := Lines + 1;
                Break;
            end
            else
                temp := temp + ch;

            Index := Index + 1;
        end;

        Index := Index + 2;
        temp := Trim(temp);
        temp := Replace(temp, '"', '');
        temp := Replace(temp, '<', '');
        temp := Replace(temp, '>', '');

        if Pos(';', temp) <> 0 then
        begin
            CompileError(LINK_ERR, Lines, 'Include file''s name can''t include ";".');
            Exit;
        end;

        if FileExists(TScript(Parent).LibPath + temp) then
            AddFile := TScript(Parent).LibPath + temp
        else if FileExists(TScript(Parent).CurrentPath + temp) then
            AddFile := TScript(Parent).CurrentPath + temp
        else
        begin
            CompileError(LINK_ERR, Lines, '"' + temp + '"was not found ');
            Exit;
        end;

        AddInclude(AddFile);
        NewSource := NewSource + 'linkto ' + AddFile + ';' + #13#10;
        Result := True;
    end;

    function AddClass(var Index : Integer; var Lines : Integer) : Boolean;
    var
        temp : String;
        ch : Char;
        NewObject : TJaObject;
        ObjParent : TJaObject;
        Props : TNStringList;
        StartPoint : Integer;
    begin
        //NXo
        NewObject := nil;
        temp := '';
        StartPoint := Index;

        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            case ch of
                '{':
                    begin
                        temp := Trim(temp);
                        Index := Index + 1;
                        Break;
                    end;
                #13:
                    begin
                        NewSource := NewSource + #13#10;
                        temp := temp + #13#10;
                        Lines := Lines + 1;
                    end;

                #10:
                    begin
                    end;

                ';', '*', '/', '-', '+', '\', '%', '$'
                    , '#', '"', '''', '!', '.', '|', '='
                        , '<', '>', '?', '@', ':', '~', '['
                            , ']':
                    begin
                        CompileError(SYNTAX_ERR, Lines
                            , 'Syntax Error. Invalid Character "' + ch +  '".');
                        Result := False;
                        Exit;
                    end;

                '}':
                    begin
                        Break;
                    end;

                else
                    temp := temp + ch;
            end;

            Index := Index + 1;
        end;

        //IuWFNg`FbN
        temp := Trim(temp);

        if temp = '' then
        begin
            CompileError(SYNTAX_ERR, Lines, 'Class name was not found.');
            Result := False;
            Exit;
        end
        else if not IDCheck(temp) then
        begin
            CompileError(SYNTAX_ERR, Lines, 'Identifer is invalid.');
            Result := False;
            Exit;
        end;

        //pIuWFNg쐬
        Props := SplitString(Replace(temp, #13#10, ' '), ' ');

        if Props.Count = 1 then
            NewObject := ObjectServer.CreateInherited(Props.Strings[0], '')
        else if Props.Count = 3 then
        begin
            if Props.Strings[1] = 'extends' then
            begin
                NewObject := ObjectServer.CreateInherited(Props.Strings[0]
                                                            , Props.Strings[2]);
                NewObject.Line := StartPoint;
                
                if NewObject.Parent = nil then
                begin
                    ObjParent := FindClass(Props.Strings[2]);

                    if ObjParent <> nil then
                        NewObject.Parent := ObjParent;
                end;
            end;
        end;

        temp := '';
        NewObject.ScriptFile := ScriptFile;

        //o[̉
        while Index < Length(CSource) do
        begin
            ch := PChar(PSource + Index)^;

            case ch of
                #13:
                    begin
                        NewSource := NewSource + #13#10;
                        Lines := Lines + 1;
                        Index := Index + 1;
                        temp := Trim(temp);

                        if temp = 'var' then
                        begin
                            AddVariant(Index, Lines, NewObject);
                            temp := '';
                        end
                        else if temp = 'function' then
                        begin
                            AddFunction(Index, Lines, NewObject);
                            temp := '';
                        end
                        else
                            temp := temp + ch;

                        Continue;
                    end;

                ' ', #9:
                    begin
                        temp := Trim(temp);
                        Index := Index + 1;

                        if temp = 'var' then
                        begin
                            AddVariant(Index, Lines, NewObject);
                            Index := Index + 1;
                            temp := '';
                        end
                        else if temp = 'function' then
                        begin
                            AddFunction(Index, Lines, NewObject);
                            temp := '';
                        end
                        else
                            temp := temp + ch;

                        Continue;
                    end;

                '}':
                    begin
                        Break;
                    end;

                #10:
                    begin
                    end;

                else
                    temp := temp + ch;
            end;

            Index := Index + 1;
        end;

        Index := Index + 1;
        Result := False;
    end;

begin
    //
    n := 0;
    temp := '';
    QuotType := 0;
    Step := 0;
    BackSlash := False;
    LineNum := 1;
    CSource := Source;
    PSource := PChar(CSource);
    NewSource := '';

    //O[oNX擾
    GlobalObj := ObjectServer.GetClass('Global');
    TJaGlobal(GlobalObj).ScriptFile := ScriptFile;

    //functionEclassƂɕ
    while n < Length(CSource) do
    begin
        ch := PChar(PSource + n)^;

        if BackSlash then
        begin
            n := n + 1;
            temp := temp + ch;
            BackSlash := False;
            Continue;
        end;

        case ch of
            #13:
                begin
                    LineNum := LineNum + 1;
                    stemp := Trim(temp);

                    if stemp = 'function' then
                    begin
                        temp := '';
                        n := n + 1;
                        NewSource := NewSource + #13#10;

                        AddFunction(n, LineNum, GlobalObj);
                        Continue;
                    end
                    else if stemp = 'class' then
                    begin
                        temp := '';
                        n := n + 1;
                        NewSource := NewSource + #13#10;

                        AddClass(n, LineNum);
                        Continue;
                    end
                    else if stemp = 'var' then
                    begin
                        temp := '';
                        n := n + 1;
                        NewSource := NewSource + #13#10;

                        AddVariant(n, LineNum, GlobalObj);
                        Continue;
                    end
                    else if stemp = '#include' then
                    begin
                        temp := '';
                        n := n + 1;
                        NewSource := NewSource + #13#10;

                        AddIncludeFile(n, LineNum);
                        Continue;
                    end
                    else
                    begin
                        NewSource := NewSource + temp + #13#10;
                        temp := '';
                    end;
                end;

            #9, ' ':
                begin
                    if (QuotType <> 0) or (Step <> 0) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    stemp := Trim(temp);

                    if stemp = 'function' then
                    begin
                        temp := '';
                        n := n + 1;

                        AddFunction(n, LineNum, GlobalObj);
                        Continue;
                    end
                    else if stemp = 'class' then
                    begin
                        temp := '';
                        n := n + 1;

                        AddClass(n, LineNum);
                        Continue;
                    end
                    else if stemp = 'var' then
                    begin
                        temp := '';
                        n := n + 1;

                        AddVariant(n, LineNum, GlobalObj);
                        Continue;
                    end
                    else if stemp = '#include' then
                    begin
                        temp := '';
                        n := n + 1;

                        AddIncludeFile(n, LineNum);
                        Continue;
                    end
                    else
                    begin
                        NewSource := NewSource + temp + ch;
                        temp := '';
                    end;
                end;

            '{':
                begin
                    if QuotType = 0 then
                        Step := Step + 1;
                    temp := temp + ch;
                end;

            '}':
                begin
                    if QuotType = 0 then
                        Step := Step - 1;
                    temp := temp + ch;
                end;

            '"':
                begin
                    if QuotType = 0 then
                        QuotType := 1
                    else if QuotType = 1 then
                        QuotType := 0;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = 0 then
                        QuotType := 2
                    else if QuotType = 2 then
                        QuotType := 0;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if QuotType = 0 then
                    begin
                        CompileError(SYNTAX_ERR, LineNum
                            , 'Syntax Error. Invalid Character "' + ch +  '".');
                        Exit;
                    end;

                    if (ByteType(CSource, n + 1) = btSingle) and (QuotType <> 0) then
                        BackSlash := True;

                    temp := temp + ch;
                end;

            #10:
                begin
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if temp <> '' then
        NewSource := NewSource + temp;

    TJaGlobal(GlobalObj).Main := NewSource;
    Result := NewSource;
end;

function TScriptFile.Compile : Boolean;
var
    NewSource : String;
begin
    Result := True;
    NewSource := DeleteComment(Source);

    if Error.Count <> 0 then
    begin
        Result := False;
        Exit;
    end;

    //\擾
    FindDefine(NewSource);
end;

procedure TScriptFile.CompileError(ErrorNumber : Integer ; LineNum : Integer ; Mes : String);
begin
    Error.Add(LineNum,ErrorNumber, Mes, ScriptFile);
end;

function TScriptFile.LoadFromFile(FileName : String) : Boolean;
begin
    ScriptFile := FileName;
    Result := FileExists(FileName);
    Source := AdjustLineBreaks(tn_utils.LoadFromFile(FileName));
end;

procedure TScriptFile.AddInclude(FileName : String);
var
    NewInc : TScriptFile;
begin
    NewInc := TScript(Parent).AddInclude(FileName);

    SetLength(Includes, Count + 1);
    Includes[Count] := NewInc;
    Count := Count + 1;
end;

function TScriptFile.FindClass(Name : String) : TJaObject;
var
    n : Integer;
begin
    Result := ObjectServer.GetClass(Name);
    if Result <> nil then Exit;

    for n := Count - 1 downto 0 do
    begin
        Result := Includes[n].ObjectServer.GetClass(Name);
        if Result <> nil then Exit;
    end;
end;

//******************************************************************************
//TScript

constructor TScript.Create(ScriptFile : String);
begin
    Error := TErrors.Create;
    LibPath := ExtractFilePath(ParamStr(0)) + 'lib\';
    CurrentPath := ExtractFilePath(ScriptFile);
    StartFile := ScriptFile;
    Runtime := nil;
    Plugin := TPluginLoader.Create;
    DustBox := TNIntList.Create;
    Compiled := False;

    //gݍ݃IuWFNg̓o^
    Plugin.Add('Number', TJaNumber.Create);
    Plugin.Add('Boolean', TJaBoolean.Create);
    Plugin.Add('String', TJaString.Create);
    Plugin.Add('Undefined', TJaUndefined.Create);
    Plugin.Add('Array', TJaArray.Create);
    Plugin.Add('Date', TJaDate.Create);
    //Plugin.Add('Global', TJaGlobal.Create);
    Plugin.Add('Object', TJaObject.Create);
    Plugin.Add('RegExp', TJaRegExp.Create);
end;

destructor TScript.Destroy;
var
    Count : Integer;
begin
    Count := 0;

    if Runtime <> nil then
    begin
        //QuitbZ[W𔭍s
        Runtime.Quit;

        //RuntimeIuWFNgJ܂őҋ@
        while (Runtime <> nil) and (Count < 100) do
        begin
            Count := Count + 1;
            ProcessMessage;
            Sleep(100);
        end;
        
        //܂JĂȂƂ͋IɃXbh~
        if Runtime <> nil then Runtime.Free;

        //eXgR[h
        //Exit;
    end;

    Clear;
    Error.Free;
    Plugin.Free;
    DustBox.Free;
    inherited Destroy;
end;

procedure TScript.Compile;
var
    n : Integer;
begin
    //ScriptFileIuWFNgj
    Clear;

    //ŏ̃XNvg[h
    SetLength(Scripts, 1);
    Count := 1;
    Scripts[0] := TScriptFile.Create(Error);

    for n := 0 to 10 do
    begin
        if Scripts[0].LoadFromFile(StartFile) then Break;
        Sleep(10);
    end;

    if Scripts[0].Source = '' then
    begin
        ErrorStr := 'err> File is empty or occupied by other application.';
        Compiled := True;
        Exit;
    end;

    Scripts[0].Parent := Self;
    Scripts[0].ObjectServer.Plugin := Plugin;
    Scripts[0].ObjectServer.DustBox := DustBox;
    Scripts[0].Compile;

    //\𐶐
    StructStr := GetStruct;

    //G[𐶐
    ErrorStr := GetCompileError;
    Compiled := True;
end;

function TScript.AddInclude(FileName : String) : TScriptFile;
var
    n : Integer;
    NowIndex : Integer;
begin
    for n := 0 to Count - 1 do
    begin
        if Scripts[n].ScriptFile = FileName then
        begin
            Result := Scripts[n];
            Exit;
        end;
    end;

    SetLength(Scripts, Count + 1);
    NowIndex := Count;
    Count := Count + 1;
    Scripts[NowIndex] := TScriptFile.Create(Error);
    Scripts[NowIndex].LoadFromFile(FileName);
    Scripts[NowIndex].Parent := Self;
    Scripts[NowIndex].ObjectServer.Plugin := Plugin;
    Scripts[NowIndex].ObjectServer.DustBox := DustBox;
    Scripts[NowIndex].Compile;
    Result := Scripts[NowIndex];
end;

function TScript.GetStruct : String;
var
    k : Integer;
    l : Integer;
    m : Integer;
    n : Integer;
    This : TJaObject;
    temp : String;

    procedure PrintOut(Mes : String);
    begin
        Result := Result + Mes + #13#10;
    end;

begin
    Result := '';

    PrintOut('Compiled script infomation about "' + Scripts[0].ScriptFile + '".');
    PrintOut('================================================================================');

    for n := 0 to Count - 1 do
    //for n := 0 to High(Scripts) do
    begin
        PrintOut('');
        PrintOut(Scripts[n].ScriptFile);
        PrintOut('');
        PrintOut('Classes');

        for m := 0 to Scripts[n].ObjectServer.Count - 1 do
        begin
            This := Scripts[n].ObjectServer.Types[m];
            if This.Parent <> nil then
                PrintOut(#9 + This.ClassName + ' extends ' + TJaObject(This.Parent).ClassName)
            else
                PrintOut(#9 + This.ClassName + ' extends Object');
        end;

        PrintOut('');
        PrintOut('Variants');

        for m := 0 to Scripts[n].ObjectServer.Count - 1 do
        begin
            This := Scripts[n].ObjectServer.Types[m];
            temp := '';

            for l := 0 to This.Variants.Count - 1 do
            begin
                if temp <> '' then
                    temp := temp + ', ';

                temp := temp + This.Variants.Strings[l];
            end;

            PrintOut(#9 + This.ClassName + ' : ' + temp);
        end;

        PrintOut('');
        PrintOut('Functions');

        for m := 0 to Scripts[n].ObjectServer.Count - 1 do
        begin
            This := Scripts[n].ObjectServer.Types[m];

            for l := 0 to This.Functions.Count - 1 do
            begin
                temp := '';

                for k := 0 to This.Functions.Functions[l].Variants.Count - 1 do
                begin
                    if temp <> '' then
                        temp := temp + ', ';

                    temp := temp + This.Functions.Functions[l].Variants.Strings[k];
                end;
                PrintOut(#9 + This.ClassName + '.' + This.Functions.Functions[l].Name + ' : ' + temp);
            end;

        end;

        PrintOut('');
    end;
end;

function TScript.GetCompileError : String;
begin
    Result := Error.GetErrMessage;
end;

function TScript.Run(Sync : Boolean) : Boolean;
begin
    Result := True;

    if (Error.Count <> 0) or (Runtime <> nil) then
    begin
        Result := False;
        Exit;
    end;

    //XNvg̎s
    Runtime := TJaRuntime.Create(Self);
    Runtime.FreeOnTerminate := True;

    {$IFNDEF THREADTEST}
    Runtime.TermEventObj := ExecuteTerm;
    {$ELSE}
    Runtime.OnTerminate := ExecuteTerm;
    {$ENDIF}

    Runtime.Resume;

    if Sync then
    begin
        while Runtime <> nil do
            Sleep(100);
    end;
end;

procedure TScript.ExecuteTerm(Sender : TObject);
begin
    Runtime := nil;
    //w̃EBhEɃbZ[W𑗂
    SendMessage(Handle, WM_JPTERMINATE, 0, 0);
    //PostMessage(Handle, WM_JPTERMINATE, 0, 0);
end;

procedure TScript.Clear;
var
    n : Integer;
begin
    //ScriptFilẽNA
    for n := 0 to Count - 1 do
        Scripts[n].Free;

    Count := 0;
    SetLength(Scripts, Count);

    //G[̃NA
    Error.Clear;
end;

//******************************************************************************
//TRuntime
//^CIuWFNg & p[T[

constructor TJaRuntime.Create(CompiledScript : TScript);
var
    Target : TVirtualObject;
begin
    inherited Create(True);
    Script := CompiledScript;
    Error := Script.Error;
    ExitFlag := False;
    Variants := TVariantList.Create(Script.Scripts[0].ObjectServer);
    OptionCode := '';

    //MathfUCIuWFNg
    MathObj := TJaMath.Create;

    //pMathIuWFNg
    Target := TVirtualObject.Create(Script.Scripts[0].ObjectServer);
    Target.Reference := MathObj;
    Variants.SetObject('Math', Target);

    //pDateIuWFNg
    Target := TVirtualObject.Create(Script.Scripts[0].ObjectServer);
    Target.Reference := TJaDate.Create;
    Variants.SetObject('Date', Target);
end;

destructor TJaRuntime.Destroy;
var
    Obj : TVirtualObject;
begin
    Variants.Free;
    MathObj.Free;

    while Script.DustBox.Count <> 0 do
    begin
        Obj := Pointer(Script.DustBox.GetValue(0));
        Obj.Free;
    end;

    inherited Destroy;
end;

procedure TJaRuntime.Execute;
var
    m, n : Integer;

    function GetIndex(Test : TScriptFile) : Integer;
    var
        n : Integer;
    begin
        Result := -1;

        for n := 0 to Script.Count - 1 do
        begin
            if Test = Script.Scripts[n] then
            begin
                Result := n;
                Break;
            end;
        end;
    end;

begin
    Error.Line := 1;
    Error.FileName := Script.Scripts[0].ScriptFile;
    SetLength(Globals, Script.Count);

    //XbhDxݒ
    SetThreadPriority(Handle, Priority);

    for n := 0 to Script.Count - 1 do
    begin
        Globals[n] := Script.Scripts[n].ObjectServer.PrepareInstance('Global');
        Globals[n].Global := Globals[n];
        Script.Scripts[n].ObjectServer.Global := Globals[n];
    end;

    for n := 0 to Script.Count - 1 do
    begin
        SetLength(Globals[n].Includes, Script.Scripts[n].Count);
        Globals[n].Include_Count := Script.Scripts[n].Count;

        for m := 0 to Script.Scripts[n].Count - 1 do
            Globals[n].Includes[m] := Globals[GetIndex(Script.Scripts[n].Includes[m])];
    end;

    ExecOption;
    Inc_Exec(0);

    for n := 0 to Script.Count - 1 do
    begin
        Globals[n].Free;
    end;
end;

procedure TJaRuntime.Run(var Inf : TScriptCall);
var
    temp, stemp : String;
    ch : Char;
    Target : TVirtualObject;
    WideStep : Integer;
    QuotType : TQuoteType;
    BackSlash : Boolean;
    Running : Boolean;
    StartBreakLevel : Integer;
begin
    Inf.Return := nil;
    temp := '';
    WideStep := 0;
    QuotType := qtNone;
    BackSlash := False;
    StartBreakLevel := Inf.BreakLevel;

    if Inf.Switch = nil then
        Running := True
    else
        Running := False;


    while Inf.Index < Inf.Length do
    begin
        if ExitFlag then Exit;
        if Inf.Return <> nil then Break;
        if Inf.Exception then Exit;
        if StartBreakLevel > Inf.BreakLevel then Exit;
        if Inf.Continued then Exit;

        ch := (Inf.Code + Inf.Index)^;

        if BackSlash then
        begin
            BackSlash := False;
            temp := temp + ch;
            Inf.Index := Inf.Index + 1;
            Continue;
        end;

        case ch of
            ';':
                begin
                    if (WideStep = 0) and (QuotType = qtNone) then
                    begin
                        if Running then
                        begin
                            temp := Trim(temp);

                            if (temp = 'break') and (Inf.BreakLevel <> 0) then
                            begin
                                Inf.BreakLevel := Inf.BreakLevel - 1;
                                Exit;
                            end
                            else if (temp = 'continue') and (Inf.BreakLevel <> 0) then
                            begin
                                Inf.BreakLevel := Inf.BreakLevel - 1;
                                Inf.Continued := True;
                                Exit;
                            end;

                            if Running then
                            begin
                                Target := ToObject(Inf, temp);
                                if Target <> nil then Target.Free;
                            end;
                        end;

                        temp := '';
                        Inf.Index := Inf.Index + 1;
                        Continue;
                    end;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;

            ' ':
                begin
                    stemp := Trim(temp);

                    if (Inf.Switch <> nil) and (QuotType = qtNone) and (WideStep = 0) then
                    begin
                        if stemp = 'case' then
                        begin
                            SkipNonsenseChar(Inf);
                            temp := Trim(GetStringUntil(Inf, ':'));
                            Inf.Index := Inf.Index + 1;

                            if not Running then
                            begin
                                Target := ToObject(Inf, temp);

                                if Inf.Switch.Equal(Target) then
                                    Running := True;

                                Target.Free;
                            end;

                            temp := '';
                            Inf.Index := Inf.Index + 1;
                            Continue;
                        end;
                    end;
                end;

            ':':
                begin
                    if (Inf.Switch = nil) or (WideStep <> 0)
                                                or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        Inf.Index := Inf.Index + 1;
                        Continue;
                    end;

                    stemp := Trim(temp);

                    if stemp = 'default' then
                    begin
                        Running := True;
                        temp := '';
                        Inf.Index := Inf.Index + 1;
                        Continue;
                    end;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and
                        (ByteType(Inf.Code, Inf.Index + 1) = btSingle) then
                            BackSlash := True;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                    begin
                        stemp := Trim(temp);

                        if stemp = 'for' then
                        begin
                            ForStatement(Inf);
                            temp := '';
                            Continue;
                        end
                        else if stemp = 'while' then
                        begin
                            WhileStatement(Inf);
                            temp := '';
                            Continue;
                        end
                        else if stemp = 'if' then
                        begin
                            IfStatement(Inf);
                            temp := '';
                            Continue;
                        end
                        else if stemp = 'switch' then
                        begin
                            SwitchStatement(Inf);
                            temp := '';
                            Continue;
                        end
                        else if stemp = 'with' then
                        begin
                            WithStatement(Inf);
                            temp := '';
                            Continue;
                        end;
                    end;
                end;

            '{':
                begin
                    if QuotType = qtNone then
                        WideStep := WideStep + 1;
                end;

            '}':
                begin
                    if QuotType = qtNone then
                        WideStep := WideStep - 1;
                end;
        end;

        temp := temp + ch;
        Inf.Index := Inf.Index + 1;
    end;
end;

function TJaRuntime.ValueResolve(var Inf : TScriptCall ; This : TVirtualObject
                        ; Data : String ; EnterValue : TVirtualObject ; AsPointer : Boolean) : TVirtualObject;
var
    CurrentParent : TVirtualObject;
    n : Integer;
    PSource : PChar;
    temp, stemp , ttemp : String;
    Params : TNStringList;
    ch : Char;
    Step : Integer;
    ArrayStep : Integer;
    QuotType : TQuoteType;
    IsMethod : Boolean;
    IsLast : Boolean;
    BackSlash : Boolean;

    procedure FindMethod(Name : String);
    var
        n : Integer;
        Func : TFunction;

        procedure CallMethod;
        var
            args : array of TVirtualObject;
            n : Integer;
            CallInf : TScriptCall;
            Target : TVirtualObject;
            PrevLine : Integer;
            PrevFile : String;

            procedure DeleteParam;
            var
                n : Integer;
            begin
                for n := 0 to Params.Count - 1 do
                    args[n].Free;
            end;

        begin
            //̏
            SetLength(args, Params.Count);

            for n := 0 to Params.Count - 1 do
                args[n] := ToObject(Inf, Params.Strings[n]);

            if Inf.Exception then
            begin
                DeleteParam;
                Exit;
            end;

            if Func.MaxParam > High(args) + 1 then
            begin
                Error.RuntimeErr(errParam);
                DeleteParam;
                CurrentParent.Free;
                CurrentParent := MakeUndefined(Inf.Parent.Server);
                Exit;
            end;

            if @Func.InternalFunc <> nil then
            begin
                //gݍ݃\bh
                Target := Func.InternalFunc(args, CurrentParent, Error);
                CurrentParent.Free;
                VarCopy(Target, CurrentParent, Inf.Parent.Server);
                Target.Free;
                DeleteParam;
                Exit;
            end;

            //IWĩ\bh
            PrevLine := Error.Line;
            PrevFile := Error.FileName;

            CallInf.Code := PChar(Func.PreCode);
            CallInf.Index := 0;
            CallInf.Length := Length(Func.PreCode);
            CallInf.Parent := CurrentParent;
            CallInf.Vars := TVariantList.Create(Inf.Parent.Server);
            CallInf.BreakLevel := 0;
            CallInf.Continued := False;
            CallInf.Exception := False;
            CallInf.Switch := nil;
            CallInf.WithState := nil;

            //ϐZbg
            for n := 0 to Func.Variants.Count - 1 do
                CallInf.Vars.Add(Func.Variants.Strings[n]);

            //Zbg
            for n := 0 to Func.MaxParam - 1 do
            begin
                CallInf.Vars.Datas[n].Free;
                VarCopy(args[n], CallInf.Vars.Datas[n], Inf.Parent.Server);
            end;

            //Jnsݒ
            Error.Line := Func.Line;
            if CurrentParent.Reference.ScriptFile <> '' then
                Error.FileName := CurrentParent.Reference.ScriptFile;

            //R[h
            Run(CallInf);
            CallInf.Code := PChar(Func.Code);
            CallInf.Index := 0;
            CallInf.Length := Length(Func.Code);
            CallInf.Return := nil;

            //{
            Run(CallInf);
            CallInf.Vars.Free;

            if CallInf.Return <> nil then
                Target := CallInf.Return
            else
                Target := MakeUndefined(CallInf.Parent.Server);

            CurrentParent.Free;
            VarCopy(Target, CurrentParent, CallInf.Parent.Server);
            Target.Free;

            //p[^폜
            DeleteParam;

            //Jns߂
            Error.Line := PrevLine;
            Error.FileName := PrevFile;

            //OtO
            Inf.Exception := CallInf.Exception;
        end;

        procedure DoEval;
        var
            CallInf : TScriptCall;
            Target : TVirtualObject;
            temp : String;
        begin
            if Inf.Exception then Exit;

            if Params.Count >= 1 then
                temp := Params.Strings[0]
            else
                temp := '';

            Target := ToObject(Inf, temp);
            temp := ForceString(Target);
            Target.Free;
            
            //IWĩ\bh
            CallInf.Code := PChar(temp);
            CallInf.Index := 0;
            CallInf.Length := Length(temp);
            CallInf.Parent := Inf.Parent;
            CallInf.Vars := Inf.Vars;
            CallInf.BreakLevel := Inf.BreakLevel;
            CallInf.Continued := False;
            CallInf.Exception := False;
            CallInf.Switch := nil;
            CallInf.Return := nil;
            CallInf.WithState := nil;
            Run(CallInf);

            if CurrentParent <> nil then
                CurrentParent.Free;

            if CallInf.Return <> nil then
            begin
                VarCopy(CallInf.Return, CurrentParent, CallInf.Parent.Server);
                CallInf.Return.Free;
            end
            else
                CurrentParent := MakeUndefined(CallInf.Parent.Server);

            //OtO
            Inf.Exception := CallInf.Exception;
        end;

    begin
        if CurrentParent = nil then
        begin
            //IuWFNg̓

            //evaľo
            if Name = 'eval' then
            begin
                DoEval;
                Exit;
            end;

            //WithXe[ggΏۃIuWFNg̃\bh
            if (Inf.WithState <> nil) and (Inf.WithState.Reference <> nil) then
            begin
                Func := Inf.WithState.Reference.FindFunction(Name);

                if Func <> nil then
                begin
                    VarCopy(Inf.WithState, CurrentParent, Inf.Parent.Server);
                    CallMethod;
                    Exit;
                end;
            end;

            //NX̃\bh
            if Inf.Parent.Reference <> nil then
            begin
                Func := Inf.Parent.Reference.FindFunction(Name);

                if Func <> nil then
                begin
                    VarCopy(Inf.Parent, CurrentParent, Inf.Parent.Server);
                    CallMethod;
                    Exit;
                end;
            end;

            //t@C̃O[o\bh
            Func := Inf.Parent.Global.Reference.FindFunction(Name);

            if Func <> nil then
            begin
                VarCopy(Inf.Parent.Global, CurrentParent, Inf.Parent.Server);
                CallMethod;
                Exit;
            end;

            //CN[ht@C̃\bh
            for n := Inf.Parent.Global.Include_Count - 1 downto 0 do
            begin
                Func := Inf.Parent.Global.Includes[n].Reference.FindFunction(Name);

                if Func <> nil then
                begin
                    VarCopy(Inf.Parent.Global.Includes[n]
                                , CurrentParent, Inf.Parent.Server);
                    CallMethod;
                    Exit;
                end;
            end;

            //Ȃ(ToT)U
            Exit;
        end
        else
        begin
            //IuWFNg킩Ă
            if (CurrentParent.Reference <> nil) then
            begin
                if (CurrentParent.Reference.ClassName = 'Global')
                        and (Name = 'eval') then
                begin
                    DoEval;
                    Exit;
                end;

                Func := CurrentParent.Reference.FindFunction(Name);

                if Func <> nil then
                begin
                    CallMethod;
                    Exit;
                end
                else
                begin
                    CurrentParent.Free;
                    CurrentParent := MakeUndefined(Inf.Parent.Server);
                end;
            end
            else
                Exit;
        end;
    end;

    procedure FindVariant(Name : String ; ArrayParam : String ; Continued : Boolean);
    var
        n : Integer;
        Index : Integer;
        Target : TVirtualObject;
        Func : TFunction;

        procedure AccessToArray;
        var
            Name : String;
            Target : TVirtualObject;
            Target2 : TVirtualObject;
        begin
            Target := ToObject(Inf, ArrayParam);

            if ArrayParam <> '' then
            begin
                Index := CurrentParent.FindArray(Target);

                if Index <> -1 then
                begin
                    if (EnterValue <> nil) and (IsLast) then
                    begin
                        CurrentParent.Arrays.Datas[Index].Free;
                        VarCopy(EnterValue
                                    , CurrentParent.Arrays.Datas[Index]
                                    , Inf.Parent.Server);
                    end;

                    if Continued then
                        VarCopy2(CurrentParent.Arrays.Datas[Index], Target2)
                    else
                        VarCopy(CurrentParent.Arrays.Datas[Index]
                                , Target2, Inf.Parent.Server);

                    CurrentParent.Free;

                    if AsPointer then
                        VarCopy2(Target2, CurrentParent)
                    else
                        VarCopy(Target2, CurrentParent, Inf.Parent.Server);

                    Target2.Free;
                end
                else
                begin
                    Name := ForceString(Target);
                    Index := CurrentParent.Variants.GetIndex(Name);

                    if Index <> -1 then
                    begin
                        if (EnterValue <> nil) and (IsLast) then
                        begin
                            CurrentParent.Variants.Datas[Index].Free;

                            if Continued then
                                VarCopy2(EnterValue
                                        , CurrentParent.Variants.Datas[Index])
                            else
                                VarCopy(EnterValue
                                        , CurrentParent.Variants.Datas[Index]
                                            , Inf.Parent.Server);
                        end;

                        Target2 := CurrentParent.Variants.Datas[Index];
                        CurrentParent.Free;

                        if (AsPointer) or (Continued) then
                            VarCopy2(Target2, CurrentParent)
                        else
                            VarCopy(Target2, CurrentParent, Inf.Parent.Server);
                    end
                    else
                    begin
                        //݂Ȃ̂ŃIuWFNgɃ[Jϐ쐬
                        CurrentParent.Variants.Add(Name);

                        if (EnterValue <> nil) and (IsLast) then
                        begin
                            //if Inf.Vars = nil then
                            //begin
                                CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1].Free;
                                VarCopy(EnterValue
                                            , CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                                                , Inf.Parent.Server);
                            //end
                            //else
                            //begin
                            //    Inf.Vars.Datas[CurrentParent.Variants.Count - 1].Free;
                            //    VarCopy(EnterValue
                            //                , CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                            //                , Inf.Parent.Server);
                            //end;
                        end;

                        //if CurrentParent.Variants = nil then
                        //    VarCopy(CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                        //                , Target2, Inf.Parent.Server)
                        //else
                            VarCopy(CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                                        , Target2, Inf.Parent.Server);

                        CurrentParent.Free;

                        if (AsPointer) or (Continued) then
                            VarCopy2(Target2, CurrentParent)
                        else
                            VarCopy(Target2, CurrentParent, Inf.Parent.Server);
                    end;
                end;
            end;

            Target.Free;
        end;

        procedure CallProperty;
        var
            Target : TVirtualObject;
            args : array of TVirtualObject;
        begin
            SetLength(args, 0);
            Target := Func.InternalFunc(args, CurrentParent, Error);
            if CurrentParent <> nil then CurrentParent.Free;
            VarCopy(Target, CurrentParent, Inf.Parent.Server);
            Target.Free;
        end;

    begin
        if CurrentParent = nil then
        begin
            //IuWFNg̓&ϐ̌

            if Name = 'this' then
            begin
                VarCopy(Inf.Parent, CurrentParent, This.Server);
                AccessToArray;
                Exit;
            end
            else if Name = 'Global' then
            begin
                VarCopy(Inf.Parent.Global, CurrentParent, Inf.Parent.Server);
                AccessToArray;
                Exit;
            end
            else if Name = 'true' then
            begin
                CurrentParent := MakeBoolean(True, Inf.Parent.Server);
                Exit;
            end
            else if Name = 'false' then
            begin
                CurrentParent := MakeBoolean(False, Inf.Parent.Server);
                Exit;
            end
            else if Name = 'NaN' then
            begin
                CurrentParent := MakeNaN(Inf.Parent.Server);
                Exit;
            end;

            Index := Variants.GetIndex(Name);
            if Index <> -1 then
            begin
                VarCopy2(Variants.Datas[Index], CurrentParent);
                Exit;
            end;

            //With̑ΏۃIuWFNǧ
            if Inf.WithState <> nil then
            begin
                Index := Inf.WithState.Variants.GetIndex(Name);

                if Index <> -1 then
                begin
                    if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                    begin
                        Inf.WithState.Variants.Datas[Index].Free;

                        if Continued then
                            VarCopy2(EnterValue
                                    , Inf.WithState.Variants.Datas[Index])
                        else
                            VarCopy(EnterValue
                                    , Inf.WithState.Variants.Datas[Index]
                                    , Inf.Parent.Server);

                        if (AsPointer) or (Continued) then
                            VarCopy2(Inf.WithState.Variants.Datas[Index], CurrentParent)
                        else
                            VarCopy(Inf.WithState.Variants.Datas[Index]
                                        , CurrentParent, Inf.Parent.Server);
                    end
                    else
                    begin
                        VarCopy2(Inf.WithState.Variants.Datas[Index], CurrentParent);
                        AccessToArray;
                    end;

                    Exit;
                end;
            end;

            //֐̃[Jϐ̌
            if Inf.Vars <> nil then
            begin
                Index := Inf.Vars.GetIndex(Name);

                if Index <> -1 then
                begin
                    if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                    begin
                        Inf.Vars.Datas[Index].Free;

                        if Continued then
                            VarCopy2(EnterValue, Inf.Vars.Datas[Index])
                        else
                            VarCopy(EnterValue, Inf.Vars.Datas[Index]
                                    , Inf.Parent.Server);

                        if AsPointer then
                            VarCopy2(Inf.Vars.Datas[Index], CurrentParent)
                        else
                            VarCopy(Inf.Vars.Datas[Index]
                                        , CurrentParent, Inf.Parent.Server);
                    end
                    else
                    begin
                        VarCopy2(Inf.Vars.Datas[Index], CurrentParent);
                        AccessToArray;
                    end;

                    Exit;
                end;
            end;

            //NX̕ϐ
            Index := Inf.Parent.Variants.GetIndex(Name);

            if Index <> - 1 then
            begin
                if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                begin
                    Inf.Parent.Variants.Datas[Index].Free;
                    VarCopy(EnterValue
                                , Inf.Parent.Variants.Datas[Index]
                                , Inf.Parent.Server);

                    if (AsPointer) or (Continued) then
                        VarCopy2(Inf.Parent.Variants.Datas[Index], CurrentParent)
                    else
                        VarCopy(Inf.Parent.Variants.Datas[Index]
                                    , CurrentParent, Inf.Parent.Server);
                end
                else
                begin
                    VarCopy2(Inf.Parent.Variants.Datas[Index], CurrentParent);
                    AccessToArray;
                end;

                Exit;
            end;

            //t@C̃O[oϐ
            Index := Inf.Parent.Global.Variants.GetIndex(Name);

            if Index <> - 1 then
            begin
                if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                begin
                    Inf.Parent.Global.Variants.Datas[Index].Free;
                    VarCopy(EnterValue
                                , Inf.Parent.Global.Variants.Datas[Index]
                                , Inf.Parent.Server);

                    if (AsPointer) or (Continued) then
                        VarCopy2(Inf.Parent.Global.Variants.Datas[Index]
                                                            , CurrentParent)
                    else
                        VarCopy(Inf.Parent.Global.Variants.Datas[Index]
                                    , CurrentParent, Inf.Parent.Server);
                end
                else
                begin
                    VarCopy2(Inf.Parent.Global.Variants.Datas[Index]
                                , CurrentParent);
                    AccessToArray;
                end;

                Exit;
            end;

            //CN[ht@C̃O[oϐ
            for n := Inf.Parent.Global.Include_Count - 1 downto 0 do
            begin
                Index := Inf.Parent.Global.Includes[n].Variants.GetIndex(Name);

                if Index <> -1 then
                begin
                    if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                    begin
                        Inf.Parent.Global.Includes[n].Variants.Datas[Index].Free;
                        Inf.Parent.Global.Includes[n].Variants.Datas[Index] := EnterValue;

                        if (AsPointer) or (Continued) then
                            VarCopy2(Inf.Parent.Global.Includes[n].Variants.Datas[Index]
                                    , CurrentParent)
                        else
                            VarCopy(Inf.Parent.Global.Includes[n].Variants.Datas[Index]
                                    , CurrentParent, Inf.Parent.Server);
                    end
                    else
                    begin
                        VarCopy2(Inf.Parent.Global.Includes[n].Variants.Datas[Index]
                                                            , CurrentParent);
                        AccessToArray;
                    end;

                    Exit;
                end;
            end;

            //vpeB
            Func := Inf.Parent.Reference.FindProperty(Name);

            if Func <> nil then
            begin
                CallProperty;
                Exit;
            end;

            Func := Inf.Parent.Global.Reference.FindProperty(Name);

            if Func <> nil then
            begin
                CallProperty;
                Exit;
            end;

            //ϐvpeB݂Ȃ̂Ń[Jɍ쐬
            if not IDCheck(Name) then
            begin
                //ʎqᔽ
                Error.RuntimeErr(errInvalidID);
                Inf.Exception := True;
                Exit;
            end;

            if Inf.Vars <> nil then
            begin
                Inf.Vars.Add(Name);
                Inf.Vars.Datas[Inf.Vars.Count - 1].Server := Inf.Parent.Server;

                if ArrayParam <> '' then
                begin
                    //Y
                    VarCopy2(Inf.Vars.Datas[Inf.Vars.Count - 1], CurrentParent);
                    AccessToArray;
                end
                else
                begin
                    //YȂ
                    if (IsLast) and (EnterValue <> nil) then
                    begin
                        //l̑
                        Inf.Vars.Datas[Inf.Vars.Count - 1].Free;
                        VarCopy(EnterValue
                                    , Inf.Vars.Datas[Inf.Vars.Count - 1]
                                    , Inf.Parent.Server);
                    end;

                    if (AsPointer) or (Continued) then
                        VarCopy2(Inf.Vars.Datas[Inf.Vars.Count - 1], CurrentParent)
                    else
                        VarCopy(Inf.Vars.Datas[Inf.Vars.Count - 1]
                                    , CurrentParent, Inf.Parent.Server);
                end;
            end
            else
            begin
                Inf.Parent.Variants.Add(Name);
                Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1].Server
                                                    := Inf.Parent.Server;

                if ArrayParam <> '' then
                begin
                    //Y
                    VarCopy2(Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1]
                                                                        , CurrentParent);
                    AccessToArray;
                end
                else
                begin
                    //YȂ
                    if (IsLast) and (EnterValue <> nil) then
                    begin
                        //l̑
                        Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1].Free;
                        VarCopy(EnterValue
                            , Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1]
                            , Inf.Parent.Server);
                    end;

                    if (AsPointer) or (Continued) then
                        VarCopy2(Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1]
                                    , CurrentParent)
                    else
                        VarCopy(Inf.Parent.Variants.Datas[Inf.Parent.Variants.Count - 1]
                                    , CurrentParent, Inf.Parent.Server);
                end;
            end;
        end
        else
        begin
            //IuWFNg킩Ă
            Index := CurrentParent.Variants.GetIndex(Name);

            if Index <> -1 then
            begin
                if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
                begin
                    CurrentParent.Variants.Datas[Index].Free;
                    VarCopy(EnterValue
                                , CurrentParent.Variants.Datas[Index]
                                , Inf.Parent.Server);
                end;

                if Continued then
                begin
                    VarCopy2(CurrentParent.Variants.Datas[Index], Target);
                end
                else
                begin
                    VarCopy(CurrentParent.Variants.Datas[Index]
                            , Target, Inf.Parent.Server);
                end;

                CurrentParent.Free;

                if (AsPointer) or (Continued) then
                    VarCopy2(Target, CurrentParent)
                else
                    VarCopy(Target, CurrentParent, Inf.Parent.Server);

                Target.Free;
                AccessToArray;
                Exit;
            end;

            //vpeB
            if CurrentParent.Reference <> nil then
            begin
                Func := CurrentParent.Reference.FindProperty(Name);

                if Func <> nil then
                begin
                    CallProperty;
                    Exit;
                end;
            end;

            //݂Ȃ̂ŃIuWFNgɃ[Jϐ쐬
            if not IDCheck(Name) then
            begin
                //ʎqᔽ
                CurrentParent.Free;
                CurrentParent := nil;
                Error.RuntimeErr(errInvalidID);
                Inf.Exception := True;
                Exit;
            end;

            CurrentParent.Variants.Add(Name);
            CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1].Server := Inf.Parent.Server;

            if (EnterValue <> nil) and (IsLast) and (ArrayParam = '') then
            begin
                CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1].Free;
                VarCopy(EnterValue, Target, Inf.Parent.Server);
                CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1] := Target;
            end;

            if Continued then
                VarCopy2(CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                        , Target)
            else
                VarCopy(CurrentParent.Variants.Datas[CurrentParent.Variants.Count - 1]
                        , Target, Inf.Parent.Server);

            CurrentParent.Free;

            if (AsPointer) or (Continued) then
                VarCopy2(Target, CurrentParent)
            else
                VarCopy(Target, CurrentParent, Inf.Parent.Server);

            Target.Free;
            AccessToArray;
        end;
    end;

begin
    Result := nil;
    n := 0;
    Step := 0;
    ArrayStep := 0;
    temp := '';
    stemp := '';
    ttemp := '';
    QuotType := qtNone;
    PSource := PChar(Data);
    IsMethod := False;
    IsLast := False;
    BackSlash := False;

    if This <> nil then
        VarCopy(This, CurrentParent, Inf.Parent.Server)
    else
        CurrentParent := nil;

    while n < Length(Data) do
    begin
        if Inf.Exception then
        begin
            if CurrentParent <> nil then CurrentParent.Free;
            Result := MakeUndefined(Inf.Parent.Server);
            Exit;
        end;

        ch := (PSource + n)^;

        if BackSlash then
        begin
            BackSlash := False;

            if Step <> 0 then
                stemp := stemp + ch
            else if ArrayStep <> 0 then
                ttemp := ttemp + ch
            else
                temp := temp + ch;

            n := n + 1;
            Continue;
        end;

        case ch of
            '.':
                begin
                    if QuotType <> qtNone then
                    begin
                        if Step <> 0 then
                            stemp := stemp + ch
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                            temp := temp + ch;

                        n := n + 1;
                        Continue;
                    end
                    else
                    begin
                        if Step <> 0 then
                        begin
                            stemp := stemp + ch;
                            n := n + 1;
                            Continue;
                        end
                        else if ArrayStep <> 0 then
                        begin
                            ttemp := ttemp + ch;
                            n := n + 1;
                            Continue;
                        end;
                    end;

                    temp := Trim(temp);
                    stemp := Trim(stemp);
                    ttemp := Trim(ttemp);

                    if not IDCheck(temp) then Break;

                    if IsMethod then
                    begin
                        //\bh
                        if EnterValue <> nil then Exit;

                        Params := DivideParam(stemp);
                        FindMethod(temp);
                        Params.Free;
                        IsMethod := False;
                    end
                    else
                    begin
                        //ϐEvpeB
                        FindVariant(temp, ttemp, True);
                    end;

                    temp := '';
                    stemp := '';
                    ttemp := '';
                end;

            '(':
                begin
                    if QuotType = qtNone then
                    begin
                        if Step <> 0 then
                        begin
                            stemp := stemp + ch;
                            Step := Step + 1;
                        end
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                        begin
                            IsMethod := True;
                            Step := Step + 1;
                        end;
                    end
                    else
                    begin
                        if Step <> 0 then
                            stemp := stemp + ch
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                            temp := temp + ch;
                    end;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                    begin
                        if Step <> 0 then
                        begin
                            Step := Step - 1;

                            if Step <> 0 then
                                stemp := stemp + ch;
                        end
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch;
                    end
                    else
                    begin
                        if Step <> 0 then
                            stemp := stemp + ch
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                            temp := temp + ch;
                    end;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                    begin
                        if ArrayStep <> 0 then
                        begin
                            ttemp := ttemp + ch;
                            ArrayStep := ArrayStep + 1;
                        end
                        else if Step <> 0 then
                            stemp := stemp + ch
                        else
                            ArrayStep := ArrayStep + 1;
                    end
                    else
                    begin
                        if Step <> 0 then
                            stemp := stemp + ch
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                            temp := temp + ch;
                    end;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                    begin
                        if ArrayStep <> 0 then
                        begin
                            ArrayStep := ArrayStep - 1;

                            if ArrayStep <> 0 then
                                ttemp := ttemp + ch;
                        end
                        else if Step <> 0 then
                            stemp := stemp + ch;
                    end
                    else
                    begin
                        if Step <> 0 then
                            stemp := stemp + ch
                        else if ArrayStep <> 0 then
                            ttemp := ttemp + ch
                        else
                            temp := temp + ch;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    if Step <> 0 then
                        stemp := stemp + ch
                    else if ArrayStep <> 0 then
                        ttemp := ttemp + ch
                    else
                        temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    if Step <> 0 then
                        stemp := stemp + ch
                    else if ArrayStep <> 0 then
                        ttemp := ttemp + ch
                    else
                        temp := temp + ch;
                end;

            '\':
                begin
                    if QuotType <> qtNone then
                        BackSlash := True;

                    if Step <> 0 then
                        stemp := stemp + ch
                    else if ArrayStep <> 0 then
                        ttemp := ttemp + ch
                    else
                        temp := temp + ch;
                end;

            else
                begin
                    if Step <> 0 then
                        stemp := stemp + ch
                    else if ArrayStep <> 0 then
                        ttemp := ttemp + ch
                    else
                        temp := temp + ch;
                end;
        end;

        n := n + 1;
    end;

    temp := Trim(temp);
    stemp := Trim(stemp);
    ttemp := Trim(ttemp);

    if not IDCheck(temp) then
    begin
        Error.RuntimeErr(errInvalidID);
        Inf.Exception := True;
        if CurrentParent <> nil then CurrentParent.Free;
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end;

    if IsMethod then
    begin
        //\bh
        if EnterValue <> nil then Exit;

        Params := DivideParam(stemp);
        FindMethod(temp);
        Params.Free;

        if CurrentParent <> nil then
        begin
            VarCopy(CurrentParent, Result, Inf.Parent.Server);
            CurrentParent.Free;
        end
        else
            Result := MakeUndefined(Inf.Parent.Server);
    end
    else
    begin
        IsLast := True;
        FindVariant(temp, ttemp, False);

        if CurrentParent <> nil then
        begin
            if AsPointer then
                VarCopy2(CurrentParent, Result)
            else
                VarCopy(CurrentParent, Result, Inf.Parent.Server);

            CurrentParent.Free;
        end
        else
            Result := MakeUndefined(Inf.Parent.Server);
    end;
end;

function TJaRuntime.DivideParam(const Data : String) : TNStringList;
var
    PSource : PChar;
    ch : Char;
    n : Integer;
    Step : Integer;
    QuotType : TQuoteType;
    temp : String;
    BackSlash : Boolean;
begin
    Result := TNStringList.Create;
    PSource := PChar(Data);
    n := 0;
    Step := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            BackSlash := False;
            temp := temp + ch;
            n := n + 1;
            Continue;
        end;

        case ch of
            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            ',':
                begin
                    if (QuotType = qtNone) and (Step = 0) then
                    begin
                        temp := Trim(temp);
                        Result.Add(temp);
                        temp := '';
                    end
                    else
                        temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if QuotType <> qtNone then
                        BackSlash := True;

                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    temp := Trim(temp);

    if (QuotType = qtNone) and (Step = 0) then
    begin
        temp := Trim(temp);
        if temp <> '' then
            Result.Add(temp);
    end
end;

function TJaRuntime.ToObject(var Inf : TScriptCall ; const Data : String) : TVirtualObject;
var
    PSource : PChar;
    ch : Char;
    n : Integer;
    NewData : String;
    temp : String;
    stemp : String;
    Step : Integer;
    ArrayStep : Integer;
    QuotType : TQuoteType;
    CalcType : TCalcType;
    Target : TVirtualObject;
    Target2 : TVirtualObject;
    BackSlash : Boolean;
    Try_Int : Integer;
    Try_Float : Double;
    Code : Integer;
    CodeF : Integer;
    ShiftNF : Boolean;
    Compatibled : Boolean;
    Params : TNStringList;
begin
    Result := nil;
    NewData := Data + '   ';
    PSource := PChar(NewData);
    Compatibled := True;

    //returnElinktoo
    temp := Trim(Data);
    stemp := Trim(Copy(Data, 1, 7));

    if stemp = 'return;' then
    begin
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end
    else if stemp = 'return' then
    begin
        temp := Copy(Data, 8, Length(Data) - 7);
        Inf.Return := ToObject(Inf, temp);
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end
    else if stemp = 'return(' then
    begin
        temp := '';
        QuotType := qtNone;
        Step := 1;
        n := 7;

        while n < Length(Data) do
        begin
            ch := (PSource + n)^;

            case ch of
                '"':
                    begin
                        if QuotType = qtNone then
                            QuotType := qtDouble
                        else if QuotType = qtDouble then
                            QuotType := qtNone;

                        temp := temp + ch;
                    end;

                '''':
                    begin
                        if QuotType = qtNone then
                            QuotType := qtSingle
                        else if QuotType = qtSingle then
                            QuotType := qtNone;

                        temp := temp + ch;
                    end;

                '(':
                    begin
                        if QuotType = qtNone then
                            Step := Step + 1;

                        temp := temp + ch;
                    end;

                ')':
                    begin
                        if QuotType = qtNone then
                            Step := Step - 1;

                        if Step = 0 then
                            Break
                        else
                            temp := temp + ch;
                    end;

                else
                    temp := temp + ch;
            end;

            n := n + 1;
        end;

        Inf.Return := ToObject(Inf, temp);
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end
    else if stemp = 'linkto' then
    begin
        temp := Trim(Copy(temp, 8, Length(temp) - 7));
        Run_IncFile(temp);
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end;

    //c,c,c
    Params := DivideParam(Trim(Data));

    if Params.Count > 1 then
    begin
        for n := 0 to Params.Count - 1 do
        begin
            Target := ToObject(Inf, Params.Strings[n]);
            Target.Free;

            if Inf.Exception then
            begin
                Params.Free;
                Exit;
            end;
        end;

        Params.Free;
        Exit;
    end
    else
        Params.Free;

    // ? ` : `;
    n := 0;
    temp := '';
    Step := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '?':
                begin
                    if (QuotType <> qtNone) or (Step <> 0) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);
                    Target := ToObject(Inf, temp);

                    if Inf.Exception then
                    begin
                        VarCopy(Target, Result, Inf.Parent.Server);
                        Target.Free;
                        Exit;
                    end;

                    n := n + 1;
                    temp := '';

                    while n < Length(Data) do
                    begin
                        ch := (PSource + n)^;

                        case ch of
                            ':':
                                begin
                                    if (QuotType <> qtNone) or (Step <> 0) then
                                    begin
                                        temp := temp + ch;
                                        n := n + 1;
                                        Continue;
                                    end;

                                    Break;
                                end;

                            '(':
                                begin
                                    if QuotType = qtNone then
                                        Step := Step + 1;

                                    temp := temp + ch;
                                end;

                            ')':
                                begin
                                    if QuotType = qtNone then
                                        Step := Step - 1;

                                    temp := temp + ch;
                                end;

                            '"':
                                begin
                                    if QuotType = qtNone then
                                        QuotType := qtDouble
                                    else if QuotType = qtDouble then
                                        QuotType := qtNone;

                                    temp := temp + ch;
                                end;

                            '''':
                                begin
                                    if QuotType = qtNone then
                                        QuotType := qtSingle
                                    else if QuotType = qtSingle then
                                        QuotType := qtNone;

                                    temp := temp + ch;
                                end;

                            else
                                temp := temp + ch;
                        end;

                        n := n + 1;
                    end;

                    n := n + 1;
                    temp := Trim(temp);
                    stemp := Copy(Data, n + 1, Length(Data) - n);

                    if ForceBool(Target) then
                        Target2 := ToObject(Inf, temp)
                    else
                        Target2 := ToObject(Inf, stemp);

                    Target.Free;
                    Result := Target2;
                    Break;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        Exit;
    end;

    // =, -=, += ,*= ,/=, %=, <<=, >>=, >>>=
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '=':
                begin
                    // =

                    if (Step <> 0) or (ArrayStep <> 0) or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if (PSource + n + 1)^ = '=' then
                    begin
                        temp := temp + '==';
                        n := n + 2;
                        Continue;
                    end;

                    if (PSource + n - 1)^ = '!' then
                    begin
                        temp := temp + '!=';
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end
                    else
                    begin
                        if ((PSource + n - 1)^ = '<')
                                or ((PSource + n - 1)^ = '>') then
                        begin
                            temp := temp + ch;
                            n := n + 1;
                            Continue;
                        end;
                    end;

                    n := n + 1;
                    stemp := Trim(Copy(Data, n + 1, Length(Data) - n));
                    Target := ToObject(Inf, stemp);
                    Target2 := ValueResolve(Inf, nil, temp, Target, False);

                    VarCopy(Target2, Result, Inf.Parent.Server);
                    Target.Free;
                    Target2.Free;
                    Break;
                end;

            '+', '-', '*', '/', '%', '&', '|', '^':
                begin
                    // += -= *= /= &= |= ^=
                    if ((PSource + n + 1)^ <> '=') or (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);
                    Target := ValueResolve(Inf, nil, temp, nil, True);

                    if Inf.Exception then
                    begin
                        VarCopy(Target, Result, Inf.Parent.Server);
                        Target.Free;
                        Exit;
                    end;

                    n := n + 1;
                    temp := Trim(Copy(Data, n + 2, Length(Data) - n - 1));

                    Target2 := ToObject(Inf, temp);

                    case ch of
                        '+':
                            Target.Add(Target2);

                        '-':
                            Target.Sub(Target2);

                        '*':
                            Target.Mul(Target2);

                        '/':
                            Target.Divide(Target2);

                        '%':
                            Target.Mode(Target2);

                        '&':
                            Target.BitAnd(Target2);

                        '|':
                            Target.BitOr(Target2);

                        '^':
                            Target.BitXor(Target2);
                    end;

                    Target2.Free;
                    VarCopy(Target, Result, Inf.Parent.Server);
                    Target.Free;
                    Break;
                end;

            '>', '<':
                begin
                    ShiftNF := False;

                    if (PSource + n + 1)^ <> ch then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if (ch = '>') and ((PSource + n + 2)^ = '>')
                        and ((PSource + n + 3)^ = '=') then
                    begin
                        ShiftNF := True;
                    end
                    else if (PSource + n + 2)^ <> '=' then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);
                    Target := ValueResolve(Inf, nil, temp, nil, True);

                    if Inf.Exception then
                    begin
                        VarCopy(Target, Result, Inf.Parent.Server);
                        Target.Free;
                        Exit;
                    end;

                    if ShiftNF then
                        n := n + 4
                    else
                        n := n + 3;

                    temp := Trim(Copy(Data, n + 1, Length(Data) - n));
                    Target2 := ToObject(Inf, temp);

                    case ch of
                        '>':
                            begin
                                if ShiftNF then
                                    Target.ShiftRightNF(Target2)
                                else
                                    Target.ShiftRight(Target2);
                            end;

                        '<':
                            Target.ShiftLeft(Target2);
                    end;

                    Target2.Free;
                    VarCopy(Target, Result, Inf.Parent.Server);
                    Target.Free;
                    Break;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        Exit;
    end;

    // || ݂̂
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '|':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) or ((PSource + n + 1)^ <> ch) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    temp := '';

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                                n := n + 2;
                                CalcType := ctOr;
                                Continue;
                            end;

                        ctOr:
                            begin
                                Result.BOr(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    n := n + 1;
                    CalcType := ctOr;
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BOr(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // && ݂̂
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '&':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) or ((PSource + n + 1)^ <> ch) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    temp := '';

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                                n := n + 2;
                                CalcType := ctAnd;
                                Continue;
                            end;

                        ctAnd:
                            begin
                                Result.BAnd(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    n := n + 1;
                    Target.Free;
                    CalcType := ctAnd
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BAnd(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // | ݂̂
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '|':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                                or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    temp := '';

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                                n := n + 1;
                                Continue;
                            end;

                        ctBitOr:
                            begin
                                Result.BitOr(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    CalcType := ctBitOr;
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitOr(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // ^ ݂̂
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '^':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                                or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    temp := '';

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                                n := n + 1;
                                Continue;
                            end;

                        ctBitXor:
                            begin
                                Result.BitXor(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    CalcType := ctBitXor;
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitXor(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // & ݂̂
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '&':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                            or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    temp := '';

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                                n := n + 1;
                                Continue;
                            end;

                        ctBitAnd:
                            begin
                                Result.BitAnd(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    CalcType := ctBitAnd
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitAnd(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // == !=
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '!':
                begin
                    ch := (PSource + n + 1)^;

                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) or (ch <> '=')then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);

                    n := n + 2;
                    temp := Copy(Data, n + 1, Length(Data) - n);
                    Target2 := ToObject(Inf, temp);
                    Result := MakeBoolean(not Target.Equal(Target2)
                                                , Inf.Parent.Server);

                    //ϐ̂Ă
                    Target.Free;
                    Target2.Free;
                    temp := '';
                    Break;
                end;

            '=':
                begin
                    ch := (PSource + n + 1)^;

                    if (Step <> 0) or (ArrayStep <> 0)
                            or (QuotType <> qtNone) or (ch <> '=')then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);

                    n := n + 2;
                    temp := Copy(Data, n + 1, Length(Data) - n);
                    Target2 := ToObject(Inf, temp);
                    Result := MakeBoolean(Target.Equal(Target2)
                                                , Inf.Parent.Server);

                    //ϐ̂Ă
                    Target.Free;
                    Target2.Free;
                    temp := '';
                    Break;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitAnd(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // <, <=, >=, >

    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '<':
                begin
                    ch := (PSource + n + 1)^;

                    if (Step <> 0) or (ArrayStep <> 0)
                                or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if ch = '<' then
                    begin
                        temp := temp + '<<';
                        n := n + 2;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);

                    if ch = '=' then
                        n := n + 2
                    else
                        n := n + 1;

                    temp := Copy(Data, n + 1, Length(Data) - n);
                    Target2 := ToObject(Inf, temp);
                    Try_Int := Target.Compare(Target2, Compatibled);

                    if not Compatibled then
                        Result := MakeBoolean(False, Inf.Parent.Server)
                    else
                    begin
                        if ch = '=' then
                            Result := MakeBoolean(Try_Int <= 0
                                                    , Inf.Parent.Server)
                        else
                            Result := MakeBoolean(Try_Int < 0
                                                    , Inf.Parent.Server);
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    Target2.Free;
                    temp := '';
                    Break;
                end;

            '>':
                begin
                    ch := (PSource + n + 1)^;

                    if (Step <> 0) or (ArrayStep <> 0)
                            or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if ch = '>' then
                    begin
                        if (PSource + n + 2)^ = '>' then
                        begin
                            temp := temp + '>>>';
                            n := n + 3;
                            Continue;
                        end
                        else
                        begin
                            temp := temp + '>>';
                            n := n + 2;
                            Continue;
                        end;
                    end;
                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);

                    if ch = '=' then
                        n := n + 2
                    else
                        n := n + 1;

                    temp := Copy(Data, n + 1, Length(Data) - n);
                    Target2 := ToObject(Inf, temp);
                    Try_Int := Target.Compare(Target2, Compatibled);

                    if not Compatibled then
                        Result := MakeBoolean(False, Inf.Parent.Server)
                    else
                    begin
                        if ch = '=' then
                            Result := MakeBoolean(Try_Int >= 0
                                                    , Inf.Parent.Server)
                        else
                            Result := MakeBoolean(Try_Int > 0
                                                    , Inf.Parent.Server);
                    end;

                    //ϐ̂Ă
                    Target.Free;
                    Target2.Free;
                    temp := '';
                    Break;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitAnd(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // << , <<< , >>
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    BackSlash := False;
    ShiftNF := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '<', '>':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                            or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if (PSource + n + 1)^ = ch then
                    begin
                        if (ch = '>') and ((PSource + n + 2)^ = '>') then
                            ShiftNF := True
                    end
                    else
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                    begin
                        Error.RuntimeErr(errNoIdentifer);
                        Exit;
                    end;

                    Target := ToObject(Inf, temp);
                    VarCopy(Target, Result, Inf.Parent.Server);

                    if ShiftNF then
                        n := n + 3
                    else
                        n := n + 2;

                    temp := Copy(Data, n + 1, Length(Data) - n);
                    Target2 := ToObject(Inf, temp);

                    if ch = '>' then
                    begin
                        if ShiftNF then
                            Result.ShiftRightNF(Target2)
                        else
                            Result.ShiftRight(Target2);
                    end
                    else
                        Result.ShiftLeft(Target2);

                    //ϐ̂Ă
                    Target.Free;
                    Target2.Free;
                    Break;
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);
            Result.BitAnd(Target);

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // + , -
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '+', '-':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                                or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if ((PSource + n + 1)^ = ch) and ((PSource + n + 2)^ <> ch) then
                    begin
                        temp := temp + ch + ch;
                        n := n + 2;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                        Target := MakeInt(0, Inf.Parent.Server)
                    else
                        Target := ToObject(Inf, temp);

                    temp := '';
                    n := n + 1;

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                            end;

                        ctAdd:
                            begin
                                Result.Add(Target);
                            end;

                        ctSub:
                            begin
                                Result.Sub(Target);
                            end;
                    end;

                    //ϐ̂Ă
                    if CalcType <> ctNone then
                        Target.Free;

                    if ch = '+' then
                        CalcType := ctAdd
                    else if ch = '-' then
                        CalcType := ctSub;

                    Continue;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);

            case CalcType of
                ctNone:
                    begin
                        Result := Target;
                    end;

                ctAdd:
                    begin
                        Result.Add(Target);
                    end;

                ctSub:
                    begin
                        Result.Sub(Target);
                    end;
            end;

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // *, /, %
    n := 0;
    temp := '';
    Step := 0;
    ArrayStep := 0;
    QuotType := qtNone;
    CalcType := ctNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '*', '/', '%':
                begin
                    if (Step <> 0) or (ArrayStep <> 0) or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    if (PSource + n + 1)^ = ch then
                    begin
                        temp := temp + ch + ch;
                        n := n + 2;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp = '' then
                        Target := MakeInt(0, Inf.Parent.Server)
                    else
                        Target := ToObject(Inf, temp);

                    temp := '';
                    n := n + 1;

                    case CalcType of
                        ctNone:
                            begin
                                Result := Target;
                            end;

                        ctMul:
                            begin
                                Result.Mul(Target);
                                Continue;
                            end;

                        ctDiv:
                            begin
                                Result.Divide(Target);
                                Continue;
                            end;

                        ctMod:
                            begin
                                Result.Mode(Target);
                                Continue;
                            end;
                    end;

                    //ϐ̂Ă
                    if CalcType <> ctNone then
                        Target.Free;

                    if ch = '*' then
                        CalcType := ctMul
                    else if ch = '/' then
                        CalcType := ctDiv
                    else if ch = '%' then
                        CalcType := ctMod;

                    Continue;
                end;


            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);

            case CalcType of
                ctNone:
                    begin
                        Result := Target;
                    end;

                ctMul:
                    begin
                        Result.Mul(Target);
                    end;

                ctDiv:
                    begin
                        Result.Divide(Target);
                    end;

                ctMod:
                    begin
                        Result.Mode(Target);
                    end;
            end;

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;

    // ++ , --, new
    n := 0;
    temp := '';
    Step := 0;
    QuotType := qtNone;
    BackSlash := False;

    while n < Length(Data) do
    begin
        ch := (PSource + n)^;

        if BackSlash then
        begin
            temp := temp + ch;
            n := n + 1;
            BackSlash := False;
            Continue;
        end;

        case ch of
            '+', '-':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone)
                        or ((PSource + n + 1)^ <> ch) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    temp := Trim(temp);

                    if temp <> '' then
                    begin
                        Target := ValueResolve(Inf, nil, temp, nil, True);

                        if Inf.Exception then
                        begin
                            VarCopy(Target, Result, Inf.Parent.Server);
                            Target.Free;
                            Exit;
                        end;

                        VarCopy(Target, Result, Inf.Parent.Server);

                        if ch = '+' then
                            Target.Inc
                        else if ch = '-' then
                            Target.Dec;

                        Target.Free;
                        temp := '';
                        Break;
                    end;

                    n := n + 2;
                    temp := Trim(Copy(Data, n + 1, Length(Data) - n));

                    if temp <> '' then
                    begin
                        Target := ValueResolve(Inf, nil, temp, nil, True);

                        if Inf.Exception then
                        begin
                            VarCopy(Target, Result, Inf.Parent.Server);
                            Target.Free;
                            Exit;
                        end;

                        if ch = '+' then
                            Target.Inc
                        else if ch = '-' then
                            Target.Dec;

                        VarCopy(Target, Result, Inf.Parent.Server);
                        Target.Free;
                        temp := '';
                        Break;
                    end;
                end;

            '!':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    n := n + 1;
                    temp := Trim(Copy(Data, n + 1, Length(Data) - n));
                    Target := ValueResolve(Inf, nil, temp, nil, True);
                    Target.BNot;
                    VarCopy(Target, Result, Inf.Parent.Server);
                    Target.Free;
                    Break;
                end;

            '~':
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    n := n + 1;
                    temp := Trim(Copy(Data, n + 1, Length(Data) - n));
                    Target := ValueResolve(Inf, nil, temp, nil, True);
                    Target.BitNot;
                    VarCopy(Target, Result, Inf.Parent.Server);
                    Target.Free;
                    Break;
                end;

            ' ', #9:
                begin
                    if (Step <> 0) or (ArrayStep <> 0)
                        or (QuotType <> qtNone) then
                    begin
                        temp := temp + ch;
                        n := n + 1;
                        Continue;
                    end;

                    stemp := Trim(temp);

                    if stemp = 'new' then
                    begin
                        temp := '';

                        while n < Length(Data) do
                        begin
                            ch := (PSource + n)^;

                            case ch of
                                '(':
                                    Break;
                                else
                                    temp := temp + ch;
                            end;

                            n := n + 1;
                        end;

                        stemp := Trim(temp);
                        Target := MakeInstance(Inf, stemp);

                        temp := '(';
                        n := n + 1;
                        QuotType := qtNone;
                        Step := 0;
                        ArrayStep := 0;

                        while n < Length(Data) do
                        begin
                            ch := (PSource + n)^;

                            case ch of
                                '(':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                        begin
                                            if ArrayStep = 0 then
                                                Step := Step + 1;
                                        end;
                                    end;

                                ')':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                        begin
                                            if ArrayStep = 0 then
                                            begin
                                                if Step = 0 then
                                                    Break
                                                else
                                                    Step := Step - 1;
                                            end;
                                        end;
                                    end;

                                ']':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                            ArrayStep := ArrayStep - 1;
                                    end;

                                '[':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                            ArrayStep := ArrayStep + 1;
                                    end;

                                '"':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                            QuotType := qtDouble
                                        else if QuotType = qtDouble then
                                            QuotType := qtNone;
                                    end;

                                '''':
                                    begin
                                        temp := temp + ch;

                                        if QuotType = qtNone then
                                            QuotType := qtSingle
                                        else if QuotType = qtSingle then
                                            QuotType := qtNone;
                                    end;

                                else
                                    temp := temp + ch;
                            end;

                            n := n + 1;
                        end;

                        //RXgN^s
                        Target2 := ValueResolve(Inf, Target, stemp + temp, nil, False);
                        Target2.Free;

                        if Inf.Exception then
                        begin
                            VarCopy(Target, Result, Inf.Parent.Server);
                            Target.Free;
                            Exit;
                        end;

                        //o[ւ̃ANZXw肳ĂH
                        n := n + 1;
                        temp := Trim(Copy(Data, n + 1, Length(Data) - n));

                        if (temp <> '') and (temp[1] = '.') then
                        begin
                            temp := Copy(temp, 2, Length(temp) - 1);
                            Target2 := ValueResolve(Inf, Target, temp, nil, False);
                            VarCopy(Target2, Result, Inf.Parent.Server);
                            Target2.Free;
                            if Inf.Exception then Exit;
                        end
                        else
                            VarCopy(Target, Result, Inf.Parent.Server);

                        Target.Free;
                        temp := '';
                        Break;
                    end
                    else if stemp = 'typeof' then
                    begin
                        temp := Trim(Copy(Data, n + 1, Length(Data) - n));

                        if temp = '' then
                        begin
                            Result := MakeUndefined(Inf.Parent.Server);
                            Break;
                        end;

                        Target := ToObject(Inf, temp);

                        if Target.Reference <> nil then
                            Result := MakeString(Target.Reference.ClassName
                                                            , Inf.Parent.Server)
                        else
                            Result := MakeString('undefined'
                                                        , Inf.Parent.Server);

                        Target.Free;
                    end
                    else
                        temp := temp + ch;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;

                    temp := temp + ch;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;

                    temp := temp + ch;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;

                    temp := temp + ch;
                end;

            '[':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep + 1;

                    temp := temp + ch;
                end;

            ']':
                begin
                    if QuotType = qtNone then
                        ArrayStep := ArrayStep - 1;

                    temp := temp + ch;
                end;

            '\':
                begin
                    if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                        BackSlash := True;
                    temp := temp + ch;
                end;

            else
                temp := temp + ch;
        end;

        n := n + 1;
    end;

    if Result <> nil then Exit;
    (*
    begin
        temp := Trim(temp);

        if temp <> '' then
        begin
            Target := ToObject(Inf, temp);

            case CalcType of
                ctNone:
                    begin
                        Result := Target;
                    end;

                ctAdd:
                    begin
                        Result.Add(Target);
                    end;

                ctSub:
                    begin
                        Result.Sub(Target);
                    end;
            end;

            //ϐ̂Ă
            Target.Free;
        end;

        Exit;
    end;
    *)

    //**************************************************************************
    //񂠂邢͐lIuWFNgɕϊ
    //**************************************************************************

    NewData := Trim(Data);
    temp := '';
    PSource := PChar(NewData);

    if NewData = '' then
    begin
        Result := MakeUndefined(Inf.Parent.Server);
        Exit;
    end;

    if (NewData[1] = '(') and (NewData[Length(NewData)] = ')') then
    begin
        Result := ToObject(Inf, Copy(NewData, 2, Length(NewData) - 2));
        Exit;
    end;

    if (NewData[1] = '"') or (NewData[1] = '''') then
    begin
        //
        BackSlash := False;
        n := 1;

        if NewData[1] = '"' then
            QuotType := qtDouble
        else
            QuotType := qtSingle;

        while n < Length(Data) do
        begin
            ch := (PSource + n)^;

            if BackSlash then
            begin
                case ch of
                    'b', 'B':
                        //BackSpace
                        temp := temp + #8;

                    'n', 'N':
                        //LF
                        temp := temp + #10;

                    'r', 'R':
                        //CR
                        temp := temp + #13;

                    't', 'T':
                        //^u
                        temp := temp + #9;

                    '0':
                        begin
                            if (PSource + n + 1)^ = 'x' then
                            begin
                                stemp := '$' + (PSource + n + 2)^ + (PSource + n + 3)^;
                                Val(stemp, Try_Int, Code);

                                if Code = 0 then
                                begin
                                    temp := temp + Char(Byte(Try_Int));
                                    n := n + 3;
                                end
                                else
                                    temp := temp + ch;
                            end
                            else
                                temp := temp + ch;
                        end;

                    else
                        temp := temp + ch;
                end;

                n := n + 1;
                BackSlash := False;
                Continue;
            end;

            case ch of
                '"':
                    begin
                        if QuotType = qtDouble then
                        begin
                            Break;
                        end;

                        temp := temp + ch;
                    end;

                '''':
                    begin
                        if QuotType = qtSingle then
                        begin
                            Break;
                        end;

                        temp := temp + ch;
                    end;

                '\':
                    begin
                        if (QuotType <> qtNone) and (ByteType(Data, n + 1) = btSingle) then
                            BackSlash := True
                        else
                            temp := temp + ch;
                    end;

                else
                    temp := temp + ch;
            end;

            n := n + 1;
        end;

        Result := MakeString(temp, Inf.Parent.Server);
        n := n + 1;

        temp := Trim(Copy(Data, n + 1, Length(Data) - n));

        if (temp <> '') and (temp[1] = '.') then
        begin
            temp := Copy(temp, 2, Length(temp) - 1);
            Target := ValueResolve(Inf, Result, temp, nil, False);
            Result.Free;
            VarCopy(Target, Result, Inf.Parent.Server);
            Target.Free;
        end;
    end
    else
    begin
        //l邢͕ϐ
        NewData := Replace(Data, '0x', '$');
        Val(NewData, Try_Int, Code);
        Val(NewData, Try_Float, CodeF);

        if (Code = 0) and (CodeF = 0) then
        begin
            //l
            if Try_Int = Try_Float then
                Result := MakeInt(Try_Int, Inf.Parent.Server)
            else
                Result := MakeFloat(Try_Float, Inf.Parent.Server);
        end
        else if (Code <> 0) and (CodeF = 0) then
            Result := MakeFloat(Try_Float, Inf.Parent.Server)
        else if (Code = 0) and (CodeF <> 0) then
            Result := MakeInt(Try_Int, Inf.Parent.Server)
        else
        begin
            //ϐ̉\
            temp := Trim(Data);
            Target := ValueResolve(Inf, nil, temp, nil, False);
            //Rs[쐬
            VarCopy(Target, Result, Inf.Parent.Server);
            Target.Free;
        end;
    end;
end;

procedure TJaRuntime.Inc_Exec(Index : Integer);
var
    CallInf : TScriptCall;
    Global : TVirtualObject;
    PrevLine : Integer;
    PrevFile : String;
begin
    PrevLine := Error.Line;
    PrevFile := Error.FileName;

    Global := Globals[Index];
    CallInf.Code := PChar(Global.Reference.PreCode);
    CallInf.Index := 0;
    CallInf.Length := Length(Global.Reference.PreCode);
    CallInf.Parent := Global;
    CallInf.Vars := nil;
    CallInf.Return := nil;
    CallInf.Continued := False;
    CallInf.BreakLevel := 0;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := nil;

    //R[h
    Run(CallInf);

    CallInf.Code := PChar(TJaGlobal(Global.Reference).Main);
    CallInf.Index := 0;
    CallInf.Length := Length(TJaGlobal(Global.Reference).Main);
    Error.Line := 1;
    Error.FileName := Script.Scripts[0].ScriptFile;

    if CallInf.Return <> nil then
    begin
        CallInf.Return.Free;
        CallInf.Return := nil;
    end;

    //{̂̎s
    Run(CallInf);
    //CallInf.Vars.Free;

    if CallInf.Return <> nil then
        CallInf.Return.Free;

    Error.Line := PrevLine;
    Error.FileName := PrevFile;
end;

procedure TJaRuntime.ExecOption;
var
    CallInf : TScriptCall;
    Global : TVirtualObject;
begin
    if OptionCode = '' then Exit;

    Global := Globals[0];
    CallInf.Code := PChar(OptionCode);
    CallInf.Index := 0;
    CallInf.Length := Length(OptionCode);
    CallInf.Parent := Global;
    CallInf.Vars := Variants;
    CallInf.Return := nil;
    CallInf.Continued := False;
    CallInf.BreakLevel := 0;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := nil;

    //R[h
    Run(CallInf);
end;

procedure TJaRuntime.Run_IncFile(Name : String);
var
    n : Integer;
begin
    for n := 0 to Script.Count - 1 do
    begin
        if Script.Scripts[n].ScriptFile = Name then
        begin
            Inc_Exec(n);
            Break;
        end;
    end;
end;

function TJaRuntime.MakeInstance(var Inf : TScriptCall ; Name : String) : TVirtualObject;
var
    Design : TJaObject;
    n : Integer;
    CallInf : TScriptCall;

    procedure ObjectInit;
    begin
        CallInf.Code := PChar(Result.Reference.PreCode);
        CallInf.Index := 0;
        CallInf.Length := Length(Result.Reference.PreCode);
        CallInf.Parent := Result;
        CallInf.Vars := TVariantList.Create(Inf.Parent.Server);
        CallInf.Return := nil;
        CallInf.BreakLevel := 0;
        CallInf.Continued := False;
        CallInf.Exception := False;
        CallInf.Switch := nil;
        CallInf.WithState := nil;

        //R[h
        Run(CallInf);
        CallInf.Vars.Free;

        if CallInf.Return <> nil then
            CallInf.Return.Free;
    end;

begin
    Result := nil;

    //ĂXNvg̃IuWFNgT[o
    Design := Inf.Parent.Global.Server.GetClass(Name);

    if Design <> nil then
    begin
        Result := Inf.Parent.Global.Server.PrepareInstance(Name);
        ObjectInit;
        Exit;
    end;

    //CN[hĂt@C
    for n := Inf.Parent.Global.Include_Count - 1 downto 0 do
    begin
        Design := Inf.Parent.Global.Includes[n].Server.GetClass(Name);

        if Design <> nil then
        begin
            Result := Inf.Parent.Global.Includes[n].Server.PrepareInstance(Name);
            ObjectInit;
            Exit;
        end;
    end;

    if Result = nil then
        Result := MakeUndefined(Inf.Parent.Server);
end;

procedure TJaRuntime.ForStatement(var Inf : TScriptCall);
var
    n : Integer;
    ch : Char;
    Step : Integer;
    QuotType : TQuoteType;
    BackSlash : Boolean;
    temp : String;
    Target : TVirtualObject;
    CallInf : TScriptCall;

    InitCode : String;
    TestCode : String;
    IncCode : String;
    MainCode : String;
    StartLine : Integer;
    EndLine : Integer;
begin
    n := Inf.Index + 1;
    temp := '';
    Step := 0;
    QuotType := qtNone;
    BackSlash := False;

    //R[h𔲂o
    while n < Inf.Length do
    begin
        ch := (Inf.Code + n)^;

        if BackSlash then
        begin
            BackSlash := False;
            temp := temp + ch;
            n := n + 1;
            Continue;
        end;

        case ch of
            ';':
                begin
                    if (Step = 0) and (QuotType = qtNone) then
                    begin
                        n := n + 1;
                        Break;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;

            '\':
                begin
                    if (QuotType <> qtNone)
                        and (ByteType(Inf.Code, n + 1) = btSingle) then
                            BackSlash := True;
                end;
        end;

        temp := temp + ch;
        n := n + 1;
    end;

    //R[h擾
    InitCode := Trim(temp);

    //eXgR[h𔲂o
    temp := '';

    while n < Inf.Length do
    begin
        ch := (Inf.Code + n)^;

        if BackSlash then
        begin
            BackSlash := False;
            temp := temp + ch;
            n := n + 1;
            Continue;
        end;

        case ch of
            ';':
                begin
                    if (Step = 0) and (QuotType = qtNone) then
                    begin
                        n := n + 1;
                        Break;
                    end;
                end;

            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                        Step := Step - 1;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;

            '\':
                begin
                    if (QuotType <> qtNone)
                        and (ByteType(Inf.Code, n + 1) = btSingle) then
                            BackSlash := True;
                end;
        end;

        temp := temp + ch;
        n := n + 1;
    end;

    //eXgR[h擾
    TestCode := Trim(temp);

    //CNgR[h𔲂o
    temp := '';

    while n < Inf.Length do
    begin
        ch := (Inf.Code + n)^;

        if BackSlash then
        begin
            BackSlash := False;
            temp := temp + ch;
            n := n + 1;
            Continue;
        end;

        case ch of
            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                        Step := Step + 1;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                    begin
                        if Step = 0 then
                        begin
                            n := n + 1;
                            Break;
                        end;

                        Step := Step - 1;
                    end;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;

            '\':
                begin
                    if (QuotType <> qtNone)
                        and (ByteType(Inf.Code, n + 1) = btSingle) then
                            BackSlash := True;
                end;
        end;

        temp := temp + ch;
        n := n + 1;
    end;

    //CNgR[h擾
    IncCode := Trim(temp);

    //)ŏ̗L܂ŃXLbv
    Inf.Index := n;
    SkipNonsenseChar(Inf);
    ch := (Inf.Code + Inf.Index)^;
    StartLine := Error.Line;

    //R[h{̂擾
    if ch = '{' then
    begin
        Inf.Index := Inf.Index + 1;
        MainCode := GetWide(Inf);
        Inf.Index := Inf.Index + 1;
    end
    else
        MainCode := GetOneStatement(Inf);

    //݂̏ۑ
    EndLine := Error.Line;

    CallInf.Code := PChar(MainCode);
    CallInf.Length := Length(MainCode);
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel + 1;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := Inf.WithState;

    //R[h̎s
    Target := ToObject(CallInf, InitCode);
    Target.Free;

    while True do
    begin
        //eXgR[h̎s
        Target := ToObject(CallInf, TestCode);

        if not ForceBool(Target) then
        begin
            //𖞂ĂȂ烋[vI
            Target.Free;
            Break;
        end
        else
            Target.Free;

        if CallInf.Return <> nil then
        begin
            //߂lZbgꂽ֐𔲂
            Inf.Return := CallInf.Return;
            Break;
        end;

        if CallInf.Exception then
        begin
            //sG[
            Inf.Exception := True;
            Break;
        end;

        if ExitFlag then Exit;

        //CR[h̎s
        Error.Line := StartLine;
        CallInf.Index := 0;
        Run(CallInf);

        //breakXe[ggꂽforXe[gg𔲂
        if CallInf.BreakLevel <= Inf.BreakLevel then
        begin
            if CallInf.Continued then
            begin
                CallInf.Continued := False;
                CallInf.BreakLevel := Inf.BreakLevel + 1;
            end
            else
                Break;
        end;

        //CNgR[h̎s
        Target := ToObject(CallInf, IncCode);
        Target.Free;
    end;

    Error.Line := EndLine;
end;

procedure TJaRuntime.WhileStatement(var Inf : TScriptCall);
var
    ch : Char;
    temp : String;
    Target : TVirtualObject;
    CallInf : TScriptCall;

    TestCode : String;
    MainCode : String;
    StartLine : Integer;
    EndLine : Integer;
begin
    Inf.Index := Inf.Index + 1;
    temp := '';

    //eXgR[h𔲂o
    TestCode := GetSmall(Inf);
    Inf.Index := Inf.Index + 1;

    //)ŏ̗L܂ŃXLbv
    SkipNonsenseChar(Inf);
    StartLine := Error.Line;
    ch := (Inf.Code + Inf.Index)^;

    //R[h{̂擾
    if ch = '{' then
    begin
        Inf.Index := Inf.Index + 1;
        MainCode := GetWide(Inf);
        Inf.Index := Inf.Index + 1;
    end
    else
        MainCode := GetOneStatement(Inf);

    //݂̏ۑ
    EndLine := Error.Line;

    CallInf.Code := PChar(MainCode);
    CallInf.Length := Length(MainCode);
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel + 1;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := Inf.WithState;

    while True do
    begin
        //eXgR[h̎s
        Target := ToObject(CallInf, TestCode);

        if not ForceBool(Target) then
        begin
            //𖞂ĂȂ烋[vI
            Target.Free;
            Break;
        end
        else
            Target.Free;

        if CallInf.Return <> nil then
        begin
            //߂lZbgꂽ֐𔲂
            Inf.Return := CallInf.Return;
            Break;
        end;

        if CallInf.Exception then
        begin
            //sG[
            Inf.Exception := True;
            Break;
        end;

        if ExitFlag then
        begin
            Exit;
        end;

        //CR[h̎s
        Error.Line := StartLine;
        CallInf.Index := 0;
        Run(CallInf);

        //breakXe[ggꂽwhileXe[gg𔲂
        if CallInf.BreakLevel <= Inf.BreakLevel then
        begin
            if CallInf.Continued then
            begin
                CallInf.Continued := False;
                CallInf.BreakLevel := Inf.BreakLevel + 1;
            end
            else
                Break;
        end;
    end;

    Error.Line := EndLine;
end;

(*
procedure TJaRuntime.IfStatement(var Inf : TScriptCall);
var
    ch : Char;
    temp : String;
    Target : TVirtualObject;
    CallInf : TScriptCall;
    Prev : Integer;
    PrevLine : Integer;
    TestCode : String;
    MainCode : String;
    ElseCode : String;
    StartLine : Integer;
    EStartLine : Integer;
    LastLine : Integer;
begin
    EStartLine := 0;
    Inf.Index := Inf.Index + 1;

    //eXgR[h𔲂o
    TestCode := Trim(GetSmall(Inf));
    Inf.Index := Inf.Index + 1;

    //)ŏ̗L܂ŃXLbv
    SkipNonsenseChar(Inf);
    ch := (Inf.Code + Inf.Index)^;
    StartLine := Error.Line;

    //R[h{̂擾
    if ch = '{' then
    begin
        Inf.Index := Inf.Index + 1;
        MainCode := GetWide(Inf);
        Inf.Index := Inf.Index + 1;
    end
    else
        MainCode := GetOneStatement(Inf);

    //݂̏ۑ
    Prev := Inf.Index;
    PrevLine := Error.Line;

    //}ŏ̗L܂ŃXLbv
    SkipNonsenseChar(Inf);

    //elseL邩ǂH
    temp := Trim(GetSingleWord(Inf));

    //temp='else'̂Ƃelseȉ̕擾
    if temp = 'else' then
    begin
        //L܂ł̃XLbv
        SkipNonsenseChar(Inf);

        ch := (Inf.Code + Inf.Index)^;
        EStartLine := Error.Line;

        //R[h{̂擾
        if ch = '{' then
        begin
            Inf.Index := Inf.Index + 1;
            ElseCode := GetWide(Inf);
            Inf.Index := Inf.Index + 1;
        end
        else
            ElseCode := GetOneStatement(Inf);
    end
    else
    begin
        ElseCode := '';
        Inf.Index := Prev;
        Error.Line := PrevLine;
    end;

    //ݒ
    LastLine := Error.Line;

    //eXgR[h̎s
    Target := ToObject(Inf, TestCode);

    //s̐ݒ
    CallInf.Index := 0;
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := Inf.WithState;

    if ForceBool(Target) then
    begin
        //𖞂Ƃ
        Error.Line := StartLine;
        CallInf.Code := PChar(MainCode);
        CallInf.Length := Length(MainCode);
        Run(CallInf);
    end
    else if ElseCode <> '' then
    begin
        //𖞂ĂȂƂ
        Error.Line := EStartLine;
        CallInf.Code := PChar(ElseCode);
        CallInf.Length := Length(ElseCode);
        Run(CallInf);
    end;

    //߂l
    Inf.Return := CallInf.Return;
    Inf.BreakLevel := CallInf.BreakLevel;
    Inf.Continued := CallInf.Continued;

    //s̍sݒ
    Error.Line := LastLine;

    //eXgR[ȟʂj
    Target.Free;
end;
*)

procedure TJaRuntime.IfStatement(var Inf : TScriptCall);
var
    ch : Char;
    temp : String;
    Target : TVirtualObject;
    CallInf : TScriptCall;
    Prev : Integer;
    PrevLine : Integer;
    TestCode : String;
    MainCode : String;
    StartLine : Integer;
    LastLine : Integer;
    ElseOnly : Boolean;
    Satisfied : Boolean;
begin
	ElseOnly := False;
    Satisfied := False;

    CallInf.Index := 0;
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := Inf.WithState;

	repeat
	    //eXgR[h𔲂o
        if ElseOnly then
        begin
        	TestCode := '';
        end
        else
        begin
	    	Inf.Index := Inf.Index + 1;
	    	TestCode := Trim(GetSmall(Inf));
		    Inf.Index := Inf.Index + 1;
        end;

	    //)ŏ̗L܂ŃXLbv
   		SkipNonsenseChar(Inf);
	    ch := (Inf.Code + Inf.Index)^;
   		StartLine := Error.Line;

	    //R[h{̂擾
    	if ch = '{' then
	    begin
    	    Inf.Index := Inf.Index + 1;
	        MainCode := GetWide(Inf);
    	    Inf.Index := Inf.Index + 1;
	    end
    	else
	        MainCode := GetOneStatement(Inf);

	    //}ŏ̗L܂ŃXLbv
    	SkipNonsenseChar(Inf);

	    //ݒ
    	LastLine := Error.Line;

	    //eXgR[h̎s
        if TestCode = '' then
        begin
        	if ElseOnly then
            	Target := ToObject(Inf, 'true')
            else
            	Target := ToObject(Inf, 'false');
        end
        else
	    	Target := ToObject(Inf, TestCode);

	    if ForceBool(Target) and (not Satisfied) then
        begin
	        //𖞂Ƃ
    	    Error.Line := StartLine;

		    //s̐ݒ
        	CallInf.Code := PChar(MainCode);
	        CallInf.Length := Length(MainCode);

            //s
	        Run(CallInf);

            //sς
            Satisfied := True;
        end;

        Target.Free;

	    //݂̏ۑ
    	Prev := Inf.Index;
	    PrevLine := Error.Line;

        //擾
	    temp := Trim(GetSingleWord(Inf));

        if temp <> 'else' then
        begin
        	Inf.Index := Prev;
            Error.Line := PrevLine;
        	Break;
        end;

	    //݂̏ۑ
    	Prev := Inf.Index;
	    PrevLine := Error.Line;

	    //}ŏ̗L܂ŃXLbv
    	SkipNonsenseChar(Inf);

	    temp := Trim(GetSingleWord(Inf));
		ElseOnly := temp <> 'if';

        if ElseOnly then
        begin
        	Inf.Index := Prev;
            Error.Line := PrevLine;
        end
        else
        begin
		    //}ŏ̗L܂ŃXLbv
    		SkipNonsenseChar(Inf);
        end;
    until False;

    //߂l
    Inf.Return := CallInf.Return;
    Inf.BreakLevel := CallInf.BreakLevel;
    Inf.Continued := CallInf.Continued;

    //s̍sݒ
    Error.Line := LastLine;

    //eXgR[ȟʂj
    //Target.Free;
end;

function TJaRuntime.SkipNonsenseChar(var Inf : TScriptCall) : String;
var
    ch : Char;
    Index : Integer;
begin
    Result := '';
    Index := Inf.Index;

    while Index < Inf.Length do
    begin
        ch := (Inf.Code + Index)^;

        case ch of
            #9, #10, ' ':
                begin
                    Result := Result + ch;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                    Result := Result + ch;
                end;

            else
                Break;
        end;

        Index := Index + 1;
    end;

    Inf.Index := Index;
end;

function TJaRuntime.GetSingleWord (var Inf : TScriptCall) : String;
var
    ch : Char;
    Index : Integer;
begin
    Result := '';
    Index := Inf.Index;

    while Index < Inf.Length do
    begin
        ch := (Inf.Code + Index)^;

        case ch of
            #9, #10, ' ', '(', '{':
                begin
                    Break;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                    Break;
                end;

            else
                Result := Result + ch;
        end;

        Index := Index + 1;
    end;

    Inf.Index := Index;
end;

function TJaRuntime.GetWide(var Inf : TScriptCall) : String;
var
    Step : Integer;
    Index : Integer;
    ch : Char;
    QuotType : TQuoteType;
begin
    Result := '';
    Step := 0;
    Index := Inf.Index;
    QuotType := qtNone;

    while Index < Inf.Length do
    begin
        ch := (Inf.Code + Index)^;

        case ch of
            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '{':
                begin
                    if QuotType = qtNone then
                    begin
                        Step := Step + 1;
                    end;
                end;

            '}':
                begin
                    if QuotType = qtNone then
                    begin
                        if Step = 0 then
                        begin
                            Break;
                        end;

                        Step := Step - 1;
                    end;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;
        end;

        Result := Result + ch;
        Index := Index + 1;
    end;

    Inf.Index := Index;
end;

function TJaRuntime.GetSmall(var Inf : TScriptCall) : String;
var
    Step : Integer;
    Index : Integer;
    ch : Char;
    QuotType : TQuoteType;
begin
    Result := '';
    Step := 0;
    Index := Inf.Index;
    QuotType := qtNone;

    while Index < Inf.Length do
    begin
        ch := (Inf.Code + Index)^;

        case ch of
            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            '(':
                begin
                    if QuotType = qtNone then
                    begin
                        Step := Step + 1;
                    end;
                end;

            ')':
                begin
                    if QuotType = qtNone then
                    begin
                        if Step = 0 then
                        begin
                            Break;
                        end;

                        Step := Step - 1;
                    end;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;
        end;

        Result := Result + ch;
        Index := Index + 1;
    end;

    Inf.Index := Index;
end;

function TJaRuntime.GetStringUntil(var Inf : TScriptCall ; FindChar : Char) : String;
var
    Index : Integer;
    ch : Char;
    QuotType : TQuoteType;
begin
    Result := '';
    Index := Inf.Index;
    QuotType := qtNone;

    while Index < Inf.Length do
    begin
        ch := (Inf.Code + Index)^;

        case ch of
            '"':
                begin
                    if QuotType = qtNone then
                        QuotType := qtDouble
                    else if QuotType = qtDouble then
                        QuotType := qtNone;
                end;

            '''':
                begin
                    if QuotType = qtNone then
                        QuotType := qtSingle
                    else if QuotType = qtSingle then
                        QuotType := qtNone;
                end;

            #13:
                begin
                    Error.Line := Error.Line + 1;
                end;

            else
                begin
                    if ch = FindChar then Break;
                end;
        end;

        Result := Result + ch;
        Index := Index + 1;
    end;

    Inf.Index := Index;
end;

function TJaRuntime.GetOneStatement(var Inf : TScriptCall) : String;
var
    ch : Char;
    Prev, PrevLine : Integer;
    temp, stemp : String;
    QuotType : TQuoteType;
begin
    temp := '';
    QuotType := qtNone;

    //ȕXLbv
    Result := SkipNonsenseChar(Inf);

    //ŏ̃Xe[ggo
    Prev := Inf.Index;
    PrevLine := Error.Line;
    temp := GetSingleWord(Inf);
    stemp := Trim(temp);
    temp := temp + (Inf.Code + Inf.Index)^;

    if stemp = 'if' then
    begin
        Result := Result + temp;
        temp := '';

        //ȕXLbv
        temp := SkipNonsenseChar(Inf);
        Result := Result + temp;
        Inf.Index := Inf.Index + 1;

        //ʓ̃eXgR[h擾
        temp := GetSmall(Inf);
        Result := Result + temp + ')';
        Inf.Index := Inf.Index + 1;

        //ȕXLbv
        temp := SkipNonsenseChar(Inf);
        Result := Result + temp;

        ch := (Inf.Code + Inf.Index)^;

        if ch = '{' then
        begin
            Result := Result + temp + ch;
            Inf.Index := Inf.Index + 1;
            temp := GetWide(Inf) + '}';
            Inf.Index := Inf.Index + 1;
            Result := Result + temp;
        end
        else
        begin
            temp := GetOneStatement(Inf);
            Result := Result + temp;
        end;

        //ȕXLbv
        temp := SkipNonsenseChar(Inf);
        Result := Result + temp;

        Prev := Inf.Index;
        PrevLine := Error.Line;
        temp := GetSingleWord(Inf);
        stemp := Trim(temp);

        if stemp = 'else' then
        begin
            Result := Result + temp;
            temp := GetOneStatement(Inf);
            Result := Result + temp;
        end
        else
        begin
            Inf.Index := Prev;
            Error.Line := PrevLine;
        end;
    end
    else if stemp = 'for' then
    begin
        Result := Result + temp;
        temp := '';

        //ȕXLbv
        temp := SkipNonsenseChar(Inf);
        Result := Result + temp;
        Inf.Index := Inf.Index + 1;

        //ʓ̃eXgR[h擾
        temp := GetSmall(Inf);
        Result := Result + temp + ')';
        Inf.Index := Inf.Index + 1;

        //ȕXLbv
        temp := SkipNonsenseChar(Inf);
        Result := Result + temp;

        ch := (Inf.Code + Inf.Index)^;

        if ch = '{' then
        begin
            Result := Result + temp + ch;
            Inf.Index := Inf.Index + 1;
            temp := GetWide(Inf) + '}';
            Inf.Index := Inf.Index + 1;
            Result := Result + temp;
        end
        else
        begin
            temp := GetOneStatement(Inf);
            Result := Result + temp;
        end;
    end
    else
    begin
        temp := '';
        Inf.Index := Prev;
        Error.Line := PrevLine;

        while Inf.Index < Inf.Length do
        begin
            ch := (Inf.Code + Inf.Index)^;

            case ch of
                ';':
                    begin
                        if QuotType = qtNone then
                        begin
                            Result := Result + temp + ch;
                            Inf.Index := Inf.Index + 1;
                            Break;
                        end;
                    end;

                '"':
                    begin
                        if QuotType = qtNone then
                            QuotType := qtDouble
                        else if QuotType = qtDouble then
                            QuotType := qtNone;
                    end;

                '''':
                    begin
                        if QuotType = qtNone then
                            QuotType := qtSingle
                        else if QuotType = qtSingle then
                            QuotType := qtNone;
                    end;

                '{':
                    begin
                        if QuotType = qtNone then
                        begin
                            Result := Result + temp + ch;
                            Inf.Index := Inf.Index + 1;
                            temp := GetWide(Inf) + '}';
                            Inf.Index := Inf.Index + 1;
                            Result := Result + temp;
                            Break;
                        end;
                    end;

                #13:
                    begin
                        Error.Line := Error.Line + 1;
                    end;
            end;

            temp := temp + ch;
            Inf.Index := Inf.Index + 1;
        end;
    end;
end;

procedure TJaRuntime.SwitchStatement(var Inf : TScriptCall);
var
    TestCode : String;
    MainCode : String;
    ch : Char;
    PrevLine : Integer;
    LastLine : Integer;
    Target : TVirtualObject;
    CallInf : TScriptCall;
begin
    Inf.Index := Inf.Index + 1;
    //eXgR[h̎擾
    TestCode := GetSmall(Inf);
    Inf.Index := Inf.Index + 1;

    //)ŏ̗L܂ŃXLbv
    SkipNonsenseChar(Inf);

    ch := (Inf.Code + Inf.Index)^;

    if ch <> '{' then
    begin
        Error.RuntimeErr(errSyntax);
        Inf.Exception := True;
        Exit;
    end;

    Inf.Index := Inf.Index + 1;
    PrevLine := Error.Line;

    //eo
    MainCode := GetWide(Inf);
    Inf.Index := Inf.Index + 1;
    LastLine := Error.Line;
    Error.Line := PrevLine;

    //eXgR[h]
    Target := ToObject(Inf, TestCode);

    //Switch̓es
    CallInf.Index := 0;
    CallInf.Code := PChar(MainCode);
    CallInf.Length := Length(MainCode);
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel + 1;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := Target;
    CallInf.WithState := Inf.WithState;

    Run(CallInf);

    Error.Line := LastLine;
    Target.Free;
end;

procedure TJaRuntime.WithStatement(var Inf : TScriptCall);
var
    ch : Char;
    temp : String;
    Target : TVirtualObject;
    CallInf : TScriptCall;

    TestCode : String;
    MainCode : String;
    StartLine : Integer;
    EndLine : Integer;
begin
    Inf.Index := Inf.Index + 1;
    temp := '';

    //eXgR[h𔲂o
    TestCode := GetSmall(Inf);
    Inf.Index := Inf.Index + 1;

    //)ŏ̗L܂ŃXLbv
    SkipNonsenseChar(Inf);
    StartLine := Error.Line;
    ch := (Inf.Code + Inf.Index)^;

    //R[h{̂擾
    if ch = '{' then
    begin
        Inf.Index := Inf.Index + 1;
        MainCode := GetWide(Inf);
        Inf.Index := Inf.Index + 1;
    end
    else
        MainCode := GetOneStatement(Inf);

    //݂̏ۑ
    EndLine := Error.Line;

    CallInf.Code := PChar(MainCode);
    CallInf.Length := Length(MainCode);
    CallInf.Parent := Inf.Parent;
    CallInf.Return := Inf.Return;
    CallInf.Vars := Inf.Vars;
    CallInf.BreakLevel := Inf.BreakLevel + 1;
    CallInf.Continued := False;
    CallInf.Exception := False;
    CallInf.Switch := nil;
    CallInf.WithState := Inf.WithState;

    //eXgR[h̎s
    Target := ToObject(CallInf, TestCode);
    CallInf.WithState := Target;

    //CR[h̎s
    Error.Line := StartLine;
    CallInf.Index := 0;
    Run(CallInf);

    Inf.Return := CallInf.Return;
    Inf.Exception := CallInf.Exception;

    Target.Free;
    Error.Line := EndLine;
end;

procedure TJaRuntime.Quit;
begin
    ExitFlag := True;
    ProcessMessage;
end;

end.
