unit jp5_ps;

interface

uses
	ja_embed, tn_socket, tn_utils, tn_md5sup;

type
	TJaPop	=	class(TJaObject)
		private
			function login(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function quit(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function list(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function uidl(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function retr(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
			function dele(args : array of TVirtualObject ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
    	public
            constructor Create;
            destructor Destroy; override;
            procedure CreateObject(This : TVirtualObject); override;
            procedure FreeObject(This : TVirtualObject); override;
    end;

    TJaSmtp	=	class
    end;

implementation

constructor TJaPop.Create;
begin
    inherited;

    ClassName := 'Pop';

	//\bh̓o^
    AddFunction('login', login, 4);
    AddFunction('quit', quit, 0);
    AddFunction('list', list, 0);
    AddFunction('uidl', uidl, 0);
end;

destructor TJaPop.Destroy;
begin
    inherited;
end;

procedure TJaPop.CreateObject(This : TVirtualObject);
begin
	This.Data := Pointer(TNSocket.Create);
end;

procedure TJaPop.FreeObject(This : TVirtualObject);
begin
	TNSocket(This.Data).Free;
end;

function TJaPop.login(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
	sock : TNSocket;
    addr : String;
    port : Integer;
    user : String;
    pass : String;
    nan : Boolean;
    temp : String;
    md5str : String;
begin
	md5str := '';
	sock := TNSocket(This.Data);

	if High(args) <> 3 then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

	addr := ForceString(args[0]);
    port := ForceInt(args[1], nan);
	user := ForceString(args[2]);
	pass := ForceString(args[3]);

    if (addr = '') or (port = 0) or (sock.Connected) then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

	//ڑ
	if not sock.Connect(addr, port) then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

    temp := Trim(sock.ReadData(1024));

    if Copy(temp, 1, 3) = '+OK' then
		md5str := Trim(SliceString(temp, '<', '>'))
    else
    begin
	    Result := MakeBoolean(False, This.Server);
        sock.Close;
        Exit;
    end;

    //[UF
    if md5str = '' then
    begin
    	//WF
        sock.SendCommand('USER ' + user);
	    temp := Trim(sock.ReadData(1024));

        if Copy(temp, 1, 3) <> '+OK' then
        begin
		    Result := MakeBoolean(False, This.Server);
        	sock.Close;
        	Exit;
        end;

        sock.SendCommand('PASS ' + pass);
    end
    else
    begin
    	//APOPF
		sock.SendCommand('APOP ' + user + ' ' + MD5Encode('<' + md5str + '>' + pass));
    end;

    temp := Trim(sock.ReadData(1024));

    if Copy(temp, 1, 3) <> '+OK' then
    begin
    	Result := MakeBoolean(False, This.Server);
        sock.Close;
        Exit;
    end;

    Result := MakeBoolean(True, This.Server);
end;

function TJaPop.quit(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
	sock : TNSocket;
    temp : String;
begin
	sock := TNSocket(This.Data);

    if not sock.Connected then
    begin
	    Result := MakeBoolean(False, This.Server);
        Exit;
    end;

    sock.SendCommand('QUIT');
    temp := sock.ReadLine;
	sock.Close;

    if Copy(temp, 1, 3) = '+OK' then
	    Result := MakeBoolean(True, This.Server)
    else
	    Result := MakeBoolean(False, This.Server);
end;

function TJaPop.list(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
	sock : TNSocket;
    temp : String;
    ar : TArray;
begin
	sock := TNSocket(This.Data);

	if not sock.Connected then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//LISTR}hs
	sock.SendCommand('LIST');

    //M
    temp := Trim(sock.ReadLine);

    if Copy(temp, 1, 3) <> '+OK' then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//zIuWFNgp
	Result := This.Server.PrepareInstance('Array');
    ar := Result.Arrays;

    while True do
    begin
    	temp := Trim(sock.ReadLine);
        if temp = '.' then Break;
        ar.AddNext(MakeString(temp, This.Server));
    end;
end;

function TJaPop.uidl(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
	sock : TNSocket;
    temp : String;
    ar : TArray;
begin
	sock := TNSocket(This.Data);

	if not sock.Connected then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//UIDLR}hs
	sock.SendCommand('UIDL');

    //M
    temp := Trim(sock.ReadLine);

    if Copy(temp, 1, 3) <> '+OK' then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//zIuWFNgp
	Result := This.Server.PrepareInstance('Array');
    ar := Result.Arrays;

    while True do
    begin
    	temp := Trim(sock.ReadLine);
        if temp = '.' then Break;
        ar.AddNext(MakeString(temp, This.Server));
    end;
end;

function TJaPop.retr(args : array of TVirtualObject
                    ; This : TVirtualObject ; Error : TErrors) : TVirtualObject;
var
	index : Integer;
	sock : TNSocket;
    temp : String;
    ar : TArray;
    nan : Boolean;
begin
	sock := TNSocket(This.Data);

	if (not sock.Connected) or (High(args) <> 0) then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//RETRR}hs
	index := ForceInt(args[0], nan);
	sock.SendCommand('RETR ' + IntToStr(index));

    //M
    temp := Trim(sock.ReadLine);

    if Copy(temp, 1, 3) <> '+OK' then
    begin
	    Result := MakeUndefined(This.Server);
    	Exit;
    end;

	//zIuWFNgp
end;

end.
