/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.jpki.wrapper;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osdn.jpki.wrapper.InternalClassLoader;
import net.osdn.jpki.wrapper.JpkiException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;

public class JpkiWrapper {
    private Pattern ERROR_CODE_PATTERN = Pattern.compile("!ErrorCode=([-]?[0-9]+),WinErrorCode=([-]?[0-9]+)");
    private static ClassLoader loader;
    private static Class<?> clsJpkiWrapper;
    private static Throwable initializeError;
    private Object instance;
    private Method methodSetApplicationName;
    private Method methodSetApplicationVersion;
    private Method methodAddSignature;

    public JpkiWrapper() throws JpkiException, IOException, ClassNotFoundException, NoSuchFieldException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException {
        if (initializeError != null) {
            if (initializeError instanceof JpkiException) {
                throw (JpkiException)initializeError;
            }
            if (initializeError instanceof IOException) {
                throw (IOException)initializeError;
            }
            if (initializeError instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)initializeError;
            }
            if (initializeError instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)initializeError;
            }
            if (initializeError instanceof SecurityException) {
                throw (SecurityException)initializeError;
            }
            if (initializeError instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)initializeError;
            }
            if (initializeError instanceof IllegalAccessException) {
                throw (IllegalAccessException)initializeError;
            }
            throw new JpkiException(initializeError.getMessage(), initializeError.getLocalizedMessage(), initializeError);
        }
        this.instance = clsJpkiWrapper.newInstance();
        this.methodSetApplicationName = clsJpkiWrapper.getDeclaredMethod("setApplicationName", String.class);
        this.methodSetApplicationVersion = clsJpkiWrapper.getDeclaredMethod("setApplicationVersion", String.class);
        this.methodAddSignature = clsJpkiWrapper.getDeclaredMethod("addSignature", OutputStream.class, PDDocument.class, String.class, String.class, Date.class, String.class, String.class, SignatureOptions.class);
    }

    public void setApplicationName(String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.methodSetApplicationName.invoke(this.instance, name);
    }

    public void setApplicationVersion(String version) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.methodSetApplicationVersion.invoke(this.instance, version);
    }

    public void addSignature(OutputStream output, PDDocument document) throws JpkiException, IOException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        this.addSignature(output, document, null, null, null, null, null, null);
    }

    public void addSignature(OutputStream output, PDDocument document, SignatureOptions options) throws JpkiException, IOException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        this.addSignature(output, document, null, null, null, null, null, options);
    }

    public void addSignature(OutputStream output, PDDocument document, String name, String reason, Date date, String location, String contact, SignatureOptions options) throws JpkiException, IOException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        try {
            this.methodAddSignature.invoke(this.instance, output, document, name, reason, date, location, contact, options);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                Matcher m;
                String message = t.getMessage();
                if (message != null && message.charAt(0) == '!' && (m = this.ERROR_CODE_PATTERN.matcher(message)).matches()) {
                    int errorCode = Integer.parseInt(m.group(1));
                    int winErrorCode = Integer.parseInt(m.group(2));
                    throw new JpkiException(errorCode, winErrorCode, t.getCause());
                }
                throw (IOException)t;
            }
            throw e;
        }
    }

    private static ClassLoader createClassLoader(File jpkiInstallPath) throws ClassNotFoundException, IOException {
        File jarJPKIUserCertService;
        boolean is64 = JpkiWrapper.is64bitJavaVM();
        ArrayList<URL> jars = new ArrayList<URL>();
        File jarJPKICryptSignJNI = new File(jpkiInstallPath, is64 ? "JPKICryptSignJNI64.jar" : "JPKICryptSignJNI.jar");
        if (jarJPKICryptSignJNI.exists()) {
            jars.add(jarJPKICryptSignJNI.toURI().toURL());
        }
        if ((jarJPKIUserCertService = new File(jpkiInstallPath, is64 ? "JPKIUserCertService64.jar" : "JPKIUserCertService.jar")).exists()) {
            jars.add(jarJPKIUserCertService.toURI().toURL());
        }
        InternalClassLoader loader = new InternalClassLoader(is64, jars, JpkiWrapper.class.getClassLoader());
        return loader;
    }

    private static boolean is64bitJavaVM() {
        String s = System.getProperty("sun.arch.data.model");
        if ("64".equals(s)) {
            return true;
        }
        if ("32".equals(s)) {
            return false;
        }
        return false;
    }

    private static File getJpkiInstallPath() {
        File dir;
        String s = null;
        try {
            s = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\JPKI", (String)"InstallPath");
        }
        catch (Win32Exception e) {
            if (e.getErrorCode() != 2) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (s != null && (dir = new File(s)).exists() && dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    private static void addLibraryPath(String path) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        System.setProperty("java.library.path", path + ";" + System.getProperty("java.library.path"));
        Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
        sysPathsField.setAccessible(true);
        sysPathsField.set(null, null);
    }

    private static File getLibraryPath() throws URISyntaxException {
        ProtectionDomain pd = JpkiWrapper.class.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        URI uri = location.toURI();
        return new File(uri).getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.getAbsolutePath());
        }
        if (dst.exists() && dst.lastModified() == src.lastModified() && dst.length() == src.length()) {
            return;
        }
        FileInputStream input = null;
        OutputStream output = null;
        try {
            input = new FileInputStream(src);
            output = new FileOutputStream(dst);
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception exception) {}
            }
        }
        dst.setLastModified(src.lastModified());
    }

    static {
        try {
            File jpkiInstallPath = JpkiWrapper.getJpkiInstallPath();
            if (jpkiInstallPath == null) {
                initializeError = new JpkiException("JPKI user software was not found. Make sure that the JPKI user software is correctly installed.", "JPKI\u5229\u7528\u8005\u30bd\u30d5\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002JPKI\u5229\u7528\u8005\u30bd\u30d5\u30c8\u304c\u6b63\u3057\u304f\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", null);
            } else {
                boolean is64 = JpkiWrapper.is64bitJavaVM();
                String version = System.getProperty("java.version");
                if (version != null && version.startsWith("1.")) {
                    JpkiWrapper.addLibraryPath(jpkiInstallPath.getAbsolutePath());
                } else {
                    File libraryPath = JpkiWrapper.getLibraryPath();
                    if (is64) {
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKICSPSign64.dll"), new File(libraryPath, "JPKICSPSign64.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKI_JNI64.dll"), new File(libraryPath, "JPKI_JNI64.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKISign_JNI64.dll"), new File(libraryPath, "JPKISign_JNI64.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKIServiceAPI64.dll"), new File(libraryPath, "JPKIServiceAPI64.dll"));
                    } else {
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKICSPSign.dll"), new File(libraryPath, "JPKICSPSign.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKI_JNI.dll"), new File(libraryPath, "JPKI_JNI.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKISign_JNI.dll"), new File(libraryPath, "JPKISign_JNI.dll"));
                        JpkiWrapper.copy(new File(jpkiInstallPath, "JPKIServiceAPI.dll"), new File(libraryPath, "JPKIServiceAPI.dll"));
                    }
                }
                loader = JpkiWrapper.createClassLoader(jpkiInstallPath);
                clsJpkiWrapper = Class.forName("net.osdn.jpki.wrapper.internal.JpkiWrapperInternal", true, loader);
            }
        }
        catch (URISyntaxException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (IOException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (SecurityException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            initializeError = e;
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e) {
            initializeError = e;
            e.printStackTrace();
        }
    }
}

