/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.jpki.wrapper;

public class JpkiException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int SCARD_E_NOT_READY = -2146435056;
    public static final int SCARD_W_CANCELLED_BY_USER = -2146434962;
    private int errorCode;
    private int winErrorCode;
    private String message;
    private String localizedMessage;

    public JpkiException(int errorCode, int winErrorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.winErrorCode = winErrorCode;
        String[] messages = JpkiException.getMessages(errorCode, winErrorCode);
        if (messages != null) {
            this.message = messages[0];
            this.localizedMessage = messages[1];
        } else {
            this.message = cause.getMessage();
            this.localizedMessage = cause.getLocalizedMessage();
        }
    }

    public JpkiException(String message, String localizedMessage, Throwable cause) {
        super(cause);
        this.message = message;
        this.localizedMessage = localizedMessage != null ? localizedMessage : message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getWinErrorCode() {
        return this.winErrorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public static String[] getMessages(int errorCode, int winErrorCode) {
        switch (winErrorCode) {
            case -2146435056: {
                return new String[]{"The reader or smart card is not ready to accept commands.", "\u8aad\u307f\u53d6\u308a\u88c5\u7f6e\u307e\u305f\u306f\u30b9\u30de\u30fc\u30c8 \u30ab\u30fc\u30c9\u306f\u3001\u30b3\u30de\u30f3\u30c9\u3092\u53d7\u3051\u53d6\u308b\u6e96\u5099\u304c\u3067\u304d\u3066\u3044\u307e\u305b\u3093\u3002"};
            }
            case -2146434962: {
                return new String[]{"The action was cancelled by the user.", "\u30e6\u30fc\u30b6\u30fc\u306b\u3088\u3063\u3066\u64cd\u4f5c\u306f\u53d6\u308a\u6d88\u3055\u308c\u307e\u3057\u305f\u3002"};
            }
        }
        return null;
    }
}

