/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.Horizontal;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.Vertical;
import net.osdn.pdf_brewer.instruction.Instruction;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class Image
extends Instruction {
    private File file;
    private float scale = 1.0f;

    public Image(int indent, List<Object> params) {
        super(indent, params);
        for (int i = 0; i < params.size(); ++i) {
            String s;
            File file;
            Object obj = params.get(i);
            if (obj instanceof Number) {
                this.scale = ((Number)obj).floatValue();
                continue;
            }
            if (!(obj instanceof String) || !(file = new File(s = (String)obj)).exists()) continue;
            this.file = file;
        }
    }

    @Override
    public void process(PdfBrewer brewer, Context context) throws IOException {
        if (this.file == null) {
            return;
        }
        float pageHeight = brewer.getPage().getMediaBox().getHeight();
        PDDocument document = brewer.getDocument();
        PDImageXObject image = PDImageXObject.createFromFileByContent((File)this.file, (PDDocument)document);
        float imageWidth = (float)image.getWidth() * this.scale;
        float imageHeight = (float)image.getHeight() * this.scale;
        Horizontal hAlign = context.getHorizontalAlignment();
        Vertical vAlign = context.getVerticalAlignment();
        float ptLeft = Image.mm2pt(context.getLeft());
        float ptTop = Image.mm2pt(context.getTop());
        float ptRight = Image.mm2pt(context.getRight());
        float ptBottom = Image.mm2pt(context.getBottom());
        float ptX = hAlign == Horizontal.Right ? ptRight - imageWidth : (hAlign == Horizontal.Center ? ptLeft + (ptRight - ptLeft - imageWidth) / 2.0f : ptLeft);
        float ptY = vAlign == Vertical.Bottom ? ptBottom - imageHeight : (vAlign == Vertical.Center ? ptTop + (ptBottom - ptTop - imageHeight) / 2.0f : ptTop);
        PDPageContentStream stream = brewer.getContentStream();
        stream.drawImage(image, ptX, pageHeight - ptY - imageHeight, imageWidth, imageHeight);
    }
}

