/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.jpki.wrapper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.pdfbox.io.IOUtils;

public class InternalClassLoader
extends URLClassLoader {
    private Map<String, byte[]> entries = new HashMap<String, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalClassLoader(boolean is64, List<URL> urls, ClassLoader parent) throws IOException {
        super(urls.toArray(new URL[0]), parent);
        byte[] internalJar = null;
        if (internalJar == null) {
            InputStream is = null;
            is = is64 ? this.getClass().getResourceAsStream("/jpki-wrapper-internal64.jar") : this.getClass().getResourceAsStream("/jpki-wrapper-internal32.jar");
            try {
                if (is != null) {
                    internalJar = IOUtils.toByteArray((InputStream)is);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (internalJar != null) {
            try (JarInputStream jar = new JarInputStream(new ByteArrayInputStream(internalJar));){
                JarEntry entry;
                while ((entry = jar.getNextJarEntry()) != null) {
                    byte[] bytes = InternalClassLoader.readJarEntryBytes(jar);
                    this.entries.put(entry.getName(), bytes);
                }
            }
        }
    }

    private static byte[] readJarEntryBytes(JarInputStream in) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] bytes = new byte[65536];
        int len = 0;
        while (len != -1) {
            len = in.read(bytes);
            if (len <= 0) continue;
            buf.write(bytes, 0, len);
        }
        return buf.toByteArray();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String entryName = name.replace('.', '/') + ".class";
        byte[] bytes = this.entries.get(entryName);
        if (bytes != null) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }
}

