package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;

import org.compiere.util.DB;

public class InvoiceCorpSummary extends SvrProcess {


	private int			p_AD_Client_ID;
	private Timestamp	p_DateInvoiced_From = null;	//Mandatory
	private Timestamp	p_DateInvoiced_To = null;	//Mandatory



	@Override
	protected void prepare() {

		p_AD_Client_ID =getProcessInfo().getAD_Client_ID();
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (para[i].getParameter() == null){
				;
			}else if (name.equals("DateInvoiced")){
				p_DateInvoiced_From = (Timestamp)para[i].getParameter();
				p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();

			}else{
				log.log(Level.SEVERE, "Unknown Parameter: " + name);
			}//if
		}//for

	}

	@Override
	protected String doIt() throws Exception {
		String DateFrom = p_DateInvoiced_From.toString();
		String DateTo = p_DateInvoiced_To.toString();

		StringBuilder sql = new StringBuilder ("INSERT INTO T_InvoiceCorpSummary ")
							.append("(AD_PInstance_ID, AD_Client_ID, AD_Org_ID, C_Corporation_ID, DocBaseTYpe, C_Currency_ID, IsSOTrx, TotalLines, GrandTotal,DateInvoiced)")
							.append(" SELECT ").append(getAD_PInstance_ID())
							.append(" , inv.AD_Client_ID, 0, bp.C_Corporation_ID, dt.DocBaseType, inv.C_Currency_ID, inv.IsSOTrx, sum(inv.TotalLines), sum(inv.GrandTotal), ")
							.append(" TO_DATE('").append(DateFrom.substring(0,10)).append(" 12:00:00','YYYY-MM-DD HH24:MI:SS')")
							.append(" FROM C_Invoice inv")
							.append(" INNER JOIN C_BPartner bp ON (inv.C_BPartner_ID = bp.C_BPartner_ID)")
							.append(" INNER JOIN C_DocType dt ON (inv.C_DocType_ID = dt.C_DocType_ID)")
							.append(" WHERE inv.docstatus in ('CO','CL') AND bp.C_Corporation_ID is not null ")
							.append(" AND inv.AD_Client_ID = ").append(p_AD_Client_ID)
							.append(" AND inv.DateInvoiced >= TO_DATE('").append(DateFrom.substring(0,10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS')")
							.append(" AND inv.DateInvoiced <= TO_DATE('").append(DateTo.substring(0,10)).append(" 23:59:59','YYYY-MM-DD HH24:MI:SS')")
							.append(" GROUP BY inv.AD_Client_ID, bp.C_Corporation_ID, dt.DocBaseType, inv.C_Currency_ID, inv.IsSOTrx ;");


		int InsertRecords = DB.executeUpdateEx(sql.toString(), get_TrxName());
		if (log.isLoggable(Level.FINE)) log.fine("Inserted Records=" + InsertRecords);


		return "Inserted Records=" + InsertRecords;
	}

}
