/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.Cell;
import jp.co.nissy.jpicosheet.core.PicosheetException;
import jp.co.nissy.jpicosheet.core.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLoader {
    private static final String IGNORE_LINE_PATTERN = "^\\s*#|^\\s+|";
    private static Pattern _ignoreLinePattern = Pattern.compile("^\\s*#|^\\s+|");
    private static final String PARAMETER_PATTERN = "[^\\s=]+=[^\\s=]+";
    private static Pattern _parameterPattern = Pattern.compile("[^\\s=]+=[^\\s=]+");
    private static final String CELLNAME_VALUE_PATTERN = "([a-zA-Z_][a-zA-Z0-9_]*)=(.*)";
    private static final Pattern _cellnameValuePattern = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)=(.*)");
    Book _book;

    public TextLoader() {
        this._book = null;
    }

    public TextLoader(Book book) {
        this._book = book;
    }

    public Book load(BufferedReader br) throws IOException, PicosheetException {
        String line = null;
        while ((line = this.filterdRead(br)) != null) {
            String firstToken = this.getFirstToken(line);
            if (!firstToken.equalsIgnoreCase("beginbook")) continue;
            this.loadBook(line, br);
        }
        return this._book;
    }

    private void loadBook(String currentLine, BufferedReader br) throws PicosheetException, IOException {
        String line;
        if (this._book == null) {
            Map<String, String> params = this.getParams(currentLine);
            if (params.get("name") == null) {
                throw new PicosheetException("name not found.");
            }
            this._book = new Book(params.get("name"));
        }
        while ((line = this.filterdRead(br)) != null) {
            String firstToken = this.getFirstToken(line);
            if (firstToken.equalsIgnoreCase("beginsheet")) {
                this.loadSheet(line, br);
            }
            if (!firstToken.equalsIgnoreCase("endbook")) continue;
            return;
        }
    }

    private void loadSheet(String currentLine, BufferedReader br) throws PicosheetException, IOException {
        String line;
        Map<String, String> params = this.getParams(currentLine);
        if (params.get("name") == null) {
            throw new PicosheetException("name not found.");
        }
        this._book.addSheet(params.get("name"));
        while ((line = this.filterdRead(br)) != null) {
            String firstToken = this.getFirstToken(line);
            if (firstToken.equalsIgnoreCase("begincell")) {
                this.loadCell(line, br);
            }
            if (firstToken.equalsIgnoreCase("begintable")) {
                this.loadTable(line, br);
            }
            if (!firstToken.equalsIgnoreCase("endsheet")) continue;
            return;
        }
    }

    private void loadCell(String currentLine, BufferedReader br) throws PicosheetException, IOException {
        new CellCreator("endcell"){

            protected Cell createCell(String cellName) {
                return TextLoader.this._book.getResolver().getDefaultSheet().addCell(cellName);
            }
        }.process(br);
    }

    private void loadTable(String currentLine, BufferedReader br) throws PicosheetException, IOException {
        Map<String, String> params = this.getParams(currentLine);
        final String tableName = params.get("name");
        if (tableName == null) {
            throw new PicosheetException("name not found.");
        }
        int rowSize = 0;
        if (params.get("rowsize") == null) {
            throw new PicosheetException("rowsize not found.");
        }
        try {
            rowSize = Integer.parseInt(params.get("rowsize"));
        }
        catch (NumberFormatException nfe) {
            throw new PicosheetException("invalid rowsize: rowsize = " + params.get("rowsize"));
        }
        int colSize = 0;
        if (params.get("colsize") == null) {
            throw new PicosheetException("colsize not found.");
        }
        try {
            colSize = Integer.parseInt(params.get("colsize"));
        }
        catch (NumberFormatException nfe) {
            throw new PicosheetException("invalid colsize: colsize = " + params.get("colsize"));
        }
        this._book.getResolver().getDefaultSheet().addTable(tableName, rowSize, colSize);
        new CellCreator("endtable"){

            protected Cell createCell(String cellName) {
                Resolver resolver = TextLoader.this._book.getResolver();
                return resolver.getCell(String.valueOf(tableName) + cellName);
            }
        }.process(br);
    }

    private String filterdRead(BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            if (_ignoreLinePattern.matcher(line = line.trim()).matches()) continue;
            return line;
        }
        return null;
    }

    private String getFirstToken(String str) {
        String[] tokens = str.split("\\s");
        return tokens[0];
    }

    private Map<String, String> getParams(String line) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = _parameterPattern.matcher(line);
        while (m.find()) {
            int i = 0;
            while (i <= m.groupCount()) {
                if (m.group(i) != null) {
                    String[] paramValue = m.group(i).split("=");
                    map.put(paramValue[0].toLowerCase(), paramValue[1]);
                }
                ++i;
            }
        }
        return map;
    }

    private abstract class CellCreator {
        private String _endString;

        private CellCreator() {
        }

        public CellCreator(String endString) {
            this._endString = endString;
        }

        public void process(BufferedReader br) throws IOException, PicosheetException {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.equalsIgnoreCase(this._endString)) {
                    return;
                }
                Matcher m = _cellnameValuePattern.matcher(line);
                if (m.find() && m.groupCount() != 2) {
                    throw new PicosheetException("invalid cell definition.");
                }
                String cellName = m.group(1);
                String cellValue = m.group(2);
                Cell cell = this.createCell(cellName);
                if (cell == null) continue;
                cell.setValue(cellValue);
            }
        }

        protected abstract Cell createCell(String var1);
    }
}

