/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nissy.jpicosheet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.math.MathContext;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.co.nissy.jpicosheet.core.Book;
import jp.co.nissy.jpicosheet.core.ConcurrentBookWrapper;

public class SimpleReader {
    private ConcurrentBookWrapper _bookWrapper;

    public SimpleReader(ConcurrentBookWrapper cbr) {
        this._bookWrapper = cbr;
    }

    public void Read(BufferedReader br) throws IOException {
        try {
            String readLine;
            ReentrantReadWriteLock.WriteLock writeLock = this._bookWrapper.getWriteLock();
            Book book = this._bookWrapper.getBook(writeLock);
            book.recalcDisable();
            while ((readLine = this.revertingEscapedChars(br.readLine())) != null) {
                if (readLine.charAt(0) == '@') {
                    this.doAtmarkLine(book, readLine);
                    continue;
                }
                String cellName = readLine.substring(0, readLine.indexOf("\t"));
                String cellValue = readLine.substring(readLine.indexOf("\t") + 1);
                this._bookWrapper.setCellValue(cellName, cellValue);
            }
            book.recalcEnable();
        }
        finally {
            this._bookWrapper.releaseWriteLock();
        }
    }

    private String revertingEscapedChars(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src);
        int c = 0;
        while (c < sb.length()) {
            block0 : switch (sb.charAt(c)) {
                case '\\': {
                    if (c == sb.length()) {
                        throw new RuntimeException("invalid escape character at index " + Integer.toString(c) + " : " + sb.toString());
                    }
                    switch (sb.charAt(c + 1)) {
                        case '\\': {
                            sb.replace(c, c + 2, "\\");
                            break block0;
                        }
                        case 'n': {
                            sb.replace(c, c + 2, "\n");
                            break block0;
                        }
                    }
                    throw new RuntimeException("invalid escape character at index " + Integer.toString(c) + " : " + sb.toString());
                }
            }
            ++c;
        }
        return sb.toString();
    }

    private void doAtmarkLine(Book book, String line) {
        if (line.equals("@Book:name\t.*")) {
            String bookName = this.splitAtmarkValue(line);
            book.setName(bookName);
            return;
        }
        if (line.matches("@[^:]+:MathContext\t.*")) {
            String mathContextString = this.splitAtmarkValue(line);
            String sheetName = line.substring(1, line.indexOf(58));
            book.addSheet(sheetName).setMathContext(new MathContext(mathContextString));
            return;
        }
        if (line.matches("@[^:]+:Label\t.*")) {
            String labelString = this.splitAtmarkValue(line);
            String[] sheetCellName = line.substring(1, line.indexOf(58)).split("!");
            book.addSheet(sheetCellName[0]).addCell(sheetCellName[1]).setLabel(labelString);
            return;
        }
        if (line.matches("@[^:]+:Table\t.*")) {
            String[] rowcolStr = this.splitAtmarkValue(line).split(",");
            int rowSize = Integer.parseInt(rowcolStr[0]);
            int colSize = Integer.parseInt(rowcolStr[1]);
            String[] sheetTableName = line.substring(1, line.indexOf(58)).split("!");
            book.addSheet(sheetTableName[0]).addTable(sheetTableName[1], rowSize, colSize);
        }
        if (line.matches("@[^:]+:Group\t.*")) {
            String[] groupString = this.splitAtmarkValue(line).split(",");
            String[] sheetGroupName = line.substring(1, line.indexOf(58)).split("!");
            book.addSheet(sheetGroupName[0]).addGroup(sheetGroupName[1]).addCells(groupString);
        }
    }

    private String splitAtmarkValue(String atmarkLine) {
        if (atmarkLine.length() > atmarkLine.indexOf("\t") + 1) {
            return atmarkLine.substring(atmarkLine.indexOf("\t") + 1);
        }
        return "";
    }
}

