/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.DisposeWaySelectPage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageSelectPage;
import jp.thisnor.dre.app.SimilarEntrySelectPage;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.NormalFileEntry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

class DisposeExecutePage
extends DREPage {
    private DREFrame frame;
    private Messages messages;
    private Composite rootComp;
    private Label disposeProgressLabel;
    private ProgressBar disposeProgress;
    private Text logText;
    private Set<FileEntry> targetFileSet;
    private int disposeWay;
    private File dirMoveTo;
    private ExecutorService executor;
    private CountDownLatch disposeLatch;

    DisposeExecutePage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    @Override
    void createContents(Composite parent) {
        this.rootComp = new SashForm(parent, 512);
        Composite progressComp = new Composite(this.rootComp, 0);
        FormLayout l = new FormLayout();
        l.spacing = 8;
        progressComp.setLayout((Layout)l);
        this.disposeProgressLabel = new Label(progressComp, 0);
        this.disposeProgress = new ProgressBar(progressComp, 0);
        this.disposeProgress.setMinimum(0);
        this.disposeProgressLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(0, 160).top(0).build());
        this.disposeProgress.setLayoutData((Object)new FormDataBuilder().left((Control)this.disposeProgressLabel).right(100).top(0).build());
        this.logText = new Text(this.rootComp, 2570);
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("DisposeExecutePage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("DisposeExecutePage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setPreviousButtonEnabled(true);
        this.frame.setNextButtonEnabled(false);
        this.disposeProgressLabel.setText(this.messages.getString("DisposeExecutePage.DISPOSE_WAY_TEXT." + (this.disposeWay == 0 ? "DELETE" : "MOVE")));
        this.targetFileSet = this.frame.getPage(SimilarEntrySelectPage.class).getCheckedFileSet();
        DisposeWaySelectPage disposeWayPage = this.frame.getPage(DisposeWaySelectPage.class);
        this.disposeWay = disposeWayPage.getSelectedDisposeWay();
        this.dirMoveTo = new File(disposeWayPage.getDirectoryPathMoveTo());
        this.disposeProgress.setMaximum(this.targetFileSet.size());
        this.disposeProgress.setSelection(0);
        this.logText.setText("");
        int numThreads = this.frame.getPage(PackageSelectPage.class).getNumThreads();
        this.executor = Executors.newFixedThreadPool(numThreads + 1);
        this.disposeLatch = new CountDownLatch(this.targetFileSet.size());
        this.executor.execute(new WaitFinishTask());
        switch (this.disposeWay) {
            case 0: {
                for (FileEntry file : this.targetFileSet) {
                    this.executor.execute(new FileDeleteTask(file));
                }
                break;
            }
            case 1: {
                if (!this.dirMoveTo.exists()) {
                    MessageBox msgBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
                    msgBox.setText(this.messages.getString("DisposeExecutePage.CONFIRM_MKDIR_TITLE"));
                    msgBox.setMessage(this.messages.getString("DisposeExecutePage.CONFIRM_MKDIR_MESSAGE"));
                    if (msgBox.open() == 128) {
                        this.executor.shutdownNow();
                        return;
                    }
                    if (!this.dirMoveTo.mkdirs()) {
                        this.logText.setText(String.format(this.messages.getString("DisposeExecutePage.REPORT_FAILED_MKDIR_MESSAGE"), this.dirMoveTo.getPath()));
                        this.executor.shutdownNow();
                        return;
                    }
                }
                for (FileEntry file : this.targetFileSet) {
                    this.executor.execute(new FileMoveTask(file));
                }
                break;
            }
        }
        this.executor.shutdown();
    }

    @Override
    void hiddened() {
    }

    @Override
    void nextRequested() {
    }

    @Override
    void previousRequested() {
        if (!this.executor.isTerminated()) {
            MessageBox msgBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
            msgBox.setText(this.messages.getString("DisposeExecutePage.CONFIRM_ABORT_TITLE"));
            msgBox.setMessage(this.messages.getString("DisposeExecutePage.CONFIRM_ABORT_MESSAGE"));
            if (msgBox.open() == 128) {
                return;
            }
            this.executor.shutdownNow();
            while (!this.executor.isTerminated()) {
                try {
                    Thread.sleep(33L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        this.frame.setActivePage(this.frame.getPage(DisposeWaySelectPage.class));
    }

    @Override
    void dispose() {
    }

    private void incProgress() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DisposeExecutePage.this.disposeProgress.isDisposed()) {
                    DisposeExecutePage.this.disposeProgress.setSelection(DisposeExecutePage.this.disposeProgress.getSelection() + 1);
                }
            }
        });
    }

    private void log(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DisposeExecutePage.this.logText.isDisposed()) {
                    DisposeExecutePage.this.logText.append(String.valueOf(text) + "\n");
                }
            }
        });
    }

    private class FileDeleteTask
    implements Runnable {
        private final FileEntry file;

        private FileDeleteTask(FileEntry file) {
            this.file = file;
        }

        @Override
        public void run() {
            File f;
            if (this.file instanceof NormalFileEntry && !(f = new File(((NormalFileEntry)this.file).getPath())).delete()) {
                DisposeExecutePage.this.log(String.format(DisposeExecutePage.this.messages.getString("DisposeExecutePage.REPORT_FAILED_DELETE_MESSAGE"), this.file.getPath()));
            }
            DisposeExecutePage.this.disposeLatch.countDown();
            DisposeExecutePage.this.incProgress();
        }
    }

    private class FileMoveTask
    implements Runnable {
        private final FileEntry file;

        private FileMoveTask(FileEntry file) {
            this.file = file;
        }

        @Override
        public void run() {
            File newF;
            File f;
            if (this.file instanceof NormalFileEntry && !(f = new File(((NormalFileEntry)this.file).getPath())).renameTo(newF = new File(DisposeExecutePage.this.dirMoveTo, f.getName()))) {
                int dotPos = newF.getName().lastIndexOf(46);
                String name = dotPos >= 0 ? newF.getName().substring(0, dotPos) : newF.getName();
                String ext = dotPos >= 0 ? newF.getName().substring(dotPos) : "";
                boolean succeeded = false;
                int i = 1;
                while (i < 1000) {
                    newF = new File(DisposeExecutePage.this.dirMoveTo, String.format("%s(%3d)%s", name, i, ext));
                    if (f.renameTo(newF)) {
                        succeeded = true;
                        break;
                    }
                    ++i;
                }
                if (!succeeded) {
                    DisposeExecutePage.this.log(String.format(DisposeExecutePage.this.messages.getString("DisposeExecutePage.REPORT_FAILED_MOVE_MESSAGE"), this.file.getPath()));
                }
            }
            DisposeExecutePage.this.disposeLatch.countDown();
            DisposeExecutePage.this.incProgress();
        }
    }

    private class WaitFinishTask
    implements Runnable {
        private WaitFinishTask() {
        }

        @Override
        public void run() {
            try {
                DisposeExecutePage.this.disposeLatch.await();
                DisposeExecutePage.this.log(DisposeExecutePage.this.messages.getString("DisposeExecutePage.REPORT_COMPLETED_MESSAGE"));
            }
            catch (InterruptedException e) {
                DisposeExecutePage.this.log(DisposeExecutePage.this.messages.getString("DisposeExecutePage.REPORT_ABORTED_MESSAGE"));
            }
        }
    }
}

