/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.util.List;
import jp.thisnor.dre.core.MeasureEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.core.ProgressListener;
import jp.thisnor.dre.core.SynchronizedCounter;

public class LoadTask
implements Runnable {
    private final Measurer measurer;
    private final List<MeasureEntry> entryList;
    private final SynchronizedCounter counter;
    private final ProgressListener logger;

    public LoadTask(List<MeasureEntry> entryList, Measurer measurer, SynchronizedCounter counter, ProgressListener logger) {
        this.measurer = measurer;
        this.entryList = entryList;
        this.counter = counter;
        this.logger = logger;
    }

    @Override
    public void run() {
        int index;
        while ((index = this.counter.countup()) < this.entryList.size()) {
            MeasureEntry entry = this.entryList.get(index);
            try {
                entry.data = this.measurer.convert(entry.fileEntry);
            }
            catch (Exception e) {
                this.logger.log(String.format("%s: %s (%s)", entry.fileEntry.getPath(), e.getClass(), e.getLocalizedMessage()));
            }
            if (!Thread.interrupted()) continue;
            return;
        }
    }
}

