/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    int progress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    boolean showingText = false;
    Menu menu;
    static final int PROGRESS_MAX = 100;

    TaskItem(TaskBar taskBar, int n) {
        super(taskBar, n);
        this.parent = taskBar;
        taskBar.createItem(this, -1);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void recreate() {
        if (this.showingText) {
            if (this.overlayText.length() != 0) {
                this.updateText();
            }
        } else if (this.overlayImage != null) {
            this.updateImage();
        }
        if (this.progress != 0) {
            this.updateProgress();
        }
        if (this.progressState != -1) {
            this.updateProgressState();
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
        }
        if (this.shell != null) {
            return;
        }
        this.menu = menu;
        this.parent.setMenu(menu);
    }

    public void setOverlayImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayImage = image;
        if (image != null) {
            this.updateImage();
        } else if (this.overlayText.length() != 0) {
            this.updateText();
        } else {
            long l = this.parent.mTaskbarList3;
            long l2 = this.shell.handle;
            OS.VtblCall(18, l, l2, 0L, 0L);
        }
    }

    public void setOverlayText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayText = string;
        if (string.length() != 0) {
            this.updateText();
        } else if (this.overlayImage != null) {
            this.updateImage();
        } else {
            long l = this.parent.mTaskbarList3;
            long l2 = this.shell.handle;
            OS.VtblCall(18, l, l2, 0L, 0L);
        }
    }

    public void setProgress(int n) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progress == (n = Math.max(0, Math.min(n, 100)))) {
            return;
        }
        this.progress = n;
        this.updateProgress();
    }

    public void setProgressState(int n) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progressState == n) {
            return;
        }
        this.progressState = n;
        this.updateProgressState();
    }

    void setShell(Shell shell) {
        this.shell = shell;
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (TaskItem.this.isDisposed()) {
                    return;
                }
                TaskItem.this.dispose();
            }
        });
    }

    void updateImage() {
        this.showingText = false;
        Image image = null;
        long l = 0L;
        switch (this.overlayImage.type) {
            case 0: {
                image = Display.createIcon(this.overlayImage);
                l = image.handle;
                break;
            }
            case 1: {
                l = this.overlayImage.handle;
            }
        }
        long l2 = this.parent.mTaskbarList3;
        long l3 = this.shell.handle;
        OS.VtblCall(18, l2, l3, l, 0L);
        if (image != null) {
            image.dispose();
        }
    }

    void updateProgress() {
        if (this.progressState == 2) {
            return;
        }
        if (this.progressState == -1) {
            return;
        }
        long l = this.parent.mTaskbarList3;
        long l2 = this.shell.handle;
        OS.VtblCall(9, l, l2, (long)this.progress, 100L);
    }

    void updateProgressState() {
        int n = 0;
        switch (this.progressState) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 2: {
                n = 1;
            }
        }
        long l = this.parent.mTaskbarList3;
        long l2 = this.shell.handle;
        OS.VtblCall(9, l, l2, (long)this.progress, 100L);
        OS.VtblCall(10, l, l2, n);
    }

    void updateText() {
        this.showingText = true;
        int n = 16;
        int n2 = 16;
        long l = OS.GetDC(0L);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n;
        bITMAPINFOHEADER.biHeight = -n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        long[] lArray = new long[1];
        long l2 = OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
        if (l2 == 0L) {
            SWT.error(2);
        }
        long l3 = OS.CreateCompatibleDC(l);
        long l4 = OS.SelectObject(l3, l2);
        long l5 = OS.CreateBitmap(n, n2, 1, 1, null);
        if (l5 == 0L) {
            SWT.error(2);
        }
        long l6 = OS.CreateCompatibleDC(l);
        long l7 = OS.SelectObject(l6, l5);
        OS.PatBlt(l6, 0, 0, n, n2, 16711778);
        long l8 = OS.SelectObject(l6, OS.GetStockObject(4));
        OS.RoundRect(l6, 0, 0, n, n2, 8, 8);
        OS.SelectObject(l6, l8);
        long l9 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_HIGHLIGHT));
        l8 = OS.SelectObject(l3, l9);
        OS.RoundRect(l3, 0, 0, n, n2, 8, 8);
        OS.SelectObject(l3, l8);
        OS.DeleteObject(l9);
        int n3 = 2080;
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.shell.getCodePage(), this.overlayText, false);
        int n4 = tCHAR.length();
        long l10 = 0L;
        long l11 = 0L;
        NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
        nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
            LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
            lOGFONT.lfHeight = -10;
            l10 = OS.CreateFontIndirect(lOGFONT);
            l11 = OS.SelectObject(l3, l10);
            OS.DrawText(l3, tCHAR, n4, rECT, n3 | 0x400);
            if (rECT.right > n - 2) {
                OS.SelectObject(l3, l11);
                OS.DeleteObject(l10);
                lOGFONT.lfHeight = -8;
                l10 = OS.CreateFontIndirect(lOGFONT);
                OS.SelectObject(l3, l10);
            }
        }
        OS.DrawText(l3, tCHAR, n4, rECT, n3 | 0x400);
        OS.OffsetRect(rECT, (n - rECT.right) / 2, (n2 - rECT.bottom) / 2);
        int n5 = OS.SetBkMode(l3, 1);
        OS.SetTextColor(l3, OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT));
        OS.DrawText(l3, tCHAR, n4, rECT, n3);
        if (l10 != 0L) {
            OS.SelectObject(l3, l11);
            OS.DeleteObject(l10);
        }
        OS.SetBkMode(l3, n5);
        OS.SelectObject(l3, l4);
        OS.DeleteDC(l3);
        OS.SelectObject(l6, l7);
        OS.DeleteDC(l6);
        OS.ReleaseDC(0L, l);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = l2;
        iCONINFO.hbmMask = l5;
        long l12 = OS.CreateIconIndirect(iCONINFO);
        if (l12 == 0L) {
            SWT.error(2);
        }
        OS.DeleteObject(l2);
        OS.DeleteObject(l5);
        long l13 = this.parent.mTaskbarList3;
        long l14 = this.shell.handle;
        OS.VtblCall(18, l13, l14, l12, 0L);
        OS.DestroyIcon(l12);
    }
}

