/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.FileEntrySelectPage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.MeasureExecutePage;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageListViewer;
import jp.thisnor.dre.app.PackageViewer;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.MeasurerPackage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;

public class PackageSelectPage
extends DREPage {
    private static final File PACKAGE_DIR = new File("packages");
    private static final String PREFS_PACKAGE_KEY = "jp.thisnor.dre.core.PackageSelectPage.selectedpackage";
    private static final String PREFS_NUM_THREAD_KEY = "jp.thisnor.dre.core.PackageSelectPage.numthread";
    private MeasurerPackage[] packages;
    private DREFrame frame;
    private PreferenceStore prefs;
    private Messages messages;
    private SashForm rootComp;
    private PackageListViewer packageListViewer;
    private PackageViewer packageViewer;
    private Spinner numThreadsSpinner;
    private final SelectionListener PACKAGE_LIST_SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            PackageSelectPage.this.setActivePackage(PackageSelectPage.this.packageListViewer.getActivePackage());
        }
    };

    PackageSelectPage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    MeasurerPackage getSelectedPackage() {
        return this.packageListViewer.getActivePackage();
    }

    int getNumThreads() {
        return this.numThreadsSpinner.getSelection();
    }

    @Override
    void createContents(Composite parent) {
        ArrayList<MeasurerPackage> packageList = new ArrayList<MeasurerPackage>();
        File[] fileArray = PACKAGE_DIR.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File packageFile = fileArray[n2];
            try {
                packageList.add(MeasurerPackage.importPackage(packageFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.packages = packageList.toArray(new MeasurerPackage[packageList.size()]);
        this.prefs = this.frame.getPreferences();
        this.prefs.setDefault(PREFS_PACKAGE_KEY, "jp.thisnor.dre.simimg");
        this.prefs.setDefault(PREFS_NUM_THREAD_KEY, 2);
        this.rootComp = new SashForm(parent, 256);
        this.rootComp.setSashWidth(8);
        this.rootComp.setLayout((Layout)new FillLayout());
        this.packageListViewer = new PackageListViewer(this.packages);
        this.packageListViewer.createContents((Composite)this.rootComp);
        this.packageListViewer.getTable().addSelectionListener(this.PACKAGE_LIST_SELECTION_LISTENER);
        Composite rightComp = new Composite((Composite)this.rootComp, 0);
        FormLayout l = new FormLayout();
        l.spacing = 8;
        rightComp.setLayout((Layout)l);
        Group packageViewerGroup = new Group(rightComp, 0);
        FillLayout l2 = new FillLayout();
        l2.marginHeight = 8;
        l2.marginWidth = 8;
        packageViewerGroup.setLayout((Layout)l2);
        this.packageViewer = new PackageViewer(this.frame);
        this.packageViewer.createContents((Composite)packageViewerGroup);
        Composite systemOptionComp = new Composite(rightComp, 0);
        RowLayout l3 = new RowLayout(256);
        l3.spacing = 8;
        systemOptionComp.setLayout((Layout)l3);
        Label numThreadLabel = new Label(systemOptionComp, 0);
        numThreadLabel.setText(this.messages.getString("PackageSelectPage.NUM_THREADS_SPINNER_TEXT"));
        this.numThreadsSpinner = new Spinner(systemOptionComp, 2048);
        this.numThreadsSpinner.setMinimum(1);
        packageViewerGroup.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)systemOptionComp).build());
        systemOptionComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom(100).build());
        MeasurerPackage[] measurerPackageArray = this.packages;
        int n3 = this.packages.length;
        int n4 = 0;
        while (n4 < n3) {
            MeasurerPackage e = measurerPackageArray[n4];
            String className = e.getKey();
            for (MeasureOptionEntry option : e.getOptionMap().values()) {
                String prefsKey = String.valueOf(className) + "." + option.getKey();
                if (!this.prefs.contains(prefsKey)) continue;
                option.setValue(this.prefs.getString(prefsKey));
            }
            ++n4;
        }
        String defaultPackagePath = this.prefs.getString(PREFS_PACKAGE_KEY);
        TableItem[] tableItemArray = this.packageListViewer.getTable().getItems();
        int n5 = tableItemArray.length;
        n3 = 0;
        while (n3 < n5) {
            TableItem item = tableItemArray[n3];
            MeasurerPackage pack = (MeasurerPackage)item.getData();
            if (pack.getKey().equals(defaultPackagePath)) {
                this.packageListViewer.getTable().setSelection(item);
                this.setActivePackage(pack);
                break;
            }
            ++n3;
        }
        this.numThreadsSpinner.setSelection(this.prefs.getInt(PREFS_NUM_THREAD_KEY));
    }

    void setActivePackage(MeasurerPackage pack) {
        this.packageViewer.setActivePackage(pack);
        this.frame.setNextButtonEnabled(pack != null);
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("PackageSelectPage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("PackageSelectPage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setPreviousButtonEnabled(true);
        this.frame.setNextButtonEnabled(this.packageListViewer.getActivePackage() != null);
    }

    @Override
    void hiddened() {
        if (this.getSelectedPackage() != null) {
            MeasurerPackage selectedPackage = this.getSelectedPackage();
            this.prefs.setValue(PREFS_PACKAGE_KEY, selectedPackage.getKey());
        }
        this.prefs.setValue(PREFS_NUM_THREAD_KEY, this.getNumThreads());
        MeasurerPackage[] measurerPackageArray = this.packages;
        int n = this.packages.length;
        int n2 = 0;
        while (n2 < n) {
            MeasurerPackage e = measurerPackageArray[n2];
            String className = e.getKey();
            for (MeasureOptionEntry option : e.getOptionMap().values()) {
                String prefsKey = String.valueOf(className) + "." + option.getKey();
                this.prefs.setValue(prefsKey, option.getValue());
            }
            ++n2;
        }
    }

    @Override
    void nextRequested() {
        if (this.getSelectedPackage() == null) {
            MessageBox msgBox = new MessageBox(this.rootComp.getShell(), 32);
            msgBox.setText(this.messages.getString("PackageSelectPage.REPORT_FAILED_NOSELECTION_TITLE"));
            msgBox.setMessage(this.messages.getString("PackageSelectPage.REPORT_FAILED_NOSELECTION_MESSAGE"));
            msgBox.open();
            return;
        }
        this.frame.setActivePage(this.frame.getPage(MeasureExecutePage.class));
    }

    @Override
    void previousRequested() {
        this.frame.setActivePage(this.frame.getPage(FileEntrySelectPage.class));
    }

    @Override
    void dispose() {
    }
}

