/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.core.FileEntry;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class ImagePreviewer {
    private static final String PREFS_LOUPE_ZOOM_KEY = "jp.thisnor.dre.core.ImagePreviewer.loupeZoom";
    private static final String PREFS_LOUPE_RADIUS_KEY = "jp.thisnor.dre.core.ImagePreviewer.loupeRadius";
    private Image image;
    private DREFrame frame;
    private PreferenceStore prefs;
    private Messages messages;
    private Composite rootComp;
    private Canvas canvas;
    private Composite descComp;
    private Label titleLabel;
    private Label infoLabel;
    private Button loupeButton;
    private Spinner loupeZoomSpinner;
    private Spinner loupeRadiusSpinner;
    private Image viewImage;
    private int viewWidth;
    private int viewHeight;
    private int clientWidth;
    private int clientHeight;
    private boolean loupeEnabled;
    private int loupeX;
    private int loupeY;
    private int loupeWidth;
    private int loupeHeight;
    private double loupeZoom;
    private boolean mouseDown;
    private final PaintListener PREVIEW_IMAGE_PAINTER = new PaintListener(){

        public void paintControl(PaintEvent event) {
            GC gc = event.gc;
            Rectangle clientRect = ImagePreviewer.this.canvas.getClientArea();
            if (ImagePreviewer.this.image == null || ImagePreviewer.this.image.isDisposed()) {
                ImagePreviewer.this.image = null;
                gc.fillRectangle(clientRect.x, clientRect.y, clientRect.width, clientRect.height);
                return;
            }
            if (clientRect.width != ImagePreviewer.this.clientWidth || clientRect.height != ImagePreviewer.this.clientHeight) {
                if (ImagePreviewer.this.viewImage != null) {
                    ImagePreviewer.this.viewImage.dispose();
                }
                ImagePreviewer.this.clientWidth = clientRect.width;
                ImagePreviewer.this.clientHeight = clientRect.height;
                ImagePreviewer.this.viewImage = new Image((Device)Display.getCurrent(), ImagePreviewer.this.clientWidth, ImagePreviewer.this.clientHeight);
            }
            GC gc2 = new GC((Drawable)ImagePreviewer.this.viewImage);
            gc2.fillRectangle(0, 0, ImagePreviewer.this.clientWidth, ImagePreviewer.this.clientHeight);
            int imageWidth = ((ImagePreviewer)ImagePreviewer.this).image.getImageData().width;
            int imageHeight = ((ImagePreviewer)ImagePreviewer.this).image.getImageData().height;
            double clientAspect = (double)clientRect.width / (double)clientRect.height;
            double imageAspect = (double)imageWidth / (double)imageHeight;
            if (clientAspect > imageAspect) {
                ImagePreviewer.this.viewHeight = clientRect.height;
                ImagePreviewer.this.viewWidth = (int)((double)clientRect.height * imageAspect);
            } else {
                ImagePreviewer.this.viewWidth = clientRect.width;
                ImagePreviewer.this.viewHeight = (int)((double)clientRect.width / imageAspect);
            }
            gc2.drawImage(ImagePreviewer.this.image, 0, 0, imageWidth, imageHeight, 0, 0, ImagePreviewer.this.viewWidth, ImagePreviewer.this.viewHeight);
            if (ImagePreviewer.this.loupeEnabled) {
                double scaleRatio = (double)imageWidth / (double)ImagePreviewer.this.viewWidth;
                int loupeXOnSrc = (int)((double)ImagePreviewer.this.loupeX * scaleRatio);
                int loupeYOnSrc = (int)((double)ImagePreviewer.this.loupeY * scaleRatio);
                int widthOnSrc = (int)((double)ImagePreviewer.this.loupeWidth / ImagePreviewer.this.loupeZoom);
                int heightOnSrc = (int)((double)ImagePreviewer.this.loupeHeight / ImagePreviewer.this.loupeZoom);
                int leftOnSrc = loupeXOnSrc - widthOnSrc / 2;
                int topOnSrc = loupeYOnSrc - heightOnSrc / 2;
                if (leftOnSrc < 0) {
                    widthOnSrc -= 0 - leftOnSrc;
                    leftOnSrc = 0;
                }
                if (topOnSrc < 0) {
                    heightOnSrc -= 0 - topOnSrc;
                    topOnSrc = 0;
                }
                if (leftOnSrc + widthOnSrc >= imageWidth) {
                    widthOnSrc = imageWidth - leftOnSrc;
                }
                if (topOnSrc + heightOnSrc >= imageHeight) {
                    heightOnSrc = imageHeight - topOnSrc;
                }
                if (widthOnSrc > 0 && heightOnSrc > 0) {
                    int widthOnView = (int)((double)widthOnSrc * ImagePreviewer.this.loupeZoom);
                    int heightOnView = (int)((double)heightOnSrc * ImagePreviewer.this.loupeZoom);
                    int leftOnView = (int)((double)(leftOnSrc - loupeXOnSrc) * ImagePreviewer.this.loupeZoom) + ImagePreviewer.this.loupeX;
                    int topOnView = (int)((double)(topOnSrc - loupeYOnSrc) * ImagePreviewer.this.loupeZoom) + ImagePreviewer.this.loupeY;
                    Path clippingPath = new Path((Device)Display.getCurrent());
                    clippingPath.addArc((float)(ImagePreviewer.this.loupeX - ImagePreviewer.this.loupeWidth / 2), (float)(ImagePreviewer.this.loupeY - ImagePreviewer.this.loupeHeight / 2), (float)ImagePreviewer.this.loupeWidth, (float)ImagePreviewer.this.loupeHeight, 0.0f, 360.0f);
                    gc2.setClipping(clippingPath);
                    gc2.fillRectangle(leftOnView, topOnView, widthOnView, heightOnView);
                    gc2.drawImage(ImagePreviewer.this.image, leftOnSrc, topOnSrc, widthOnSrc, heightOnSrc, leftOnView, topOnView, widthOnView, heightOnView);
                    clippingPath.dispose();
                }
            }
            gc2.dispose();
            gc.drawImage(ImagePreviewer.this.viewImage, 0, 0);
        }
    };
    private final MouseListener MOUSE_CLICKED_ON_CANVAS = new MouseAdapter(){

        public void mouseDown(MouseEvent event) {
            if (ImagePreviewer.this.loupeEnabled) {
                ImagePreviewer.this.setLoupePosition(event.x, event.y);
            }
        }
    };
    private final MouseDragOnCanvasListener MOUSE_DRAGGED_ON_CANVAS = new MouseDragOnCanvasListener();
    private final SelectionListener LOUPE_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ImagePreviewer.this.setLoupeEnabled(ImagePreviewer.this.loupeButton.getSelection());
        }
    };
    private static final String[] FILE_SIZE_UNIT = new String[]{"byte", "KB", "MB", "GB"};

    ImagePreviewer(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    void createContents(Composite parent) {
        this.prefs = this.frame.getPreferences();
        this.prefs.setDefault(PREFS_LOUPE_ZOOM_KEY, 2.0);
        this.prefs.setDefault(PREFS_LOUPE_RADIUS_KEY, 100);
        this.rootComp = new Composite(parent, 0);
        this.rootComp.setLayout((Layout)new FormLayout());
        this.canvas = new Canvas(this.rootComp, 262144);
        this.canvas.addPaintListener(this.PREVIEW_IMAGE_PAINTER);
        this.canvas.addMouseListener(this.MOUSE_CLICKED_ON_CANVAS);
        this.canvas.addMouseListener((MouseListener)this.MOUSE_DRAGGED_ON_CANVAS);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.MOUSE_DRAGGED_ON_CANVAS);
        Composite controlComp = new Composite(this.rootComp, 0);
        controlComp.setLayout((Layout)new FormLayout());
        this.descComp = new Composite(controlComp, 0);
        this.descComp.setLayout((Layout)new RowLayout(512));
        this.titleLabel = new Label(this.descComp, 0);
        this.infoLabel = new Label(this.descComp, 0);
        Composite loupeComp = new Composite(controlComp, 0);
        RowLayout l = new RowLayout(256);
        l.spacing = 8;
        l.center = true;
        loupeComp.setLayout((Layout)l);
        this.loupeButton = new Button(loupeComp, 32);
        this.loupeButton.setText(this.messages.getString("ImagePreviewer.LOUPE_BUTTON_TEXT"));
        this.loupeButton.addSelectionListener(this.LOUPE_SELECTED);
        Composite loupeZoomComp = new Composite(loupeComp, 0);
        RowLayout l2 = new RowLayout(256);
        l2.center = true;
        loupeZoomComp.setLayout((Layout)l2);
        Label loupeZoomLabel = new Label(loupeZoomComp, 0);
        loupeZoomLabel.setText("x");
        this.loupeZoomSpinner = new Spinner(loupeZoomComp, 2048);
        this.loupeZoomSpinner.setMinimum(1);
        this.loupeZoomSpinner.setMaximum(8);
        this.loupeZoomSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ImagePreviewer.this.loupeZoom = ((Spinner)event.widget).getSelection();
                ImagePreviewer.this.prefs.setValue(ImagePreviewer.PREFS_LOUPE_ZOOM_KEY, ImagePreviewer.this.loupeZoom);
                ImagePreviewer.this.canvas.redraw();
            }
        });
        Composite loupeRadiusComp = new Composite(loupeComp, 0);
        RowLayout l3 = new RowLayout(256);
        l3.center = true;
        loupeRadiusComp.setLayout((Layout)l3);
        Label loupeRadiusLabel = new Label(loupeRadiusComp, 0);
        loupeRadiusLabel.setText("R");
        this.loupeRadiusSpinner = new Spinner(loupeRadiusComp, 2048);
        this.loupeRadiusSpinner.setMinimum(10);
        this.loupeRadiusSpinner.setMaximum(999);
        this.loupeRadiusSpinner.setIncrement(10);
        this.loupeRadiusSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int value = ((Spinner)event.widget).getSelection();
                ImagePreviewer.this.loupeWidth = value * 2;
                ImagePreviewer.this.loupeHeight = value * 2;
                ImagePreviewer.this.prefs.setValue(ImagePreviewer.PREFS_LOUPE_RADIUS_KEY, value);
                ImagePreviewer.this.canvas.redraw();
            }
        });
        this.descComp.setLayoutData((Object)new FormDataBuilder().left(0).right((Control)loupeComp).top(0).bottom(100).build());
        loupeComp.setLayoutData((Object)new FormDataBuilder().right(100).top(0).bottom(100).build());
        this.canvas.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)controlComp).build());
        controlComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom(100).build());
        this.setLoupeZoom(this.prefs.getDouble(PREFS_LOUPE_ZOOM_KEY));
        this.setLoupeRadius(this.prefs.getInt(PREFS_LOUPE_RADIUS_KEY));
    }

    void setFileEntry(final FileEntry entry) {
        if (this.image != null) {
            this.image.dispose();
        }
        if (entry == null) {
            this.titleLabel.setText("");
            this.infoLabel.setText("");
            this.canvas.redraw();
            this.descComp.layout();
        } else {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImagePreviewer.this.image = ImageUtils.loadImage(entry);
                    ImagePreviewer.this.titleLabel.setText(entry.getName());
                    StringBuilder infoText = new StringBuilder();
                    if (ImagePreviewer.this.image != null) {
                        ImageData data = ImagePreviewer.this.image.getImageData();
                        infoText.append(data.width).append('x').append(data.height).append(' ');
                        infoText.append(data.depth).append("bpp").append(' ');
                    }
                    if (!entry.isDirectory()) {
                        infoText.append(ImagePreviewer.this.getFileSizeDescription(entry.getSize()));
                    }
                    ImagePreviewer.this.infoLabel.setText(infoText.toString());
                    ImagePreviewer.this.canvas.redraw();
                    ImagePreviewer.this.descComp.layout();
                }
            });
        }
    }

    void setLoupeEnabled(boolean enabled) {
        this.loupeEnabled = enabled;
        this.loupeButton.setSelection(enabled);
        this.canvas.redraw();
    }

    void setMouseDown(boolean down) {
        this.mouseDown = down;
    }

    boolean getLoupeEnabled() {
        return this.loupeEnabled;
    }

    void setLoupePosition(int x, int y) {
        int dirtyLeft = Math.min(this.loupeX, x) - this.loupeWidth / 2;
        int dirtyTop = Math.min(this.loupeY, y) - this.loupeHeight / 2;
        int dirtyWidth = Math.abs(this.loupeX - x) + this.loupeWidth;
        int dirtyHeight = Math.abs(this.loupeY - y) + this.loupeHeight;
        if (x >= 0 && x < this.viewWidth) {
            this.loupeX = x;
        }
        if (y >= 0 && y < this.viewHeight) {
            this.loupeY = y;
        }
        this.canvas.redraw(dirtyLeft, dirtyTop, dirtyWidth, dirtyHeight, false);
    }

    int getLoupePositionX() {
        return this.loupeX;
    }

    int getLoupePositionY() {
        return this.loupeY;
    }

    void setLoupeZoom(double zoom) {
        this.loupeZoomSpinner.setSelection((int)zoom);
    }

    void setLoupeRadius(int radius) {
        this.loupeRadiusSpinner.setSelection(radius);
    }

    Control getControl() {
        return this.rootComp;
    }

    private String getFileSizeDescription(long byteSize) {
        int curUnitId = 0;
        if (byteSize < 1000L) {
            return String.valueOf(byteSize) + FILE_SIZE_UNIT[0];
        }
        long viewByteSize = byteSize * 10L;
        while (byteSize >> 10 > 0L && curUnitId < FILE_SIZE_UNIT.length - 1) {
            ++curUnitId;
            byteSize >>= 10;
            viewByteSize >>= 10;
        }
        return String.format("%d.%d%s", viewByteSize / 10L, viewByteSize % 10L, FILE_SIZE_UNIT[curUnitId]);
    }

    private class MouseDragOnCanvasListener
    implements MouseListener,
    MouseMoveListener {
        private MouseDragOnCanvasListener() {
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            if (event.button == 1) {
                ImagePreviewer.this.mouseDown = true;
            }
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                ImagePreviewer.this.mouseDown = false;
            }
        }

        public void mouseMove(MouseEvent event) {
            if (ImagePreviewer.this.loupeEnabled && ImagePreviewer.this.mouseDown) {
                ImagePreviewer.this.setLoupePosition(event.x, event.y);
            }
        }
    }
}

