/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.FileDropListViewer;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PackageSelectPage;
import jp.thisnor.dre.core.PathFilter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileEntrySelectPage
extends DREPage {
    private static final String PREFS_TARGET_FILES_KEY = String.valueOf(FileEntrySelectPage.class.getName()) + ".target.files";
    private static final String PREFS_SOURCE_FILES_KEY = String.valueOf(FileEntrySelectPage.class.getName()) + ".source.files";
    private static final String PREFS_SAME_TARGET_KEY = String.valueOf(FileEntrySelectPage.class.getName()) + ".sametarget";
    private static final String PREFS_USE_EXTENSION_FILTER_KEY = String.valueOf(FileEntrySelectPage.class.getName()) + ".use.extfilter";
    private static final String PREFS_EXTENSION_FILTER_KEY = String.valueOf(FileEntrySelectPage.class.getName()) + ".extfilter";
    private static final String DEFAULT_EXTENSION_FILTER = ".*\\.(?i:png|jpe?g|gif)";
    private DREFrame frame;
    private PreferenceStore prefs;
    private Messages messages;
    private SashForm rootComp;
    private FileDropListViewer targetFileListViewer;
    private FileDropListViewer storageFileListViewer;
    private Button sameTargetCheck;
    private Button extFilterCheck;
    private Text extFilterText;
    private final SelectionListener UPDATE_CONTENTS_ENABLED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileEntrySelectPage.this.updateContentsEnabled();
        }
    };

    FileEntrySelectPage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    @Override
    void createContents(Composite parent) {
        String path;
        int n;
        int n2;
        String[] stringArray;
        this.prefs = this.frame.getPreferences();
        this.prefs.setDefault(PREFS_TARGET_FILES_KEY, "");
        this.prefs.setDefault(PREFS_SOURCE_FILES_KEY, "");
        this.prefs.setDefault(PREFS_SAME_TARGET_KEY, true);
        this.prefs.setDefault(PREFS_USE_EXTENSION_FILTER_KEY, false);
        this.prefs.setDefault(PREFS_EXTENSION_FILTER_KEY, DEFAULT_EXTENSION_FILTER);
        this.prefs.setDefault(String.valueOf(PREFS_TARGET_FILES_KEY) + ".save", true);
        this.prefs.setDefault(String.valueOf(PREFS_SOURCE_FILES_KEY) + ".save", true);
        this.rootComp = new SashForm(parent, 256);
        this.rootComp.setSashWidth(8);
        this.rootComp.setLayout((Layout)new FillLayout());
        Group targetComp = new Group((Composite)this.rootComp, 0);
        targetComp.setText(this.messages.getString("FileEntrySelectPage.TARGET_TABLE_CAPTION"));
        FillLayout l = new FillLayout();
        l.marginHeight = 8;
        l.marginWidth = 8;
        targetComp.setLayout((Layout)l);
        this.targetFileListViewer = new FileDropListViewer(this.frame, (Composite)targetComp);
        Composite rightComp = new Composite((Composite)this.rootComp, 0);
        FormLayout l2 = new FormLayout();
        l2.spacing = 8;
        rightComp.setLayout((Layout)l2);
        Group storageComp = new Group(rightComp, 0);
        storageComp.setText(this.messages.getString("FileEntrySelectPage.SOURCE_TABLE_CAPTION"));
        FormLayout l3 = new FormLayout();
        l3.marginHeight = 8;
        l3.marginWidth = 8;
        l3.spacing = 8;
        storageComp.setLayout((Layout)l3);
        this.storageFileListViewer = new FileDropListViewer(this.frame, (Composite)storageComp);
        this.sameTargetCheck = new Button((Composite)storageComp, 32);
        this.sameTargetCheck.setText(this.messages.getString("FileEntrySelectPage.TARGET_AS_SOURCE_BUTTON_TEXT"));
        this.sameTargetCheck.addSelectionListener(this.UPDATE_CONTENTS_ENABLED);
        this.storageFileListViewer.getControl().setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)this.sameTargetCheck).build());
        this.sameTargetCheck.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom(100).build());
        Composite extFilterComp = new Composite(rightComp, 0);
        FormLayout l4 = new FormLayout();
        l4.marginHeight = 8;
        l4.marginWidth = 8;
        l4.spacing = 8;
        extFilterComp.setLayout((Layout)l4);
        this.extFilterCheck = new Button(extFilterComp, 32);
        this.extFilterCheck.setText(this.messages.getString("FileEntrySelectPage.TARGET_EXTENSION_LABEL_TEXT"));
        this.extFilterCheck.addSelectionListener(this.UPDATE_CONTENTS_ENABLED);
        this.extFilterText = new Text(extFilterComp, 2048);
        this.extFilterCheck.setLayoutData((Object)new FormDataBuilder().left(0).top(0).build());
        this.extFilterText.setLayoutData((Object)new FormDataBuilder().left((Control)this.extFilterCheck).right(100).top(0).build());
        storageComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)extFilterComp).build());
        extFilterComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).bottom(100).build());
        this.sameTargetCheck.setSelection(this.prefs.getBoolean(PREFS_SAME_TARGET_KEY));
        this.extFilterCheck.setSelection(this.prefs.getBoolean(PREFS_USE_EXTENSION_FILTER_KEY));
        this.extFilterText.setText(this.prefs.getString(PREFS_EXTENSION_FILTER_KEY));
        if (!this.prefs.getString(PREFS_TARGET_FILES_KEY).isEmpty()) {
            stringArray = this.prefs.getString(PREFS_TARGET_FILES_KEY).split(File.pathSeparator);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                path = stringArray[n];
                this.targetFileListViewer.addFile(path);
                ++n;
            }
        }
        if (!this.prefs.getString(PREFS_SOURCE_FILES_KEY).isEmpty()) {
            stringArray = this.prefs.getString(PREFS_SOURCE_FILES_KEY).split(File.pathSeparator);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                path = stringArray[n];
                this.storageFileListViewer.addFile(path);
                ++n;
            }
        }
        this.updateContentsEnabled();
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("FileEntrySelectPage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("FileEntrySelectPage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setPreviousButtonEnabled(false);
        this.frame.setNextButtonEnabled(true);
    }

    @Override
    void hiddened() {
        PreferenceStore prefs = this.frame.getPreferences();
        prefs.setValue(PREFS_SAME_TARGET_KEY, this.sameTargetCheck.getSelection());
        prefs.setValue(PREFS_USE_EXTENSION_FILTER_KEY, this.extFilterCheck.getSelection());
        prefs.setValue(PREFS_EXTENSION_FILTER_KEY, this.extFilterText.getText());
        if (prefs.getBoolean(String.valueOf(PREFS_TARGET_FILES_KEY) + ".save")) {
            prefs.setValue(PREFS_TARGET_FILES_KEY, this.fileEntryListToText(this.targetFileListViewer.getExtPathList()));
        }
        if (prefs.getBoolean(String.valueOf(PREFS_SOURCE_FILES_KEY) + ".save")) {
            prefs.setValue(PREFS_SOURCE_FILES_KEY, this.fileEntryListToText(this.storageFileListViewer.getExtPathList()));
        }
    }

    @Override
    void nextRequested() {
        this.frame.setActivePage(this.frame.getPage(PackageSelectPage.class));
    }

    @Override
    void previousRequested() {
    }

    @Override
    void dispose() {
        this.targetFileListViewer.dispose();
        this.storageFileListViewer.dispose();
    }

    List<String> getExtTargetFileList() {
        return this.targetFileListViewer.getExtPathList();
    }

    List<String> getExtStorageFileList() {
        return this.sameTargetCheck.getSelection() ? this.getExtTargetFileList() : this.storageFileListViewer.getExtPathList();
    }

    PathFilter getPathFilter() {
        if (this.extFilterCheck.getSelection()) {
            final Pattern pattern = Pattern.compile(this.extFilterText.getText());
            return new PathFilter(){

                @Override
                public boolean accept(String path) {
                    return pattern.matcher(path).matches();
                }
            };
        }
        return PathFilter.DEFAULT;
    }

    private void updateContentsEnabled() {
        this.storageFileListViewer.setEnabled(!this.sameTargetCheck.getSelection());
        this.extFilterText.setEnabled(this.extFilterCheck.getSelection());
    }

    private String fileEntryListToText(List<String> filePathList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String filePath : filePathList) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(filePath);
        }
        return sb.toString();
    }
}

