/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.NormalFileEntry;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class FileDropListViewer {
    private static final int SUBCHECK_COLUMN_WIDTH = 48;
    private static final String FILE_ICON_PATH = "res/icon/page32.png";
    private static final String IMAGE_FILE_ICON_PATH = "res/icon/image32.png";
    private static final String NO_FILE_ICON_PATH = "res/icon/page_remove32.png";
    private static final String EMPTY_FOLDER_ICON_PATH = "res/icon/folder32.png";
    private static final String APPEND_FILE_ICON_PATH = "res/icon/page_add_inactive32.png";
    private static final String APPEND_FOLDER_ICON_PATH = "res/icon/folder_add_inactive32.png";
    private static final String TABLE_EDITOR_KEY = "tableEditor";
    private Messages messages;
    private Composite rootComp;
    private Table fileTable;
    private TableItem appendDirItem;
    private TableItem appendFileItem;
    private Image fileIconImage;
    private Image imageFileIconImage;
    private Image noFileIconImage;
    private Image emptyFolderIconImage;
    private Image appendFileIconImage;
    private Image appendFolderIconImage;
    private ExecutorService computePropertiesExecutor;
    private Map<FileEntry, String> propertiesMap;
    private List<String> pathList;
    private boolean listChanged;
    private final SelectionListener FILE_TABLE_SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TableItem item = (TableItem)event.item;
            if (item == FileDropListViewer.this.appendDirItem) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 2);
                String path = dialog.open();
                if (path != null) {
                    FileDropListViewer.this.addFile(path);
                }
            } else if (item == FileDropListViewer.this.appendFileItem) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 2);
                dialog.open();
                if (dialog.getFileNames() != null) {
                    FileDropListViewer.this.addFiles(dialog.getFileNames());
                }
            }
        }
    };
    private final KeyListener FILE_TABLE_KEY_LISTENER = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            switch (event.keyCode) {
                case 0x1000009: {
                    DirectoryDialog dialog = new DirectoryDialog(FileDropListViewer.this.rootComp.getShell());
                    String path = dialog.open();
                    if (path == null) break;
                    FileDropListViewer.this.addFile(path);
                    break;
                }
                case 127: {
                    FileDropListViewer.this.removeItems(FileDropListViewer.this.fileTable.getSelectionIndices());
                }
            }
        }
    };
    private final ControlListener FILE_TABLE_RESIZE_LISTENER = new ControlAdapter(){

        public void controlResized(ControlEvent event) {
            FileDropListViewer.this.fileTable.getColumn(0).setWidth(((FileDropListViewer)FileDropListViewer.this).fileTable.getClientArea().width - 48);
        }
    };
    private final Listener FILE_TABLE_MEASURE_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            event.height = Math.max(event.height, 40);
        }
    };
    private final Listener FILE_TABLE_ERASE_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            event.detail &= 0xFFFFFFEF;
        }
    };
    private final Listener FILE_TABLE_PAINT_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            if (event.index != 0) {
                return;
            }
            TableItem item = (TableItem)event.item;
            if (item.getImage() == null) {
                return;
            }
            if (item == FileDropListViewer.this.appendDirItem || item == FileDropListViewer.this.appendFileItem) {
                GC gc = event.gc;
                gc.setForeground(Display.getCurrent().getSystemColor(33));
                gc.drawImage(item.getImage(), event.x + 4, event.y + 4);
                gc.drawText(item.getText(), event.x + 48, event.y + 20, true);
                return;
            }
            FileEntry fileEntry = (FileEntry)item.getData();
            String text = (String)FileDropListViewer.this.propertiesMap.get(fileEntry);
            if (text == null) {
                FileDropListViewer.this.computePropertiesExecutor.execute(new ComputeFilePropertiesTask(fileEntry));
            }
            GC gc = event.gc;
            gc.drawImage(item.getImage(), event.x + 4, event.y + 4);
            gc.drawText(fileEntry.getPath(), event.x + 48, event.y, true);
            gc.drawText(text != null ? text : FileDropListViewer.this.messages.getString("FileDropListViewer.REPORT_CALCULATING_MESSAGE"), event.x + 48, event.y + 20, true);
        }
    };
    private final DropTargetListener FILE_TABLE_DROP_LISTENER = new DropTargetAdapter(){

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 10;
        }

        public void drop(DropTargetEvent event) {
            int insertPos = event.item != null && event.item.getData() != null ? FileDropListViewer.this.fileTable.indexOf((TableItem)event.item) : FileDropListViewer.this.fileTable.getItemCount() - 2;
            FileDropListViewer.this.addFiles((String[])event.data, insertPos);
        }
    };
    private final DragSourceListener FILE_TABLE_DRAG_LISTENER = new DragSourceAdapter(){

        public void dragSetData(DragSourceEvent event) {
            TableItem[] items = FileDropListViewer.this.fileTable.getSelection();
            String[] pathes = new String[items.length];
            int i = 0;
            while (i < items.length) {
                pathes[i] = new File(((FileEntry)items[i].getData()).getPath()).getAbsolutePath();
                ++i;
            }
            event.data = pathes;
        }
    };
    private final SelectionListener FILE_TABLE_CHANGE_TO_DIR_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TableItem item = FileDropListViewer.this.fileTable.getSelection()[0];
            FileEntry entry = (FileEntry)item.getData();
            DirectoryDialog dialog = new DirectoryDialog(FileDropListViewer.this.rootComp.getShell());
            dialog.setFilterPath(entry.getPath());
            String path = dialog.open();
            if (path != null) {
                File file = new File(path);
                item.setImage(FileDropListViewer.this.getIcon(file));
                item.setText(path);
                item.setData((Object)new NormalFileEntry(file));
                if (item.getData(FileDropListViewer.TABLE_EDITOR_KEY) == null) {
                    FileDropListViewer.this.attachSubCheckEditor(item);
                }
            }
        }
    };
    private final SelectionListener FILE_TABLE_CHANGE_TO_FILE_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TableItem item = FileDropListViewer.this.fileTable.getSelection()[0];
            FileEntry entry = (FileEntry)item.getData();
            FileDialog dialog = new FileDialog(FileDropListViewer.this.rootComp.getShell());
            dialog.setFilterPath(entry.getPath());
            String path = dialog.open();
            if (path != null) {
                File file = new File(path);
                item.setImage(FileDropListViewer.this.getIcon(file));
                item.setText(path);
                item.setData((Object)new NormalFileEntry(file));
                if (item.getData(FileDropListViewer.TABLE_EDITOR_KEY) != null) {
                    TableEditor editor = (TableEditor)item.getData(FileDropListViewer.TABLE_EDITOR_KEY);
                    editor.getEditor().dispose();
                    editor.dispose();
                }
            }
        }
    };
    private final SelectionListener FILE_TABLE_REMOVE_ITEM_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDropListViewer.this.removeItems(FileDropListViewer.this.fileTable.getSelectionIndices());
        }
    };
    private final SelectionListener FILE_TABLE_CHECKBOX_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            FileDropListViewer.this.listChanged = true;
        }
    };
    private final Runnable FILE_TABLE_REDRAW_TASK = new Runnable(){

        @Override
        public void run() {
            if (!FileDropListViewer.this.fileTable.isDisposed()) {
                FileDropListViewer.this.fileTable.redraw();
            }
        }
    };
    private static final String[] FILE_SIZE_UNIT = new String[]{"byte", "KB", "MB", "GB"};

    FileDropListViewer(DREFrame frame, Composite parentComp) {
        this.messages = frame.getMessages();
        this.computePropertiesExecutor = Executors.newSingleThreadExecutor();
        this.propertiesMap = new WeakHashMap<FileEntry, String>();
        this.listChanged = true;
        this.fileIconImage = ImageUtils.loadImage(FILE_ICON_PATH);
        this.imageFileIconImage = ImageUtils.loadImage(IMAGE_FILE_ICON_PATH);
        this.noFileIconImage = ImageUtils.loadImage(NO_FILE_ICON_PATH);
        this.emptyFolderIconImage = ImageUtils.loadImage(EMPTY_FOLDER_ICON_PATH);
        this.appendFileIconImage = ImageUtils.loadImage(APPEND_FILE_ICON_PATH);
        this.appendFolderIconImage = ImageUtils.loadImage(APPEND_FOLDER_ICON_PATH);
        this.rootComp = new Composite(parentComp, 0);
        this.rootComp.setLayout((Layout)this.newFormLayout(8));
        this.fileTable = new Table(this.rootComp, 2562);
        this.fileTable.setLinesVisible(false);
        this.fileTable.addSelectionListener(this.FILE_TABLE_SELECTION_LISTENER);
        this.fileTable.addKeyListener(this.FILE_TABLE_KEY_LISTENER);
        this.fileTable.addControlListener(this.FILE_TABLE_RESIZE_LISTENER);
        this.fileTable.addListener(41, this.FILE_TABLE_MEASURE_ITEM_LISTENER);
        this.fileTable.addListener(40, this.FILE_TABLE_ERASE_ITEM_LISTENER);
        this.fileTable.addListener(42, this.FILE_TABLE_PAINT_ITEM_LISTENER);
        TableColumn fileColumn = new TableColumn(this.fileTable, 0);
        fileColumn.setText(this.messages.getString("FileDropListViewer.COLUMNS.FILE"));
        fileColumn.setWidth(0);
        TableColumn subCheckColumn = new TableColumn(this.fileTable, 0);
        subCheckColumn.setText(this.messages.getString("FileDropListViewer.COLUMNS.SUBENTRY"));
        subCheckColumn.setWidth(48);
        this.appendDirItem = new TableItem(this.fileTable, 0);
        this.appendDirItem.setImage(this.appendFolderIconImage);
        this.appendDirItem.setText(this.messages.getString("FileDropListViewer.ITEMS.APPEND_DIR"));
        this.appendFileItem = new TableItem(this.fileTable, 0);
        this.appendFileItem.setImage(this.appendFileIconImage);
        this.appendFileItem.setText(this.messages.getString("FileDropListViewer.ITEMS.APPEND_FILE"));
        Menu fileTableMenu = new Menu((Decorations)this.fileTable.getShell(), 8);
        MenuItem changeToDirMenuItem = new MenuItem(fileTableMenu, 8);
        changeToDirMenuItem.setText(this.messages.getString("FileDropListViewer.CONTEXT_MENU.OPEN_DIR"));
        changeToDirMenuItem.addSelectionListener(this.FILE_TABLE_CHANGE_TO_DIR_LISTENER);
        MenuItem changeToFileMenuItem = new MenuItem(fileTableMenu, 8);
        changeToFileMenuItem.setText(this.messages.getString("FileDropListViewer.CONTEXT_MENU.OPEN_FILE"));
        changeToFileMenuItem.addSelectionListener(this.FILE_TABLE_CHANGE_TO_FILE_LISTENER);
        MenuItem removeMenuItem = new MenuItem(fileTableMenu, 8);
        removeMenuItem.setText(this.messages.getString("FileDropListViewer.CONTEXT_MENU.REMOVE"));
        removeMenuItem.addSelectionListener(this.FILE_TABLE_REMOVE_ITEM_LISTENER);
        removeMenuItem.setAccelerator(127);
        this.fileTable.setMenu(fileTableMenu);
        this.fileTable.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom(100).build());
        DropTarget dropTarget = new DropTarget((Control)this.fileTable, 7);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener(this.FILE_TABLE_DROP_LISTENER);
        DragSource dragSource = new DragSource((Control)this.fileTable, 3);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(this.FILE_TABLE_DRAG_LISTENER);
    }

    Control getControl() {
        return this.rootComp;
    }

    void setEnabled(boolean enabled) {
        this.fileTable.setEnabled(enabled);
    }

    void addFile(String path) {
        this.addFile(path, this.fileTable.getItemCount() - 2);
    }

    void addFile(String path, int insertPos) {
        this.addFiles(new String[]{path}, insertPos);
    }

    void addFiles(String[] paths) {
        this.addFiles(paths, this.fileTable.getItemCount() - 2);
    }

    void addFiles(String[] paths, int insertPos) {
        this.addFilesRaw(paths, insertPos);
        this.updateCheckboxLocation(0);
    }

    List<String> getExtPathList() {
        if (this.listChanged) {
            this.pathList = new ArrayList<String>(this.fileTable.getItemCount() - 2);
            TableItem[] tableItemArray = this.fileTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item != this.appendDirItem && item != this.appendFileItem) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((FileEntry)item.getData()).getPath());
                    TableEditor editor = (TableEditor)item.getData(TABLE_EDITOR_KEY);
                    if (editor != null && ((Button)editor.getEditor()).getSelection()) {
                        sb.append("//");
                    }
                    this.pathList.add(sb.toString());
                }
                ++n2;
            }
            this.listChanged = false;
        }
        return this.pathList;
    }

    void dispose() {
        this.computePropertiesExecutor.shutdownNow();
    }

    private FormLayout newFormLayout(int spacing) {
        FormLayout l = new FormLayout();
        l.spacing = 8;
        return l;
    }

    private void addFilesRaw(String[] paths, int insertPos) {
        String p;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            p = stringArray[n2];
            int i = 0;
            while (i < this.fileTable.getItemCount() - 2) {
                FileEntry fe = (FileEntry)this.fileTable.getItem(i).getData();
                if (fe != null && fe.getPath().equals(p)) {
                    this.removeItemsRaw(new int[]{i});
                    if (insertPos > i) {
                        --insertPos;
                    }
                    --i;
                }
                ++i;
            }
            ++n2;
        }
        stringArray = paths;
        n = paths.length;
        n2 = 0;
        while (n2 < n) {
            p = stringArray[n2];
            this.newTableItem(p, insertPos++);
            ++n2;
        }
        this.listChanged = true;
    }

    private TableItem newTableItem(String pathex, int insertPos) {
        if (insertPos < 0 || insertPos >= this.fileTable.getItemCount()) {
            insertPos = this.fileTable.getItemCount();
        }
        String path = pathex.endsWith("//") ? pathex.substring(0, pathex.length() - 2) : pathex;
        File file = new File(path);
        Image icon = this.getIcon(file);
        TableItem item = new TableItem(this.fileTable, 0, insertPos);
        item.setImage(0, icon);
        item.setText(0, path);
        if (file.isDirectory()) {
            this.attachSubCheckEditor(item);
            Button bt = (Button)((TableEditor)item.getData(TABLE_EDITOR_KEY)).getEditor();
            if (pathex.endsWith("//")) {
                bt.setSelection(true);
            }
        }
        item.setData((Object)new NormalFileEntry(file));
        return item;
    }

    private void attachSubCheckEditor(TableItem item) {
        TableEditor editor = new TableEditor(this.fileTable);
        Button subButton = new Button((Composite)this.fileTable, 32);
        subButton.setText(this.messages.getString("FileDropListViewer.SUBENTRY_BUTTON_TEXT"));
        subButton.setSelection(false);
        subButton.pack();
        subButton.addSelectionListener(this.FILE_TABLE_CHECKBOX_LISTENER);
        editor.minimumWidth = subButton.getSize().x;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)subButton, item, 1);
        item.setData(TABLE_EDITOR_KEY, (Object)editor);
    }

    private void removeItems(int[] indices) {
        this.removeItemsRaw(indices);
        this.fileTable.setSelection(indices[0]);
        this.updateCheckboxLocation(indices[0]);
    }

    private void removeItemsRaw(int[] indices) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableEditor editor = (TableEditor)this.fileTable.getItem(i).getData(TABLE_EDITOR_KEY);
            if (editor != null) {
                editor.getEditor().dispose();
            }
            ++n2;
        }
        this.fileTable.remove(indices);
        this.listChanged = true;
    }

    private void updateCheckboxLocation(int offset) {
        int i = offset;
        while (i < this.fileTable.getItemCount()) {
            TableItem item = this.fileTable.getItem(i);
            TableEditor editor = (TableEditor)item.getData(TABLE_EDITOR_KEY);
            if (editor != null) {
                Control c = editor.getEditor();
                c.setLocation(c.getLocation().x, i * item.getBounds().height);
            }
            ++i;
        }
    }

    private boolean isImageFile(String path) {
        int dotPos = path.lastIndexOf(46);
        if (dotPos < 0) {
            return false;
        }
        String suffix = path.substring(dotPos + 1);
        return ImageIO.getImageReadersBySuffix(suffix).hasNext();
    }

    private Image getIcon(File file) {
        Image icon = null;
        icon = !file.exists() ? this.noFileIconImage : (file.isDirectory() ? this.emptyFolderIconImage : (this.isImageFile(file.getPath()) ? this.imageFileIconImage : this.fileIconImage));
        return icon;
    }

    private String getFileSizeDescription(long byteSize) {
        int curUnitId = 0;
        if (byteSize < 1000L) {
            return String.valueOf(byteSize) + FILE_SIZE_UNIT[0];
        }
        long viewByteSize = byteSize * 10L;
        while (byteSize >> 10 > 0L && curUnitId < FILE_SIZE_UNIT.length - 1) {
            ++curUnitId;
            byteSize >>= 10;
            viewByteSize >>= 10;
        }
        return String.format("%d.%d%s", viewByteSize / 10L, viewByteSize % 10L, FILE_SIZE_UNIT[curUnitId]);
    }

    private class ComputeFilePropertiesTask
    implements Runnable {
        private final FileEntry fileEntry;

        private ComputeFilePropertiesTask(FileEntry fileEntry) {
            this.fileEntry = fileEntry;
        }

        @Override
        public void run() {
            if (this.fileEntry.isDirectory()) {
                this.computeDirProperties();
            } else if (FileDropListViewer.this.isImageFile(this.fileEntry.getPath())) {
                this.computeImageFileProperties();
            } else {
                this.computeFileProperties();
            }
            Display.getDefault().syncExec(FileDropListViewer.this.FILE_TABLE_REDRAW_TASK);
        }

        private void computeFileProperties() {
            File file = new File(this.fileEntry.getPath());
            if (!file.exists()) {
                return;
            }
            String text = FileDropListViewer.this.getFileSizeDescription(file.length());
            FileDropListViewer.this.propertiesMap.put(this.fileEntry, text);
        }

        private void computeImageFileProperties() {
            File file = new File(this.fileEntry.getPath());
            if (!file.exists()) {
                return;
            }
            Image image = ImageUtils.loadImage(this.fileEntry);
            StringBuilder sb = new StringBuilder();
            if (image != null) {
                ImageData data = image.getImageData();
                sb.append(data.width).append('x').append(data.height).append(' ');
                sb.append(data.depth).append("bpp").append(' ');
            }
            sb.append(FileDropListViewer.this.getFileSizeDescription(file.length()));
            FileDropListViewer.this.propertiesMap.put(this.fileEntry, sb.toString());
        }

        private void computeDirProperties() {
            File dir = new File(this.fileEntry.getPath());
            if (!dir.exists()) {
                return;
            }
            int numDirs = 0;
            int numFiles = 0;
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    ++numDirs;
                } else {
                    ++numFiles;
                }
                ++n2;
            }
            String text = String.format(FileDropListViewer.this.messages.getString("FileDropListViewer.REPORT_DIRINFO_MESSAGE"), numDirs, numFiles);
            FileDropListViewer.this.propertiesMap.put(this.fileEntry, text);
        }
    }
}

