/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.DREPage;
import jp.thisnor.dre.app.DisposeExecutePage;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.PathInputViewer;
import jp.thisnor.dre.app.SimilarEntrySelectPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

class DisposeWaySelectPage
extends DREPage {
    private static final String PREFS_DISPOSE_KEY = String.valueOf(DisposeWaySelectPage.class.getName()) + ".dispose";
    private static final String PREFS_DIRMOVETO_KEY = String.valueOf(DisposeWaySelectPage.class.getName()) + ".dirmoveto";
    private DREFrame frame;
    private Messages messages;
    private Composite rootComp;
    private Button[] disposeRadios;
    private PathInputViewer pathInput;
    private final SelectionListener UPDATE_CONTENTS_ENABLED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DisposeWaySelectPage.this.updateContentsEnabled();
        }
    };

    DisposeWaySelectPage(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    @Override
    void createContents(Composite parent) {
        PreferenceStore prefs = this.frame.getPreferences();
        prefs.setDefault(PREFS_DISPOSE_KEY, 0);
        prefs.setDefault(PREFS_DIRMOVETO_KEY, "");
        this.rootComp = new Composite(parent, 0);
        FormLayout l = new FormLayout();
        l.spacing = 8;
        this.rootComp.setLayout((Layout)l);
        Group disposeGroup = new Group(this.rootComp, 0);
        FormLayout l2 = new FormLayout();
        l2.spacing = 8;
        disposeGroup.setLayout((Layout)l2);
        this.disposeRadios = new Button[2];
        this.disposeRadios[0] = new Button((Composite)disposeGroup, 16);
        this.disposeRadios[0].setText(this.messages.getString("DisposeWaySelectPage.DISPOSE_MENUES.DELETE"));
        this.disposeRadios[0].addSelectionListener(this.UPDATE_CONTENTS_ENABLED);
        this.disposeRadios[1] = new Button((Composite)disposeGroup, 16);
        this.disposeRadios[1].setText(this.messages.getString("DisposeWaySelectPage.DISPOSE_MENUES.MOVE"));
        this.disposeRadios[1].addSelectionListener(this.UPDATE_CONTENTS_ENABLED);
        this.pathInput = new PathInputViewer(this.frame);
        this.pathInput.createContents((Composite)disposeGroup);
        this.disposeRadios[0].setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).build());
        this.disposeRadios[1].setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.disposeRadios[0]).build());
        this.pathInput.getControl().setLayoutData((Object)new FormDataBuilder().left(0, 40).right(100).top((Control)this.disposeRadios[1]).build());
        disposeGroup.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom(100).build());
        int selectIndex = prefs.getInt(PREFS_DISPOSE_KEY);
        if (selectIndex >= 0) {
            this.disposeRadios[selectIndex].setSelection(true);
        }
        this.pathInput.setPath(prefs.getString(PREFS_DIRMOVETO_KEY));
        this.updateContentsEnabled();
    }

    @Override
    void activated() {
        this.frame.setPageTitle(this.messages.getString("DisposeWaySelectPage.PAGE_TITLE"));
        this.frame.setPageDescription(this.messages.getString("DisposeWaySelectPage.PAGE_DESCRIPTION"));
        this.frame.setContent((Control)this.rootComp);
        this.frame.setNextButtonEnabled(true);
        this.frame.setPreviousButtonEnabled(true);
    }

    @Override
    void hiddened() {
        PreferenceStore prefs = this.frame.getPreferences();
        prefs.setValue(PREFS_DISPOSE_KEY, this.getSelectedDisposeWay());
        prefs.setValue(PREFS_DIRMOVETO_KEY, this.pathInput.getPath());
    }

    @Override
    void nextRequested() {
        if (this.getSelectedDisposeWay() == 0) {
            MessageBox msgBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
            msgBox.setText(this.messages.getString("DisposeWaySelectPage.CONFIRM_DELETE_TITLE"));
            msgBox.setMessage(this.messages.getString("DisposeWaySelectPage.CONFIRM_DELETE_MESSAGE"));
            if (msgBox.open() == 128) {
                return;
            }
        }
        this.frame.setActivePage(this.frame.getPage(DisposeExecutePage.class));
    }

    @Override
    void previousRequested() {
        this.frame.setActivePage(this.frame.getPage(SimilarEntrySelectPage.class));
    }

    @Override
    void dispose() {
    }

    int getSelectedDisposeWay() {
        int i = 0;
        while (i < this.disposeRadios.length) {
            if (this.disposeRadios[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getDirectoryPathMoveTo() {
        return this.pathInput.getPath();
    }

    private void updateContentsEnabled() {
        this.pathInput.setEnabled(this.disposeRadios[1].getSelection());
        this.frame.setNextButtonEnabled(this.getSelectedDisposeWay() >= 0);
    }
}

