/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jp.thisnor.dre.core.FirstMeasureTask;
import jp.thisnor.dre.core.FullMeasureTask;
import jp.thisnor.dre.core.LoadTask;
import jp.thisnor.dre.core.MeasureEntry;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.core.PathFilter;
import jp.thisnor.dre.core.ProgressListener;
import jp.thisnor.dre.core.ResolvePathTask;
import jp.thisnor.dre.core.SimilarGroup;
import jp.thisnor.dre.core.SynchronizedCounter;

public class WholeTask
implements Callable<List<SimilarGroup>> {
    private final Measurer measurer;
    private final List<String> targetList;
    private final List<String> storageList;
    private final PathFilter filter;
    private final Map<String, MeasureOptionEntry> optionMap;
    private final int numThreads;
    private final ProgressListener logger;
    private volatile List<SimilarGroup> simGroupList;
    private static final Comparator<MeasureEntry> MEASURE_ENTRY_COMPARATOR = new Comparator<MeasureEntry>(){

        @Override
        public int compare(MeasureEntry o1, MeasureEntry o2) {
            return Integer.signum(o1.firstDistance - o2.firstDistance);
        }
    };

    public WholeTask(List<String> targetList, List<String> storageList, PathFilter filter, Measurer measurer, Map<String, MeasureOptionEntry> optionMap, int numThreads, ProgressListener logger) {
        if (measurer == null) {
            throw new IllegalArgumentException("Need measurer");
        }
        if (targetList == null) {
            throw new IllegalArgumentException("Need target path list");
        }
        if (numThreads <= 0) {
            throw new IllegalArgumentException("numThreads must be >= 1, got " + numThreads);
        }
        this.targetList = targetList;
        this.storageList = storageList;
        this.filter = filter;
        this.measurer = measurer;
        this.optionMap = new HashMap<String, MeasureOptionEntry>(optionMap);
        this.numThreads = numThreads;
        this.logger = logger;
    }

    @Override
    public List<SimilarGroup> call() throws InterruptedException {
        int i;
        SynchronizedCounter counter;
        ArrayList<MeasureEntry> targetEntryList = new ArrayList<MeasureEntry>();
        ArrayList<MeasureEntry> storageEntryList = null;
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        if (this.storageList == null || this.storageList == this.targetList) {
            storageEntryList = targetEntryList;
            counter = new SynchronizedCounter();
            i = 0;
            while (i < this.numThreads) {
                executor.submit(new ResolvePathTask(this.targetList, targetEntryList, this.filter, counter));
                ++i;
            }
        } else {
            storageEntryList = new ArrayList();
            counter = new SynchronizedCounter();
            i = 0;
            while (i < this.numThreads) {
                executor.submit(new ResolvePathTask(this.targetList, targetEntryList, this.filter, counter));
                ++i;
            }
            counter = new SynchronizedCounter();
            i = 0;
            while (i < this.numThreads) {
                executor.submit(new ResolvePathTask(this.storageList, storageEntryList, this.filter, counter));
                ++i;
            }
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
        this.measurer.init(this.optionMap);
        int fullFileCount = targetEntryList.size() + (targetEntryList.size() == storageEntryList.size() ? 0 : storageEntryList.size());
        executor = Executors.newFixedThreadPool(this.numThreads);
        counter = new SynchronizedCounter();
        int i2 = 0;
        while (i2 < this.numThreads) {
            executor.submit(new LoadTask(targetEntryList, this.measurer, counter, this.logger));
            ++i2;
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.logger.progressLoad(Math.min(counter.currentValue(), targetEntryList.size()), fullFileCount);
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
        if (targetEntryList != storageEntryList) {
            executor = Executors.newFixedThreadPool(this.numThreads);
            counter = new SynchronizedCounter();
            i2 = 0;
            while (i2 < this.numThreads) {
                executor.submit(new LoadTask(storageEntryList, this.measurer, counter, this.logger));
                ++i2;
            }
            executor.shutdown();
            try {
                while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.logger.progressLoad(Math.min(targetEntryList.size() + counter.currentValue(), fullFileCount), fullFileCount);
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                throw e;
            }
        }
        this.logger.progressLoad(fullFileCount, fullFileCount);
        Iterator it = targetEntryList.iterator();
        while (it.hasNext()) {
            if (((MeasureEntry)it.next()).data != null) continue;
            it.remove();
        }
        if (targetEntryList != storageEntryList) {
            it = storageEntryList.iterator();
            while (it.hasNext()) {
                if (((MeasureEntry)it.next()).data != null) continue;
                it.remove();
            }
        }
        executor = Executors.newFixedThreadPool(this.numThreads);
        counter = new SynchronizedCounter(1);
        i = 0;
        while (i < this.numThreads) {
            executor.submit(new FirstMeasureTask(targetEntryList, (MeasureEntry)targetEntryList.get(0), this.measurer, counter));
            ++i;
        }
        if (targetEntryList != storageEntryList) {
            counter = new SynchronizedCounter(0);
            i = 0;
            while (i < this.numThreads) {
                executor.submit(new FirstMeasureTask(storageEntryList, (MeasureEntry)targetEntryList.get(0), this.measurer, counter));
                ++i;
            }
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
        Collections.sort(targetEntryList, MEASURE_ENTRY_COMPARATOR);
        if (targetEntryList != storageEntryList) {
            Collections.sort(storageEntryList, MEASURE_ENTRY_COMPARATOR);
        }
        this.simGroupList = Collections.synchronizedList(new ArrayList());
        int threshold = this.optionMap.containsKey("threshold") ? Integer.parseInt(this.optionMap.get("threshold").getValue()) : Integer.MAX_VALUE;
        executor = Executors.newFixedThreadPool(this.numThreads);
        counter = new SynchronizedCounter();
        int i3 = 0;
        while (i3 < this.numThreads) {
            executor.submit(new FullMeasureTask(targetEntryList, storageEntryList, this.simGroupList, this.measurer, threshold, counter));
            ++i3;
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.logger.progressMeasure(counter.currentValue(), targetEntryList.size());
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
        this.logger.progressMeasure(targetEntryList.size(), targetEntryList.size());
        Collections.sort(this.simGroupList, SimilarGroup.FIRST_DISTANCE_COMPARATOR);
        this.measurer.dispose();
        for (MeasureEntry entry : targetEntryList) {
            entry.data = null;
        }
        if (targetEntryList != storageEntryList) {
            for (MeasureEntry entry : storageEntryList) {
                entry.data = null;
            }
        }
        return this.simGroupList;
    }

    public List<SimilarGroup> getResult() {
        return this.simGroupList;
    }
}

