<?php
* @version $Id: pdf.php 
* @package Joomla}`oCgPDFCreate
* @copyright Copyright (C) 2005 Joomla!JAPAN All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* FPDF(fpdf.php 1.53
* html2pdf.class.php 1.2
* 
* 
* 

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

	dofreePDF ($database);

function dofreePDF ($database) {
	global $mosConfig_live_site, $mosConfig_sitename, $mosConfig_offset, $mosConfig_hideCreateDate, $mosConfig_hideAuthor, $mosConfig_hideModifyDate;

	//inti
	$txt2 = "";
	$id = intval( mosGetParam( $_REQUEST, 'id', 1 ) );
	$row = new mosContent( $database );
	$row->load($id);
	//Find Author Name
	$users_rows = new mosUser( $database );
	$users_rows->load($row->created_by);
	$row->author = $users_rows->name;
	$row->usertype = $users_rows->usertype;
	
	//Gets the images
	if (trim( $row->images )) {
		$row->images = explode( "\n", $row->images );
	} else {
		$row->images = array();
	}

	$images2 = array();
	foreach($row->images as $file) {
		$temp = explode( '|', $file );
		$images2[] = $temp[0];
	}

	//Gets the text
	$row->introtext = RemoveTags($row->introtext);
	$row->fulltext = RemoveTags($row->fulltext);
	$g = mb_convert_encoding($row->introtext,"EUC-JP");
	$h = mb_convert_encoding($row->fulltext,"EUC-JP");
	$html = $g."<br>".$h;
	
	//Replace the tag {mosimages}
	for ($j=0, $m=count( $images2 ); $j < $m; $j++) {
		$imagepos = strpos($html,"{mosimage}");
		if($imagepos>=0) {
			$part1 = substr($html, 0, ($imagepos + 9));
			$part2 = substr($html, $imagepos + 9);
			$html = $part1.$j.$part2;
		}
	}
	
	//Place images
	for ($j=0, $m=count( $images2 ); $j < $m; $j++) {
		$html = str_replace("{mosimage$j}", "<img src=\"images/stories/".$images2[$j]."\">", $html);
		//print $j." - ".$images2[$j];
	}
	
	
	require("html2pdf.class.php");


	$pdf = new PDF('P','pt','A4');
	//$pdf->AddSJISFont();
        $pdf->AddMBFont(GOTHIC ,'SJIS');
        $pdf->AddMBFont(PGOTHIC,'SJIS');
        $pdf->AddMBFont(MINCHO ,'SJIS');
        $pdf->AddMBFont(PMINCHO,'SJIS');
        $pdf->AddMBFont(KOZMIN ,'SJIS');
	$pdf->Open();
	$pdf->AliasNbPages();
	$pdf->SetLeftMargin(25);
	$pdf->AddPage();

	//Title
	$pdf->changeClass("title");
	$f = "<input type=\"hidden\" class=\"texte\">";
	$f = mb_convert_encoding($row->title,"EUC-JP")."<br><br>";
	$f = $pdf->PrepareTxt($f);
	$f = $pdf->ExplodeHTML($f);
	$pdf->ParseHTML($f);

	//Author and Date information
	$mod_date = null; $create_date = null;
	if (intval( $row->modified ) != 0) {
		$mod_date = mosFormatDate($row->modified);
	}
	if (intval( $row->created ) != 0) {
		$create_date = mosFormatDate($row->created);
	}

	if ($mosConfig_hideCreateDate == "0") {
		$txt2 .= "(".$create_date.") - ";
	}

	if ($mosConfig_hideAuthor == "0") {
		if ($row->author != "" && $mosConfig_hideAuthor == "0") {
			if ($row->usertype == 'administrator' || $row->usertype == 'superadministrator') {
				$txt2 .=  _WRITTEN_BY." ".($row->created_by_alias ? $row->created_by_alias : $row->author);
			} else {
				$txt2 .=  _AUTHOR_BY." ".($row->created_by_alias ? $row->created_by_alias : $row->author);
			}
		}
	}

	if ($mosConfig_hideModifyDate == "0") {
		$txt2 .= " - " . _LAST_UPDATED." (".$mod_date.") ";
	}
	$pdf->SetY(60);
	$pdf->SetFont(GOTHIC,'I',7);
	$pdf->Cell(182,10,mb_convert_encoding($txt2,"EUC-JP"),0,0,'L');
	$pdf->ln(20);

	//Body
	//$h = $row->fulltext;
	$html = "<input type=\"hidden\" class=\"texte\">" . $html;
	$html = $pdf->PrepareTxt($html);
	$html = $pdf->ExplodeHTML($html);
	$pdf->ParseHTML($html);
	
	//Output the file
	$pdf->Output();
	
}

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}

function RemoveTags($html="") {
	$html2="";
	$html = str_replace("<B>", "<b>", $html);
	$html = str_replace("</B>", "</b>", $html);
	$html = str_replace("<U>", "<u>", $html);
	$html = str_replace("</U>", "</u>", $html);
	$html = str_replace("<I>", "<i>", $html);
	$html = str_replace("</I>", "</i>", $html);
	$html = str_replace("<P>", "<p>", $html);
	$html = str_replace("</P>", "</p>", $html);
	$html = str_replace("<UL>", "<ul>", $html);
	$html = str_replace("</UL>", "</ul>", $html);
	$html = str_replace("<OL>", "<ol>", $html);
	$html = str_replace("</OL>", "</ol>", $html);
	$html = str_replace("<LI>", "<li>", $html);
	$html = str_replace("</LI>", "</li>", $html);
	$html = str_replace("<SPAN>", "<span>", $html);
	$html = str_replace("</SPAN>", "</span>", $html);
	$html = str_replace("<SUP>", "<sup>", $html);
	$html = str_replace("</SUP>", "</sup>", $html);
	$html = str_replace("<SUB>", "<sub>", $html);
	$html = str_replace("</SUB>", "</sub>", $html);
	$html = str_replace("<BR>", "<br>", $html);
	$html = str_replace("<A ", "<a ", $html);
	$html = str_replace("</A>", "</a>", $html);
	$html = str_replace("<STRONG>", "<b>", $html);
	$html = str_replace("</STRONG>", "</b>", $html);
	$html = str_replace("<strong>", "<b>", $html);
	$html = str_replace("</strong>", "</b>", $html);
	$html = str_replace("<TBODY>", "", $html);
	$html = str_replace("</TBODY>", "", $html);
	$html = str_replace("<tbody>", "", $html);
	$html = str_replace("</tbody>", "", $html);
	$html = str_replace("<DIV ", "<p ", $html);
	$html = str_replace("<DIV>", "<p>", $html);
	$html = str_replace("</DIV>", "</p>", $html);
	$html = str_replace("<div ", "<p ", $html);
	$html = str_replace("</div>", "</p>", $html);
	$html = str_replace("<TABLE ", "<table ", $html);
	$html = str_replace("<TABLE>", "<table>", $html);
	$html = str_replace("</TABLE>", "</table>", $html);
	$html = str_replace("<TR>", "<tr>", $html);
	$html = str_replace("</TR>", "</tr>", $html);
	$html = str_replace("<TD ", "<td ", $html);
	$html = str_replace("<TD>", "<td>", $html);
	$html = str_replace("</TD>", "</td>", $html);
	$html = str_replace("<FONT ", "<font ", $html);
	$html = str_replace("</FONT>", "</font>", $html);
	$html = str_replace("cellSpacing", "cellspacing", $html);
	$html = str_replace("cellPadding", "cellpadding", $html);
	$html = str_replace("&#8364;", "?", $html);
	$html = str_replace("<li>", "</li><li>", $html);
	$html = str_replace("<p>&nbsp;</p>", "", $html);
	
	##	Fix the lists
	$continue=true;
	while($continue==true) {
		$iPos = strpos($html, "<ul>");

		if(substr($html, ($iPos+6), 5)!= "</li>") {
			$continue==false;
			break;
		}
		
		$html2 .= substr($html, 0, $iPos+4);
		$html = substr($html, ($iPos+11));
	}

	$html2 .= $html;
	$html = $html2;

	##	Remove links from the HTML
	$continue=true;
	while($continue==true) {
		$iPos = strpos($html, "<a ");

		if($iPos===false) {
			$continue = false;
			break;
		}

		$iPosEnd = strpos($html, "</a>");
		
		$temp = "";
		for ($i = $iPos; $i <= strlen($html); $i++) {
			$temp .= substr($html, $i, 1);
			if(substr($html, $i, 1)==">") {
				$html = str_replace($temp, "", $html);
				break;
			}
		}
	}

	return $html;
}
?>