_cascadeWin = null; // roߗpCA

// |bvAbvEBhEIuWFNg
function PopupWin(id,iconDiv,winDiv,nproc,interval){
  this.id          = id;
  if(_cascadeWin==null){
    _cascadeWin = createLayer(0,0,10,10);
    setDivBackgroundColor(_cascadeWin,'#cccccc');
  }
  this.cascadeDiv  = _cascadeWin;
  this.iconDiv     = iconDiv;  this.winDiv      = winDiv;
  this.interval    = interval; this.timeId      = null;
  this.nproc       = nproc;    this.cproc       = 0;
  this.iconDisable = true;
  this.dx = 0; this.dy = 0; this.dw = 0; this.dh = 0;
}

// |bvAbv\bh( Jn )
PopupWin.prototype.popup = function(){
  if(this.timeId) clearTimeout(this.timeId);
  this.timeId    = null;
  var cascadeDiv = this.cascadeDiv;
  var winDiv     = this.winDiv, iconDiv    = this.iconDiv;
  this.dx = (getDivLeft  (winDiv)-getDivLeft  (iconDiv))/this.nproc;
  this.dy = (getDivTop   (winDiv)-getDivTop   (iconDiv))/this.nproc;
  this.dw = (getDivWidth (winDiv)-getDivWidth (iconDiv))/this.nproc;
  this.dh = (getDivHeight(winDiv)-getDivHeight(iconDiv))/this.nproc;
  this.cproc = this.nproc;
  moveDivTo  (cascadeDiv,getDivLeft (iconDiv),getDivTop   (iconDiv));
  resizeDivTo(cascadeDiv,getDivWidth(iconDiv),getDivHeight(iconDiv));
  setDivVisibility(cascadeDiv,true);
  if(this.iconDisable) setDivVisibility(iconDiv,false);
  if(!this.popupProcessCB ||
      this.popupProcessCB(this,this.popupProcessCD)){
    this.timeId = setTimeout(this.id+'.doPopupProcess();',this.interval);
  } else {
    setDivVisibility(cascadeDiv,false);
    setDivVisibility(winDiv,true);
  }
}

// |bvAbv\bh( s )
PopupWin.prototype.doPopupProcess = function(){
  this.timeId = null;
  var cascadeDiv = this.cascadeDiv;
  moveDivBy(cascadeDiv,this.dx,this.dy);
  resizeDivBy(cascadeDiv,this.dw,this.dh);
  if(--this.cproc>0){
    if(!this.popupProcessCB ||
        this.popupProcessCB(this,this.popupProcessCD)){
      this.timeId = setTimeout(this.id+'.doPopupProcess();',this.interval);
    } else {
      setDivVisibility(cascadeDiv,false);
      setDivVisibility(this.winDiv,true);
    }
  } else {
    setDivVisibility(this.winDiv,true);
    setDivVisibility(cascadeDiv,false);
    if(this.popupCompleteCB)
      this.popupCompleteCB(this,this.popupCompleteCD);
  }
}

// |bv_E\bh( Jn )
PopupWin.prototype.popdown = function(){
  if(this.timeId) clearTimeout(this.timeId);
  this.timeId = null;
  var iconDiv = this.iconDiv, winDiv = this.winDiv, cascadeDiv = this.cascadeDiv;
  this.dx = (getDivLeft  (iconDiv)-getDivLeft  (winDiv))/this.nproc;
  this.dy = (getDivTop   (iconDiv)-getDivTop   (winDiv))/this.nproc;
  this.dw = (getDivWidth (iconDiv)-getDivWidth (winDiv))/this.nproc;
  this.dh = (getDivHeight(iconDiv)-getDivHeight(winDiv))/this.nproc;
  this.cproc = this.nproc;
  moveDivTo  (cascadeDiv,getDivLeft (winDiv),getDivTop   (winDiv));
  resizeDivTo(cascadeDiv,getDivWidth(winDiv),getDivHeight(winDiv));
  setDivVisibility(cascadeDiv,true);
  setDivVisibility(winDiv,false);
  if(!this.popdownProcessCB ||
      this.popdownProcessCB(this,this.popdownProcessCD)){
    this.timeId = setTimeout(this.id+'.doPopdownProcess();',this.interval);
  } else {
    setDivVisibility(cascadeDiv,false);
    if(this.iconDisable) setDivVisibility(iconDiv,true);
  }
}

// |bv_E\bh( s )
PopupWin.prototype.doPopdownProcess = function(){
  this.timeId = null;
  var cascadeDiv = this.cascadeDiv;
  moveDivBy  (cascadeDiv,this.dx,this.dy);
  resizeDivBy(cascadeDiv,this.dw,this.dh);
  if(--this.cproc>0){
    if(!this.popdownProcessCB ||
        this.popdownProcessCB(this,this.popdownProcessCD)){
      this.timeId = setTimeout(this.id+'.doPopdownProcess();',this.interval);
    } else {
      setDivVisibility(cascadeDiv,false);
      if(this.iconDisable) setDivVisibility(this.iconDiv,true);
    }
  } else {
    if(this.iconDisable) setDivVisibility(this.iconDiv,true);
    setDivVisibility(cascadeDiv,false);
    if(this.popdownCompleteCB)
      this.popdownCompleteCB(this,this.popdownCompleteCD);
  }
}

// \ߒ\bh
PopupWin.prototype.cancelProcess = function(){
  if(this.timeId) clearTimeout(this.timeId);
  this.timeId = null;
}

// isR[obNo^\bh
PopupWin.prototype.setProcessCallback = function(upcb,upcd, pdcb,pdcd){
  this.popupProcessCB   = upcb;
  this.popupProcessCD   = upcd;
  this.popdownProcessCB = pdcb;
  this.popdownProcessCD = pdcd;
}

// R[obNo^\bh
PopupWin.prototype.setCompleteCallback = function(upcb,upcd, pdcb,pdcd){
  this.popupCompleteCB   = upcb;
  this.popupCompleteCD   = upcd;
  this.popdownCompleteCB = pdcb;
  this.popdownCompleteCD = pdcd;
}
