/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class JdbcDriverType {
    private static final Map productMap = new HashMap();
    private final String productName;
    private final String innerName;
    public static final JdbcDriverType POSTGRESQL = new JdbcDriverType("PostgreSQL", "postgresql");
    public static final JdbcDriverType HSQL = new JdbcDriverType("HSQL Database Engine", "hsql");
    public static final JdbcDriverType MYSQL = new JdbcDriverType("MySQL", "mysql");

    protected JdbcDriverType(String productName, String innerName) {
        this.productName = productName;
        this.innerName = innerName;
        productMap.put(productName, this);
    }

    public String getInnerName() {
        return this.innerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String toString() {
        return this.productName;
    }

    public static JdbcDriverType get(String databaseProductName) throws SQLException {
        JdbcDriverType result = (JdbcDriverType)productMap.get(databaseProductName);
        if (result == null) {
            throw new SQLException("unknown kind of connection. [" + databaseProductName + "]. Now you can use these database." + productMap.keySet());
        }
        return result;
    }

    public static JdbcDriverType get(DatabaseMetaData metaData) throws SQLException {
        return JdbcDriverType.get(metaData.getDatabaseProductName());
    }

    public static JdbcDriverType get(Connection connection) throws SQLException {
        return JdbcDriverType.get(connection.getMetaData());
    }
}

