/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public class NamedParamSQL {
    protected final String original;
    protected final Set quotedParamClasses = new HashSet();
    protected List paramNames = null;
    private char quote = (char)39;
    public static final char PARAM_DELIMETER = '$';
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public NamedParamSQL(String original) {
        this.original = original;
        this.initQuotedParamClasses();
    }

    protected void initQuotedParamClasses() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.quotedParamClasses.add(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.quotedParamClasses.add(clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Ljava.lang.Character;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.quotedParamClasses.add(clazz3);
    }

    protected Iterator getParamNameIterator() {
        if (this.paramNames != null) {
            return this.paramNames.iterator();
        }
        this.paramNames = new ArrayList();
        StringUtils.extractStrings(this.original, this.paramNames, '$');
        return this.paramNames.iterator();
    }

    private Map getPreparingProps() {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iterator = this.getParamNameIterator();
        while (iterator.hasNext()) {
            String paramName = (String)iterator.next();
            result.put(paramName, "?");
        }
        return result;
    }

    public String toPreparable() {
        return this.toExecutable(this.getPreparingProps());
    }

    public String toExecutable(Object value) {
        if (value instanceof Map) {
            return this.toExecutableByMap((Map)value);
        }
        return this.toExecutableByBean(value);
    }

    protected String toExecutableByBean(Object bean) {
        StringBuffer result = new StringBuffer(this.original);
        Iterator iterator = this.getParamNameIterator();
        while (iterator.hasNext()) {
            String paramName = (String)iterator.next();
            Object param = null;
            try {
                param = PropertyUtils.getNestedProperty((Object)bean, (String)paramName);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (param == null) continue;
            StringUtils.replace(result, String.valueOf('$') + paramName + '$', this.getPropParamValue(param));
        }
        return result.toString();
    }

    protected String toExecutableByMap(Map props) {
        StringBuffer result = new StringBuffer(this.original);
        Iterator iterator = this.getParamNameIterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            StringUtils.replace(result, String.valueOf('$') + param + '$', this.getPropParamValue(props.get(param)));
        }
        return result.toString();
    }

    private String getPropParamValue(Object value) {
        if (value == null) {
            return "";
        }
        if (this.quotedParamClasses.contains(value.getClass())) {
            return String.valueOf(this.quote) + String.valueOf(value) + this.quote;
        }
        return String.valueOf(value);
    }

    public Set getQuotedParamClasses() {
        return this.quotedParamClasses;
    }

    public String getOriginal() {
        return this.original;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }
}

