/* -----------------------------------------------------------------------
 TextUnit.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/11/09
 *
 * File Name: TextUnit.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 *
 */
package jp.co.jlight.undo;

import org.eclipse.swt.graphics.*;
/**
 * 1ɲä줿ʸȺ줿ʸ
 *       ޤΰ֤ݴɤ륯饹
 */
class TextUnit {

	private Point delPoint = null;
	private Point addPoint = null;
	private String delString = "";
	private String addString = "";

	TextUnit() {
		delPoint = new Point(0, 0);
		addPoint = new Point(0, 0);
	}

	TextUnit(Point delPoint, String delString,
						 Point addPoint, String addString) {
		this.delPoint = delPoint;
		this.delString = delString;
		this.addPoint = addPoint;
		this.addString = addString;
	}

	/**
	 * @return Point	ɲä줿ʸ֤֤
	 */
	Point getAddPoint() {
		return addPoint;
	}

	/**
	 * @return String	ɲä줿ʸ֤
	 */
	String getAddString() {
		return addString;
	}

	/**
	 * @return Point	줿ʸ֤֤
	 */
	Point getDelPoint() {
		return delPoint;
	}

	/**
	 * @return String	줿ʸ֤
	 */
	String getDelString() {
		return delString;
	}

	/**
	 * @param point		ɲä줿ʸ֤
	 */
	void setAddPoint(Point point) {
		addPoint = point;
	}

	/**
	 * @param string	ɲä줿ʸ
	 */
	void setAddString(String string) {
		addString = string;
	}

	/**
	 * @param point		줿ʸ֤
	 */
	void setDelPoint(Point point) {
		delPoint = point;
	}

	/**
	 * @param string	줿ʸ
	 */
	void setDelString(String string) {
		delString = string;
	}

	void reverse() {
		Point tmpPoint = delPoint;
		String tmpString = delString;
		
		delPoint = addPoint;
		delString = addString;
		addPoint = tmpPoint;
		addString = tmpString;
	}
	
	TextUnit getReverse() {
		TextUnit textUnit = new TextUnit(delPoint, delString, addPoint, addString);
		textUnit.reverse();
		return textUnit;
	}
}
