/* -----------------------------------------------------------------------
 SaveDialog.java
 Copyright (C) 2003  Nue

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
----------------------------------------------------------------------- */
/*
 * Created on 2003/07/14
 *
 * File Name: SaveDialog.java
 * Encoding : EUC-JP
 * LineDelimiter: LF
 * 
 */
package jp.co.jlight;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;

import java.util.*;
import java.text.*;
/**
 * λե¸뤫ɤҤͤ
 *       
 */
public class SaveDialog {

	private Shell parent = null;
	private Shell dialog = null;
	
	private Label expl;
	private Table table;
	private Button selectAll;
	private Button removeAll;
	private Button ok;
	private Button cancel;
	
	private int result = SWT.CANCEL;
	
	private ControlManager cm;
	private FileManager fm;
	
	private boolean[] sortflgs = {false, false, false, false, false};


	/**
	 * SaveDialog饹󥹥ȥ饯
	 */
	SaveDialog(Shell parent, ControlManager controlManager,
				FileManager fileManager) {
		this.parent = parent;
		this.cm = controlManager;
		this.fm = fileManager;
	}

	/**
	 * ¸ե
	 */
	public int initDialog() {
		// 
		dialog = new Shell(parent, SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
		dialog.setText("Save Files");
		dialog.setLayout(new FormLayout());
		dialog.setSize(360, 340);

		// Ƽ拾ȥ
		expl = new Label(dialog, SWT.HORIZONTAL);
		expl.setText("Select the files to save:");
		
		table = new Table(dialog, SWT.CHECK | SWT.V_SCROLL | SWT.H_SCROLL);
		table.setHeaderVisible(true);

		selectAll = new Button(dialog, SWT.PUSH);
		selectAll.setText("Select All");
		removeAll = new Button(dialog, SWT.PUSH);
		removeAll.setText("Deselect All");
		
		ok = new Button(dialog, SWT.PUSH);
		ok.setText("OK");
		cancel = new Button(dialog, SWT.PUSH);
		cancel.setText("Cancel");

		// Ƽܥ˥ꥹʤ
		ok.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				if (saveSelectedFiles()) {
					setReturnValue(SWT.OK);
				} else {
					setReturnValue(SWT.CANCEL);
				}
				dialog.close();
				dialog.dispose();
			}
		});
		
		cancel.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				setReturnValue(SWT.CANCEL);
				dialog.close();
				dialog.dispose();
			}
		});

		selectAll.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent event) {
				TableItem[] items = table.getItems();
				for (int i = 0; i < table.getItemCount(); i++) {
					items[i].setChecked(true);
				}
			}
		});

		removeAll.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent event) {
				TableItem[] items = table.getItems();
				for (int i = 0; i < table.getItemCount(); i++) {
					items[i].setChecked(false);
				}
			}
		});

//		table.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent event) {
//				table.deselect(table.getSelectionIndex());
//			}
//		});

		if (!setTableItem()) return SWT.OK;

		// 쥤Ȥ
		setLayout();

		dialog.setDefaultButton(ok);

		// ɽ
		dialog.open();
		while (!dialog.isDisposed()) {
			if (!parent.getDisplay().readAndDispatch()) {
				parent.getDisplay().sleep();
			}
		}
		return result;
	}

	/**
	 * Ĥ֤ѿꤹ
	 * @param rv
	 */
	private void setReturnValue(int rv) {
		result = rv;
	}

	/**
	 * ơ֥˥ơ֥륢ƥ򥻥åȤƤ
	 */
	private boolean setTableItem() {
		boolean flg = false;
		Enumeration enum = cm.getControlSets().elements();
		if (enum == null) return flg;
		ControlSet cset;
		TableItem item;
		// ե̾
		TableColumn col1 = new TableColumn(table, SWT.NONE);
		// ֥Ȥꤹ뤿key
		TableColumn col2 = new TableColumn(table, SWT.NONE);
		// եѥ
		TableColumn col3 = new TableColumn(table, SWT.NONE);
		// ߡ
		TableColumn col4 = new TableColumn(table, SWT.NONE);
		// ơ
		TableColumn col5 = new TableColumn(table, SWT.NONE);
		col2.setWidth(1);
		col2.setResizable(false);
		col4.setWidth(1);
		col4.setResizable(false);
		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				sortTableByColumn(0);
			}
		});
		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				sortTableByColumn(2);
			}
		});
		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				sortTableByColumn(4);
			}
		});
		String[] titles = {"File Name", "key", "Directory", "dummy", "Status"};
		TableColumn column;
		for (int i = 0; i < titles.length; i++) {
			column = table.getColumn(i);
			column.setText(titles[i]);
		}

		FileManager fm = new FileManager(parent);

		while (enum.hasMoreElements()) {
			cset = (ControlSet)enum.nextElement();

			if (cset.getEdited()) {
				item = new TableItem(table, SWT.NONE);
				item.setText(0, cset.getFileName());
				item.setText(1, "" + cset.getKey());
				item.setText(3, "");
				if (cset.getFlgNew()) {
					item.setText(4, "New");
					item.setText(2, "");
				} else if (!fm.fileCanWrite(cset.getFullName())) {
					item.setText(4, "RO");
					item.setText(2, "[" + cset.getFullName() + "]");
				} else {
					item.setText(4, "");
					item.setText(2, "[" + cset.getFullName() + "]");
				}
				item.setChecked(true);
			}
		}
		if (table.getItemCount() > 0) {
			// column1 ꤵ줿keyν˥
			sortTableByColumn(1);
			flg = true;
		} 

		return flg;
	}

	/**
	 * columnǥơ֥Ƥ򥽡Ȥ
	 * (sortflgs[]ǳξ硢߽)
	 * @param column
	 */
	private void sortTableByColumn(int column) {
		if (table.getColumnCount() <= column || table.getItemCount() < 2) return;
		
		TableItem[] items = table.getItems();
		Collator collator = Collator.getInstance(Locale.getDefault());
		boolean checked;

		// 򤷤ƤԤõ
		String sel = "";
		for (int n = 0; n < items.length; n++) {
			if (table.isSelected(n)) {
				sel = new String(items[n].getText(1));
				break;
			}
		}
		table.setRedraw(false);
		for (int i = 1; i < items.length; i++) {
			String value1 = items[i].getText(column);
			for (int j = 0; j < i; j++){
				String value2 = items[j].getText(column);
//				if (collator.compare(value1, value2) < 0) {
				if ((collator.compare(value1, value2) < 0 && !sortflgs[column])
					|| (collator.compare(value1, value2) > 0 && sortflgs[column])) {

					checked = items[i].getChecked();
					String[] values1 = {items[i].getText(0), items[i].getText(1),
										items[i].getText(2), items[i].getText(3),
										items[i].getText(4)};
					String[] values2 = {items[j].getText(0), items[j].getText(1),
										items[j].getText(2), items[j].getText(3),
										items[j].getText(4)};
					// ؤԤʤ
					items[i].setText(values2);
					items[i].setChecked(items[j].getChecked());
					items[j].setText(values1);
					items[j].setChecked(checked);
				}
			}
		}
		// 򤵤ƤԤ
		for (int n = 0; n < items.length; n++) {
			if (sel.equals(items[n].getText(1))) {
				table.setSelection(n);
				break;
			}
		}
		table.setRedraw(true);
		sortflgs[column] = !(sortflgs[column]);
	}

	/**
	 * ơ֥륢ƥååդƤ
	 * ե¸Ƥ
	 * @return boolean
	 */
	private boolean saveSelectedFiles() {
		TableItem[] items = table.getItems();
		ControlSet cset;
		Integer key;
		// åդƤΤ¸Ƥ
		for (int i = 0; i < items.length; i++) {
			if (items[i].getChecked()) {

				key = new Integer(items[i].getText(1));
				cset = cm.getControlSet(key);

				fm.setSaveFileName(cset.getFileName());
				fm.setSaveFullName(cset.getFullName());
				fm.setSavePath(cset.getPath());

				String rs;
				if (cset.getFlgNew() || !fm.fileCanWrite(cset.getFullName())) {
					rs = fm.saveAsText(cset.getStyledText().getText());
				} else {
					rs = fm.saveText(cset.getStyledText().getText());
				}
				if (rs != null) {
					String fname = fm.getSavedFileName();
					cset.setFlgNew(false);
					cset.setFileName(fname);
					cset.setFullName(rs);
					cset.setPath(fm.getSavedPath());
					cset.setTabItemText(fname);
					cset.setEdited(false);
				} else {
					return false;
				}

			}
		}
		return true;
	}

	/**
	 * Dialog˥쥤Ȥꤷȥ֤
	 */
	private void setLayout() {
		// ȥ쥤Ȥ
		FormData d1 = new FormData();
		d1.top = new FormAttachment(0, 10);
		d1.left = new FormAttachment(0, 20);
		
		expl.setLayoutData(d1);
		
		FormData d2 = new FormData();
		d2.top = new FormAttachment(0, 30);
		d2.bottom = new FormAttachment(100, -90);
		d2.left = new FormAttachment(0, 20);
		d2.right = new FormAttachment(100, -20);
		
		table.setLayoutData(d2);

		FormData d3 = new FormData();
		d3.top = new FormAttachment(100, -80);
		d3.bottom = new FormAttachment(100, -55);
		d3.left = new FormAttachment(0, 20);
		d3.right = new FormAttachment(0, 170);
		
		selectAll.setLayoutData(d3);
		
		FormData d4 = new FormData();
		d4.top = new FormAttachment(100, -80);
		d4.bottom = new FormAttachment(100, -55);
		d4.left = new FormAttachment(0, 175);
		d4.right = new FormAttachment(0, 325);
		
		removeAll.setLayoutData(d4);
		
		FormData d5 = new FormData();
		d5.top = new FormAttachment(100, -35);
		d5.bottom = new FormAttachment(100, -10);
		d5.left = new FormAttachment(100, -305);
		d5.right = new FormAttachment(100, -165);
		
		ok.setLayoutData(d5);
		
		FormData d6 = new FormData();
		d6.top = new FormAttachment(100, -35);
		d6.bottom = new FormAttachment(100, -10);
		d6.left = new FormAttachment(ok, 10);
		d6.right = new FormAttachment(100, -15);
		
		cancel.setLayoutData(d6);
	}
}
