// $Id: jikes.cpp,v 1.98 2004/03/20 04:48:17 jikesadmin Exp $
//
// This software is subject to the terms of the IBM Jikes Compiler
// License Agreement available at the following URL:
// http://ibm.com/developerworks/opensource/jikes.
// Copyright (C) 1996, 2004 IBM Corporation and others.  All Rights Reserved.
// You must accept the terms of that agreement to use this software.
//

#include "platform.h"
#include "jikesapi.h"
#include "error.h"

#ifdef HAVE_JIKES_NAMESPACE
using namespace Jikes;
#endif

int main(int argc, char *argv[])
{
    // Here we are creating instance of default API
    JikesAPI *compiler = new JikesAPI();

    int return_code;
    char **files;

    files = compiler -> parseOptions(argc, argv);

    if (compiler -> getOptions() -> help)
    {
        printf("%s%s", StringConstant::U8S_help_header,
               StringConstant::U8S_command_format);
        printf("\r\n"
               "\tRegular options:\r\n"
               "-bootclasspath path location of system classes [default '']\r\n"
               "-classpath path     location of user classes and source files [default .]\r\n"
               "-d dir              write class files in directory dir [default .]\r\n"
               "-debug              no effect (ignored for compatibility)\r\n"
               "-depend | -Xdepend  recompile all used classes\r\n"
               "-deprecation        report uses of deprecated features\r\n"
#if defined(HAVE_ENCODING)
               "-encoding encoding  use specified encoding to read source files\r\n"
               "                      [default is system and locale dependent]\r\n"
# if defined(HAVE_LIBICU_UC)
               "                      this binary requires the ICU library\r\n"
# endif
#endif
               "-extdirs path       location of zip/jar files with platform extensions\r\n"
               "                      [default '']\r\n"
               "-g | -g:none | -g:{lines,vars,source}\r\n"
               "                      control level of debug information in class files\r\n"
               "                      [default lines,source]\r\n"
               "-J...               no effect (ignored for compatibility)\r\n"
               "-nowarn             javac-compatible equivalent of +Z0\r\n"
               "-nowrite            do not write any class files, useful with -verbose\r\n"
               "-O                  optimize bytecode (presently does nothing)\r\n"
               "-source release     interpret source by Java SDK release rules\r\n"
               "                      [default to max(target, 1.4)]\r\n"
               "-sourcepath path    location of user source files [default '']\r\n"
               "-target release     output bytecode for Java SDK release rules\r\n"
               "                      [default to source if specified, else 1.4.2]\r\n"
               "-verbose            list files read and written\r\n"
               "-Werror             javac-compatible equivalent of +Z2\r\n"
               "-Xstdout            redirect output listings to stdout\r\n"
               "-Xswitchcheck       warn about fallthrough between switch statement cases\r\n"
               "\tEnhanced options:\r\n"
               "++                  compile in incremental mode\r\n"
               "+a                  omit assert statements from class files\r\n"
               "+B                  do not invoke bytecode generator\r\n"
               "+D                  report errors immediately in emacs-form without buffering\r\n"
               "+DR=filename        generate dependence report in filename\r\n"
               "+E                  list errors in emacs-form\r\n"
               "+F                  do full dependence check except for Zip and Jar files\r\n"
               "+Kname=TypeKeyWord  map name to type keyword\r\n"
               "+M                  generate makefile dependencies\r\n"
               "+OLDCSO             perform original Jikes classpath order for compatibility\r\n"
               "+P                  pedantic compilation - issues lots of warnings\r\n"
               "                      some warnings can be turned on or off independently:\r\n");

        SemanticError::PrintNamedWarnings();

        printf("+T=n                set value of tab to n spaces, defaults to 8\r\n"
               "+U                  do full dependence check including Zip and Jar files\r\n"
               "+Z0                 do not issue warning messages\r\n"
               "+Z1                 treat cautions as errors\r\n"
               "+Z2                 treat both warnings and cautions as errors\r\n"
               "+Z                  equivalent to +Z1\r\n"
#ifdef JIKES_DEBUG
               "\tDebugging options:\r\n"
               "+A                  dump AST to standard output\r\n"
               "+c                  do not discard comments from lexer output, use with +L\r\n"
               "+C                  dump bytecodes to standard output\r\n"
               "+L                  dump lexer output (stream of tokens) to file.java.tok\r\n"
               "+O numbytes         call no-op op_trap() for bytecodes of the given length\r\n"
               "+S                  trace method stack depth to standard output\r\n"
               "+u                  unparse AST; produces Java code for the AST\r\n"
               "+ud                 unparse AST, with extra debugging information\r\n"
#endif
               "\tMiscellaneous options:\r\n"
               "-help | --help      display this message and exit\r\n"
               "-version | --version  display version and contact information, and exit\r\n");

        return_code = 0;
    }
    else if (compiler -> getOptions() -> version)
    {
        printf("%s", StringConstant::U8S_help_header);
        printf("Originally written by Philippe Charles and David Shields of IBM Research,\r\n"
               "Jikes is now maintained and refined by the Jikes Project at:\r\n"
               "<http://ibm.com/developerworks/opensource/jikes>\r\n"
               "Please consult this URL for more information and for reporting problems.\r\n");

        return_code = 0;
    }
    else if (files && files[0])
    {
        return_code = compiler -> compile(files);
    }
    else
    {
        printf("%s", StringConstant::U8S_command_format);
        printf("For more help, try -help or -version.\r\n");

        return_code = 2;
    }

    delete compiler;
    return return_code;
}
