/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLScriptDialog
extends HTMLDialog {
    private JLabel typeLabel = new JLabel("type\u5c5e\u6027", 4);
    private JCheckBox srcBtn = new JCheckBox("src\u5c5e\u6027", true);
    private JCheckBox charsetBtn = new JCheckBox("charset\u5c5e\u6027");
    private JCheckBox deferBtn = new JCheckBox("defer\u5c5e\u6027");
    private String[] type_str = new String[]{"text/javascript", "text/ecmascript", "text/jscript", "text/vbscript", "text/tcl"};
    private JComboBox typeBox = new JComboBox<String>(this.type_str);
    private JTextField srcField = new JTextField(30);
    private JButton srcLinkBtn = new JButton("\u53c2\u7167");
    private String[] charset_str = new String[]{"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
    private JComboBox charsetBox = new JComboBox<String>(this.charset_str);

    public HTMLScriptDialog(TextView view) {
        super(view);
        this.setDialog(view, "script\u8981\u7d20\u5b9a\u7fa9", 600, 250);
    }

    protected JPanel createHTMLDocumentPanel() {
        this.typeBox.setEditable(true);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        JPanel pane = new JPanel(layout);
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        this.gridLayoutComponent(pane, layout, gc, this.typeLabel, 0, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.typeBox, 1, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.srcBtn, 0, 1, true);
        gc.fill = 0;
        gc.gridwidth = 2;
        this.gridLayoutComponent(pane, layout, gc, this.srcField, 1, 1, true);
        gc.fill = 2;
        gc.gridwidth = 1;
        this.gridLayoutComponent(pane, layout, gc, this.srcLinkBtn, 3, 1, true);
        this.gridLayoutComponent(pane, layout, gc, this.charsetBtn, 0, 2, true);
        this.gridLayoutComponent(pane, layout, gc, this.charsetBox, 1, 2, false);
        this.gridLayoutComponent(pane, layout, gc, this.deferBtn, 0, 3, true);
        this.srcLinkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] filter = new String[]{"javascript"};
                HTMLScriptDialog.this.fileSelect(HTMLScriptDialog.this.srcField, filter);
            }
        });
        this.srcBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLScriptDialog.this.enabledSetting(e, HTMLScriptDialog.this.srcLinkBtn);
                HTMLScriptDialog.this.enabledSetting(e, HTMLScriptDialog.this.srcField);
            }
        });
        this.charsetBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HTMLScriptDialog.this.enabledSetting(e, HTMLScriptDialog.this.charsetBox);
            }
        });
        return pane;
    }

    public String getStringStart() {
        StringBuffer buff = new StringBuffer();
        buff.append("<script");
        buff.append(" type=\"" + (String)this.typeBox.getSelectedItem() + "\"");
        if (this.srcBtn.isSelected()) {
            buff.append(" src=\"" + this.srcField.getText() + "\"");
        }
        if (this.charsetBtn.isSelected()) {
            buff.append(" charset=\"" + (String)this.charsetBox.getSelectedItem() + "\"");
        }
        if (this.deferBtn.isSelected()) {
            buff.append(" defer=\"defer\"");
        }
        buff.append(">\n");
        return buff.toString();
    }

    public String getStringEnd() {
        return "</script>\n";
    }
}

