/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileIOFilter
extends FileFilter {
    public static final String HTML = "html";
    public static final String CSS = "css";
    public static final String XML = "xml";
    public static final String TEXT = "text";
    public static final String JPEG = "jpeg";
    public static final String PNG = "png";
    public static final String GIF = "gif";
    public static final String MOV = "mov";
    public static final String MPEG = "mpeg";
    public static final String JAVASCRIPT = "javascript";
    public static final String HTML_GROUP = "html_g";
    public static final String JPEG_GROUP = "hpeg_g";
    public static final String MOV_GROUP = "mov_g";
    public static final String AUDIO_GROUP = "audio_g";
    public static final String ITUNES_GROUP = "itunes_g";
    private String type;

    public FileIOFilter(String type) {
        this.type = type;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        boolean retFlag = false;
        String filename = file.getName().toLowerCase();
        if (this.type.equals(HTML)) {
            retFlag = filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".xhtml");
        } else if (this.type.equals(CSS)) {
            retFlag = filename.endsWith(".css");
        } else if (this.type.equals(XML)) {
            retFlag = filename.endsWith(".xml") || filename.endsWith(".xsl");
        } else if (this.type.equals(TEXT)) {
            retFlag = filename.endsWith(".txt") || filename.endsWith(".text");
        } else if (this.type.equals(JPEG)) {
            retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg");
        } else if (this.type.equals(PNG)) {
            retFlag = filename.endsWith(".png");
        } else if (this.type.equals(GIF)) {
            retFlag = filename.endsWith(".gif");
        } else if (this.type.equals(MOV)) {
            retFlag = filename.endsWith(".mov");
        } else if (this.type.equals(MPEG)) {
            retFlag = filename.endsWith(".mpeg") || filename.endsWith(".mpg");
        } else if (this.type.equals(JAVASCRIPT)) {
            retFlag = filename.endsWith(".js");
        } else if (this.type.equals(HTML_GROUP)) {
            retFlag = filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".xhtml") || filename.endsWith(".xml");
        } else if (this.type.equals(JPEG_GROUP)) {
            retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".gif") || filename.endsWith(".png");
        } else if (this.type.equals(MOV_GROUP)) {
            retFlag = filename.endsWith(".mov") || filename.endsWith(".mpeg") || filename.endsWith(".mpg");
        } else if (this.type.equals(AUDIO_GROUP)) {
            retFlag = filename.endsWith(".mp3") || filename.endsWith(".mid") || filename.endsWith(".aif") || filename.endsWith(".aiff") || filename.endsWith(".wav") || filename.endsWith(".aac");
        } else if (this.type.equals(ITUNES_GROUP)) {
            retFlag = filename.endsWith(".mp3") || filename.endsWith(".m4a") || filename.endsWith(".mp4") || filename.endsWith(".m4v") || filename.endsWith(".mov") || filename.endsWith(".pdf");
        }
        return retFlag;
    }

    public String getDescription() {
        String str = null;
        if (this.type.equals(HTML)) {
            str = "HTML\u30d5\u30a1\u30a4\u30eb (*.html, *.htm, *.xhtml)";
        } else if (this.type.equals(CSS)) {
            str = "CSS\u30d5\u30a1\u30a4\u30eb (*.css)";
        } else if (this.type.equals(XML)) {
            str = "XML\u30d5\u30a1\u30a4\u30eb (*.xml, *.xsl)";
        } else if (this.type.equals(TEXT)) {
            str = "TEXT\u30d5\u30a1\u30a4\u30eb (*.txt, *.text)";
        } else if (this.type.equals(JPEG)) {
            str = "JPEG\u30d5\u30a1\u30a4\u30eb (*.jpg, *.jpeg)";
        } else if (this.type.equals(PNG)) {
            str = "PNG\u30d5\u30a1\u30a4\u30eb (*.png)";
        } else if (this.type.equals(GIF)) {
            str = "GIF\u30d5\u30a1\u30a4\u30eb (*.gif)";
        } else if (this.type.equals(MOV)) {
            str = "MOV\u30d5\u30a1\u30a4\u30eb (*.mov)";
        } else if (this.type.equals(MPEG)) {
            str = "MPEG\u30d5\u30a1\u30a4\u30eb (*.mpg, *.mpeg)";
        } else if (this.type.equals(JAVASCRIPT)) {
            str = "JavaScript\u30d5\u30a1\u30a4\u30eb (*.js)";
        } else if (this.type.equals(HTML_GROUP)) {
            str = "HTML,XML\u30d5\u30a1\u30a4\u30eb (*.html, *.xml, *.htm, *.xhtml)";
        } else if (this.type.equals(JPEG_GROUP)) {
            str = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb (*.jpg, *.jpeg, *.png, *.gif)";
        } else if (this.type.equals(MOV_GROUP)) {
            str = "\u52d5\u753b\u30d5\u30a1\u30a4\u30eb (*.mov, *.mpg, *.mpeg)";
        } else if (this.type.equals(AUDIO_GROUP)) {
            str = "\u97f3\u58f0\u30d5\u30a1\u30a4\u30eb (*.mp3, *.mid, *.aif, *.aiff, *.wav, *.aac)";
        } else if (this.type.equals(ITUNES_GROUP)) {
            str = "Podcast\u30d5\u30a1\u30a4\u30eb (*.mp3, *.m4a, *.mp4, *.m4v, *.mov, *.pdf)";
        }
        return str;
    }
}

