/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Configuration {
    public static void load() {
        try {
            Document doc;
            Element root;
            JHime.TAB_SIZE = 4;
            JHime.FONT_SIZE = 11;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            String path = "JHime.xml";
            if (JHime.USER_PATH != null) {
                path = JHime.USER_PATH + "/" + path;
            }
            if ((root = (doc = db.parse(new FileInputStream(path))).getDocumentElement()).getTagName().equals("jhime")) {
                NodeList nodeList = root.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    String tagName = ((Element)node).getTagName();
                    String value = ((Element)node).getAttribute("value");
                    if (tagName.equals("tabsize")) {
                        JHime.TAB_SIZE = Integer.parseInt(value);
                        continue;
                    }
                    if (tagName.equals("fontsize")) {
                        JHime.FONT_SIZE = Integer.parseInt(value);
                        continue;
                    }
                    if (tagName.equals("csstabcount")) {
                        JHime.CSS_TAB_COUNT = Integer.parseInt(value);
                        continue;
                    }
                    if (tagName.equals("baseurl")) {
                        JHime.BASEURL = value;
                        continue;
                    }
                    if (tagName.equals("linkfile")) {
                        if (value.toUpperCase().equals("TRUE")) {
                            JHime.LINK_FILE = true;
                            continue;
                        }
                        JHime.LINK_FILE = false;
                        continue;
                    }
                    if (tagName.equals("linkpath")) {
                        if (value.toUpperCase().equals("TRUE")) {
                            JHime.LINK_PATH = true;
                            continue;
                        }
                        JHime.LINK_PATH = false;
                        continue;
                    }
                    if (!tagName.equals("linkurl")) continue;
                    JHime.LINK_URL = value.toUpperCase().equals("TRUE");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("jhime");
            doc.appendChild(root);
            Element tabSize = doc.createElement("tabsize");
            tabSize.setAttribute("value", Integer.toString(JHime.TAB_SIZE));
            root.appendChild(tabSize);
            Element fontSize = doc.createElement("fontsize");
            fontSize.setAttribute("value", Integer.toString(JHime.FONT_SIZE));
            root.appendChild(fontSize);
            Element cssTabCount = doc.createElement("csstabcount");
            cssTabCount.setAttribute("value", Integer.toString(JHime.CSS_TAB_COUNT));
            root.appendChild(cssTabCount);
            Element baseUrl = doc.createElement("baseurl");
            baseUrl.setAttribute("value", JHime.BASEURL);
            root.appendChild(baseUrl);
            Element linkFile = doc.createElement("linkfile");
            if (JHime.LINK_FILE) {
                linkFile.setAttribute("value", "TRUE");
            } else {
                linkFile.setAttribute("value", "FALSE");
            }
            root.appendChild(linkFile);
            Element linkPath = doc.createElement("linkpath");
            if (JHime.LINK_PATH) {
                linkPath.setAttribute("value", "TRUE");
            } else {
                linkPath.setAttribute("value", "FALSE");
            }
            root.appendChild(linkPath);
            Element linkUrl = doc.createElement("linkurl");
            if (JHime.LINK_URL) {
                linkUrl.setAttribute("value", "TRUE");
            } else {
                linkUrl.setAttribute("value", "FALSE");
            }
            root.appendChild(linkUrl);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            String path = "JHime.xml";
            if (JHime.USER_PATH != null) {
                path = JHime.USER_PATH + "/" + path;
            }
            tf.transform(new DOMSource(doc), new StreamResult(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

