/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class CSSColorComponent
implements ActionListener {
    private String[] color_str = new String[]{"", "black", "silver", "gray", "navy", "blue", "aqua", "teal", "purple", "fuchsia", "white", "lime", "green", "maroon", "red", "orange", "yellow", "olive"};
    public JComboBox colorBox = new JComboBox<String>(this.color_str);
    public JButton colorLinkBtn = new JButton("\u8272\u53c2\u7167");
    private String[] type_str = new String[]{"#rrggbb\u5f62\u5f0f", "#rgb\u5f62\u5f0f", "rgb(r, g, b)\u5f62\u5f0f", "rgb(r%, g%, b%)\u5f62\u5f0f"};
    public JComboBox typeBox = new JComboBox<String>(this.type_str);
    private JDialog dlg;

    public CSSColorComponent(JDialog dlg) {
        this.colorBox.setEditable(true);
        this.colorLinkBtn.addActionListener(this);
        this.dlg = dlg;
    }

    private String getHexColorCode(Color cl) {
        String red = "0" + Integer.toHexString(cl.getRed());
        String green = "0" + Integer.toHexString(cl.getGreen());
        String blue = "0" + Integer.toHexString(cl.getBlue());
        StringBuffer buff = new StringBuffer();
        buff.append("#");
        int i = red.length() - 2;
        buff.append(red.substring(i));
        i = green.length() - 2;
        buff.append(green.substring(i));
        i = blue.length() - 2;
        buff.append(blue.substring(i));
        return buff.toString();
    }

    private String getRgbColorCode(Color cl) {
        String red = "0" + Integer.toHexString(cl.getRed());
        String green = "0" + Integer.toHexString(cl.getGreen());
        String blue = "0" + Integer.toHexString(cl.getBlue());
        StringBuffer buff = new StringBuffer();
        buff.append("#");
        int i = red.length() - 2;
        buff.append(red.charAt(i));
        i = green.length() - 2;
        buff.append(green.charAt(i));
        i = blue.length() - 2;
        buff.append(blue.charAt(i));
        return buff.toString();
    }

    private String getRgb10ColorCode(Color cl) {
        String red = Integer.toString(cl.getRed());
        String green = Integer.toString(cl.getGreen());
        String blue = Integer.toString(cl.getBlue());
        StringBuffer buff = new StringBuffer();
        buff.append("rgb(");
        buff.append(red + ",");
        buff.append(green + ",");
        buff.append(blue + ")");
        return buff.toString();
    }

    private String getRgbPercentColorCode(Color cl) {
        String red = Integer.toString(cl.getRed() * 100 / 255);
        String green = Integer.toString(cl.getGreen() * 100 / 255);
        String blue = Integer.toString(cl.getBlue() * 100 / 255);
        StringBuffer buff = new StringBuffer();
        buff.append("rgb(");
        buff.append(red + "%,");
        buff.append(green + "%,");
        buff.append(blue + "%)");
        return buff.toString();
    }

    private String createColorCode(Color cl) {
        String ret = null;
        switch (this.typeBox.getSelectedIndex()) {
            case 0: {
                ret = this.getHexColorCode(cl);
                break;
            }
            case 1: {
                ret = this.getRgbColorCode(cl);
                break;
            }
            case 2: {
                ret = this.getRgb10ColorCode(cl);
                break;
            }
            case 3: {
                ret = this.getRgbPercentColorCode(cl);
            }
        }
        return ret;
    }

    public String getColor() {
        return (String)this.colorBox.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        JColorChooser dlg = new JColorChooser();
        Color ret = JColorChooser.showDialog(this.dlg, "\u8272\u53c2\u7167", Color.black);
        if (ret != null) {
            this.colorBox.setSelectedItem(this.createColorCode(ret));
        }
    }
}

