package jp.sourceforge.jeextension.jspc.popup.actions;
/* ********************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 * ********************************************************************/

import java.io.File;

import jp.sourceforge.jeextension.jspc.JspC;

import org.apache.jasper.JasperException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class JspCAction implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public JspCAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {

        IWorkbenchWindow window= JavaPlugin.getActiveWorkbenchWindow();
        ISelection selection= window.getSelectionService().getSelection();
		
        IResource resource = getSelectionResource(selection);
        if (resource == null) {
            showMessage();
            return;
        }
        File dir = resource.getLocation().toFile();
        String[] dirList = dir.list();
        boolean uriroot = false;
        for (int i = 0; i < dirList.length; i++) {
            if (dirList[i].equals("WEB-INF")) {
                uriroot = true;
            }
        }
        if (uriroot == false) {
            showMessage();
            return;
        }
        
		IProgressMonitor monitor = new NullProgressMonitor();
        IResource file = getSelectionResource(selection);
        if (file == null) {
            showMessage();
            return;
        }
		IProject project = file.getProject();
		JspC jspc = new JspC();
		String location = project.getLocation().toFile().getPath();
		jspc.setUriroot(file.getLocation().toFile().getPath());
		jspc.setOutputDir(location + "/work/org/apache/jsp");
		jspc.setPackage("org.apache.jsp");
        jspc.setJavaEncoding("Shift_JIS");
		try {
			jspc.execute();
		} catch (JasperException e) {
            showMessage(e);
            return;
		}
		try {
			project.refreshLocal(IResource.DEPTH_INFINITE, monitor);
			project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, monitor);
		} catch (CoreException e) {
            showMessage(e);
            return;
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
    
    private IResource getSelectionResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IResource) {
                return (IResource) obj;
            }
        }
        return null;
    }
    
    private void showMessage() {
        Shell shell = new Shell();
        MessageDialog.openWarning(shell, "Warning",
            "please select folder include \"WEB-INF\"");
        return;
    }

    private void showMessage(Exception e) {
        Shell shell = new Shell();
        MessageDialog.openWarning(shell, "Warning", e.getMessage());
        return;
    }

}
