/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.jspc.popup.actions;

import java.io.File;
import jp.sourceforge.jeextension.jspc.JspC;
import org.apache.jasper.JasperException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class JspCAction
implements IObjectActionDelegate {
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        IResource resource = this.getSelectionResource(selection);
        if (resource == null) {
            this.showMessage();
            return;
        }
        File dir = resource.getLocation().toFile();
        String[] dirList = dir.list();
        boolean uriroot = false;
        int i = 0;
        while (i < dirList.length) {
            if (dirList[i].equals("WEB-INF")) {
                uriroot = true;
            }
            ++i;
        }
        if (!uriroot) {
            this.showMessage();
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IResource file = this.getSelectionResource(selection);
        if (file == null) {
            this.showMessage();
            return;
        }
        IProject project = file.getProject();
        JspC jspc = new JspC();
        String location = project.getLocation().toFile().getPath();
        jspc.setUriroot(file.getLocation().toFile().getPath());
        jspc.setOutputDir(String.valueOf(location) + "/work/org/apache/jsp");
        jspc.setPackage("org.apache.jsp");
        jspc.setJavaEncoding("Shift_JIS");
        try {
            jspc.execute();
        }
        catch (JasperException e) {
            this.showMessage((Exception)((Object)e));
            return;
        }
        try {
            project.refreshLocal(2, (IProgressMonitor)monitor);
            project.build(10, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            this.showMessage((Exception)((Object)e));
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IResource getSelectionResource(ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return (IResource)obj;
        }
        return null;
    }

    private void showMessage() {
        Shell shell = new Shell();
        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"please select folder include \"WEB-INF\"");
    }

    private void showMessage(Exception e) {
        Shell shell = new Shell();
        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)e.getMessage());
    }
}

