/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/preferences/AddDependsDialog.java,v 1.3 2005/01/31 07:30:41 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/31 07:30:41 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * DefinedStyleEditroDialog
 */
class AddDependsDialog extends DefaultDialog {
    
    /** ColorSelector button. */
    private ColorSelector fColorSel;

    /** 'End' Label. */
    private Label fLabelEnd;

    /** 'Keyword' Label. */
    private Label fLabelKwd;

    /** 'Start' Label. */
    private Label fLabelStr;
    
    /** depends partition name. */
    private String fParitionName;
    
    /** Selection Radio button. */
    private Button fRadioMlt;
    
    /** Selection Radio button. */
    private Button fRadioEnd;
    
    /** Selection Radio button. */
    private Button fRadioKwd;
    
    /** Selection Radio button. */
    private Button fRadioSgl;
    
    /** return values reference when dialog was disposed. */
    private IDependsEntry[] fStyleContainer;
    
    /** dialog values container. */
    private IDependsEntry fStyleEntry;
    
    /** End's Text. */
    private Text fTextEnd;
    
    /** Keyword's Text. */
    private Text fTextKwd;
    
    /** Start's Text. */
    private Text fTextStr;
    
    /** Case Check Button. */
    private Button fCheckCase;
    
    /** current editting extension. */
    private String fExtension;
    
    /**
     * Initiate DefineEditorDialog Window.
     * @param shell     shell using on parent window
     * @param container dialog values container.
     * @param part      depends partition name.
     * @param ext   extension name. (ex. java, means *.java)
     */
    AddDependsDialog(Shell shell, IDependsEntry[] container, String part,
            String ext) {
        super(shell);
        fStyleEntry = container[0];
        fStyleContainer = container;
        fParitionName = part;
        fExtension = ext;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    public void handleEvent(Event event) {
        if (event.widget == fRadioSgl || event.widget == fRadioMlt) {
            fLabelStr.setEnabled(true);
            fLabelEnd.setEnabled(true);
            fLabelKwd.setEnabled(false);
            fTextStr.setEnabled(true);
            fTextEnd.setEnabled(true);
            fTextKwd.setEnabled(false);
        }
        if (event.widget == fRadioEnd) {
            fLabelStr.setEnabled(true);
            fLabelEnd.setEnabled(false);
            fLabelKwd.setEnabled(false);
            fTextStr.setEnabled(true);
            fTextEnd.setEnabled(false);
            fTextKwd.setEnabled(false);
        }
        if (event.widget == fRadioKwd) {
            fLabelStr.setEnabled(false);
            fLabelEnd.setEnabled(false);
            fLabelKwd.setEnabled(true);
            fTextStr.setEnabled(false);
            fTextEnd.setEnabled(false);
            fTextKwd.setEnabled(true);
        }
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        
        final Composite composite = (Composite) super.createDialogArea(parent);
        {
            final GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout(gridLayout);

            final Label label = new Label(composite, SWT.NONE);
            final GridData gridData = new GridData();
            gridData.verticalSpan = 4;
            label.setLayoutData(gridData);
            label.setText(getMessage("pref.depends.dlg.radio.label"));

            fRadioMlt = new Button(composite, SWT.RADIO);
            fRadioMlt.setText(getMessage("pref.depends.dlg.radio.multline"));
            fRadioMlt.addListener(SWT.Selection, this);

            fRadioEnd = new Button(composite, SWT.RADIO);
            fRadioEnd.setText(getMessage("pref.depends.dlg.radio.endofline"));
            fRadioEnd.addListener(SWT.Selection, this);

            fRadioSgl = new Button(composite, SWT.RADIO);
            fRadioSgl.setText(getMessage("pref.depends.dlg.radio.singleline"));
            fRadioSgl.addListener(SWT.Selection, this);

            fRadioKwd = new Button(composite, SWT.RADIO);
            fRadioKwd.setText(getMessage("pref.depends.dlg.radio.keyword"));
            fRadioKwd.addListener(SWT.Selection, this);
        }
        final Composite subComposite = new Composite(composite, SWT.NONE);
        {
            final GridData gridData = new GridData(GridData.FILL_BOTH);
            gridData.horizontalSpan = 2;
            subComposite.setLayoutData(gridData);
            final GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            subComposite.setLayout(gridLayout);

            fLabelStr = new Label(subComposite, SWT.NONE);
            fLabelStr.setText(getMessage("pref.depends.dlg.start"));

            fTextStr = new Text(subComposite, SWT.BORDER);
            fTextStr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            fLabelEnd = new Label(subComposite, SWT.NONE);
            fLabelEnd.setText(getMessage("pref.depends.dlg.end"));

            fTextEnd = new Text(subComposite, SWT.BORDER);
            fTextEnd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            fLabelKwd = new Label(subComposite, SWT.NONE);
            fLabelKwd.setText(getMessage("pref.depends.dlg.keyword"));

            fTextKwd = new Text(subComposite, SWT.BORDER);
            fTextKwd.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

            final Label cLabelClr = new Label(subComposite, SWT.NONE);
            cLabelClr.setText(getMessage("pref.depends.dlg.color"));

            fColorSel = new ColorSelector(subComposite);
            fColorSel.setColorValue(new RGB(0, 0, 0));

            fCheckCase = new Button(subComposite, SWT.CHECK);
            fCheckCase.setText(getMessage("pref.depends.dlg.case"));
            fCheckCase.setSelection(true);
            final GridData gridData2 = new GridData();
            gridData2.horizontalSpan = 2;
            fCheckCase.setLayoutData(gridData2);

        }
        
        Event event = new Event();
        if (fStyleEntry != null) {
            IExtRule rule = fStyleEntry.getRule();
            if (fStyleEntry.getName().equals("keyword")) {
                fTextKwd.setText(rule.getWords()[0]);
                String sensitive = rule.getWords()[1];
                if (sensitive.equalsIgnoreCase("true")) {
                    fCheckCase.setSelection(
                            Boolean.valueOf(sensitive).booleanValue());
                }
                fRadioMlt.setEnabled(false);
                fRadioKwd.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioEnd.setEnabled(false);
                fCheckCase.setEnabled(true);
                event.widget = fRadioKwd;
            }
            if (fStyleEntry.getName().equals("endOfLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fRadioMlt.setEnabled(false);
                fRadioEnd.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fCheckCase.setEnabled(false);
                event.widget = fRadioEnd;
            }
            if (fStyleEntry.getName().equals("singleLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fTextEnd.setText(rule.getWords()[1]);
                fRadioMlt.setEnabled(false);
                fRadioSgl.setSelection(true);
                fRadioEnd.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fCheckCase.setEnabled(false);
                event.widget = fRadioSgl;
            }
            if (fStyleEntry.getName().equals("multiLine")) {
                fTextStr.setText(rule.getWords()[0]);
                fTextEnd.setText(rule.getWords()[1]);
                fRadioMlt.setSelection(true);
                fRadioSgl.setEnabled(false);
                fRadioEnd.setEnabled(false);
                fRadioKwd.setEnabled(false);
                fCheckCase.setEnabled(false);
                event.widget = fRadioMlt;
            }
            handleEvent(event);
            fColorSel.setColorValue(fStyleEntry.getRGB());
        }
        else {
            fRadioKwd.setSelection(true);
            event.widget = fRadioKwd;
            handleEvent(event);
        }
        
        return composite;
    }
    
    /**
     * {@inheritDoc}
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     */
    protected void okPressed() {
        
        XMLNode parent = new XMLNode("partition");
        parent.setAttribute("name", fParitionName);
        XMLNode node = null;
        if (fRadioKwd.getSelection()) {
            RGB rgb = fColorSel.getColorValue();
            node = new XMLNode("keyword");
            node.setAttribute("red"  , String.valueOf(rgb.red));
            node.setAttribute("green", String.valueOf(rgb.green));
            node.setAttribute("blue" , String.valueOf(rgb.blue));
            node.setAttribute("word" , fTextKwd.getText());
            node.setAttribute("case" ,
                    String.valueOf(fCheckCase.getSelection()));
            parent.addChild(node);
        }
        if (fRadioMlt.getSelection()) {
            RGB rgb = fColorSel.getColorValue();
            node = new XMLNode("multiLine");
            node.setAttribute("red"  , String.valueOf(rgb.red));
            node.setAttribute("green", String.valueOf(rgb.green));
            node.setAttribute("blue" , String.valueOf(rgb.blue));
            node.setAttribute("start", fTextStr.getText());
            node.setAttribute("end"  , fTextEnd.getText());
            parent.addChild(node);
        }
        if (fRadioSgl.getSelection()) {
            RGB rgb = fColorSel.getColorValue();
            node = new XMLNode("singleLine");
            node.setAttribute("red"  , String.valueOf(rgb.red));
            node.setAttribute("green", String.valueOf(rgb.green));
            node.setAttribute("blue" , String.valueOf(rgb.blue));
            node.setAttribute("start", fTextStr.getText());
            node.setAttribute("end"  , fTextEnd.getText());
            parent.addChild(node);
        }
        if (fRadioEnd.getSelection()) {
            RGB rgb = fColorSel.getColorValue();
            node = new XMLNode("endOfLine");
            node.setAttribute("red"  , String.valueOf(rgb.red));
            node.setAttribute("green", String.valueOf(rgb.green));
            node.setAttribute("blue" , String.valueOf(rgb.blue));
            node.setAttribute("start", fTextStr.getText());
            parent.addChild(node);
        }
        if (fStyleEntry == null) {
            fStyleEntry = new DependsEntry(node, fExtension);
        }
        else {
            EditorTools.changeDependsEntry(fStyleEntry, node, fExtension);
        }
        fStyleContainer[0] = fStyleEntry;
        
        super.okPressed();
    }
}
