/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/DependsEntry.java,v 1.2 2005/01/30 06:02:40 kohnosuke Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/30 06:02:40 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.swt.graphics.RGB;

/**
 * DependsEntry
 */
public class DependsEntry implements IDependsEntry {
    
    /** entry type name */
    private String fName = "";
    
    /** depends PartitionEntry. */
    private IPartitionEntry fPartitionEntry;
    
    /** defined RGB color. */
    private RGB fRGB = new RGB(0, 0, 0);
    
    /** defined rule object. */
    private IExtRule fRule;
    
    /**
     * Initiate this object. for default constructor.
     */
    public DependsEntry() {
        super();
    }
    
    /**
     * Initiate this object. using XMLNode and IPartitionEntry.
     * @param node  XMLNode
     * @param ext   extension name. (ex. java, means *.java)
     */
    public DependsEntry(XMLNode node, String ext) {
        super();
        this.fPartitionEntry = EditorTools.getPartitionEntry(
                node.getParentNode().getAttribute("name"), ext, true);
        this.fName = node.getNodeName();
        this.fRGB.red   = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue  = Integer.parseInt(node.getAttribute("blue"));
        this.fRule = EditorTools.createExtRule(node, ext);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IDependsEntry#createNode()
     */
    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode(this.fName);
        xmlNode.setAttribute("red"  , String.valueOf(this.fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(this.fRGB.green));
        xmlNode.setAttribute("blue" , String.valueOf(this.fRGB.blue));
        if (this.fName.equals("multiLine")) {
            xmlNode.setAttribute("start", fRule.getWords()[0]);
            xmlNode.setAttribute("end"  , fRule.getWords()[1]);
        }
        if (this.fName.equals("singleLine")) {
            xmlNode.setAttribute("start", fRule.getWords()[0]);
            xmlNode.setAttribute("end"  , fRule.getWords()[1]);
        }
        if (this.fName.equals("endOfLine")) {
            xmlNode.setAttribute("start", fRule.getWords()[0]);
        }
        if (this.fName.equals("keyword")) {
            xmlNode.setAttribute("word", fRule.getWords()[0]);
            xmlNode.setAttribute("case", fRule.getWords()[1]);
        }
        return xmlNode;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IDependsEntry#getDepends()
     */
    public IPartitionEntry getDepends() {
        return this.fPartitionEntry;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getName()
     */
    public String getName() {
        return this.fName;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRGB()
     */
    public RGB getRGB() {
        return this.fRGB;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRule()
     */
    public IExtRule getRule() {
        return this.fRule;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry#getWords()
     */
    public String[] getWords() {
        return this.fRule.getWords();
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IDependsEntry#setDepends(jp.sourceforge.jeextension.editor.entry.IPartitionEntry)
     */
    public void setDepends(IPartitionEntry depends) {
        this.fPartitionEntry = depends; 
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#setRGB(org.eclipse.swt.graphics.RGB)
     */
    public void setRGB(RGB pRGB) {
        this.fRGB = pRGB;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setRule(jp.sourceforge.jeextension.styleeditor.text.IExtRule)
     */
    public void setRule(IExtRule rule) {
        fRule = rule;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IDependsEntry#setWords(java.lang.String[])
     */
    public void setWords(String[] words) {
        this.fRule.setWords(words);
    }
}
