/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/ColorManager.java,v 1.1 2005/01/29 03:24:19 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:19 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/**
 * ColorManager is managing Color and RGB Objects.
 */
public class ColorManager {

    /**
     * Color Object managing table.
     */
    protected Map fColorTable = new HashMap(10);

    /**
     * Initiate ColorManager.
     */
    public ColorManager() {
        super();
    }

    /**
     * dispose Color objects. and Clear managing tables.
     */
    public void dispose() {
        Iterator e = fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color) e.next()).dispose();
        }
    }

    /**
     * Return Color object form RGB.
     * @param rgb org.eclipse.swt.graphics.RGB
     * @return org.eclipse.swt.graphics.Color
     */
    public Color getColor(RGB rgb) {
        Color color = (Color) fColorTable.get(rgb);
        if (color == null) {
            color = new Color(Display.getCurrent(), rgb);
            fColorTable.put(rgb, color);
        }
        return color;
    }
}
