// ライセンス: GPL2

//#define _DEBUG
#include "jddebug.h"

#include "maintoolbar.h"

#include "config/globalconf.h"

#include "icons/iconmanager.h"

#include "control/controlutil.h"
#include "control/controlid.h"

#include "session.h"
#include "global.h"

using namespace CORE;


MainToolBar::MainToolBar() :
    SKELETON::ToolBar( NULL ),
      m_button_go( Gtk::Stock::JUMP_TO ),

      m_button_bbslist( ICON::DIR ),
      m_button_favorite( ICON::FAVORITE ),
      m_button_board( ICON::BOARD ),
      m_button_thread( ICON::THREAD ),
      m_button_image( ICON::IMAGE )
{
    m_entry_url.set_size_request( 0 );
    m_tool_url.add( m_entry_url );
    m_tool_url.set_expand( true );

    set_tooltip( m_button_go, ITEM_NAME_GO );

    set_tooltip( m_button_bbslist, std::string( ITEM_NAME_BBSLISTVIEW )
                 + "\n\nお気に入りに切替え " + CONTROL::get_str_motions( CONTROL::TabRight ) );
    set_tooltip( m_button_favorite, std::string( ITEM_NAME_FAVORITEVIEW )
                 + "\n\n板一覧に切替え " + CONTROL::get_str_motions( CONTROL::TabLeft ) );
    set_tooltip( m_button_board, std::string( ITEM_NAME_BOARDVIEW )
                 + "\n\n" + CONTROL::get_label_motions( CONTROL::ToggleArticle ) );
    set_tooltip( m_button_thread, std::string( ITEM_NAME_ARTICLEVIEW )
                 + "\n\n" + CONTROL::get_label_motions( CONTROL::ToggleArticle ) );
    set_tooltip( m_button_image, std::string( ITEM_NAME_IMAGEVIEW )
                 + "\n\nスレビューに切替 "
                 + CONTROL::get_str_motions( CONTROL::ToggleArticle ) + " , " + CONTROL::get_str_motions( CONTROL::Left ) );
        
    pack_buttons();
}

// ボタンのパッキング
// virtual
void MainToolBar::pack_buttons()
{
    int num = 0;
    for(;;){
        int item = SESSION::get_item_main_toolbar( num );
        if( item == ITEM_END ) break;
        switch( item ){

            case ITEM_BBSLISTVIEW:
                get_buttonbar().append( m_button_bbslist );
                break;

            case ITEM_FAVORITEVIEW:
                get_buttonbar().append( m_button_favorite );
                break;

            case ITEM_BOARDVIEW:
                get_buttonbar().append( m_button_board );
                break;

            case ITEM_ARTICLEVIEW:
                get_buttonbar().append( m_button_thread );
                break;

            case ITEM_IMAGEVIEW:
                if( CONFIG::get_use_image_view() ) get_buttonbar().append( m_button_image );
                break;

            case ITEM_URL:
                get_buttonbar().append( m_tool_url );
                break;

            case ITEM_GO:
                get_buttonbar().append( m_button_go );
                break;

            case ITEM_SEPARATOR:
                pack_separator();
                break;
        }
        ++num;
    }

    set_relief();
    show_all_children();
}    
