/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.internal.AudioBufferImpl;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioRenderSupportImpl
implements AudioRenderSupport {
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private Injector _injector;

    @Override
    public AudioBuffer createAudioBuffer() {
        return this.createAudioBuffer(this._arContext.getFrameCount());
    }

    @Override
    public AudioBuffer createAudioBuffer(int frameCount) {
        AudioBufferImpl ab = new AudioBufferImpl(this._arContext.getAudioMode(), frameCount);
        this._injector.injectMembers((Object)ab);
        return ab;
    }

    @Override
    public AudioBuffer mix(AudioBuffer ab1, AudioBuffer ab2) {
        if (ab1.getAudioMode() != ab2.getAudioMode()) {
            throw new IllegalArgumentException("AudioMode of AudioBuffer arguments must match");
        }
        if (ab1.getFrameCount() > ab2.getFrameCount()) {
            AudioBuffer tmp = ab1;
            ab1 = ab2;
            ab2 = tmp;
        }
        Object data1 = ab1.getData();
        Object data2 = ab2.getData();
        int dataLen = ab1.getDataLength();
        switch (ab1.getAudioMode().dataType) {
            case SHORT: {
                this.mix((short[])data1, (short[])data2, dataLen);
                break;
            }
            case INT: {
                this.mix((int[])data1, (int[])data2, dataLen);
                break;
            }
            case FLOAT: {
                this.mix((float[])data1, (float[])data2, dataLen);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported AudioMode.DataType: " + ab1.getAudioMode().dataType);
            }
        }
        return ab1;
    }

    private void mix(short[] data1, short[] data2, int dataLen) {
        int i = 0;
        while (i < dataLen) {
            short v1 = data1[i];
            short v2 = data2[i];
            data1[i] = (short)Math.min(Math.max(v1 + v2, Short.MIN_VALUE), Short.MAX_VALUE);
            ++i;
        }
    }

    private void mix(int[] data1, int[] data2, int dataLen) {
        int i = 0;
        while (i < dataLen) {
            long v1 = data1[i];
            long v2 = data2[i];
            data1[i] = (int)Math.min(Math.max(v1 + v2, Integer.MIN_VALUE), Integer.MAX_VALUE);
            ++i;
        }
    }

    private void mix(float[] data1, float[] data2, int dataLen) {
        int i = 0;
        while (i < dataLen) {
            int n = i;
            data1[n] = data1[n] + data2[i];
            ++i;
        }
    }

    @Override
    public void amplify(AudioBuffer ab, IObjectArray<Vec2d> amplitude) {
        if (ab.getAudioMode().channels != 2) {
            throw new IllegalArgumentException("channels: " + ab.getAudioMode().channels);
        }
        Object data = ab.getData();
        int frameCount = ab.getFrameCount();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                this.amplify((short[])data, frameCount, amplitude);
                break;
            }
            case INT: {
                this.amplify((int[])data, frameCount, amplitude);
                break;
            }
            case FLOAT: {
                this.amplify((float[])data, frameCount, amplitude);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
    }

    private void amplify(short[] data, int frameCount, IObjectArray<Vec2d> amplitude) {
        Object[] array = (Object[])amplitude.getArray();
        int i = 0;
        while (i < frameCount) {
            Vec2d amp = (Vec2d)array[i];
            double leftAmp = Math.pow(10.0, amp.x / 20.0);
            double rightAmp = Math.pow(10.0, amp.y / 20.0);
            data[i * 2] = (short)Math.min(Math.max((double)data[i * 2] * leftAmp, -32768.0), 32767.0);
            data[i * 2 + 1] = (short)Math.min(Math.max((double)data[i * 2 + 1] * rightAmp, -32768.0), 32767.0);
            ++i;
        }
    }

    private void amplify(int[] data, int frameCount, IObjectArray<Vec2d> amplitude) {
        Object[] array = (Object[])amplitude.getArray();
        int i = 0;
        while (i < frameCount) {
            Vec2d amp = (Vec2d)array[i];
            double leftAmp = Math.pow(10.0, amp.x / 20.0);
            double rightAmp = Math.pow(10.0, amp.y / 20.0);
            data[i * 2] = (int)Math.min(Math.max((double)data[i * 2] * leftAmp, -2.147483648E9), 2.147483647E9);
            data[i * 2 + 1] = (int)Math.min(Math.max((double)data[i * 2 + 1] * rightAmp, -2.147483648E9), 2.147483647E9);
            ++i;
        }
    }

    private void amplify(float[] data, int frameCount, IObjectArray<Vec2d> amplitude) {
        Object[] array = (Object[])amplitude.getArray();
        int i = 0;
        while (i < frameCount) {
            Vec2d amp = (Vec2d)array[i];
            double leftAmp = Math.pow(10.0, amp.x / 20.0);
            double rightAmp = Math.pow(10.0, amp.y / 20.0);
            int n = i * 2;
            data[n] = (float)((double)data[n] * leftAmp);
            int n2 = i * 2 + 1;
            data[n2] = (float)((double)data[n2] * rightAmp);
            ++i;
        }
    }

    @Override
    public void clear(AudioBuffer ab) {
        this.clear(ab, 0, ab.getFrameCount());
    }

    @Override
    public void clear(AudioBuffer ab, int frameOffset, int frameCount) {
        Object data = ab.getData();
        int channels = ab.getAudioMode().channels;
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])data, frameOffset * channels, (frameOffset + frameCount) * channels, (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])data, frameOffset * channels, (frameOffset + frameCount) * channels, 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])data, frameOffset * channels, (frameOffset + frameCount) * channels, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
    }
}

