/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Expressioner;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import com.google.inject.Inject;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderContext
implements RenderContext {
    @Inject
    private ContextFactory _jsContextFactory;
    private Time _time;
    private Scriptable _initialExprScope;
    private final Set<Composition> _scopeCreatedComps = Util.newSet();
    private final Map<Expressioner<?>, ExpressionScopeImpl> _scopeMap = Util.newMap();
    private final WeakHashMap<Expressionee, WeakReference<?>> _exprElemPool = Util.newWeakHashMap();
    private final Set<Expressioner<?>> _cyclicCheck = Util.newSet();
    private final WeakHashMap<String, Script> _exprScriptCache = Util.newWeakHashMap();

    @Override
    public void activate() {
        if (this._initialExprScope != null) {
            throw new IllegalStateException("already activated");
        }
        Context jsContext = this._jsContextFactory.enterContext();
        ScriptableObject scope = jsContext.initStandardObjects(null, true);
        scope.sealObject();
        this._initialExprScope = scope;
    }

    @Override
    public void deactivate() {
        this._time = null;
        if (this._initialExprScope != null) {
            this._initialExprScope = null;
            Context.exit();
        }
    }

    @Override
    public boolean isActive() {
        return this._initialExprScope != null;
    }

    private Scriptable createNewExprScope(final Scriptable sharedScope) {
        return (Scriptable)this._jsContextFactory.call(new ContextAction(){

            public Object run(Context context) {
                Scriptable newScope = context.newObject(sharedScope);
                newScope.setPrototype(sharedScope);
                newScope.setParentScope(null);
                return newScope;
            }
        });
    }

    @Override
    public void reset() {
        this._time = null;
    }

    @Override
    public <T> T saveAndExecute(WrappedOperation<T> operation) {
        Time time = this._time;
        try {
            T t = operation.execute();
            return t;
        }
        finally {
            this._time = time;
        }
    }

    @Override
    public Time getTime() {
        return this._time;
    }

    @Override
    public void setTime(Time time) {
        this._time = time;
    }

    @Override
    public ExpressionScope createInitialExpressionScope(Composition comp) {
        this._scopeCreatedComps.clear();
        this._scopeMap.clear();
        this._scopeCreatedComps.add(comp);
        return new ExpressionScopeImpl(this.createNewExprScope(this._initialExprScope));
    }

    @Override
    public <T> T getExpressionElement(Expressionee exprnee) {
        Object elem;
        WeakReference<?> ref = this._exprElemPool.get(exprnee);
        if (ref != null && (elem = ref.get()) != null) {
            return elem;
        }
        elem = exprnee.createExpressionElement(this);
        this._exprElemPool.put(exprnee, new WeakReference(elem));
        return elem;
    }

    @Override
    public boolean checkCyclicEvaluation(Expressioner<?> expr) {
        return this._cyclicCheck.contains(expr);
    }

    @Override
    public <T> T evaluateExpression(final Expressioner<T> expr) {
        final ExpressionScopeImpl scope = this._scopeMap.get(expr);
        if (scope == null) {
            throw new IllegalArgumentException("no expression scope is assigned.");
        }
        if (this.checkCyclicEvaluation(expr)) {
            throw new IllegalArgumentException("cyclic evaluation: " + expr.getExpression());
        }
        this._cyclicCheck.add(expr);
        try {
            T t = expr.jsToJava(this._jsContextFactory.call(new ContextAction(){

                public Object run(Context context) {
                    Scriptable localScope = AbstractRenderContext.this.createNewExprScope(scope.scope);
                    if (AbstractRenderContext.this._time != null) {
                        ScriptableObject.putProperty((Scriptable)localScope, (String)"time", (Object)Context.javaToJS((Object)AbstractRenderContext.this._time.toSecond(), (Scriptable)localScope));
                    }
                    return AbstractRenderContext.this.getScript(context, expr).exec(context, localScope);
                }
            }));
            return t;
        }
        finally {
            this._cyclicCheck.remove(expr);
        }
    }

    @Override
    public Scriptable toNativeJavaObject(Object javaObject, final Class<?> defaultHint) {
        NativeJavaObject njo = new NativeJavaObject(this.createNewExprScope(this._initialExprScope), javaObject, null){

            public String getClassName() {
                return "JavieJavaObject";
            }

            public Object getDefaultValue(Class<?> hint) {
                return super.getDefaultValue(hint != null ? hint : defaultHint);
            }
        };
        return njo;
    }

    private Script getScript(Context context, Expressioner<?> expr) {
        String exprStr = expr.getExpression();
        Script script = this._exprScriptCache.get(exprStr);
        if (script != null) {
            return script;
        }
        String sourceName = "";
        script = context.compileString(exprStr, sourceName, 1, null);
        this._exprScriptCache.put(exprStr, script);
        return script;
    }

    protected Set<Expressioner<?>> getExpressioners() {
        return this._scopeMap.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionScopeImpl
    implements ExpressionScope {
        private Scriptable scope;

        private ExpressionScopeImpl(Scriptable scope) {
            this.scope = scope;
        }

        @Override
        public ExpressionScopeImpl clone() {
            try {
                ExpressionScopeImpl clone = (ExpressionScopeImpl)super.clone();
                clone.scope = AbstractRenderContext.this.createNewExprScope(this.scope);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        @Override
        public ExpressionScope createPrecompositionScope(Composition preComp) {
            if (AbstractRenderContext.this._scopeCreatedComps.contains(preComp)) {
                return null;
            }
            AbstractRenderContext.this._scopeCreatedComps.add(preComp);
            return new ExpressionScopeImpl(AbstractRenderContext.this.createNewExprScope(AbstractRenderContext.this._initialExprScope));
        }

        @Override
        public void setThis(Expressionee exprnee) {
            Scriptable newScope = (Scriptable)Context.javaToJS(AbstractRenderContext.this.getExpressionElement(exprnee), (Scriptable)this.scope);
            newScope.setPrototype(this.scope);
            newScope.setParentScope(null);
            this.scope = newScope;
        }

        @Override
        public void putExpressionElement(String name, Expressionee exprnee) {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)Context.javaToJS(AbstractRenderContext.this.getExpressionElement(exprnee), (Scriptable)this.scope));
        }

        @Override
        public void assignTo(Expressioner<?> expr) {
            if (AbstractRenderContext.this._scopeMap.containsKey(expr)) {
                throw new IllegalArgumentException("already assigned");
            }
            AbstractRenderContext.this._scopeMap.put(expr, this);
        }
    }
}

