/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsDirectShowInput
implements MediaFileInput {
    private static final Logger _logger = LoggerFactory.getLogger(WindowsDirectShowInput.class);
    private long _videoInput;
    private long _audioInput;
    private VideoBounds _bounds;
    private Time _duration;
    private Time _videoFrameDuration;
    private long _lastVideoFrameTime = Long.MAX_VALUE;
    private AudioFormat _audioFormat;
    private boolean _audioFloat;
    private AudioMode _audioMode;
    private AudioInputStream _audioStream;
    private long _audioStreamPosition;
    @Inject
    private SynchronousTaskThread _videoThread;
    @Inject
    private SynchronousTaskThread _audioThread;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private IArrayPools _arrayPools;

    static {
        System.loadLibrary("DirectShowInput");
    }

    public boolean initialize(final File file) {
        this._videoThread.start();
        this._videoThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                WindowsDirectShowInput.this.initializeVideo(file);
            }
        });
        if (this._videoInput == 0L) {
            this.disposeVideo();
        }
        this._audioThread.start();
        this._audioThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                WindowsDirectShowInput.this.initializeAudio(file);
            }
        });
        if (this._audioInput == 0L) {
            this.disposeAudio();
        }
        return this._videoInput != 0L || this._audioInput != 0L;
    }

    private void initializeVideo(File file) {
        long[] result = this.openVideo(file.getAbsolutePath());
        if (result != null) {
            this._videoInput = result[0];
            this._bounds = new VideoBounds((int)result[1], (int)result[2]);
            this._duration = new Time(result[4], 10000000);
            this._videoFrameDuration = new Time(result[4] / result[3], 10000000);
            this._lastVideoFrameTime = (result[3] - 1L) * result[4] / result[3];
            this._videoThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Video): " + file.getName());
        }
    }

    private void initializeAudio(File file) {
        long[] result = this.openAudio(file.getAbsolutePath());
        if (result != null) {
            this._audioInput = result[0];
            if (this._duration == null) {
                this._duration = new Time(result[1], 10000000);
            }
            this._audioFormat = new AudioFormat(result[2], (int)result[3], (int)result[4], true, false);
            this._audioFloat = result[5] != 0L;
            this._audioThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Audio): " + file.getName());
        }
    }

    public void dispose() {
        this.disposeVideo();
        this.disposeAudio();
    }

    private void disposeVideo() {
        this._videoThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (WindowsDirectShowInput.this._videoInput != 0L) {
                    WindowsDirectShowInput.this.closeVideo(WindowsDirectShowInput.this._videoInput);
                    WindowsDirectShowInput.this._videoInput = 0L;
                    WindowsDirectShowInput.this._bounds = null;
                }
            }
        });
    }

    private void disposeAudio() {
        this.closeAudioStream();
        this._audioThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (WindowsDirectShowInput.this._audioInput != 0L) {
                    WindowsDirectShowInput.this.closeAudio(WindowsDirectShowInput.this._audioInput);
                    WindowsDirectShowInput.this._audioInput = 0L;
                    WindowsDirectShowInput.this._audioMode = null;
                }
            }
        });
    }

    private void closeAudioStream() {
        if (this._audioStream != null) {
            try {
                this._audioStream.close();
            }
            catch (IOException e) {
                _logger.warn("failed to close AudioInputStream", (Throwable)e);
            }
            this._audioStream = null;
        }
        this._audioStreamPosition = 0L;
    }

    public boolean isVideoAvailable() {
        return this._videoInput != 0L;
    }

    public boolean isAudioAvailable() {
        return this._audioInput != 0L;
    }

    public Time getDuration() {
        return this._duration;
    }

    public Time getVideoFrameDuration() {
        return this._videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._bounds;
    }

    public VideoBuffer getVideoFrameImage(Time mediaTime) {
        if (this._videoInput == 0L) {
            return null;
        }
        VideoBuffer vb = this._vrSupport.createVideoBuffer(ColorMode.RGBA8, this._bounds);
        if (mediaTime.timeValue < 0L || !mediaTime.before(this._duration)) {
            vb.allocateAsTexture();
            this._vrSupport.clear(vb);
            return vb;
        }
        try {
            vb.allocateAsArray();
            Time time = Time.fromFrameNumber((long)mediaTime.toFrameNumber(this._videoFrameDuration), (Time)this._videoFrameDuration);
            long timeValue = time.timeValue + this._videoFrameDuration.timeValue / 2L;
            int timeScale = time.timeScale;
            final long dsTime = timeValue * 10000000L / (long)timeScale;
            final byte[] array = (byte[])vb.getArray();
            int error = this._videoThread.invoke(new SynchronousTaskThread.Task<Integer>(){

                @Override
                public Integer run() throws Exception {
                    int error = WindowsDirectShowInput.this.frameImageAtTime(WindowsDirectShowInput.this._videoInput, dsTime, array);
                    if (error != 0) {
                        _logger.error("frameImageAtTime: error " + error);
                    }
                    return error;
                }
            });
            if (error != 0) {
                return null;
            }
            RenderResolution resolution = this._vrContext.getRenderResolution();
            VideoBuffer vb2 = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), resolution.scale(this._bounds));
            this._vrSupport.scaleAndFlipVertical(vb, vb2, resolution.scale(1.0));
            VideoBuffer videoBuffer = vb2;
            return videoBuffer;
        }
        finally {
            vb.dispose();
        }
    }

    public synchronized AudioBuffer getAudioChunk(Time mediaTime) {
        try {
            AudioMode audioMode = this._arContext.getAudioMode();
            long frameNumber = mediaTime.toFrameNumber(audioMode.sampleDuration);
            if (-frameNumber >= (long)this._arContext.getFrameCount() || !mediaTime.before(this._duration)) {
                AudioBuffer ab = this._arSupport.createAudioBuffer();
                this._arSupport.clear(ab);
                return ab;
            }
            if (audioMode != this._audioMode || (long)audioMode.frameSize * frameNumber != this._audioStreamPosition) {
                this.closeAudioStream();
            }
            if (this._audioStream == null) {
                this._audioStream = this.createAudioInputStream();
            }
            return this.readAudioData(frameNumber);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private AudioInputStream createAudioInputStream() throws IOException, UnsupportedAudioFileException {
        this._audioMode = this._arContext.getAudioMode();
        int bits = this._audioMode.sampleSize * 8;
        int ch = this._audioMode.channels;
        long length = this._duration.toFrameNumber(new Time(1L, (int)this._audioFormat.getFrameRate()));
        AudioInputStream s1 = AudioSystem.getAudioInputStream(this._audioFormat, new AudioInputStream(new DSAudioInputStream(this._audioFormat), this._audioFormat, length));
        AudioFormat f2 = new AudioFormat(s1.getFormat().getSampleRate(), bits, ch, true, false);
        AudioInputStream s2 = AudioSystem.getAudioInputStream(f2, s1);
        AudioFormat f3 = new AudioFormat(this._audioMode.sampleRate, bits, ch, true, false);
        return AudioSystem.getAudioInputStream(f3, s2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioBuffer readAudioData(long frameNumber) throws IOException {
        AudioBuffer ab = this._arSupport.createAudioBuffer();
        AudioMode audioMode = ab.getAudioMode();
        Object data = ab.getData();
        int dataOffset = 0;
        int dataLength = ab.getDataLength();
        int lengthInBytes = ab.getDataLengthInBytes();
        if (this._audioStreamPosition == 0L) {
            if (frameNumber > 0L) {
                long skipped;
                long skip = (long)audioMode.frameSize * frameNumber;
                this._audioStreamPosition = skipped = this._audioStream.skip(skip / (long)audioMode.sampleRate * (long)audioMode.sampleRate);
                if ((skip -= skipped) > 0L) {
                    IArray array = this._arrayPools.getByteArray((int)skip);
                    try {
                        do {
                            if ((skipped = (long)this._audioStream.read((byte[])array.getArray(), 0, (int)skip)) == -1L) continue;
                            this._audioStreamPosition += skipped;
                            skip -= skipped;
                        } while (skipped != -1L && skip > 0L);
                    }
                    finally {
                        array.release();
                    }
                }
                if (skip != 0L) {
                    _logger.warn(String.format("skip failed: frameNumber=%d, skip=%d", frameNumber, skip));
                    this.closeAudioStream();
                    this._arSupport.clear(ab);
                    return ab;
                }
            } else if (frameNumber < 0L) {
                this._arSupport.clear(ab, 0, (int)(-frameNumber));
                dataOffset = (int)(-frameNumber) * audioMode.channels;
                dataLength -= dataOffset;
                lengthInBytes -= dataOffset * audioMode.sampleSize;
            }
        }
        IArray array = this._arrayPools.getByteArray(lengthInBytes);
        try {
            int n;
            byte[] buffer = (byte[])array.getArray();
            int readBytes = 0;
            do {
                if ((n = this._audioStream.read(buffer, readBytes, lengthInBytes - readBytes)) == -1) {
                    Arrays.fill(buffer, readBytes, lengthInBytes, (byte)0);
                    break;
                }
                this._audioStreamPosition += (long)n;
            } while ((readBytes += n) < lengthInBytes);
            switch (audioMode.dataType) {
                case SHORT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().get((short[])data, dataOffset, dataLength);
                    return ab;
                }
                case INT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asIntBuffer().get((int[])data, dataOffset, dataLength);
                    return ab;
                }
                case FLOAT: {
                    int i = dataOffset;
                    while (i < dataLength) {
                        int value = buffer[i * 4] & 0xFF | (buffer[i * 4 + 1] & 0xFF) << 8 | (buffer[i * 4 + 2] & 0xFF) << 16 | (buffer[i * 4 + 3] & 0xFF) << 24;
                        ((float[])data)[i] = (float)value / 2.1474836E9f;
                        ++i;
                    }
                    return ab;
                }
            }
            throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
        }
        finally {
            array.release();
        }
    }

    private native long[] openVideo(String var1);

    private native long[] openAudio(String var1);

    private native void closeVideo(long var1);

    private native void closeAudio(long var1);

    private native int frameImageAtTime(long var1, long var3, byte[] var5);

    private native int audioChunkFromTime(long var1, long var3, Object var5, int var6, int var7);

    private class DSAudioInputStream
    extends InputStream {
        private final AudioFormat format;
        private long positionInBytes;

        private DSAudioInputStream(AudioFormat format) {
            this.format = format;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 0) != -1 ? b[0] : -1;
        }

        public int read(final byte[] b, final int off, final int len) throws IOException {
            final int frameSize = this.format.getFrameSize();
            final float frameRate = this.format.getFrameRate();
            if (len % this.format.getFrameSize() != 0) {
                throw new IOException("can't read the length bytes that is not multiples of frameSize");
            }
            final long dsTime = (long)((float)(this.positionInBytes * 10000000L) / ((float)frameSize * frameRate));
            if (dsTime > WindowsDirectShowInput.this._lastVideoFrameTime) {
                Arrays.fill(b, off, off + len, (byte)0);
            } else {
                int error = WindowsDirectShowInput.this._audioThread.invoke(new SynchronousTaskThread.Task<Integer>(){

                    @Override
                    public Integer run() throws Exception {
                        int error;
                        int leastLen = frameSize * (int)(frameRate / 10.0f);
                        if (len < leastLen) {
                            IArray array = WindowsDirectShowInput.this._arrayPools.getByteArray(leastLen);
                            error = WindowsDirectShowInput.this.audioChunkFromTime(WindowsDirectShowInput.this._audioInput, dsTime, array.getArray(), 0, leastLen);
                            System.arraycopy(array.getArray(), 0, b, off, len);
                            array.release();
                        } else {
                            error = WindowsDirectShowInput.this.audioChunkFromTime(WindowsDirectShowInput.this._audioInput, dsTime, b, off, len);
                        }
                        if (error != 0) {
                            _logger.error("audioChunkFromTime: error " + error);
                        }
                        return error;
                    }
                });
                if (error != 0) {
                    throw new IOException("error=" + error);
                }
                if (WindowsDirectShowInput.this._audioFloat) {
                    int i = off;
                    while (i < len) {
                        int bits = b[i] & 0xFF | (b[i + 1] & 0xFF) << 8 | (b[i + 2] & 0xFF) << 16 | (b[i + 3] & 0xFF) << 24;
                        int intValue = (int)(Float.intBitsToFloat(bits) * 2.1474836E9f);
                        b[i] = (byte)(intValue & 0xFF);
                        b[i + 1] = (byte)(intValue >>> 8 & 0xFF);
                        b[i + 2] = (byte)(intValue >>> 16 & 0xFF);
                        b[i + 3] = (byte)(intValue >>> 24 & 0xFF);
                        i += 4;
                    }
                }
            }
            this.positionInBytes += (long)len;
            return len;
        }

        public long skip(long n) throws IOException {
            long actualSkip = 0L;
            if (n > 0L) {
                int frameSize = this.format.getFrameSize();
                actualSkip = n / (long)frameSize * (long)frameSize;
                this.positionInBytes += actualSkip;
            }
            return actualSkip;
        }
    }
}

