/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;

class LayerMatrixUtil {
    private final VideoRenderContext _vrContext;
    private final VideoRenderSupport _vrSupport;

    static void multModelViewMatrix(TransformableLayer layer, Vec2d offset, CollapseTransformation ct, VideoRenderContext vrContext, VideoRenderSupport vrSupport) {
        LayerMatrixUtil util = new LayerMatrixUtil(vrContext, vrSupport);
        if (ct != null) {
            util.multCollapseTransformation(ct, LayerNature.isThreeD(layer));
        }
        util.multModelViewMatrix(layer, offset, true);
    }

    static void multParentMatrix(CameraLayer cameraLayer, VideoRenderContext vrContext, VideoRenderSupport vrSupport) {
        Layer parent = cameraLayer.getParent();
        if (parent != null) {
            new LayerMatrixUtil(vrContext, vrSupport).multModelViewMatrixInverse(parent, null, true);
        }
    }

    private LayerMatrixUtil(VideoRenderContext vrContext, VideoRenderSupport vrSupport) {
        this._vrContext = vrContext;
        this._vrSupport = vrSupport;
    }

    private void multCollapseTransformation(CollapseTransformation ct, boolean threeD) {
        MediaItemLayer layer = ct.getLayer();
        if (ct.getParent() != null) {
            this.multCollapseTransformation(ct.getParent(), threeD && LayerNature.isThreeD(layer));
        }
        this.multModelViewMatrix(layer, null, threeD);
    }

    private void multModelViewMatrix(Layer layer, Vec2d offset, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        Layer parent = layer.getParent();
        if (parent != null) {
            this.multModelViewMatrix(parent, null, threeD);
        }
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, offset, threeD, false);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, false);
        }
    }

    private void multModelViewMatrixInverse(Layer layer, Vec2d offset, boolean threeD) {
        threeD &= LayerNature.isThreeD(layer);
        if (layer instanceof TransformableLayer) {
            this.multTransformableLayerMatrix((TransformableLayer)layer, offset, threeD, true);
        } else if (layer instanceof CameraLayer) {
            this.multCameraLayerMatrix((CameraLayer)layer, threeD, true);
        }
        Layer parent = layer.getParent();
        if (parent != null) {
            this.multModelViewMatrixInverse(parent, null, threeD);
        }
    }

    private void multTransformableLayerMatrix(TransformableLayer tlayer, Vec2d offset, boolean threeD, boolean inverse) {
        Vec3d rotation;
        Vec3d orientation;
        if (!LayerNature.isVideoNature(tlayer)) {
            return;
        }
        Vec3d anchorPoint = (Vec3d)tlayer.getAnchorPoint().value(this._vrContext);
        if (offset != null) {
            anchorPoint = new Vec3d(anchorPoint.x + offset.x, anchorPoint.y + offset.y, anchorPoint.z);
        }
        Vec3d scale = (Vec3d)tlayer.getScale().value(this._vrContext);
        Vec3d position = (Vec3d)tlayer.getPosition().value(this._vrContext);
        if (threeD) {
            orientation = (Vec3d)tlayer.getOrientation().value(this._vrContext);
            rotation = new Vec3d(((Double)tlayer.getRotationX().value(this._vrContext)).doubleValue(), ((Double)tlayer.getRotationY().value(this._vrContext)).doubleValue(), ((Double)tlayer.getRotationZ().value(this._vrContext)).doubleValue());
        } else {
            anchorPoint = new Vec3d(anchorPoint.x, anchorPoint.y, 0.0);
            scale = new Vec3d(scale.x, scale.y, 100.0);
            orientation = new Vec3d(0.0, 0.0, 0.0);
            rotation = new Vec3d(0.0, 0.0, ((Double)tlayer.getRotationZ().value(this._vrContext)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
        }
        RenderResolution resolution = this._vrContext.getRenderResolution();
        if (inverse) {
            this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
        } else {
            this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
        }
    }

    private void multCameraLayerMatrix(CameraLayer clayer, boolean threeD, boolean inverse) {
        RenderResolution resolution = this._vrContext.getRenderResolution();
        Vec3d position = (Vec3d)clayer.getPosition().value(this._vrContext);
        Vec3d pointOfInterest = (Vec3d)clayer.getPointOfInterest().value(this._vrContext);
        if (threeD) {
            Vec3d orientation = (Vec3d)clayer.getOrientation().value(this._vrContext);
            Vec3d rotation = new Vec3d(((Double)clayer.getRotationX().value(this._vrContext)).doubleValue(), ((Double)clayer.getRotationY().value(this._vrContext)).doubleValue(), ((Double)clayer.getRotationZ().value(this._vrContext)).doubleValue());
            if (inverse) {
                this._vrSupport.multCameraMatrix(orientation, rotation, resolution.scale(position), resolution.scale(pointOfInterest), false);
            } else {
                this._vrSupport.multCameraMatrixInverse(orientation, rotation, resolution.scale(position), resolution.scale(pointOfInterest));
            }
        } else {
            Vec3d anchorPoint = new Vec3d(pointOfInterest.x, pointOfInterest.y, 0.0);
            Vec3d scale = new Vec3d(100.0, 100.0, 100.0);
            Vec3d orientation = new Vec3d(0.0, 0.0, 0.0);
            Vec3d rotation = new Vec3d(0.0, 0.0, ((Double)clayer.getRotationZ().value(this._vrContext)).doubleValue());
            position = new Vec3d(position.x, position.y, 0.0);
            if (inverse) {
                this._vrSupport.multModelViewMatrixInverse(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
            } else {
                this._vrSupport.multModelViewMatrix(resolution.scale(anchorPoint), scale, orientation, rotation, resolution.scale(position));
            }
        }
    }
}

