/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AbstractComposition;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.CameraImpl;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.internal.VideoLayerComposerImpl;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="layerComposition")
public class LayerCompositionImpl
extends AbstractComposition
implements LayerComposition {
    private List<Layer> _layers;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;

    @Override
    public void initialize(ColorMode colorMode, Size2i size, Time frameDuration, Time duration) {
        super.initialize(colorMode, size, frameDuration, duration);
        this._layers = Util.newList();
    }

    @Override
    public List<Layer> getLayers() {
        return this._layers;
    }

    public void setLayers(List<Layer> layers) {
        this._layers = layers;
    }

    @Override
    public Layer getLayer(String id) {
        for (Layer layer : this._layers) {
            if (!layer.getId().equals(id)) continue;
            return layer;
        }
        return null;
    }

    @Override
    public void afterDecode(Project p) throws ProjectDecodeException {
        for (Layer layer : this._layers) {
            layer.afterDecode(p, this);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        scope.putExpressionElement("thisComp", this);
        for (Layer layer : this._layers) {
            layer.prepareExpression(scope.clone());
        }
    }

    @Override
    public VideoBuffer renderVideoFrame() {
        ColorMode colorMode = this.getColorMode();
        Size2i size = this._vrContext.getRenderResolution().scale(this.getSize());
        Time time = this._vrContext.getTime();
        this._vrContext.setColorMode(colorMode);
        CameraLayer cameraLayer = null;
        ListIterator<Layer> it = this._layers.listIterator(this._layers.size());
        while (it.hasPrevious()) {
            Layer layer = it.previous();
            if (!(layer instanceof CameraLayer) || !LayerNature.isVideoEnabled(layer) || layer.getInPoint().after(time) || !layer.getOutPoint().after(time)) continue;
            cameraLayer = (CameraLayer)layer;
            break;
        }
        final CameraImpl camera = new CameraImpl(this._vrContext, this._vrSupport, cameraLayer, this.getSize(), size);
        final VideoLayerComposerImpl composer = new VideoLayerComposerImpl(this._vrContext, this._vrSupport, colorMode, size, camera.getPosition());
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer matteLayer;
                final MediaLayer ml = (MediaLayer)layer;
                if (ml.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (matteLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    this.setupTrackMatteRenderer(ml, (MediaLayer)matteLayer, composer, camera, null);
                } else {
                    this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

                        @Override
                        public Object execute() {
                            ml.setupVideoRenderer(composer, camera, null);
                            return null;
                        }
                    });
                }
            }
            ++i;
        }
        return composer.compose();
    }

    @Override
    public void setupCollapseTransformation(final VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct) {
        Time time = this._vrContext.getTime();
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer matteLayer;
                final MediaLayer ml = (MediaLayer)layer;
                if (ml.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (matteLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    this.setupTrackMatteRenderer(ml, (MediaLayer)matteLayer, composer, camera, ct);
                } else {
                    this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

                        @Override
                        public Object execute() {
                            ml.setupVideoRenderer(composer, camera, ct);
                            return null;
                        }
                    });
                }
            }
            ++i;
        }
    }

    private void setupTrackMatteRenderer(MediaLayer fillLayer, MediaLayer matteLayer, VideoLayerComposer composer, Camera camera, CollapseTransformation ct) {
        final VideoLayerRenderer[] renderers = new VideoLayerRenderer[2];
        final Vec3d[][] vertices = new Vec3d[1][];
        final String[] intersectionGroup = new String[1];
        fillLayer.setupVideoRenderer(new VideoLayerComposer(){

            public void add2D(VideoLayerRenderer r) {
                renderers[0] = r;
            }

            public void add3D(VideoLayerRenderer r, Vec3d[] v, String ig) {
                renderers[0] = r;
                vertices[0] = v;
                intersectionGroup[0] = ig;
            }
        }, camera, ct);
        matteLayer.setupVideoRenderer(new VideoLayerComposer(){

            public void add2D(VideoLayerRenderer r) {
                renderers[1] = r;
            }

            public void add3D(VideoLayerRenderer r, Vec3d[] v, String ig) {
                renderers[1] = r;
            }
        }, camera, ct);
        if (renderers[0] == null) {
            return;
        }
        if (renderers[1] == null) {
            if (vertices[0] == null) {
                composer.add2D(renderers[0]);
            } else {
                composer.add3D(renderers[0], vertices[0], intersectionGroup[0]);
            }
            return;
        }
        final TrackMatte trackMatte = fillLayer.getTrackMatte();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                VideoLayerBuffer fillBuffer = null;
                VideoLayerBuffer matteBuffer = null;
                VideoBuffer vbFill = null;
                try {
                    fillBuffer = renderers[0].render(withDepthBuffer);
                    matteBuffer = renderers[1].render(false);
                    vbFill = fillBuffer.getVideoBuffer();
                    VideoBuffer resultBuffer = LayerCompositionImpl.this._vrSupport.createVideoBuffer(vbFill.getColorMode(), vbFill.getBounds());
                    LayerCompositionImpl.this._vrSupport.trackMatte(matteBuffer.getVideoBuffer(), fillBuffer.getVideoBuffer(), resultBuffer, trackMatte, matteBuffer.getOpacity());
                    VideoLayerBufferImpl newBuffer = new VideoLayerBufferImpl(resultBuffer, fillBuffer.getDepthBuffer(), fillBuffer.getBlendMode(), fillBuffer.getOpacity());
                    fillBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = newBuffer;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (matteBuffer != null) {
                        matteBuffer.dispose();
                    }
                    if (fillBuffer != null) {
                        fillBuffer.dispose();
                    } else if (vbFill != null) {
                        vbFill.dispose();
                    }
                }
            }
        };
        if (vertices[0] == null) {
            composer.add2D(r);
        } else {
            composer.add3D(r, vertices[0], intersectionGroup[0]);
        }
    }

    @Override
    public AudioBuffer renderAudioChunk() {
        AudioBuffer ab = null;
        Time time = this._arContext.getTime();
        Time chunkDuration = Time.fromFrameNumber((long)this._arContext.getFrameCount(), (Time)this._arContext.getAudioMode().sampleDuration);
        for (Layer layer : this._layers) {
            MediaLayer al;
            AudioBuffer alab;
            if (!LayerNature.isAudioEnabled(layer) || layer.getInPoint().after(time.add(chunkDuration)) || !layer.getOutPoint().after(time) || !(layer instanceof MediaLayer) || (alab = this._arContext.saveAndExecute(new WrappedOperation<AudioBuffer>(al = (MediaLayer)layer){
                private final /* synthetic */ MediaLayer val$al;
                {
                    this.val$al = mediaLayer;
                }

                @Override
                public AudioBuffer execute() {
                    return this.val$al.renderAudioChunk();
                }
            })) == null) continue;
            if (ab == null) {
                ab = alab;
                continue;
            }
            AudioBuffer abOld = ab;
            try {
                ab = this._arSupport.mix(ab, alab);
            }
            finally {
                if (ab != abOld) {
                    abOld.dispose();
                }
                if (ab != alab) {
                    alab.dispose();
                }
            }
        }
        return ab;
    }

    @Override
    public Object createExpressionElement(RenderContext renderContext) {
        return new LayerCompositionExpressionElement(renderContext);
    }

    public class LayerCompositionExpressionElement {
        protected final RenderContext renderContext;

        public LayerCompositionExpressionElement(RenderContext renderContext) {
            this.renderContext = renderContext;
        }

        public Object layer(int index) {
            Layer layer = (Layer)LayerCompositionImpl.this._layers.get(LayerCompositionImpl.this._layers.size() - index);
            return this.renderContext.getExpressionElement(layer);
        }

        public int getHeight() {
            return LayerCompositionImpl.this.getSize().width;
        }

        public int getWidth() {
            return LayerCompositionImpl.this.getSize().height;
        }
    }
}

