/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.core;

import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

public class VersionedName {
    private final String id;
    private final Version version;

    public static VersionedName parse(String spec) {
        String[] segments = StringHelper.getArrayFromString(spec, '/');
        return new VersionedName(segments[0], segments.length == 1 ? null : segments[1]);
    }

    public VersionedName(String id, String version) {
        this.id = id;
        this.version = Version.parseVersion(version);
    }

    public VersionedName(String id, Version version) {
        this.id = id;
        this.version = version == null ? Version.emptyVersion : version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionedName)) {
            return false;
        }
        VersionedName vname = (VersionedName)obj;
        return this.id.equals(vname.id) && this.version.equals(vname.version);
    }

    public int hashCode() {
        return this.id.hashCode() * 31 + this.version.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return Version.emptyVersion.equals(this.version) ? this.id : String.valueOf(this.id) + '/' + this.version.toString();
    }
}

